/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffdetaillrpt.function;

import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.StockDiffDetailReportParam;

public class DiffDetailBeforePeriodGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private StockDiffDetailReportParam reportparam;

    public DiffDetailBeforePeriodGroupFunction(RowMeta rowMeta, StockDiffDetailReportParam reportparam) {
        this.rowMeta = rowMeta;
        this.reportparam = reportparam;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        List<Integer> periodNumberList = this.reportparam.getPeriodNumberList();
        for (RowX rowX : iterable) {
            for (Integer periodNumber : periodNumberList) {
                int year = periodNumber / 100;
                int month = periodNumber % 100;
                RowX periodRowX = new RowX(this.rowMeta.getFieldCount());
                int calOrgIdx = this.rowMeta.getFieldIndex("calorg");
                int costAccountIdx = this.rowMeta.getFieldIndex("costaccount");
                int materialIdx = this.rowMeta.getFieldIndex("material");
                int billtypeIdx = this.rowMeta.getFieldIndex("billtype");
                int periodIdx = this.rowMeta.getFieldIndex("period");
                int baseUnitIdx = this.rowMeta.getFieldIndex("baseunit");
                int currencyIdx = this.rowMeta.getFieldIndex("currency");
                int yearIdx = this.rowMeta.getFieldIndex("year");
                periodRowX.set(calOrgIdx, rowX.get(calOrgIdx));
                periodRowX.set(costAccountIdx, rowX.get(costAccountIdx));
                periodRowX.set(materialIdx, rowX.get(materialIdx));
                periodRowX.set(billtypeIdx, (Object)ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"SalesEstimateDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
                periodRowX.set(periodIdx, (Object)month);
                periodRowX.set(baseUnitIdx, rowX.get(baseUnitIdx));
                periodRowX.set(currencyIdx, rowX.get(currencyIdx));
                periodRowX.set(yearIdx, (Object)year);
                collector.collect(periodRowX);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

