/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffsumlrpt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Output;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.StockDiffGatherSumReportParam;

public class StockDiffBplatReportUtil {
    public static boolean hasGroupByName(Set<String> showKeyCols, String keyName) {
        boolean hasGroupName = false;
        if (showKeyCols != null && showKeyCols.size() > 0 && !StringUtils.isBlank((String)keyName) && showKeyCols.contains(keyName)) {
            hasGroupName = true;
        }
        return hasGroupName;
    }

    public static String getPriceSelect(String amount, String qty) {
        return "case when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    public static String getGroupCols(String sumType, StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        if ("0".equals(sumType)) {
            HashSet<String> sumKeyColsTemp = new HashSet<String>(16);
            sumKeyColsTemp.addAll(ctx.getSumKeyCols());
            sumKeyColsTemp.add("month");
            sumKeyColsTemp.add("year");
            sumKeyColsTemp.add("periodnumber");
            sumKeyColsTemp.add("currency");
            if (StockDiffBplatReportUtil.hasGroupByName(sumKeyColsTemp, "material")) {
                sumKeyColsTemp.add("materialnumber");
            }
            for (String sumKeyCol : sumKeyColsTemp) {
                sql.append(sumKeyCol);
                sql.append(",");
            }
            return sql.substring(0, sql.length() - 1);
        }
        if ("1".equals(sumType)) {
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append("costaccount");
                sql.append(",");
            }
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append("calorg");
                sql.append(",");
            }
            sql.append("year,month,periodnumber,currency");
        } else if ("2".equals(sumType)) {
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append("costaccount");
                sql.append(",");
            }
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append("calorg");
                sql.append(",");
            }
            sql.append("year,currency");
        } else if ("3".equals(sumType)) {
            sql.append("currency,");
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append("costaccount");
                sql.append(",");
            }
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append("calorg");
                sql.append(",");
            }
            return sql.substring(0, sql.length() - 1);
        }
        return sql.toString();
    }

    private static void appendCommonGroupCols(StringBuilder sql, boolean isSelectNullField, StockDiffGatherSumReportParam reportParam, Set<String> showKeyCols) {
        if (showKeyCols != null && showKeyCols.size() > 0) {
            Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
            for (String showKeyCol : showKeyCols) {
                sql.append(",");
                IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
                if (dataProperty != null) {
                    if (dataProperty instanceof BasedataProp) {
                        if (isSelectNullField) {
                            sql.append("0 as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    if (dataProperty instanceof TextProp) {
                        if (isSelectNullField) {
                            sql.append("' ' as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    if ("ownertype".equals(showKeyCol)) {
                        if (isSelectNullField) {
                            sql.append("' ' as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    sql.append(showKeyCol);
                    continue;
                }
                sql.append(showKeyCol);
            }
        }
    }

    public static String getSelectAllTotalCols(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("0 as baseunit,0 as qtyprecision,").append(reportParam.getDefaultCurrency()).append(" as currency");
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        showKeyColsTemp.remove("material");
        showKeyColsTemp.remove("materialnumber");
        showKeyColsTemp.remove("baseunit");
        showKeyColsTemp.remove("qtyprecision");
        showKeyColsTemp.remove("currency");
        boolean topSumRow = reportParam.isTopSumRow();
        String s4 = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockGatherRptQueryPlugin_32", (String)"fi-cal-report", (Object[])new Object[0]);
        if (topSumRow) {
            sql.append(",0 as year,0 as month,null as periodnumber");
        } else {
            sql.append(",9999 as year,99 as month,null as periodnumber");
        }
        sql.append(",0 as material,'").append(s4).append("' as materialnumber");
        showKeyColsTemp.remove("year");
        showKeyColsTemp.remove("month");
        showKeyColsTemp.remove("periodnumber");
        showKeyColsTemp.remove("costaccount");
        showKeyColsTemp.remove("calorg");
        showKeyColsTemp.remove("costelementname");
        showKeyColsTemp.remove("costelementnumber");
        showKeyColsTemp.remove("costsubelementname");
        showKeyColsTemp.remove("costsubelementnumer");
        sql.append(",0 as costaccount,0 as calorg");
        StockDiffBplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
        boolean showdetail = reportParam.isShowdetail();
        StockDiffBplatReportUtil.getCostElementField(sql, showdetail);
        return sql.toString();
    }

    public static String getSelectByGroupCols(String sumType, StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        boolean showdetail = reportParam.isShowdetail();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        StringBuilder sql = new StringBuilder();
        sql.append("baseunit,qtyprecision,").append("currency");
        showKeyColsTemp.remove("material");
        showKeyColsTemp.remove("materialnumber");
        showKeyColsTemp.remove("baseunit");
        showKeyColsTemp.remove("qtyprecision");
        showKeyColsTemp.remove("currency");
        showKeyColsTemp.remove("costelementnumber");
        showKeyColsTemp.remove("costelementname");
        showKeyColsTemp.remove("costsubelementnumer");
        showKeyColsTemp.remove("costsubelementname");
        boolean topSumRow = reportParam.isTopSumRow();
        if ("0".equals(sumType)) {
            HashSet<String> sumKeyColsTemp = new HashSet<String>(16);
            sumKeyColsTemp.addAll(ctx.getSumKeyCols());
            HashSet<String> showKeyColsZero = new HashSet<String>(16);
            showKeyColsZero.addAll(showKeyColsTemp);
            StringBuilder sqlZero = new StringBuilder();
            sqlZero.append("baseunit,qtyprecision,").append("currency");
            String s1 = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockGatherRptQueryPlugin_29", (String)"fi-cal-report", (Object[])new Object[0]);
            if (StockDiffBplatReportUtil.hasGroupByName(sumKeyColsTemp, "material")) {
                sqlZero.append(",material,'");
            } else {
                sqlZero.append(",0 as material,'");
            }
            sumKeyColsTemp.remove("material");
            sqlZero.append(s1).append("' as materialnumber");
            if (StockDiffBplatReportUtil.hasGroupByName(sumKeyColsTemp, "costaccount")) {
                sqlZero.append(",costaccount");
            } else {
                sqlZero.append(",0 as costaccount");
            }
            showKeyColsZero.remove("costaccount");
            sumKeyColsTemp.remove("costaccount");
            if (StockDiffBplatReportUtil.hasGroupByName(sumKeyColsTemp, "calorg")) {
                sqlZero.append(",calorg");
            } else {
                sqlZero.append(",0 as calorg");
            }
            sumKeyColsTemp.remove("calorg");
            showKeyColsZero.remove("calorg");
            sqlZero.append(",year,month,periodnumber");
            showKeyColsZero.remove("year");
            showKeyColsZero.remove("month");
            showKeyColsZero.remove("periodnumber");
            StockDiffBplatReportUtil.appendSumKeyGroupCols(sqlZero, false, reportParam, sumKeyColsTemp);
            showKeyColsZero.removeAll(sumKeyColsTemp);
            StockDiffBplatReportUtil.appendSumKeyGroupCols(sqlZero, reportParam, showKeyColsZero);
            StockDiffBplatReportUtil.getCostElementField(sqlZero, showdetail);
            return sqlZero.toString();
        }
        if ("1".equals(sumType)) {
            String s2 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_30", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append(",0 as material,'").append(s2).append("' as materialnumber");
            sql.append(",year,month,periodnumber");
            showKeyColsTemp.remove("year");
            showKeyColsTemp.remove("month");
            showKeyColsTemp.remove("periodnumber");
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append(",");
                sql.append("costaccount");
                showKeyColsTemp.remove("costaccount");
            }
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append(",");
                sql.append("calorg");
                showKeyColsTemp.remove("calorg");
            }
            StockDiffBplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
            StockDiffBplatReportUtil.getCostElementField(sql, showdetail);
        } else if ("2".equals(sumType)) {
            String s3 = ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
            if (topSumRow) {
                sql.append(",year,0 as month,year as periodnumber");
            } else {
                sql.append(",year,99 as month,year as periodnumber");
            }
            sql.append(",0 as material,'").append(s3).append("' as materialnumber");
            showKeyColsTemp.remove("year");
            showKeyColsTemp.remove("month");
            showKeyColsTemp.remove("periodnumber");
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append(",");
                sql.append("costaccount");
                showKeyColsTemp.remove("costaccount");
            }
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append(",");
                sql.append("calorg");
                showKeyColsTemp.remove("calorg");
            }
            StockDiffBplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
            StockDiffBplatReportUtil.getCostElementField(sql, showdetail);
        } else if ("3".equals(sumType)) {
            String s4 = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_49", (String)"fi-cal-report", (Object[])new Object[0]);
            if (topSumRow) {
                sql.append(",0 as year,0 as month,null as periodnumber");
            } else {
                sql.append(",9999 as year,99 as month,null as periodnumber");
            }
            sql.append(",0 as material,'").append(s4).append("' as materialnumber");
            showKeyColsTemp.remove("year");
            showKeyColsTemp.remove("month");
            showKeyColsTemp.remove("periodnumber");
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append(",");
                sql.append("costaccount");
                showKeyColsTemp.remove("costaccount");
            }
            if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append(",");
                sql.append("calorg");
                showKeyColsTemp.remove("calorg");
            }
            StockDiffBplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
            StockDiffBplatReportUtil.getCostElementField(sql, showdetail);
        }
        return sql.toString();
    }

    private static void getCostElementField(StringBuilder sql, Boolean showdetail) {
        if (showdetail.booleanValue()) {
            sql.append(",null as costelementnumber,null as costelementname,null as costsubelementnumer,null as costsubelementname");
        }
    }

    public static String getFinalSelectFields(String sumType, StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = StockDiffBplatReportUtil.getSelectByGroupCols(sumType, reportParam, ctx);
        select = select + ",periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodbeginstandardamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount,periodindifferamount,periodinstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodinstandardamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodoutstandardamount", "periodoutqty") + " as periodoutprice,";
        select = select + "periodendqty,periodendamount,periodenddifferamount,periodendstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodendstandardamount", "periodendqty") + " as periodendprice";
        return select;
    }

    public static String getAllTotalSelectFields(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = StockDiffBplatReportUtil.getSelectAllTotalCols(reportParam, ctx);
        select = select + ",periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodbeginstandardamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount,periodindifferamount,periodinstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodinstandardamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodoutstandardamount", "periodoutqty") + " as periodoutprice,";
        select = select + "periodendqty,periodendamount,periodenddifferamount,periodendstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodendstandardamount", "periodendqty") + " as periodendprice";
        return select;
    }

    public static String getGroupCols(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        Set showKeyCols = ctx.getShowKeyCols();
        HashSet showKeyColsTemp = new HashSet(16);
        showKeyColsTemp.addAll(showKeyCols);
        for (String showKeyCol : showKeyColsTemp) {
            sql.append(showKeyCol);
            sql.append(",");
        }
        return sql.toString();
    }

    public static String getGroupIsGroupByPeriodStr(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        HashSet showKeyColsTemp = new HashSet(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        showKeyColsTemp.remove("year");
        showKeyColsTemp.remove("month");
        showKeyColsTemp.remove("periodnumber");
        for (String showKeyCol : showKeyColsTemp) {
            sql.append(showKeyCol);
            sql.append(",");
        }
        String salStr = sql.substring(0, sql.length() - 1);
        return salStr;
    }

    public static String getFinalSelectFields(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = StockDiffBplatReportUtil.getGroupCols(reportParam, ctx);
        select = select + "periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodbeginstandardamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount,periodindifferamount,periodinstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodinstandardamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodoutstandardamount", "periodoutqty") + " as periodoutprice,periodendqty,periodendamount,periodenddifferamount,periodendstandardamount," + StockDiffBplatReportUtil.getPriceSelect("periodendstandardamount", "periodendqty") + " as periodendprice";
        return select;
    }

    public static String getOrders(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        boolean topSumRow = reportParam.isTopSumRow();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getSumKeyCols());
        if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
            sql.append("costaccount,");
            showKeyColsTemp.remove("costaccount");
        }
        if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
            sql.append("calorg,");
            showKeyColsTemp.remove("calorg");
        }
        sql.append("year,month,periodnumber");
        if (topSumRow) {
            sql.append(",ordercol desc");
        } else {
            sql.append(",ordercol");
        }
        StockDiffBplatReportUtil.appendSumKeyGroupCols(sql, false, reportParam, showKeyColsTemp);
        if (topSumRow) {
            sql.append(",ordercol1 desc");
        } else {
            sql.append(",ordercol1");
        }
        sql.append(",materialnumber,baseunit,currency");
        return sql.toString();
    }

    public static QFilter getFilter(StockDiffGatherSumReportParam reportParam, boolean balanceHeadFilter, boolean newBalanceFlag) {
        HashSet<Long> set;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("invtype.isforwardamount", "=", (Object)true);
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        List<Object> auxptyIds = reportParam.getAuxptyIds();
        if (auxptyIds != null) {
            q.and("assist", "in", auxptyIds);
        }
        if (reportParam.getMulcalrange() != null && reportParam.getMulcalrange().size() > 0) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMulcalrange()) {
                calrangeIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("calrange", "in", calrangeIds);
        }
        if (reportParam.getOwnerFrom() != null && reportParam.getOwnerFrom().size() == 0) {
            if (newBalanceFlag) {
                StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_costadjustbill");
            } else {
                StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_balance");
            }
        } else if (newBalanceFlag) {
            StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_costadjustbill");
        } else {
            StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_balance");
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = StockDiffBplatReportUtil.getWarehsGroupSet(reportParam);
        if (!warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("warehouse", "in", set);
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("location", "in", set);
        }
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("material", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        if (reportParam.getMatcategory() != null && reportParam.getMatcategory().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getMatcategory()) {
                set.add(info.getLong("id"));
            }
            q.and("materialcategory", "in", set);
        }
        if (reportParam.getFilter_invType() != null && reportParam.getFilter_invType().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invType()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("invtype", "in", set);
        }
        if (reportParam.getFilter_invStatus() != null && reportParam.getFilter_invStatus().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invStatus()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("invstatus", "in", set);
        }
        QFilter q1 = new QFilter("period", "<=", (Object)reportParam.getFilter_endPeriodNumber());
        q1.and(new QFilter("endperiod", ">=", (Object)reportParam.getFilter_startPeriodNumber()));
        q.and(q1);
        return q;
    }

    private static void getOwnerFilter(QFilter q, String filter_ownertype, DynamicObjectCollection filter_owner, String entityName) {
        if (StringUtils.isEmpty((String)filter_ownertype)) {
            return;
        }
        String entry = "";
        if ("cal_costrecord".equals(entityName)) {
            entry = "entry.";
        } else if ("cal_costadjustbill".equals(entityName) || "cal_initbill".equals(entityName)) {
            entry = "entryentity.";
        }
        q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        if (filter_owner != null && filter_owner.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(8);
            for (DynamicObject info : filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entry + "owner", "in", set);
        }
    }

    private static Set<Long> getWarehsGroupSet(StockDiffGatherSumReportParam reportParam) {
        HashSet<Long> warehsGroupSet = new HashSet<Long>(8);
        DynamicObjectCollection filter_warehsgroup = reportParam.getMulwarehsgroup();
        if (filter_warehsgroup != null && filter_warehsgroup.size() > 0) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (DynamicObject info : filter_warehsgroup) {
                warehsGroupSet.add(info.getDynamicObject("fbasedataid").getLong("id"));
                warehsGroupF.or("longnumber", "like", (Object)(info.getDynamicObject("fbasedataid").getString("longnumber") + "%"));
            }
            if (!warehsGroupSet.isEmpty()) {
                DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
                for (DynamicObject warehsGroup : warehsGroupColl) {
                    warehsGroupSet.add(warehsGroup.getLong("id"));
                }
            }
        }
        return warehsGroupSet;
    }

    public static List<QFilter> getBalanceHeadFilters(List<QFilter> headFilters) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stockdif_sum_col_repo");
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>(16);
        if (headFilters != null) {
            for (QFilter q : headFilters) {
                String property = q.getProperty();
                IDataEntityProperty p = entityType.findProperty(property);
                if (null == p) continue;
                if (p instanceof BasedataProp) {
                    String field = ((BasedataProp)p).getDisplayProp();
                    property = property + "." + field;
                }
                q.__setProperty(property);
                List nests = q.getNests(true);
                for (QFilter.QFilterNest net : nests) {
                    QFilter netFilter = net.getFilter();
                    StockDiffBplatReportUtil.rebuildBalanceHeadFilter(netFilter, entityType);
                }
                newHeadFilters.add(q);
            }
        }
        return newHeadFilters;
    }

    private static void rebuildBalanceHeadFilter(QFilter filter, MainEntityType entityType) {
        String property = filter.getProperty();
        IDataEntityProperty p = entityType.findProperty(property);
        if (null == p) {
            return;
        }
        if ("materialnumber".equals(property)) {
            property = "material.number";
        } else if (p instanceof BasedataProp) {
            String field = ((BasedataProp)p).getDisplayProp();
            property = property + "." + field;
        }
        filter.__setProperty(property);
    }

    public static QFilter getInitBillFilter(StockDiffGatherSumReportParam reportParam, boolean newBalanceFlag) {
        HashSet<Long> set;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        if (reportParam.getOwnerFrom() != null && reportParam.getOwnerFrom().size() == 0) {
            if (newBalanceFlag) {
                StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_costadjustbill");
            } else {
                StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_initbill");
            }
        } else if (newBalanceFlag) {
            StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_costadjustbill");
        } else {
            StockDiffBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_initbill");
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = StockDiffBplatReportUtil.getWarehsGroupSet(reportParam);
        if (!warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.location", "in", set);
        }
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("entryentity.material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        if (reportParam.getMulcalrange() != null && reportParam.getMulcalrange().size() > 0) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMulcalrange()) {
                calrangeIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.calrange", "in", calrangeIds);
        }
        if (reportParam.getFilter_invType() != null && reportParam.getFilter_invType().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invType()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (reportParam.getFilter_invStatus() != null && reportParam.getFilter_invStatus().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invStatus()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.invstatus", "in", set);
        }
        return q;
    }

    private static void appendSumKeyGroupCols(StringBuilder sql, boolean isSelectNullField, StockDiffGatherSumReportParam reportParam, Set<String> sumKeyCols) {
        if (sumKeyCols != null && sumKeyCols.size() > 0) {
            Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
            for (String showKeyCol : sumKeyCols) {
                sql.append(",");
                IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
                if (dataProperty != null) {
                    if (dataProperty instanceof BasedataProp) {
                        if (isSelectNullField) {
                            sql.append("0 as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    if (dataProperty instanceof TextProp) {
                        if (isSelectNullField) {
                            sql.append("' ' as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    if ("ownertype".equals(showKeyCol)) {
                        if (isSelectNullField) {
                            sql.append("' ' as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    sql.append(showKeyCol);
                    continue;
                }
                sql.append(showKeyCol);
            }
        }
    }

    private static void appendSumKeyGroupCols(StringBuilder sql, StockDiffGatherSumReportParam reportParam, Set<String> sumKeyCols) {
        if (sumKeyCols != null && sumKeyCols.size() > 0) {
            Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
            for (String showKeyCol : sumKeyCols) {
                sql.append(",");
                IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
                if (dataProperty != null) {
                    if (dataProperty instanceof BasedataProp) {
                        sql.append("0 as ");
                        sql.append(showKeyCol);
                        continue;
                    }
                    if (dataProperty instanceof TextProp) {
                        sql.append("' ' as ");
                        sql.append(showKeyCol);
                        continue;
                    }
                    if ("ownertype".equals(showKeyCol)) {
                        sql.append("' ' as ");
                        sql.append(showKeyCol);
                        continue;
                    }
                    sql.append(showKeyCol);
                    continue;
                }
                sql.append(showKeyCol);
            }
        }
    }

    public static String getEmptySumKeyOrders(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        showKeyColsTemp.remove("year");
        showKeyColsTemp.remove("month");
        showKeyColsTemp.remove("periodnumber");
        showKeyColsTemp.remove("materialnumber");
        showKeyColsTemp.remove("baseunit");
        showKeyColsTemp.remove("currency");
        showKeyColsTemp.remove("qtyprecision");
        showKeyColsTemp.remove("material");
        showKeyColsTemp.remove("costelementname");
        showKeyColsTemp.remove("costelementnumber");
        showKeyColsTemp.remove("costsubelementname");
        showKeyColsTemp.remove("costsubelementnumer");
        if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
            sql.append("costaccount,");
            showKeyColsTemp.remove("costaccount");
        }
        if (StockDiffBplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
            sql.append("calorg,");
            showKeyColsTemp.remove("calorg");
        }
        sql.append("year,month,periodnumber");
        StockDiffBplatReportUtil.appendCommonGroupCols(sql, false, reportParam, showKeyColsTemp);
        boolean showdetail = reportParam.isShowdetail();
        if (showdetail) {
            sql.append(",materialnumber,costelementnumber,costsubelementnumer,baseunit,currency");
        } else {
            sql.append(",materialnumber,baseunit,currency");
        }
        return sql.toString();
    }

    public static DataSet createDataSet(ReportDataCtx ctx, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        ctx.getCurrentJob().commit(60, TimeUnit.MINUTES);
        return ctx.getCurrentJob().readDataSet(resultId);
    }

    public static String getFinalSelectFieldsWithNoQty(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = StockDiffBplatReportUtil.getGroupCols(reportParam, ctx);
        select = select + "0 as periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount,0 as periodbeginprice,0 as periodinqty,periodinamount,periodindifferamount,periodinstandardamount,0 as periodinprice,0 as periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,0 as periodoutprice,0 as periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,0 as periodendprice";
        return select;
    }
}

