/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffsumlrpt.dataxtransform;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.StockDiffGatherSumReportParam;

public class AddActualDiffPriceRowDataxTransform
implements IDataTransform {
    private StockDiffGatherSumReportParam reportParam;

    public AddActualDiffPriceRowDataxTransform(StockDiffGatherSumReportParam reportParam) {
        this.reportParam = reportParam;
    }

    public DataSet doTransform(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> fieldsList = new ArrayList<String>(Arrays.asList(fieldNames));
        fieldsList.add("case when periodendqty != 0 then periodendamount / periodendqty else 0 end as periodendactualprice");
        fieldsList.add("case when periodbeginqty != 0 then periodbeginamount / periodbeginqty else 0 end as periodbeginactualprice");
        fieldsList.add("case when periodinqty != 0 then periodinamount / periodinqty else 0 end as periodinactualprice");
        fieldsList.add("case when periodoutqty != 0 then periodoutamount / periodoutqty else 0 end as periodoutactualprice");
        dataSet = dataSet.select(fieldsList.toArray(new String[fieldsList.size()]));
        ArrayList<String> fieldsListStr = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        fieldsListStr.add("case when (periodbeginqty + periodinqty) != 0 then (periodbeginamount + periodinamount) / (periodbeginqty + periodinqty) else 0 end as beginandinactualprice");
        dataSet = dataSet.select(fieldsListStr.toArray(new String[fieldsListStr.size()]));
        fieldsListStr = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        fieldsListStr.add("case when periodendqty != 0 then (periodendactualprice - beginandinactualprice) else 0 end as enddiffactualprice");
        fieldsListStr.add("case when periodoutqty != 0 then (periodoutactualprice - beginandinactualprice) else 0 end as outdiffactualprice");
        dataSet = dataSet.select(fieldsListStr.toArray(new String[fieldsListStr.size()]));
        dataSet.getRowMeta().getField("enddiffactualprice").setDataType((DataType)new BigDecimalType());
        dataSet.getRowMeta().getField("outdiffactualprice").setDataType((DataType)new BigDecimalType());
        boolean onlyShowSumRow = this.reportParam.isOnlyShowSumRow();
        if (onlyShowSumRow) {
            dataSet = dataSet.filter("ordercol <> 0 or ordercol1 <> 0");
        }
        return dataSet;
    }
}

