/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffsumlrpt.dataxtransform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.StockDiffBplatReportUtil;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.StockDiffGatherSumReportParam;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.function.ChangeYearAndMonthMapFuction;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.function.InsertZeroInOutPeriodGroupFunction;

public class CalBalUnDetailMaxDataxTransform
implements IDataXTransform {
    private StockDiffGatherSumReportParam reportParam;
    private ReportDataCtx ctx;

    public CalBalUnDetailMaxDataxTransform(StockDiffGatherSumReportParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        boolean showdetail = this.reportParam.isShowdetail();
        String groupSelectDetail = null;
        String groupSelect = null;
        String groupSelectUndetail = null;
        StringBuilder builderDetail = new StringBuilder();
        StringBuilder builderGroup = new StringBuilder();
        Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        if (allKeyCols != null && allKeyCols.size() > 0) {
            allKeyCols.addAll(this.ctx.getShowKeyCols());
            for (String keyCol : allKeyCols) {
                builderDetail.append(keyCol);
                builderDetail.append(",");
                if ("endperiod".equals(keyCol) || "mversion".equals(keyCol) || "accounttype".equals(keyCol)) continue;
                builderGroup.append(keyCol);
                builderGroup.append(",");
            }
        }
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        if (!showdetail) {
            groupSelectDetail = builderDetail.substring(0, builderDetail.length() - 1);
            srcData = balCompress ? srcData.groupBy(groupSelectDetail.split(",")).max("fid").sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount") : srcData.groupBy(groupSelectDetail.split(",")).max("fid").max("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").max("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").max("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").max("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount");
            ArrayList<Field> newfields = new ArrayList<Field>(16);
            ArrayList<String> fieldsValues = new ArrayList<String>(16);
            newfields.add(new Field("costelementnumber", (DataType)DataType.StringType));
            fieldsValues.add(" ");
            newfields.add(new Field("costelementname", (DataType)DataType.StringType));
            fieldsValues.add(" ");
            newfields.add(new Field("costsubelementnumer", (DataType)DataType.StringType));
            fieldsValues.add(" ");
            newfields.add(new Field("costsubelementname", (DataType)DataType.StringType));
            fieldsValues.add(" ");
            srcData = srcData.addFields(newfields.toArray(new Field[0]), fieldsValues.toArray());
        }
        srcData = srcData.filter("accounttype = 'D'");
        DataSetX dataSetX1 = srcData.groupBy(new String[0]).reduceGroup((GroupReduceFunction)new InsertZeroInOutPeriodGroupFunction(srcData.getRowMeta()));
        DataSet dataSet = StockDiffBplatReportUtil.createDataSet(this.ctx, dataSetX1);
        HashMap<Integer, StringBuilder> unionMap = new HashMap<Integer, StringBuilder>();
        int filter_startPeriodNumber = this.reportParam.getFilter_startPeriodNumber();
        int filter_endPeriodNumber = this.reportParam.getFilter_endPeriodNumber();
        for (Object row : dataSet) {
            int i;
            List<Integer> periodList;
            int n = row.getInteger("periodnumber");
            int endPeriodNumber = row.getInteger("endperiod");
            long id = row.getLong("fid");
            if (n == 0 && endPeriodNumber == 999999) {
                periodList = this.getPeriodNumberList(filter_startPeriodNumber, filter_endPeriodNumber);
                for (i = 0; i < periodList.size(); ++i) {
                    this.cacheUnionMap(id, periodList.get(i), unionMap);
                }
            }
            if (n == 0 && endPeriodNumber != 999999 && endPeriodNumber > filter_startPeriodNumber) {
                if (filter_endPeriodNumber < endPeriodNumber) {
                    periodList = this.getPeriodNumberList(filter_startPeriodNumber, filter_endPeriodNumber);
                    for (i = 0; i < periodList.size(); ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                } else {
                    periodList = this.getPeriodNumberList(filter_startPeriodNumber, endPeriodNumber);
                    for (i = 0; i < periodList.size() - 1; ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                }
            }
            if (n != 0 && endPeriodNumber != 999999) {
                if (filter_endPeriodNumber < endPeriodNumber) {
                    periodList = this.getPeriodNumberList(n, filter_endPeriodNumber);
                    for (i = 1; i < periodList.size(); ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                } else {
                    periodList = this.getPeriodNumberList(n, endPeriodNumber);
                    for (i = 1; i < periodList.size() - 1; ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                }
            }
            if (n == 0 || endPeriodNumber != 999999 || n >= filter_endPeriodNumber) continue;
            periodList = this.getPeriodNumberList(n, filter_endPeriodNumber);
            for (i = 1; i < periodList.size(); ++i) {
                this.cacheUnionMap(id, periodList.get(i), unionMap);
            }
        }
        DataSetX dataSetX2 = srcData.groupBy(new String[0]).reduceGroup((GroupReduceFunction)new InsertZeroInOutPeriodGroupFunction(srcData.getRowMeta()));
        for (Map.Entry entry : unionMap.entrySet()) {
            String id = ((StringBuilder)entry.getValue()).toString();
            DataSetX zeroInOutDataSet = dataSetX2.filter("fid in (" + id + ")");
            zeroInOutDataSet = zeroInOutDataSet.map((MapFunction)new ChangeYearAndMonthMapFuction(zeroInOutDataSet.getRowMeta(), (Integer)entry.getKey()));
            srcData = srcData.union(zeroInOutDataSet);
        }
        QFilter q = new QFilter("periodnumber", ">=", (Object)filter_startPeriodNumber);
        q.and("periodnumber", "<=", (Object)filter_endPeriodNumber);
        srcData = srcData.filter(q.toString());
        groupSelectUndetail = builderGroup.substring(0, builderGroup.length() - 1);
        builderGroup.append("costelementname,costelementnumber,costsubelementname,costsubelementnumer");
        groupSelect = builderGroup.toString();
        srcData = !showdetail ? (balCompress ? srcData.groupBy(groupSelectUndetail.split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount") : srcData.groupBy(groupSelectUndetail.split(",")).max("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").max("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").max("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").max("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount")) : srcData.groupBy(groupSelect.split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount");
        return srcData;
    }

    private void cacheUnionMap(long id, int period, Map<Integer, StringBuilder> unionMap) {
        if (unionMap.containsKey(period)) {
            StringBuilder sb = unionMap.get(period);
            sb.append(",").append(id);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(id);
            unionMap.put(period, sb);
        }
    }

    private List<Integer> getPeriodNumberList(int startPeriod, int endPeriod) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        List<Integer> periodNumberList = this.reportParam.getPeriodNumberList();
        for (int period : periodNumberList) {
            if (period < startPeriod || period > endPeriod) continue;
            list.add(period);
        }
        return list;
    }
}

