/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffsumlrpt.dataxtransform;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.StockDiffBplatReportUtil;
import kd.fi.cal.report.newreport.stockdiffsumlrpt.StockDiffGatherSumReportParam;

public class DiffGroupByPeriodDataXTransform
implements IDataTransform {
    private ReportDataCtx ctx;
    private StockDiffGatherSumReportParam reportParam;

    public DiffGroupByPeriodDataXTransform(ReportDataCtx ctx, StockDiffGatherSumReportParam reportParam) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSet doTransform(DataSet dataSet) {
        Set sumKeyColsSet = this.ctx.getSumKeyCols();
        if (sumKeyColsSet != null && sumKeyColsSet.size() > 0) {
            dataSet = dataSet.filter("linetype='0'");
            dataSet = dataSet.removeFields(new String[]{"linetype"});
        }
        HashSet<String> groupSelectSet = new HashSet<String>(16);
        String groupSelectSetstr = null;
        groupSelectSet.addAll(this.ctx.getShowKeyCols());
        groupSelectSet.remove("month");
        groupSelectSet.remove("year");
        groupSelectSet.remove("periodnumber");
        boolean showdetail = this.reportParam.isShowdetail();
        if (showdetail) {
            groupSelectSet.add("costelementname");
            groupSelectSet.add("costelementnumber");
            groupSelectSet.add("costsubelementname");
            groupSelectSet.add("costsubelementnumer");
        }
        StringBuilder builder = new StringBuilder();
        for (String groupStr : groupSelectSet) {
            if (StringUtils.isEmpty((String)groupStr)) continue;
            builder.append(groupStr);
            builder.append(",");
        }
        groupSelectSetstr = builder.substring(0, builder.length() - 1);
        dataSet = dataSet.groupBy(groupSelectSetstr.split(",")).minP("periodnumber", "periodbeginqty", "periodbeginqty").minP("periodnumber", "periodbeginamount", "periodbeginamount").minP("periodnumber", "periodbegindifferamount", "periodbegindifferamount").minP("periodnumber", "periodbeginstandardamount", "periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").maxP("periodnumber", "periodendqty", "periodendqty").maxP("periodnumber", "periodendamount", "periodendamount").minP("periodnumber", "periodenddifferamount", "periodenddifferamount").maxP("periodnumber", "periodendstandardamount", "periodendstandardamount").finish();
        DynamicObject filter_startPeriod = this.reportParam.getStartPeriod();
        DynamicObject filter_endPeriod = this.reportParam.getEndPeriod();
        dataSet = dataSet.addField("concat(concat('" + filter_startPeriod.getString("number") + "','-'),'" + filter_endPeriod.getString("number") + "')", "periodnumber").addField("0", "year").addField("0", "month");
        dataSet = dataSet.select(StockDiffBplatReportUtil.getFinalSelectFields(this.reportParam, this.ctx).split(","));
        return dataSet;
    }
}

