/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Output;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class BplatReportUtil {
    public static boolean hasGroupByName(Set<String> showKeyCols, String keyName) {
        boolean hasGroupName = false;
        if (showKeyCols != null && showKeyCols.size() > 0 && !StringUtils.isBlank((String)keyName) && showKeyCols.contains(keyName)) {
            hasGroupName = true;
        }
        return hasGroupName;
    }

    public static boolean hasMaterialGroupOtherFlag(Set<String> showKeyCols) {
        for (String showKey : showKeyCols) {
            if ("costaccount".equals(showKey) || "calorg".equals(showKey) || "material".equals(showKey) || "baseunit".equals(showKey) || "currency".equals(showKey) || "year".equals(showKey) || "month".equals(showKey) || "qtyprecision".equals(showKey) || "periodnumber".equals(showKey) || "group".equals(showKey) || "costelement".equals(showKey) || "costelementnum".equals(showKey) || "costsubelement".equals(showKey) || "costsubelementnum".equals(showKey)) continue;
            return true;
        }
        return false;
    }

    public static String getPriceSelect(String amount, String qty) {
        return "case when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    public static String getGroupCols(String sumType, StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        if ("0".equals(sumType)) {
            showKeyColsTemp.remove("qtyprecision");
            showKeyColsTemp.remove("material");
            showKeyColsTemp.remove("baseunit");
            boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
            boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
            if (!notShowMaterialGroup && !hasMaterialGroup) {
                showKeyColsTemp.remove("group");
                ctx.getShowKeyCols().remove("group");
            }
            HashSet<String> sumKeyColsTemp = new HashSet<String>(16);
            sumKeyColsTemp.addAll(ctx.getSumKeyCols());
            sumKeyColsTemp.add("month");
            sumKeyColsTemp.add("year");
            sumKeyColsTemp.add("periodnumber");
            sumKeyColsTemp.add("currency");
            for (String sumKeyCol : sumKeyColsTemp) {
                sql.append(sumKeyCol);
                sql.append(",");
            }
            return sql.substring(0, sql.length() - 1);
        }
        if ("1".equals(sumType)) {
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append("costaccount");
                sql.append(",");
            }
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append("calorg");
                sql.append(",");
            }
            sql.append("year,month,periodnumber,currency");
        } else if ("2".equals(sumType)) {
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append("costaccount");
                sql.append(",");
            }
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append("calorg");
                sql.append(",");
            }
            sql.append("year,currency");
        } else if ("3".equals(sumType)) {
            sql.append("currency,");
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append("costaccount");
                sql.append(",");
            }
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append("calorg");
                sql.append(",");
            }
            return sql.substring(0, sql.length() - 1);
        }
        return sql.toString();
    }

    private static void appendCommonGroupCols(StringBuilder sql, boolean isSelectNullField, StockGatherSumReportParam reportParam, Set<String> showKeyCols) {
        boolean hasMaterialGroup;
        if (showKeyCols != null && showKeyCols.size() > 0) {
            Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
            for (String showKeyCol : showKeyCols) {
                IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
                if (dataProperty == null) continue;
                sql.append(",");
                if (dataProperty instanceof BasedataProp) {
                    if (isSelectNullField) {
                        sql.append("0 as ");
                        sql.append(showKeyCol);
                        continue;
                    }
                    sql.append(showKeyCol);
                    continue;
                }
                if (dataProperty instanceof TextProp) {
                    if (isSelectNullField) {
                        sql.append("' ' as ");
                        sql.append(showKeyCol);
                        continue;
                    }
                    sql.append(showKeyCol);
                    continue;
                }
                if ("ownertype".equals(showKeyCol)) {
                    if (isSelectNullField) {
                        sql.append("' ' as ");
                        sql.append(showKeyCol);
                        continue;
                    }
                    sql.append(showKeyCol);
                    continue;
                }
                sql.append(showKeyCol);
            }
        }
        if (hasMaterialGroup = reportParam.isHasMaterialGroup()) {
            if (isSelectNullField) {
                sql.append(",null as group");
            } else {
                sql.append(",group");
            }
        }
    }

    public static String getSelectAllTotalCols(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("0 as baseunit,0 as qtyprecision,").append(reportParam.getDefaultCurrency()).append(" as currency");
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        showKeyColsTemp.remove("material");
        showKeyColsTemp.remove("baseunit");
        showKeyColsTemp.remove("qtyprecision");
        showKeyColsTemp.remove("currency");
        showKeyColsTemp.remove("group");
        boolean topSumRow = reportParam.isTopSumRow();
        if (topSumRow) {
            sql.append(",0 as year,0 as month,null as periodnumber");
        } else {
            sql.append(",9999 as year,99 as month,null as periodnumber");
        }
        sql.append(",0 as material");
        showKeyColsTemp.remove("year");
        showKeyColsTemp.remove("month");
        showKeyColsTemp.remove("periodnumber");
        showKeyColsTemp.remove("costaccount");
        showKeyColsTemp.remove("calorg");
        sql.append(",0 as costaccount,0 as calorg");
        BplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
        boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            sql.append(",null as group");
        }
        if (reportParam.isShowdetail()) {
            sql.append(",0 as costelement,0 as costsubelement,null as costelementnum,null as costsubelementnum");
        }
        return sql.toString();
    }

    public static String getSelectByGroupCols(String sumType, StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        StringBuilder sql = new StringBuilder();
        sql.append("0 as baseunit,qtyprecision,").append("currency");
        showKeyColsTemp.remove("material");
        showKeyColsTemp.remove("baseunit");
        showKeyColsTemp.remove("qtyprecision");
        showKeyColsTemp.remove("currency");
        boolean topSumRow = reportParam.isTopSumRow();
        boolean showdetail = reportParam.isShowdetail();
        if ("0".equals(sumType)) {
            HashSet<String> sumKeyColsTemp = new HashSet<String>(16);
            sumKeyColsTemp.addAll(ctx.getSumKeyCols());
            HashSet<String> showKeyColsZero = new HashSet<String>(16);
            showKeyColsZero.addAll(showKeyColsTemp);
            StringBuilder sqlZero = new StringBuilder();
            sqlZero.append("baseunit,qtyprecision,").append("currency");
            if (BplatReportUtil.hasGroupByName(sumKeyColsTemp, "material")) {
                sqlZero.append(",material");
            } else {
                sqlZero.append(",0 as material");
            }
            sumKeyColsTemp.remove("material");
            if (BplatReportUtil.hasGroupByName(sumKeyColsTemp, "costaccount")) {
                sqlZero.append(",costaccount");
            } else {
                sqlZero.append(",0 as costaccount");
            }
            showKeyColsZero.remove("costaccount");
            sumKeyColsTemp.remove("costaccount");
            if (BplatReportUtil.hasGroupByName(sumKeyColsTemp, "calorg")) {
                sqlZero.append(",calorg");
            } else {
                sqlZero.append(",0 as calorg");
            }
            sumKeyColsTemp.remove("calorg");
            showKeyColsZero.remove("calorg");
            sqlZero.append(",year,month,periodnumber");
            showKeyColsZero.remove("year");
            showKeyColsZero.remove("month");
            showKeyColsZero.remove("periodnumber");
            sumKeyColsTemp.remove("group");
            if (BplatReportUtil.hasGroupByName(sumKeyColsTemp, "storageorgunit")) {
                sqlZero.append(",storageorgunit");
                sumKeyColsTemp.remove("storageorgunit");
                showKeyColsZero.remove("storageorgunit");
            }
            if (BplatReportUtil.hasGroupByName(sumKeyColsTemp, "warehouse")) {
                sqlZero.append(",warehouse");
                sumKeyColsTemp.remove("warehouse");
                showKeyColsZero.remove("warehouse");
            }
            if (BplatReportUtil.hasGroupByName(sumKeyColsTemp, "location")) {
                sqlZero.append(",location");
                sumKeyColsTemp.remove("location");
                showKeyColsZero.remove("location");
            }
            BplatReportUtil.appendSumKeyGroupCols(sqlZero, false, reportParam, sumKeyColsTemp);
            boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
            boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
            if (!notShowMaterialGroup && !hasMaterialGroup) {
                sqlZero.append(",null as group");
            }
            showKeyColsZero.removeAll(sumKeyColsTemp);
            if (reportParam.isSumKeyhasMaterialGroup()) {
                showKeyColsZero.remove("group");
            }
            if (showdetail) {
                showKeyColsZero.remove("costelementnum");
                showKeyColsZero.remove("costsubelementnum");
                showKeyColsZero.remove("costsubelement");
                showKeyColsZero.remove("costelement");
            }
            BplatReportUtil.appendSumKeyZeroGroupCols(sqlZero, reportParam, showKeyColsZero);
            if (showdetail) {
                sqlZero.append(",9223372036854775807 as costelement,9223372036854775807 as costsubelement,null as costelementnum,null as costsubelementnum");
            }
            return sqlZero.toString();
        }
        if ("1".equals(sumType)) {
            sql.append(",0 as material");
            sql.append(",year,month,periodnumber");
            showKeyColsTemp.remove("year");
            showKeyColsTemp.remove("month");
            showKeyColsTemp.remove("periodnumber");
            showKeyColsTemp.remove("group");
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append(",");
                sql.append("costaccount");
                showKeyColsTemp.remove("costaccount");
            }
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append(",");
                sql.append("calorg");
                showKeyColsTemp.remove("calorg");
            }
            BplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
        } else if ("2".equals(sumType)) {
            showKeyColsTemp.remove("group");
            if (topSumRow) {
                sql.append(",year,0 as month,year as periodnumber");
            } else {
                sql.append(",year,99 as month,year as periodnumber");
            }
            sql.append(",0 as material");
            showKeyColsTemp.remove("year");
            showKeyColsTemp.remove("month");
            showKeyColsTemp.remove("periodnumber");
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append(",");
                sql.append("costaccount");
                showKeyColsTemp.remove("costaccount");
            }
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append(",");
                sql.append("calorg");
                showKeyColsTemp.remove("calorg");
            }
            BplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
        } else if ("3".equals(sumType)) {
            showKeyColsTemp.remove("group");
            if (topSumRow) {
                sql.append(",0 as year,0 as month,null as periodnumber");
            } else {
                sql.append(",9999 as year,99 as month,null as periodnumber");
            }
            sql.append(",0 as material");
            showKeyColsTemp.remove("year");
            showKeyColsTemp.remove("month");
            showKeyColsTemp.remove("periodnumber");
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
                sql.append(",");
                sql.append("costaccount");
                showKeyColsTemp.remove("costaccount");
            }
            if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
                sql.append(",");
                sql.append("calorg");
                showKeyColsTemp.remove("calorg");
            }
            BplatReportUtil.appendCommonGroupCols(sql, true, reportParam, showKeyColsTemp);
        }
        boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            sql.append(",null as group");
        }
        if (showdetail) {
            sql.append(",9223372036854775807 as costelement,9223372036854775807 as costsubelement,null as costelementnum,null as costsubelementnum");
        }
        return sql.toString();
    }

    public static String getFinalSelectFields(String sumType, StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = BplatReportUtil.getSelectByGroupCols(sumType, reportParam, ctx);
        select = select + ",periodbeginqty,periodbeginamount," + BplatReportUtil.getPriceSelect("periodbeginamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount," + BplatReportUtil.getPriceSelect("periodinamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount," + BplatReportUtil.getPriceSelect("periodoutamount", "periodoutqty") + " as periodoutprice,";
        select = select + "periodendqty,periodendamount," + BplatReportUtil.getPriceSelect("periodendamount", "periodendqty") + " as periodendprice";
        return select;
    }

    public static String getAllTotalSelectFields(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = BplatReportUtil.getSelectAllTotalCols(reportParam, ctx);
        select = select + ",periodbeginqty,periodbeginamount," + BplatReportUtil.getPriceSelect("periodbeginamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount," + BplatReportUtil.getPriceSelect("periodinamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount," + BplatReportUtil.getPriceSelect("periodoutamount", "periodoutqty") + " as periodoutprice,";
        select = select + "periodendqty,periodendamount," + BplatReportUtil.getPriceSelect("periodendamount", "periodendqty") + " as periodendprice";
        return select;
    }

    public static String getGroupCols(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
        StringBuilder sql = new StringBuilder();
        Set showKeyCols = ctx.getShowKeyCols();
        HashSet showKeyColsTemp = new HashSet(16);
        showKeyColsTemp.addAll(showKeyCols);
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            showKeyColsTemp.remove("group");
        }
        for (String showKeyCol : showKeyColsTemp) {
            sql.append(showKeyCol);
            sql.append(",");
        }
        return sql.toString();
    }

    public static String getGroupIsGroupByPeriodStr(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
        StringBuilder sql = new StringBuilder();
        HashSet showKeyColsTemp = new HashSet(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        showKeyColsTemp.remove("year");
        showKeyColsTemp.remove("month");
        showKeyColsTemp.remove("periodnumber");
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            showKeyColsTemp.remove("group");
        }
        for (String showKeyCol : showKeyColsTemp) {
            sql.append(showKeyCol);
            sql.append(",");
        }
        String salStr = sql.substring(0, sql.length() - 1);
        return salStr;
    }

    public static String getFinalSelectFields(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = BplatReportUtil.getGroupCols(reportParam, ctx);
        select = select + "periodbeginqty,periodbeginamount," + BplatReportUtil.getPriceSelect("periodbeginamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount," + BplatReportUtil.getPriceSelect("periodinamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount," + BplatReportUtil.getPriceSelect("periodoutamount", "periodoutqty") + " as periodoutprice,periodendqty,periodendamount," + BplatReportUtil.getPriceSelect("periodendamount", "periodendqty") + " as periodendprice";
        return select;
    }

    public static String getOrders(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        boolean topSumRow = reportParam.isTopSumRow();
        boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        showKeyColsTemp.remove("group");
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
            sql.append("costaccount,");
            showKeyColsTemp.remove("costaccount");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
            sql.append("calorg,");
            showKeyColsTemp.remove("calorg");
        }
        showKeyColsTemp.remove("year");
        showKeyColsTemp.remove("month");
        showKeyColsTemp.remove("periodnumber");
        showKeyColsTemp.remove("baseunit");
        showKeyColsTemp.remove("currency");
        showKeyColsTemp.remove("qtyprecision");
        sql.append("year,month,periodnumber");
        if (topSumRow) {
            sql.append(",ordercol desc");
        } else {
            sql.append(",ordercol");
        }
        boolean showdetail = reportParam.isShowdetail();
        if (showdetail) {
            showKeyColsTemp.remove("costelementnum");
            showKeyColsTemp.remove("costsubelementnum");
            showKeyColsTemp.remove("costsubelement");
            showKeyColsTemp.remove("costelement");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "material")) {
            sql.append(",material");
            showKeyColsTemp.remove("material");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "storageorgunit")) {
            sql.append(",storageorgunit");
            showKeyColsTemp.remove("storageorgunit");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "warehouse")) {
            sql.append(",warehouse");
            showKeyColsTemp.remove("warehouse");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "location")) {
            sql.append(",location");
            showKeyColsTemp.remove("location");
        }
        BplatReportUtil.appendSumKeyGroupCols(sql, false, reportParam, showKeyColsTemp);
        if (showdetail) {
            sql.append(",costelement,costsubelement");
        }
        if (topSumRow) {
            sql.append(",ordercol1 desc");
        } else {
            sql.append(",ordercol1");
        }
        sql.append(",baseunit,currency");
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            sql.append(",group");
        }
        return sql.toString();
    }

    public static QFilter getFilter(StockGatherSumReportParam reportParam, boolean balanceHeadFilter, boolean newBalanceFlag) {
        List<QFilter> list;
        Set<Long> costsubelementSet;
        boolean showdetail;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        List<Object> auxptyIds = reportParam.getAuxptyIds();
        if (auxptyIds != null) {
            q.and("assist", "in", auxptyIds);
        }
        if ((showdetail = reportParam.isShowdetail()) && (costsubelementSet = reportParam.getCostsubelementSet()) != null && costsubelementSet.size() > 0) {
            boolean noShowZeroInOut = reportParam.isNoShowZeroInOut();
            String qtyShowCondition = reportParam.getQtyShowCondition();
            String amountShowCondition = reportParam.getAmountShowCondition();
            boolean showAllZero = reportParam.isShowAllZero();
            if (!noShowZeroInOut && !showAllZero && StringUtils.isEmpty((String)qtyShowCondition) && StringUtils.isEmpty((String)amountShowCondition)) {
                q.and("costsubelement", "in", costsubelementSet);
            }
        }
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("material", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        if (balanceHeadFilter && (list = reportParam.getBalanceHeadFilters()) != null && list.size() > 0) {
            for (QFilter qFilter : list) {
                String property = qFilter.getProperty();
                if ("material_ref_number".equals(property)) {
                    qFilter.__setProperty("material.number");
                } else if ("material_ref_modelnum".equals(property)) {
                    qFilter.__setProperty("material.modelnum");
                }
                q.and(qFilter);
            }
        }
        return q;
    }

    public static void getCommonQFilter(StockGatherSumReportParam reportParam, QFilter q, String entityName) {
        HashSet<Long> set;
        if (reportParam.getOwnerFrom() != null && reportParam.getOwnerFrom().size() == 0) {
            BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, entityName);
        } else {
            BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), entityName);
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = BplatReportUtil.getWarehsGroupSet(reportParam);
        if (!warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("warehouse", "in", set);
        }
        if (reportParam.getMatcategory() != null && reportParam.getMatcategory().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getMatcategory()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("stocktype", "in", set);
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("location", "in", set);
        }
        if (reportParam.getMulcalrange() != null && reportParam.getMulcalrange().size() > 0) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMulcalrange()) {
                calrangeIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("calrange", "in", calrangeIds);
        }
        if (StringUtils.isNotEmpty((String)reportParam.getMulaccounttype())) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : reportParam.getMulaccounttype().split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and("accounttype", "in", accounttypes);
            }
        }
    }

    public static void getCostRecordQFilter(StockGatherSumReportParam reportParam, QFilter q, String entityName) {
        HashSet<Long> set;
        if (reportParam.getOwnerFrom() != null && reportParam.getOwnerFrom().size() == 0) {
            BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, entityName);
        } else {
            BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), entityName);
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = BplatReportUtil.getWarehsGroupSet(reportParam);
        if (!warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entry.warehouse", "in", set);
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entry.location", "in", set);
        }
        if (reportParam.getMatcategory() != null && reportParam.getMatcategory().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getMatcategory()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entry.stocktype", "in", set);
        }
        if (reportParam.getMulcalrange() != null && reportParam.getMulcalrange().size() > 0) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMulcalrange()) {
                calrangeIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entry.calrange", "in", calrangeIds);
        }
        if (StringUtils.isNotEmpty((String)reportParam.getMulaccounttype())) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : reportParam.getMulaccounttype().split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and("entry.accounttype", "in", accounttypes);
            }
        }
    }

    public static void getOwnerFilter(QFilter q, String filter_ownertype, DynamicObjectCollection filter_owner, String entityName) {
        if (StringUtils.isEmpty((String)filter_ownertype)) {
            return;
        }
        String entry = "";
        if ("cal_costrecord".equals(entityName)) {
            entry = "entry.";
        } else if ("cal_costadjustbill".equals(entityName)) {
            entry = "entryentity.";
        }
        q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        if (filter_owner != null && filter_owner.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(8);
            for (DynamicObject info : filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entry + "owner", "in", set);
        }
    }

    private static Set<Long> getWarehsGroupSet(StockGatherSumReportParam reportParam) {
        HashSet<Long> warehsGroupSet = new HashSet<Long>(8);
        DynamicObjectCollection filter_warehsgroup = reportParam.getMulwarehsgroup();
        if (filter_warehsgroup != null && filter_warehsgroup.size() > 0) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (DynamicObject info : filter_warehsgroup) {
                warehsGroupSet.add(info.getDynamicObject("fbasedataid").getLong("id"));
                warehsGroupF.or("longnumber", "like", (Object)(info.getDynamicObject("fbasedataid").getString("longnumber") + "%"));
            }
            if (!warehsGroupSet.isEmpty()) {
                DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
                for (DynamicObject warehsGroup : warehsGroupColl) {
                    warehsGroupSet.add(warehsGroup.getLong("id"));
                }
            }
        } else if (reportParam.isOnlyqueryemptygroup()) {
            warehsGroupSet.add(0L);
        }
        return warehsGroupSet;
    }

    public static List<QFilter> getBalanceHeadFilters(List<QFilter> headFilters) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stock_std_col_repo");
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>(16);
        if (headFilters != null) {
            for (QFilter q : headFilters) {
                String property = q.getProperty();
                if ("material_ref_number".equals(property)) {
                    q.__setProperty("material.number");
                } else if ("material_ref_modelnum".equals(property)) {
                    q.__setProperty("material.modelnum");
                } else {
                    IDataEntityProperty p = entityType.findProperty(property);
                    if (null == p) continue;
                    if (p instanceof BasedataProp) {
                        String field = ((BasedataProp)p).getDisplayProp();
                        property = property + "." + field;
                    }
                    q.__setProperty(property);
                    List nests = q.getNests(true);
                    for (QFilter.QFilterNest net : nests) {
                        QFilter netFilter = net.getFilter();
                        BplatReportUtil.rebuildBalanceHeadFilter(netFilter, entityType);
                    }
                }
                newHeadFilters.add(q);
            }
        }
        return newHeadFilters;
    }

    private static void rebuildBalanceHeadFilter(QFilter filter, MainEntityType entityType) {
        String property = filter.getProperty();
        IDataEntityProperty p = entityType.findProperty(property);
        if (null == p) {
            return;
        }
        if ("material_ref_number".equals(property)) {
            property = "material.number";
        } else if ("material_ref_modelnum".equals(property)) {
            property = "material.modelnum";
        } else if (p instanceof BasedataProp) {
            String field = ((BasedataProp)p).getDisplayProp();
            property = property + "." + field;
        }
        filter.__setProperty(property);
    }

    public static QFilter getInitBillFilter(StockGatherSumReportParam reportParam, boolean newBalanceFlag) {
        HashSet<Long> set;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        if (reportParam.getOwnerFrom() != null && reportParam.getOwnerFrom().size() == 0) {
            if (newBalanceFlag) {
                BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_costadjustbill");
            } else {
                BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_balance");
            }
        } else if (newBalanceFlag) {
            BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_costadjustbill");
        } else {
            BplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_balance");
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = BplatReportUtil.getWarehsGroupSet(reportParam);
        if (!warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.location", "in", set);
        }
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("entryentity.material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        if (reportParam.getMulcalrange() != null && reportParam.getMulcalrange().size() > 0) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMulcalrange()) {
                calrangeIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.calrange", "in", calrangeIds);
        }
        if (reportParam.getMultracknumber() != null && reportParam.getMultracknumber().size() > 0) {
            HashSet<Long> trackNumIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMultracknumber()) {
                trackNumIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.tracknumber", "in", trackNumIds);
        }
        if (StringUtils.isNotEmpty((String)reportParam.getMulaccounttype())) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : reportParam.getMulaccounttype().split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and("entryentity.accounttype", "in", accounttypes);
            }
        }
        return q;
    }

    private static void appendSumKeyGroupCols(StringBuilder sql, boolean isSelectNullField, StockGatherSumReportParam reportParam, Set<String> sumKeyCols) {
        boolean hasMaterialGroup;
        if (sumKeyCols != null && sumKeyCols.size() > 0) {
            Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
            for (String showKeyCol : sumKeyCols) {
                sql.append(",");
                IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
                if (dataProperty != null) {
                    if (dataProperty instanceof BasedataProp) {
                        if (isSelectNullField) {
                            sql.append("0 as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    if (dataProperty instanceof TextProp) {
                        if (isSelectNullField) {
                            sql.append("' ' as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    if ("ownertype".equals(showKeyCol)) {
                        if (isSelectNullField) {
                            sql.append("' ' as ");
                            sql.append(showKeyCol);
                            continue;
                        }
                        sql.append(showKeyCol);
                        continue;
                    }
                    sql.append(showKeyCol);
                    continue;
                }
                sql.append(showKeyCol);
            }
        }
        if (hasMaterialGroup = reportParam.isSumKeyhasMaterialGroup()) {
            if (isSelectNullField) {
                sql.append(",null as group");
            } else {
                sql.append(",group");
            }
        }
    }

    private static void appendSumKeyZeroGroupCols(StringBuilder sql, StockGatherSumReportParam reportParam, Set<String> sumKeyCols) {
        if (sumKeyCols != null && sumKeyCols.size() > 0) {
            Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
            for (String showKeyCol : sumKeyCols) {
                IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
                if (dataProperty == null) continue;
                sql.append(",");
                if (dataProperty instanceof BasedataProp) {
                    sql.append("9223372036854775807 as ");
                    sql.append(showKeyCol);
                    continue;
                }
                if (dataProperty instanceof TextProp) {
                    sql.append("' ' as ");
                    sql.append(showKeyCol);
                    continue;
                }
                if ("ownertype".equals(showKeyCol)) {
                    sql.append("' ' as ");
                    sql.append(showKeyCol);
                    continue;
                }
                sql.append(showKeyCol);
            }
        }
    }

    public static String getEmptySumKeyOrders(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(ctx.getShowKeyCols());
        showKeyColsTemp.remove("year");
        showKeyColsTemp.remove("month");
        showKeyColsTemp.remove("periodnumber");
        showKeyColsTemp.remove("baseunit");
        showKeyColsTemp.remove("currency");
        showKeyColsTemp.remove("qtyprecision");
        showKeyColsTemp.remove("group");
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "costaccount")) {
            sql.append("costaccount,");
            showKeyColsTemp.remove("costaccount");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "calorg")) {
            sql.append("calorg,");
            showKeyColsTemp.remove("calorg");
        }
        sql.append("year,month,periodnumber");
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "material")) {
            sql.append(",material");
            showKeyColsTemp.remove("material");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "storageorgunit")) {
            sql.append(",storageorgunit");
            showKeyColsTemp.remove("storageorgunit");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "warehouse")) {
            sql.append(",warehouse");
            showKeyColsTemp.remove("warehouse");
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsTemp, "location")) {
            sql.append(",location");
            showKeyColsTemp.remove("location");
        }
        BplatReportUtil.appendCommonGroupCols(sql, false, reportParam, showKeyColsTemp);
        boolean showdetail = reportParam.isShowdetail();
        if (showdetail) {
            sql.append(",costelement,costsubelement");
        }
        sql.append(",baseunit,currency");
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            sql.append(",group");
        }
        return sql.toString();
    }

    public static void setMulNoSumBiztypeSet(String mulnojoinsumrangeStr, Set<String> mulnosumbiztypeSet) {
        if (StringUtils.isNotEmpty((String)mulnojoinsumrangeStr)) {
            String[] mulnojoinsumrangeStrs;
            for (String mulnojoinsumrange : mulnojoinsumrangeStrs = mulnojoinsumrangeStr.split(",")) {
                if (!StringUtils.isNotEmpty((String)mulnojoinsumrange)) continue;
                if ("A".equals(mulnojoinsumrange) || "B".equals(mulnojoinsumrange)) {
                    mulnosumbiztypeSet.add("im_transdirbill");
                    mulnosumbiztypeSet.add("im_transoutbill");
                    mulnosumbiztypeSet.add("im_transinbill");
                    continue;
                }
                mulnosumbiztypeSet.add(mulnojoinsumrange);
            }
        }
    }

    public static Set<String> getTransBizentityobjectSet() {
        HashSet<String> transBizentityobjectSet = new HashSet<String>(16);
        transBizentityobjectSet.add("im_transdirbill");
        transBizentityobjectSet.add("im_transoutbill");
        transBizentityobjectSet.add("im_transinbill");
        return transBizentityobjectSet;
    }

    public static Set<String> getOtherBizentityobjectSet(String mulnojoinsumrangeStr) {
        HashSet<String> otherBizentityobjectSet = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)mulnojoinsumrangeStr)) {
            String[] mulnojoinsumrangeStrs;
            for (String mulnojoinsumrange : mulnojoinsumrangeStrs = mulnojoinsumrangeStr.split(",")) {
                if (!StringUtils.isNotEmpty((String)mulnojoinsumrange) || "A".equals(mulnojoinsumrange) || "B".equals(mulnojoinsumrange)) continue;
                otherBizentityobjectSet.add(mulnojoinsumrange);
            }
        }
        return otherBizentityobjectSet;
    }

    public static DataSet createDataSet(ReportDataCtx ctx, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        ctx.getCurrentJob().commit(60, TimeUnit.MINUTES);
        return ctx.getCurrentJob().readDataSet(resultId);
    }

    public static String getFinalSelectFieldsWithNoQty(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        String select = BplatReportUtil.getFinalGroupCols(reportParam, ctx);
        select = select + "0 as periodbeginqty,periodbeginamount,0 as periodbeginprice,0 as periodinqty,periodinamount,0 as periodinprice,0 as periodoutqty,periodoutamount,0 as periodoutprice";
        select = select + ",0 as periodendqty,periodendamount,0 as periodendprice";
        return select;
    }

    public static String getFinalGroupCols(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        StringBuilder sql = new StringBuilder();
        Set showKeyCols = ctx.getShowKeyCols();
        HashSet<String> showKeyColsTemp = new HashSet<String>(16);
        showKeyColsTemp.addAll(showKeyCols);
        boolean notShowMaterialGroup = reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = reportParam.isHasMaterialGroup();
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            showKeyColsTemp.add("group");
        }
        for (String showKeyCol : showKeyColsTemp) {
            sql.append(showKeyCol);
            sql.append(",");
        }
        return sql.toString();
    }
}

