/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.HashSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class AddMaterialGroupDataxTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private StockGatherSumReportParam reportParam;

    public AddMaterialGroupDataxTransform(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = (StockGatherSumReportParam)ctx.getParam(StockGatherSumReportParam.class.getName());
    }

    public DataSetX doTransform(DataSetX srcData) {
        String[] selects;
        if (this.reportParam.isNotShowMaterialGroup()) {
            return srcData;
        }
        Object pkValue = 730148448254487552L;
        DynamicObject materialgroupstandard = this.reportParam.getMaterialgroupstandard();
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        DynamicObjectCollection materialgroup = this.reportParam.getMulmaterialgroup();
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(ReportUtil.getGroupFilter((DynamicObjectCollection)materialgroup, (boolean)false, (String)"group.longnumber"));
        }
        OrmInput input = new OrmInput("handleMaterialGroup", "bd_materialgroupdetail", "group,material,material.number as materialnumber", filter.toArray());
        DataSetX groupData = this.ctx.getCurrentJob().fromInput((Input)input);
        QFilter materialNumberFilter = this.getMaterialFromToFilter("materialNumber");
        if (materialNumberFilter != null) {
            String materialNumberFilterStr = materialNumberFilter.toString();
            groupData = groupData.filter(materialNumberFilterStr);
        }
        StringBuilder selectsBuilder = new StringBuilder();
        for (String fieldName : selects = srcData.getRowMeta().getFieldNames()) {
            if ("group".equals(fieldName)) continue;
            selectsBuilder.append(fieldName);
            selectsBuilder.append(",");
        }
        String selectStr = selectsBuilder.substring(0, selectsBuilder.length() - 1);
        srcData = srcData.join(groupData).on("material", "material").select(selectStr.split(","), new String[]{"group"});
        return srcData;
    }

    private QFilter getMaterialFromToFilter(String materialKey) {
        DynamicObjectCollection materialfrom = this.reportParam.getMaterialFrom();
        if (materialfrom instanceof DynamicObject) {
            DynamicObject from = (DynamicObject)materialfrom;
            DynamicObject to = this.reportParam.getMaterialTo();
            QFilter filter = new QFilter(materialKey, ">=", from.get("number"));
            if (to != null) {
                QFilter tofilter = new QFilter(materialKey, "<=", to.get("number"));
                filter = filter.and(tofilter);
            }
            return filter;
        }
        if (materialfrom instanceof DynamicObjectCollection) {
            DynamicObjectCollection froms = materialfrom;
            if (froms.size() == 0) {
                return null;
            }
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.getDynamicObject("fbasedataid").get("number"));
                }
                return new QFilter(materialKey, "in", idSet);
            }
            DynamicObject from = ((DynamicObject)froms.get(0)).getDynamicObject("fbasedataid");
            DynamicObject to = this.reportParam.getMaterialTo();
            QFilter filter = new QFilter(materialKey, ">=", from.get("number"));
            if (to != null) {
                filter.and(materialKey, "<=", to.get("number"));
            }
            return filter;
        }
        DynamicObject to = this.reportParam.getMaterialTo();
        QFilter filter = null;
        if (to != null) {
            filter = new QFilter(materialKey, "<=", to.get("number"));
        }
        return filter;
    }
}

