/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class AddMaterialGroupTotalDataxTransform
implements IDataTransform {
    private StockGatherSumReportParam reportParam;
    private ReportDataCtx ctx;

    public AddMaterialGroupTotalDataxTransform(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSet doTransform(DataSet dataSet) {
        int hierarchylevel = this.reportParam.getHierarchylevel();
        boolean topSumRow = this.reportParam.isTopSumRow();
        boolean isGroupByPeriod = this.reportParam.isGroupByPeriod();
        StringBuilder materialGroupFieldZero = new StringBuilder(",0 as mgid1");
        for (int i = 1; i <= hierarchylevel; ++i) {
            if (i == 1) continue;
            materialGroupFieldZero.append(",0 as mgid");
            materialGroupFieldZero.append(i);
        }
        String mgZeroStr = materialGroupFieldZero.toString();
        StringBuilder orderStr = new StringBuilder();
        if (BplatReportUtil.hasGroupByName(this.ctx.getShowKeyCols(), "costaccount")) {
            orderStr.append("costaccount");
            orderStr.append(",");
        }
        if (BplatReportUtil.hasGroupByName(this.ctx.getShowKeyCols(), "calorg")) {
            orderStr.append("calorg");
            orderStr.append(",");
        }
        orderStr.append("year,month,periodnumber");
        if (topSumRow) {
            orderStr.append(",ordercol desc");
        } else {
            orderStr.append(",ordercol");
        }
        if (topSumRow) {
            orderStr.append(",ordercol1 desc");
        } else {
            orderStr.append(",ordercol1");
        }
        DataSet totalDataSet = null;
        if (isGroupByPeriod) {
            DataSet allTotalDataSet = dataSet.copy();
            allTotalDataSet = allTotalDataSet.groupBy(BplatReportUtil.getGroupCols("3", this.reportParam, this.ctx).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").sum("periodendqty").sum("periodendamount").finish();
            allTotalDataSet = allTotalDataSet.select(BplatReportUtil.getFinalSelectFields("3", this.reportParam, this.ctx) + mgZeroStr);
            allTotalDataSet = allTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
            allTotalDataSet = allTotalDataSet.filter("currency != 0");
            dataSet = dataSet.addField("0", "ordercol").addField("0", "ordercol1").addField("case when material = 0 then 1 else 0 end", "linetype").union(allTotalDataSet.addField("1", "ordercol").addField("2", "ordercol1").addField("1", "linetype")).orderBy(orderStr.toString().split(","));
            if (this.reportParam.isShowtotalflag()) {
                totalDataSet = allTotalDataSet.copy();
                totalDataSet = totalDataSet.groupBy().sum("periodbeginqty").sum("periodbeginamount").sum("periodbeginprice").sum("periodinqty").sum("periodinamount").sum("periodinprice").sum("periodoutqty").sum("periodoutamount").sum("periodoutprice").sum("periodendqty").sum("periodendamount").sum("periodendprice").finish();
                totalDataSet = totalDataSet.select(BplatReportUtil.getAllTotalSelectFields(this.reportParam, this.ctx) + mgZeroStr);
                totalDataSet = totalDataSet.addField("2", "ordercol").addField("3", "ordercol1").addField("1", "linetype");
                totalDataSet = totalDataSet.select(dataSet.getRowMeta().getFieldNames());
                dataSet = topSumRow ? totalDataSet.union(dataSet) : dataSet.union(totalDataSet);
            }
            return dataSet;
        }
        DataSet periodTotalDataSet = dataSet.copy();
        periodTotalDataSet = periodTotalDataSet.where("material <> 0").groupBy(BplatReportUtil.getGroupCols("1", this.reportParam, this.ctx).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        periodTotalDataSet = periodTotalDataSet.select(BplatReportUtil.getFinalSelectFields("1", this.reportParam, this.ctx) + mgZeroStr);
        DataSet yearTotalDataSet = periodTotalDataSet.copy();
        yearTotalDataSet = yearTotalDataSet.groupBy(BplatReportUtil.getGroupCols("2", this.reportParam, this.ctx).split(",")).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)"id,period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost as yearinactualcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost as yearissueactualcost", (QFilter[])new QFilter[]{BplatReportUtil.getInitBillFilter(this.reportParam, true)}, null);
        beginDataSet = beginDataSet.groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish();
        yearTotalDataSet = yearTotalDataSet.join(beginDataSet, JoinType.LEFT).on("year", "year").select(new String[]{"costaccount", "calorg", "year", "0 as periodbeginqty", "0 as periodbeginamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount", "0 as periodendqty", "0 as periodendamount", "qtyprecision", "baseunit", "currency"}).finish();
        yearTotalDataSet = yearTotalDataSet.select(BplatReportUtil.getFinalSelectFields("2", this.reportParam, this.ctx) + mgZeroStr);
        DataSet allTotalDataSet = periodTotalDataSet.copy();
        allTotalDataSet = allTotalDataSet.groupBy(BplatReportUtil.getGroupCols("3", this.reportParam, this.ctx).split(",")).minP("periodnumber", "periodbeginqty").minP("periodnumber", "periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").maxP("periodnumber", "periodendqty").maxP("periodnumber", "periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish().select(new String[]{"costaccount", "calorg", "periodbeginqty", "periodbeginamount", "periodendqty+periodoutqty-periodbeginqty as periodinqty", "periodendamount+periodoutamount-periodbeginamount as periodinamount", "periodoutqty", "periodoutamount", "periodendqty", "periodendamount", "qtyprecision", "baseunit", "currency"});
        allTotalDataSet = allTotalDataSet.select(BplatReportUtil.getFinalSelectFields("3", this.reportParam, this.ctx) + mgZeroStr);
        periodTotalDataSet = periodTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
        allTotalDataSet = allTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
        yearTotalDataSet = yearTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
        dataSet = dataSet.addField("0", "ordercol").addField("0", "ordercol1").addField("case when material = 0 then 3 else 0 end", "linetype").union(periodTotalDataSet.addField("1", "ordercol").addField("2", "ordercol1").addField("4", "linetype")).union(yearTotalDataSet.addField("2", "ordercol").addField("3", "ordercol1").addField("5", "linetype")).union(allTotalDataSet.addField("3", "ordercol").addField("4", "ordercol1").addField("6", "linetype")).orderBy(orderStr.toString().split(","));
        if (this.reportParam.isShowtotalflag()) {
            totalDataSet = allTotalDataSet.copy();
            totalDataSet = totalDataSet.groupBy().sum("periodbeginqty").sum("periodbeginamount").sum("periodbeginprice").sum("periodinqty").sum("periodinamount").sum("periodinprice").sum("periodoutqty").sum("periodoutamount").sum("periodoutprice").sum("periodendqty").sum("periodendamount").sum("periodendprice").finish();
            totalDataSet = totalDataSet.select(BplatReportUtil.getAllTotalSelectFields(this.reportParam, this.ctx) + mgZeroStr);
            totalDataSet = totalDataSet.addField("4", "ordercol").addField("5", "ordercol1").addField("7", "linetype");
            totalDataSet = totalDataSet.select(dataSet.getRowMeta().getFieldNames());
            dataSet = topSumRow ? totalDataSet.union(dataSet) : dataSet.union(totalDataSet);
        }
        return dataSet;
    }
}

