/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;
import kd.fi.cal.report.newreport.stocksumlrpt.function.BeginConDataReduceFuction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.BeginOutConDataMapFuction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ChangeCostelementGroupReduceFunction;

public class BeginOutConNoinDataxTransform
implements IDataXTransform {
    private StockGatherSumReportParam reportParam;
    private ReportDataCtx ctx;

    public BeginOutConNoinDataxTransform(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.reportParam.isShowdetail() && this.reportParam.isCostsubelementHasTotal()) {
            String groupSelect = null;
            Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
            StringBuilder builderUnDetail = new StringBuilder();
            if (allKeyCols != null && allKeyCols.size() > 0) {
                allKeyCols.addAll(this.ctx.getShowKeyCols());
                allKeyCols.add("entryid");
                for (String keyCol : allKeyCols) {
                    builderUnDetail.append(keyCol);
                    builderUnDetail.append(",");
                }
            }
            groupSelect = builderUnDetail.substring(0, builderUnDetail.length() - 1);
            srcData = srcData.groupBy(groupSelect.split(",")).reduceGroup((GroupReduceFunction)new ChangeCostelementGroupReduceFunction(srcData.getRowMeta()));
        }
        srcData = srcData.map((MapFunction)new BeginOutConDataMapFuction(srcData.getRowMeta()));
        srcData = srcData.reduceGroup((GroupReduceFunction)new BeginConDataReduceFuction(srcData.getRowMeta(), this.reportParam.getPeriodNumberList()));
        return srcData;
    }
}

