/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.List;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ChangeBalDataDataGroupReduceFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ChangeCostelementGroupReduceFunction;

public class ChangeBalDataDataXTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private List<Integer> periodNumberList;
    private boolean showdetail;
    private boolean costsubelementHasTotal;

    public ChangeBalDataDataXTransform(ReportDataCtx ctx, List<Integer> periodNumberList, boolean showdetail, boolean costsubelementHasTotal) {
        this.ctx = ctx;
        this.periodNumberList = periodNumberList;
        this.showdetail = showdetail;
        this.costsubelementHasTotal = costsubelementHasTotal;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.groupBy(new String[]{"calorg", "costaccount", "material"}).reduceGroup((GroupReduceFunction)new ChangeBalDataDataGroupReduceFunction(srcData.getRowMeta(), this.periodNumberList));
        String groupSelect = null;
        Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        StringBuilder builderUnDetail = new StringBuilder();
        if (allKeyCols != null && allKeyCols.size() > 0) {
            allKeyCols.addAll(this.ctx.getShowKeyCols());
            for (String keyCol : allKeyCols) {
                builderUnDetail.append(keyCol);
                builderUnDetail.append(",");
            }
        }
        groupSelect = builderUnDetail.substring(0, builderUnDetail.length() - 1);
        if (!this.showdetail) {
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            srcData = balCompress ? srcData.groupBy(groupSelect.split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount") : srcData.groupBy(groupSelect.split(",")).max("periodbeginqty").sum("periodbeginamount").max("periodinqty").sum("periodinamount").max("periodoutqty").sum("periodoutamount").max("periodendqty").sum("periodendamount");
        } else if (this.costsubelementHasTotal) {
            srcData = srcData.groupBy(groupSelect.split(",")).reduceGroup((GroupReduceFunction)new ChangeCostelementGroupReduceFunction(srcData.getRowMeta()));
        }
        return srcData;
    }
}

