/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.List;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ChangeBalDataDataGroupReduceFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ChangeCostelementGroupReduceFunction;

public class ChangeBalanceDataDataXTransform
implements IDataXTransform {
    private List<Integer> periodNumberList;
    private ReportDataCtx ctx;
    private boolean showdetail;
    private boolean costsubelementHasTotal;

    public ChangeBalanceDataDataXTransform(ReportDataCtx ctx, boolean showdetail, List<Integer> periodNumberList, boolean costsubelementHasTotal) {
        this.periodNumberList = periodNumberList;
        this.ctx = ctx;
        this.showdetail = showdetail;
        this.costsubelementHasTotal = costsubelementHasTotal;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.groupBy(new String[]{"calorg", "costaccount", "material"}).reduceGroup((GroupReduceFunction)new ChangeBalDataDataGroupReduceFunction(srcData.getRowMeta(), this.periodNumberList));
        if (this.showdetail && this.costsubelementHasTotal) {
            String groupSelect = null;
            Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
            StringBuilder builderUnDetail = new StringBuilder();
            if (allKeyCols != null && allKeyCols.size() > 0) {
                allKeyCols.addAll(this.ctx.getShowKeyCols());
                for (String keyCol : allKeyCols) {
                    builderUnDetail.append(keyCol);
                    builderUnDetail.append(",");
                }
            }
            groupSelect = builderUnDetail.substring(0, builderUnDetail.length() - 1);
            srcData = srcData.groupBy(groupSelect.split(",")).reduceGroup((GroupReduceFunction)new ChangeCostelementGroupReduceFunction(srcData.getRowMeta()));
        }
        return srcData;
    }
}

