/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import kd.bos.algo.DataSet;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class DeleteFieldDataTransform
implements IDataTransform {
    private ReportDataCtx ctx;
    private StockGatherSumReportParam reportParam;

    public DeleteFieldDataTransform(ReportDataCtx ctx, StockGatherSumReportParam reportParam) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSet doTransform(DataSet srcData) {
        String[] selects;
        StringBuilder selectsBuilder = new StringBuilder();
        for (String fieldName : selects = srcData.getRowMeta().getFieldNames()) {
            if ("year".equals(fieldName) || "month".equals(fieldName) || "qtyprecision".equals(fieldName)) continue;
            selectsBuilder.append(fieldName);
            selectsBuilder.append(",");
        }
        String selectStr = selectsBuilder.substring(0, selectsBuilder.length() - 1);
        srcData = srcData.select(selectStr.split(","));
        if (!BplatReportUtil.hasGroupByName(this.ctx.getShowKeyCols(), "group")) {
            boolean notShowMaterialGroup = this.reportParam.isNotShowMaterialGroup();
            boolean hasMaterialGroup = this.reportParam.isHasMaterialGroup();
            if (!notShowMaterialGroup && !hasMaterialGroup) {
                String[] groupselects;
                StringBuilder groupBuilder = new StringBuilder();
                for (String fieldName : groupselects = srcData.getRowMeta().getFieldNames()) {
                    if ("group".equals(fieldName)) continue;
                    groupBuilder.append(fieldName);
                    groupBuilder.append(",");
                }
                String groupselectStr = groupBuilder.substring(0, groupBuilder.length() - 1);
                srcData = srcData.select(groupselectStr.split(","));
            }
        }
        return srcData;
    }
}

