/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class GroupByPeriodDataxTransform
implements IDataTransform {
    private StockGatherSumReportParam reportParam;
    private ReportDataCtx ctx;

    public GroupByPeriodDataxTransform(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSet doTransform(DataSet dataSet) {
        Set sumKeyColsSet = this.ctx.getSumKeyCols();
        if (sumKeyColsSet != null && sumKeyColsSet.size() > 0) {
            dataSet = dataSet.filter("linetype='0'");
            dataSet = dataSet.removeFields(new String[]{"linetype"});
        }
        DataSet dataSet1 = dataSet.groupBy(BplatReportUtil.getGroupIsGroupByPeriodStr(this.reportParam, this.ctx).split(",")).minP("periodnumber", "periodbeginqty", "periodbeginqty").minP("periodnumber", "periodbeginamount", "periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").maxP("periodnumber", "periodendqty", "periodendqty").maxP("periodnumber", "periodendamount", "periodendamount").finish();
        dataSet1 = dataSet1.addField("concat(concat('" + this.reportParam.getStartPeriod().getString("number") + "','-'),'" + this.reportParam.getEndPeriod().getString("number") + "')", "periodnumber").addField("0", "year").addField("0", "month");
        dataSet1 = dataSet1.select(BplatReportUtil.getFinalSelectFields(this.reportParam, this.ctx).split(","));
        boolean notShowMaterialGroup = this.reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = this.reportParam.isHasMaterialGroup();
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            dataSet1 = dataSet1.addField("0", "group");
        }
        dataSet = dataSet1 = dataSet1.select(dataSet.getRowMeta().getFieldNames());
        return dataSet;
    }
}

