/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ChangeCostelementGroupReduceFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.InConDataMapFuction;

public class InConNoinDataxTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private boolean showdetail;
    private boolean costsubelementHasTotal;

    public InConNoinDataxTransform(ReportDataCtx ctx, boolean showdetail, boolean costsubelementHasTotal) {
        this.ctx = ctx;
        this.showdetail = showdetail;
        this.costsubelementHasTotal = costsubelementHasTotal;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.showdetail && this.costsubelementHasTotal) {
            String groupSelect = null;
            Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
            StringBuilder builderUnDetail = new StringBuilder();
            if (allKeyCols != null && allKeyCols.size() > 0) {
                allKeyCols.addAll(this.ctx.getShowKeyCols());
                allKeyCols.add("entryid");
                for (String keyCol : allKeyCols) {
                    builderUnDetail.append(keyCol);
                    builderUnDetail.append(",");
                }
            }
            groupSelect = builderUnDetail.substring(0, builderUnDetail.length() - 1);
            srcData = srcData.groupBy(groupSelect.split(",")).reduceGroup((GroupReduceFunction)new ChangeCostelementGroupReduceFunction(srcData.getRowMeta()));
        }
        srcData = srcData.map((MapFunction)new InConDataMapFuction(srcData.getRowMeta()));
        return srcData;
    }
}

