/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ShowCostsubelementAllZeroReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ShowCostsubelementAmountReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ShowCostsubelementNoInOutReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ShowCostsubelementQtyReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.ShowCostsubelementReduceFunction;

public class QtyAmountFilterDataxTransform
implements IDataXTransform {
    private StockGatherSumReportParam reportParam;
    private ReportDataCtx ctx;

    public QtyAmountFilterDataxTransform(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        boolean noShowZeroInOut = this.reportParam.isNoShowZeroInOut();
        String qtyShowCondition = this.reportParam.getQtyShowCondition();
        String amountShowCondition = this.reportParam.getAmountShowCondition();
        boolean showAllZero = this.reportParam.isShowAllZero();
        boolean showdetail = this.reportParam.isShowdetail();
        boolean costsubelementHasTotal = this.reportParam.isCostsubelementHasTotal();
        if (showdetail) {
            StringBuilder groupSbStr = new StringBuilder();
            Set showKeyCols = this.ctx.getShowKeyCols();
            for (String showKey : showKeyCols) {
                if ("costelement".equals(showKey) || "costelementnum".equals(showKey) || "costsubelement".equals(showKey) || "costsubelementnum".equals(showKey)) continue;
                groupSbStr.append(showKey);
                groupSbStr.append(",");
            }
            String groupStr = groupSbStr.substring(0, groupSbStr.length() - 1);
            if (!costsubelementHasTotal) {
                srcData = srcData.groupBy(groupStr.split(",")).reduceGroup((GroupReduceFunction)new ShowCostsubelementReduceFunction(srcData.getRowMeta()));
            }
            if (noShowZeroInOut) {
                srcData = srcData.groupBy(groupStr.split(",")).reduceGroup((GroupReduceFunction)new ShowCostsubelementNoInOutReFunction(srcData.getRowMeta()));
            }
            if (StringUtils.isNotEmpty((String)qtyShowCondition)) {
                srcData = srcData.groupBy(groupStr.split(",")).reduceGroup((GroupReduceFunction)new ShowCostsubelementQtyReFunction(srcData.getRowMeta(), qtyShowCondition));
            }
            if (StringUtils.isNotEmpty((String)amountShowCondition)) {
                srcData = srcData.groupBy(groupStr.split(",")).reduceGroup((GroupReduceFunction)new ShowCostsubelementAmountReFunction(srcData.getRowMeta(), amountShowCondition));
            }
            if (!showAllZero) {
                srcData = srcData.groupBy(groupStr.split(",")).reduceGroup((GroupReduceFunction)new ShowCostsubelementAllZeroReFunction(srcData.getRowMeta()));
            }
        } else {
            if (noShowZeroInOut) {
                srcData = srcData.filter("periodinqty <> 0 or periodinamount <> 0 or periodoutqty <> 0 or periodoutamount <> 0");
            }
            if (StringUtils.isNotEmpty((String)qtyShowCondition)) {
                if ("A".equals(qtyShowCondition)) {
                    srcData = srcData.filter("periodendqty = 0");
                } else if ("B".equals(qtyShowCondition)) {
                    srcData = srcData.filter("periodendqty <> 0");
                } else if ("C".equals(qtyShowCondition)) {
                    srcData = srcData.filter("periodendqty > 0");
                } else if ("D".equals(qtyShowCondition)) {
                    srcData = srcData.filter("periodendqty < 0");
                }
            }
            if (StringUtils.isNotEmpty((String)amountShowCondition)) {
                if ("A".equals(amountShowCondition)) {
                    srcData = srcData.filter("periodendamount = 0");
                } else if ("B".equals(amountShowCondition)) {
                    srcData = srcData.filter("periodendamount <> 0");
                } else if ("C".equals(amountShowCondition)) {
                    srcData = srcData.filter("periodendamount > 0");
                } else if ("D".equals(amountShowCondition)) {
                    srcData = srcData.filter("periodendamount < 0");
                }
            }
            if (!showAllZero) {
                srcData = srcData.filter("periodbeginqty <> 0 or periodbeginamount <> 0 or periodinqty <> 0 or periodinamount <> 0 or periodoutqty <> 0 or periodoutamount <> 0  or periodendqty <> 0 or periodendamount <> 0");
            }
        }
        return srcData;
    }
}

