/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;
import kd.fi.cal.report.newreport.stocksumlrpt.function.PeriodCostsubelementAllZeroReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.PeriodCostsubelementAmountReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.PeriodCostsubelementNoInOutReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.PeriodCostsubelementQtyReFunction;
import kd.fi.cal.report.newreport.stocksumlrpt.function.PeriodCostsubelementReduceFunction;

public class QtyAmountFilterGroupByPeriodDataTransform
implements IDataTransform {
    private StockGatherSumReportParam reportParam;
    private ReportDataCtx ctx;

    public QtyAmountFilterGroupByPeriodDataTransform(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSet doTransform(DataSet srcData) {
        DataSet resultData = srcData;
        String qtyShowCondition = this.reportParam.getQtyShowCondition();
        String amountShowCondition = this.reportParam.getAmountShowCondition();
        boolean showAllZero = this.reportParam.isShowAllZero();
        boolean showdetail = this.reportParam.isShowdetail();
        boolean costsubelementHasTotal = this.reportParam.isCostsubelementHasTotal();
        boolean noShowZeroInOut = this.reportParam.isNoShowZeroInOut();
        if (showdetail) {
            StringBuilder groupSbStr = new StringBuilder();
            Set showKeyCols = this.ctx.getShowKeyCols();
            for (String showKey : showKeyCols) {
                if ("costelement".equals(showKey) || "costelementnum".equals(showKey) || "costsubelement".equals(showKey) || "costsubelementnum".equals(showKey)) continue;
                groupSbStr.append(showKey);
                groupSbStr.append(",");
            }
            String groupStr = groupSbStr.substring(0, groupSbStr.length() - 1);
            if (!costsubelementHasTotal) {
                resultData = resultData.groupBy(groupStr.split(",")).reduceGroup((ReduceGroupFunctionWithCollector)new PeriodCostsubelementReduceFunction(resultData.getRowMeta()));
            }
            if (noShowZeroInOut) {
                resultData = resultData.groupBy(groupStr.split(",")).reduceGroup((ReduceGroupFunctionWithCollector)new PeriodCostsubelementNoInOutReFunction(resultData.getRowMeta()));
            }
            if (StringUtils.isNotEmpty((String)qtyShowCondition)) {
                resultData = resultData.groupBy(groupStr.split(",")).reduceGroup((ReduceGroupFunctionWithCollector)new PeriodCostsubelementQtyReFunction(resultData.getRowMeta(), qtyShowCondition));
            }
            if (StringUtils.isNotEmpty((String)amountShowCondition)) {
                resultData = resultData.groupBy(groupStr.split(",")).reduceGroup((ReduceGroupFunctionWithCollector)new PeriodCostsubelementAmountReFunction(resultData.getRowMeta(), amountShowCondition));
            }
            if (!showAllZero) {
                resultData = resultData.groupBy(groupStr.split(",")).reduceGroup((ReduceGroupFunctionWithCollector)new PeriodCostsubelementAllZeroReFunction(resultData.getRowMeta()));
            }
        } else {
            if (noShowZeroInOut) {
                resultData = resultData.filter("periodinqty <> 0 or periodinamount <> 0 or periodoutqty <> 0 or periodoutamount <> 0");
            }
            if (StringUtils.isNotEmpty((String)qtyShowCondition)) {
                if ("A".equals(qtyShowCondition)) {
                    resultData = resultData.filter("periodendqty = 0");
                } else if ("B".equals(qtyShowCondition)) {
                    resultData = resultData.filter("periodendqty <> 0");
                } else if ("C".equals(qtyShowCondition)) {
                    resultData = resultData.filter("periodendqty > 0");
                } else if ("D".equals(qtyShowCondition)) {
                    resultData = resultData.filter("periodendqty < 0");
                }
            }
            if (StringUtils.isNotEmpty((String)amountShowCondition)) {
                if ("A".equals(amountShowCondition)) {
                    resultData = resultData.filter("periodendamount = 0");
                } else if ("B".equals(amountShowCondition)) {
                    resultData = resultData.filter("periodendamount <> 0");
                } else if ("C".equals(amountShowCondition)) {
                    resultData = resultData.filter("periodendamount > 0");
                } else if ("D".equals(amountShowCondition)) {
                    resultData = resultData.filter("periodendamount < 0");
                }
            }
            if (!showAllZero) {
                resultData = resultData.filter("periodbeginqty <> 0 or periodbeginamount <> 0 or periodinqty <> 0 or periodinamount <> 0 or periodoutqty <> 0 or periodoutamount <> 0  or periodendqty <> 0 or periodendamount <> 0");
            }
        }
        return resultData;
    }
}

