/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform;

import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class UnionGroupRowDataxTransform
implements IDataTransform {
    private StockGatherSumReportParam reportParam;
    private ReportDataCtx ctx;

    public UnionGroupRowDataxTransform(StockGatherSumReportParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSet doTransform(DataSet dataSet) {
        boolean isGroupByPeriod = this.reportParam.isGroupByPeriod();
        if (!isGroupByPeriod) {
            String[] selects;
            dataSet = dataSet.filter("linetype='0'");
            StringBuilder selectsBuilder = new StringBuilder();
            for (String string : selects = dataSet.getRowMeta().getFieldNames()) {
                if ("linetype".equals(string)) continue;
                selectsBuilder.append(string);
                selectsBuilder.append(",");
            }
            String selectStr = selectsBuilder.substring(0, selectsBuilder.length() - 1);
            dataSet = dataSet.select(selectStr.split(","));
        }
        DataSet periodHappenTotalDataSet = dataSet.copy();
        boolean showdetail = this.reportParam.isShowdetail();
        if (showdetail) {
            periodHappenTotalDataSet = periodHappenTotalDataSet.groupBy(BplatReportUtil.getGroupCols("0", this.reportParam, this.ctx).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
            dataSet = dataSet.select(BplatReportUtil.getFinalSelectFieldsWithNoQty(this.reportParam, this.ctx).split(","));
            dataSet = dataSet.filter("periodbeginamount <> 0 or periodinamount <> 0 or periodoutamount <> 0 or periodendamount <> 0");
        } else {
            periodHappenTotalDataSet = periodHappenTotalDataSet.groupBy(BplatReportUtil.getGroupCols("0", this.reportParam, this.ctx).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        }
        periodHappenTotalDataSet = periodHappenTotalDataSet.select(BplatReportUtil.getFinalSelectFields("0", this.reportParam, this.ctx).split(","));
        DataSet totalDataSet = null;
        String[] dataSetselects = dataSet.getRowMeta().getFieldNames();
        StringBuilder dataSetselectsBuilder = new StringBuilder();
        for (String fieldName : dataSetselects) {
            dataSetselectsBuilder.append(fieldName);
            dataSetselectsBuilder.append(",");
        }
        if (isGroupByPeriod) {
            DataSet dataSet4 = periodHappenTotalDataSet.copy();
            dataSet4 = dataSet4.groupBy(BplatReportUtil.getGroupCols("3", this.reportParam, this.ctx).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").sum("periodendqty").sum("periodendamount").finish();
            dataSet4 = dataSet4.select(BplatReportUtil.getFinalSelectFields("3", this.reportParam, this.ctx).split(","));
            StringBuilder periodHappenTotalDataSetsb = new StringBuilder();
            periodHappenTotalDataSetsb.append((CharSequence)dataSetselectsBuilder);
            periodHappenTotalDataSet = periodHappenTotalDataSet.select(periodHappenTotalDataSetsb.append("0 as ordercol").append(",").append("1 as ordercol1").append(",").append("3 as linetype").toString().split(","));
            StringBuilder allTotalDataSetsb = new StringBuilder();
            allTotalDataSetsb.append((CharSequence)dataSetselectsBuilder);
            DataSet dataSet5 = dataSet4.select(allTotalDataSetsb.append("1 as ordercol").append(",").append("2 as ordercol1").append(",").append("6 as linetype").toString().split(","));
            StringBuilder dataSetsb = new StringBuilder();
            dataSetsb.append((CharSequence)dataSetselectsBuilder);
            dataSet = dataSet.select(dataSetsb.append("0 as ordercol").append(",").append("0 as ordercol1").append(",").append("0 as linetype").toString().split(","));
            dataSet = dataSet.union(periodHappenTotalDataSet).union(dataSet5).orderBy(BplatReportUtil.getOrders(this.reportParam, this.ctx).split(","));
            if (this.reportParam.isShowtotalflag()) {
                totalDataSet = dataSet5.copy();
                totalDataSet = totalDataSet.groupBy().sum("periodbeginqty").sum("periodbeginamount").sum("periodbeginprice").sum("periodinqty").sum("periodinamount").sum("periodinprice").sum("periodoutqty").sum("periodoutamount").sum("periodoutprice").sum("periodendqty").sum("periodendamount").sum("periodendprice").finish();
                totalDataSet = totalDataSet.select(BplatReportUtil.getAllTotalSelectFields(this.reportParam, this.ctx).split(","));
                StringBuilder totalDataSetsb = new StringBuilder();
                totalDataSetsb.append((CharSequence)dataSetselectsBuilder);
                totalDataSet = totalDataSet.select(totalDataSetsb.append("2 as ordercol").append(",").append("3 as ordercol1").append(",").append("7 as linetype").toString().split(","));
                boolean topSumRow = this.reportParam.isTopSumRow();
                dataSet = topSumRow ? totalDataSet.union(dataSet) : dataSet.union(totalDataSet);
            }
            return dataSet;
        }
        DataSet dataSet8 = periodHappenTotalDataSet.copy();
        dataSet8 = dataSet8.groupBy(BplatReportUtil.getGroupCols("1", this.reportParam, this.ctx).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        dataSet8 = dataSet8.select(BplatReportUtil.getFinalSelectFields("1", this.reportParam, this.ctx).split(","));
        DataSet yearTotalDataSet = dataSet8.copy();
        yearTotalDataSet = yearTotalDataSet.groupBy(BplatReportUtil.getGroupCols("2", this.reportParam, this.ctx).split(",")).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)"id,period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost as yearinactualcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost as yearissueactualcost", (QFilter[])new QFilter[]{BplatReportUtil.getInitBillFilter(this.reportParam, true)}, null);
        beginDataSet = beginDataSet.groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish();
        yearTotalDataSet = yearTotalDataSet.join(beginDataSet, JoinType.LEFT).on("year", "year").select(new String[]{"costaccount", "calorg", "year", "0 as periodbeginqty", "0 as periodbeginamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount", "0 as periodendqty", "0 as periodendamount", "qtyprecision", "baseunit", "currency"}).finish();
        yearTotalDataSet = yearTotalDataSet.select(BplatReportUtil.getFinalSelectFields("2", this.reportParam, this.ctx).split(","));
        DataSet allTotalDataSet = dataSet8.copy();
        allTotalDataSet = allTotalDataSet.groupBy(BplatReportUtil.getGroupCols("3", this.reportParam, this.ctx).split(",")).minP("periodnumber", "periodbeginqty").minP("periodnumber", "periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").maxP("periodnumber", "periodendqty").maxP("periodnumber", "periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish().select(new String[]{"costaccount", "calorg", "periodbeginqty", "periodbeginamount", "periodendqty+periodoutqty-periodbeginqty as periodinqty", "periodendamount+periodoutamount-periodbeginamount as periodinamount", "periodoutqty", "periodoutamount", "periodendqty", "periodendamount", "qtyprecision", "baseunit", "currency"});
        allTotalDataSet = allTotalDataSet.select(BplatReportUtil.getFinalSelectFields("3", this.reportParam, this.ctx).split(","));
        StringBuilder periodHappenTotalDataSetsb1 = new StringBuilder();
        periodHappenTotalDataSetsb1.append((CharSequence)dataSetselectsBuilder);
        periodHappenTotalDataSet = periodHappenTotalDataSet.select(periodHappenTotalDataSetsb1.append("0 as ordercol").append(",").append("1 as ordercol1").append(",").append("3 as linetype").toString().split(","));
        StringBuilder periodTotalDataSetsb1 = new StringBuilder();
        periodTotalDataSetsb1.append((CharSequence)dataSetselectsBuilder);
        DataSet dataSet9 = dataSet8.select(periodTotalDataSetsb1.append("1 as ordercol").append(",").append("2 as ordercol1").append(",").append("4 as linetype").toString().split(","));
        StringBuilder allTotalDataSetsb1 = new StringBuilder();
        allTotalDataSetsb1.append((CharSequence)dataSetselectsBuilder);
        allTotalDataSet = allTotalDataSet.select(allTotalDataSetsb1.append("3 as ordercol").append(",").append("4 as ordercol1").append(",").append("6 as linetype").toString().split(","));
        StringBuilder yearTotalDataSetsb1 = new StringBuilder();
        yearTotalDataSetsb1.append((CharSequence)dataSetselectsBuilder);
        yearTotalDataSet = yearTotalDataSet.select(yearTotalDataSetsb1.append("2 as ordercol").append(",").append("3 as ordercol1").append(",").append("5 as linetype").toString().split(","));
        StringBuilder dataSetsb1 = new StringBuilder();
        dataSetsb1.append((CharSequence)dataSetselectsBuilder);
        dataSet = dataSet.select(dataSetsb1.append("0 as ordercol").append(",").append("0 as ordercol1").append(",").append("0 as linetype").toString().split(","));
        dataSet = dataSet.union(periodHappenTotalDataSet).union(dataSet9).union(yearTotalDataSet).union(allTotalDataSet).orderBy(BplatReportUtil.getOrders(this.reportParam, this.ctx).split(","));
        if (this.reportParam.isShowtotalflag()) {
            totalDataSet = allTotalDataSet.copy();
            totalDataSet = totalDataSet.groupBy().sum("periodbeginqty").sum("periodbeginamount").sum("periodbeginprice").sum("periodinqty").sum("periodinamount").sum("periodinprice").sum("periodoutqty").sum("periodoutamount").sum("periodoutprice").sum("periodendqty").sum("periodendamount").sum("periodendprice").finish();
            totalDataSet = totalDataSet.select(BplatReportUtil.getAllTotalSelectFields(this.reportParam, this.ctx).split(","));
            StringBuilder totalDataSetsb1 = new StringBuilder();
            totalDataSetsb1.append((CharSequence)dataSetselectsBuilder);
            totalDataSet = totalDataSet.select(totalDataSetsb1.append("4 as ordercol").append(",").append("5 as ordercol1").append(",").append("7 as linetype").toString().split(","));
            boolean topSumRow = this.reportParam.isTopSumRow();
            dataSet = topSumRow ? totalDataSet.union(dataSet) : dataSet.union(totalDataSet);
        }
        return dataSet;
    }
}

