/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.PrintHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.base.CalAuxptyFilterHelper;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class StockGatherReportBplatForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(StockGatherReportBplatForm.class);
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private static final List<String> HEAD_FIELD_LIST = Arrays.asList("material_ref_number", "material", "material_ref_modelnum", "costelementnum", "costelement", "costsubelementnum", "costsubelement");

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulcalrange".equals(key)) {
            this.beforeF7Select4MulCalrange(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e, this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4NewMulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e, (String)"mulcalorg");
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Mulcalorgowner(e);
        } else if ("materialgroupstandard".equals(key)) {
            this.beforeMaterialgroupstandard(e);
        } else if ("mulmaterialgroup".equals(key)) {
            this.beforeF7SelectMaterialGroup(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mulnosumbiztype".equals(key)) {
            this.beforeF7SelectMulnosumbiztype(e);
        } else if ("auxproperty".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxProperty(showParameter);
        } else if ("auxdetailbd".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxpropertydetail(showParameter, (IFormView)this.getView());
        } else if ("mulsubelementfilter".equals(key)) {
            QFilter q = new QFilter("syncflag", "=", (Object)"1");
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7SelectMulnosumbiztype(BeforeF7SelectEvent e) {
        String mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange");
        HashSet<String> mulnosumbiztypeSet = new HashSet<String>(16);
        BplatReportUtil.setMulNoSumBiztypeSet(mulnojoinsumrangeStr, mulnosumbiztypeSet);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billentity.billform", "in", mulnosumbiztypeSet);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<Object> idList = new ArrayList<Object>(bizTypes.size());
        for (DynamicObject bizType : bizTypes) {
            idList.add(bizType.get("id"));
        }
        QFilter idf = new QFilter("id", "in", idList);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(idf.toArray()));
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        HashSet<Long> periodIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> periodCostAccountMap = new HashMap<Long, DynamicObject>(16);
        if (costaccountList == null || costaccountList.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockGatherReportBplatForm_3", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        for (DynamicObject costaccount : costaccountList) {
            DynamicObject startPeriod = PeriodHelper.getCurrentPeriod((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (startPeriod == null) continue;
            periodIdSet.add(startPeriod.getLong("id"));
            periodCostAccountMap.put(startPeriod.getLong("id"), costaccount.getDynamicObject("fbasedataid"));
        }
        if (periodIdSet.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        Long periodId = (Long)Collections.min(periodIdSet);
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)((DynamicObject)periodCostAccountMap.get(periodId)));
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        if (orgIds.isEmpty()) {
            params.put("isShowAllNoOrg", "true");
            formShowParameter.setCustomParams(params);
        } else {
            params.put("useOrgs", orgIds);
            formShowParameter.setCustomParams(params);
        }
        formShowParameter.getListFilterParameter().getQFilters().add(qFilter.and(serviceResponse));
    }

    private void beforeMaterialgroupstandard(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            return;
        }
        HashSet materialIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
            materialIdSet.addAll(ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", materialIdSet));
    }

    private void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue("mulstorageorg");
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet warehouseIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg.getDynamicObject("fbasedataid"));
            warehouseIdSet.addAll(set);
        }
        if (warehouseIdSet.size() > 0) {
            q = new QFilter("id", "in", warehouseIdSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)model.getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4MulCalrange(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costaccounts != null && costaccounts.size() > 0) {
            HashSet<Long> costaccountIdSet = new HashSet<Long>();
            for (DynamicObject costaccount : costaccounts) {
                costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("costaccount", "in", costaccountIdSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = UserServiceHelper.getCurrentUserId();
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stock_gather_newrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "mulcalrange", "mulstorageorg", "mulwarehouse", "mullocation", "startperiod", "endperiod", "mulmaterial", "mulowner", "materialgroupstandard", "mulmaterialgroup", "materialto", "multracknum", "mulnosumbiztype", "auxproperty", "auxdetailbd", "mulsubelementfilter");
        CalAuxptyFilterHelper.addAuxdetailbasebdRegister((Object)this);
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if (key != null && key.contains("material")) {
                    StockGatherReportBplatForm.this.hyperLinkMaterialNameClick(evt);
                }
            }
        });
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        } else if ("showkeycols".equals(key)) {
            this.changedShowKeyCols();
            this.setSumKeyCol();
        } else if ("sumkeycols".equals(key)) {
            this.changedSumKeyCols(e);
        } else if ("mulnojoinsumrange".equals(key)) {
            this.getModel().setValue("mulnosumbiztype", null);
            String mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange");
            if (kd.bos.util.StringUtils.isEmpty((String)mulnojoinsumrangeStr)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"mulnosumbiztype"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"mulnosumbiztype"});
            }
            boolean mulbeginconoutnoindata = (Boolean)this.getModel().getValue("mulbeginconoutnoindata");
            if (kd.bos.util.StringUtils.isNotEmpty((String)mulnojoinsumrangeStr) && mulbeginconoutnoindata && (mulnojoinsumrangeStr.contains("A") || mulnojoinsumrangeStr.contains("B"))) {
                String colsStr = "calorg,costaccount,material";
                this.getModel().setValue("showkeycols", (Object)colsStr);
            }
        } else if ("auxproperty".equals(key)) {
            CalAuxptyFilterHelper.handleAuxpropertyChangeEvent(newValue, rowIndex, (IFormView)this.getView());
        } else if ("auxdetailbasebd".equals(key)) {
            CalAuxptyFilterHelper.handleAuxdetailBdChagneEvent(newValue, rowIndex, this.getView().getModel());
        } else if ("showdetail".equals(key)) {
            boolean showdetail = (Boolean)this.getModel().getValue("showdetail");
            if (showdetail) {
                boolean showallzero = (Boolean)this.getModel().getValue("showallzero");
                boolean noshowzeroinout = (Boolean)this.getModel().getValue("noshowzeroinout");
                String amountshowcondition = (String)this.getModel().getValue("amountshowcondition");
                String qtyshowcondition = (String)this.getModel().getValue("qtyshowcondition");
                if (!showallzero && !noshowzeroinout && kd.bos.util.StringUtils.isEmpty((String)amountshowcondition) && kd.bos.util.StringUtils.isEmpty((String)qtyshowcondition)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
                this.getModel().setValue("mulsubelementfilter", null);
            }
        } else if ("showallzero".equals(key)) {
            this.setMulSubelementFilter();
        } else if ("noshowzeroinout".equals(key)) {
            this.setMulSubelementFilter();
        } else if ("amountshowcondition".equals(key)) {
            this.setMulSubelementFilter();
        } else if ("qtyshowcondition".equals(key)) {
            this.setMulSubelementFilter();
        }
    }

    private void setMulSubelementFilter() {
        boolean showdetail = (Boolean)this.getModel().getValue("showdetail");
        if (showdetail) {
            boolean showallzero = (Boolean)this.getModel().getValue("showallzero");
            boolean noshowzeroinout = (Boolean)this.getModel().getValue("noshowzeroinout");
            String amountshowcondition = (String)this.getModel().getValue("amountshowcondition");
            String qtyshowcondition = (String)this.getModel().getValue("qtyshowcondition");
            if (showallzero || noshowzeroinout || !kd.bos.util.StringUtils.isEmpty((String)amountshowcondition) || !kd.bos.util.StringUtils.isEmpty((String)qtyshowcondition)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
                this.getModel().setValue("mulsubelementfilter", null);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
            }
        }
    }

    private void changedShowKeyCols() {
        String warehouse;
        String storageorgunitT;
        String storageorgunit;
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String hasCostMatCal = null;
        if (kd.bos.util.StringUtils.isEmpty((String)colsStr)) {
            colsStr = "calorg,costaccount,material";
            hasCostMatCal = "material";
        }
        boolean hasGroup = false;
        String ownerLessCol = null;
        String[] colsStrs = colsStr.split(",");
        HashSet<String> colsStrSet = new HashSet<String>(16);
        StringBuilder sb = new StringBuilder();
        for (String col : colsStrs) {
            if (kd.bos.util.StringUtils.isEmpty((String)col)) continue;
            if ("group".equals(col)) {
                hasGroup = true;
            }
            colsStrSet.add(col);
            sb.append(col);
            sb.append(",");
        }
        if (!colsStrSet.contains("calorg")) {
            sb.append("calorg");
            sb.append(",");
            hasCostMatCal = "calorg";
        }
        if (!colsStrSet.contains("material")) {
            sb.append("material");
            sb.append(",");
            hasCostMatCal = "material";
        }
        if (!colsStrSet.contains("costaccount")) {
            sb.append("costaccount");
            sb.append(",");
            hasCostMatCal = "costaccount";
        }
        colsStr = sb.toString();
        if (colsStrSet.contains("ownertype") && !colsStrSet.contains("owner")) {
            colsStr = colsStr.replace("ownertype", " ");
            ownerLessCol = "ownertype";
            colsStrSet.remove("ownertype");
        }
        if ((storageorgunit = this.checkCoupleItem(colsStr, "warehouse", "storageorgunit")) != null) {
            colsStr = storageorgunit;
        }
        if ((storageorgunitT = this.checkCoupleItem(colsStr, "location", "storageorgunit")) != null && !colsStr.contains("storageorgunit")) {
            colsStr = storageorgunitT;
        }
        if ((warehouse = this.checkCoupleItem(colsStr, "location", "warehouse")) != null && !colsStr.contains("warehouse")) {
            colsStr = warehouse;
        }
        if (storageorgunit != null || storageorgunitT != null || warehouse != null || hasCostMatCal != null || ownerLessCol != null) {
            this.getModel().setValue("showkeycols", (Object)colsStr);
        }
        if (hasGroup) {
            DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
            long matgroupstandardId = 730148448254487552L;
            if (null == materialgroupstandard) {
                this.getModel().setValue("materialgroupstandard", (Object)matgroupstandardId);
            }
        }
        if (hasGroup && !BplatReportUtil.hasMaterialGroupOtherFlag(colsStrSet)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"sumkeycols"});
            this.getModel().setValue("sumkeycols", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"level"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
            this.getModel().setValue("mulsubelementfilter", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"showdetail"});
            this.getModel().setValue("showdetail", (Object)Boolean.FALSE);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"sumkeycols"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"level"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"showdetail"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
        }
        String mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange");
        boolean mulbeginconoutnoindata = (Boolean)this.getModel().getValue("mulbeginconoutnoindata");
        if (kd.bos.util.StringUtils.isNotEmpty((String)mulnojoinsumrangeStr) && mulbeginconoutnoindata && (mulnojoinsumrangeStr.contains("A") || mulnojoinsumrangeStr.contains("B"))) {
            colsStr = "calorg,costaccount,material";
            this.getModel().setValue("showkeycols", (Object)colsStr);
        }
    }

    private String checkCoupleItem(String str, String hasVal, String addVal) {
        CharSequence[] items = str.split(",");
        int hasValIdx = -1;
        int addValIdx = -1;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].equals(hasVal)) {
                hasValIdx = i;
                continue;
            }
            if (!items[i].equals(addVal)) continue;
            addValIdx = i;
        }
        if (hasValIdx > -1 && addValIdx == -1) {
            items[hasValIdx] = hasVal + "," + addVal;
            return String.join((CharSequence)",", items) + ",";
        }
        return null;
    }

    private void calOrgChanged() {
        this.getModel().setValue("mulstorageorg", null);
        this.getModel().setValue("mulowner", null);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            this.getModel().setValue("mulcostaccount", null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue("mulcostaccount", (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue("mulcostaccount", null);
            }
            this.getModel().setValue("ownertypehead", (Object)"bos_org");
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        this.getModel().setValue("mulcalrange", null);
        this.getModel().setValue("mulowner", null);
        this.getModel().setValue("mulsupplierownerfrom", null);
        this.getModel().setValue("mulcustomerownerfrom", null);
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        HashSet<Object> calpolicyIdSet = new HashSet<Object>();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccounts) {
            calpolicyIdSet.add(costaccount.getDynamicObject("fbasedataid").getDynamicObject("calpolicy").getPkValue());
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicyIdSet)});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        HashSet<Long> periodIds = new HashSet<Long>();
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            periodIds.add(period.getLong("id"));
        }
        if (periodIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long maxid = (Long)Collections.max(periodIds);
        Long minid = (Long)Collections.min(periodIds);
        this.getModel().setValue("startperiod", (Object)(periodIds.size() == 0 ? null : minid));
        this.getModel().setValue("endperiod", (Object)(periodIds.size() == 0 ? null : maxid));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        DynamicObjectCollection costaccountList = dataEntity.getDynamicObjectCollection("mulcostaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calOrgList == null || calOrgList.size() == 0 || costaccountList == null || costaccountList.size() == 0 || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        String colsStr = (String)this.getModel().getValue("showkeycols");
        if (kd.bos.util.StringUtils.isEmpty((String)colsStr)) {
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.calbycostelement", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        Long defaultCurrency = 0L;
        HashMap<Integer, Long> currencyAmtprecisionMap = new HashMap<Integer, Long>(16);
        HashSet<Integer> amtprecisionSet = new HashSet<Integer>(16);
        HashSet<Boolean> uncalbycostelementSet = new HashSet<Boolean>(16);
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
            Long currencyId = calpolicy.getLong("calpolicy.currency");
            int amtprecision = calpolicy.getInt("calpolicy.currency.amtprecision");
            amtprecisionSet.add(amtprecision);
            currencyAmtprecisionMap.put(amtprecision, currencyId);
            boolean calbycostelement = calpolicy.getBoolean("calpolicy.calbycostelement");
            if (calbycostelement) continue;
            uncalbycostelementSet.add(calbycostelement);
        }
        boolean showdetail = dataEntity.getBoolean("showdetail");
        if (showdetail && !uncalbycostelementSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u975e\u5206\u9879\u7684\u8d26\u7c3f\uff0c\u4e0d\u5141\u8bb8\u5f00\u542f\u6309\u5206\u9879\u7ed3\u8f6c\u660e\u7ec6\u67e5\u770b", (String)"StockGatherRptFormPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (!amtprecisionSet.isEmpty()) {
            defaultCurrency = (Long)currencyAmtprecisionMap.get(Collections.max(amtprecisionSet));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        boolean showtotalflag = dataEntity.getBoolean("calshowtotal");
        boolean onlyshowsumrow = dataEntity.getBoolean("onlyshowsumrow");
        boolean topsumrow = dataEntity.getBoolean("topsumrow");
        if (showtotalflag || onlyshowsumrow || topsumrow) {
            boolean hasSumCols = false;
            String sumColsStr = (String)this.getModel().getValue("sumkeycols");
            if (!kd.bos.util.StringUtils.isEmpty((String)sumColsStr)) {
                String[] sumColsStrs;
                for (String sumCol : sumColsStrs = sumColsStr.split(",")) {
                    if (kd.bos.util.StringUtils.isEmpty((String)sumCol)) continue;
                    hasSumCols = true;
                    break;
                }
            }
            if (!hasSumCols && !this.hasMaterialGroupOtherFlag()) {
                String showColsStr = (String)this.getModel().getValue("showkeycols");
                ArrayList<String> sumColList = new ArrayList<String>(16);
                if (!kd.bos.util.StringUtils.isEmpty((String)showColsStr)) {
                    String[] showColsStrs;
                    for (String showCol : showColsStrs = showColsStr.split(",")) {
                        if (kd.bos.util.StringUtils.isEmpty((String)showCol)) continue;
                        sumColList.add(showCol);
                    }
                }
                if (!sumColList.isEmpty()) {
                    FilterInfo filter = queryParam.getFilter();
                    if (sumColList.size() == 3) {
                        this.getModel().setValue("sumkeycols", (Object)",material,");
                        filter.getFilterItem("sumkeycols").setValue((Object)",material,");
                    } else {
                        for (String sumCol : sumColList) {
                            if ("material".equals(sumCol) || "calorg".equals(sumCol) || "costaccount".equals(sumCol) || "ownertype".equals(sumCol)) continue;
                            this.getModel().setValue("sumkeycols", (Object)("," + sumCol + ","));
                            filter.getFilterItem("sumkeycols").setValue((Object)("," + sumCol + ","));
                            break;
                        }
                    }
                }
            }
        }
        StockGatherSumReportParam stockGatherSumReportParam = this.buildStockGatherSumReportParam(dataEntity, costAccountInfoS, queryParam);
        List headFilters = queryParam.getFilter().getHeadFilters();
        List<QFilter> balanceHeadFilters = BplatReportUtil.getBalanceHeadFilters(headFilters);
        stockGatherSumReportParam.setBalanceHeadFilters(balanceHeadFilters);
        stockGatherSumReportParam.setDefaultCurrency(defaultCurrency);
        this.getQueryParam().getCustomParam().put(StockGatherSumReportParam.class.getName(), stockGatherSumReportParam);
        return super.verifyQuery(queryParam);
    }

    private StockGatherSumReportParam buildStockGatherSumReportParam(DynamicObject dataEntity, DynamicObjectCollection costAccountInfoS, ReportQueryParam queryParam) {
        StockGatherSumReportParam stockGatherSumReportParam = new StockGatherSumReportParam();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        for (DynamicObject costaccount : costaccounts) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        Map costAccountStartPeriodMap = PeriodHelper.getStartPeriods(costaccountIdSet);
        stockGatherSumReportParam.setCostAccountStartPeriodMap(costAccountStartPeriodMap);
        stockGatherSumReportParam.setCostaccountIdSet(costaccountIdSet);
        DynamicObject startperiod = dataEntity.getDynamicObject("startperiod");
        stockGatherSumReportParam.setStartPeriod(startperiod);
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        stockGatherSumReportParam.setEndPeriod(endperiod);
        Date filter_endDate = endperiod.getDate("enddate");
        stockGatherSumReportParam.setFilter_endDate(filter_endDate);
        Date filter_startDate = startperiod.getDate("begindate");
        stockGatherSumReportParam.setFilter_startDate(filter_startDate);
        Date filter_endStartDate = endperiod.getDate("begindate");
        stockGatherSumReportParam.setFilter_endStartDate(filter_endStartDate);
        boolean isNewGoupModel = AcctGroupModelHelper.isNewGroupModel();
        stockGatherSumReportParam.setNewGoupModel(isNewGoupModel);
        QFilter q = new QFilter("periodtype", "=", ((DynamicObject)costAccountInfoS.get(0)).get("calpolicy.periodtype"));
        q.and(new QFilter("isadjustperiod", "=", (Object)false));
        q.and("id", ">=", (Object)startperiod.getLong("id"));
        q.and("id", "<=", (Object)endperiod.getLong("id"));
        ArrayList<Integer> periodNumberList = new ArrayList<Integer>(16);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            int periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            periodNumberList.add(periodNumber);
        }
        Integer startPeriodNumber = (Integer)Collections.min(periodNumberList);
        stockGatherSumReportParam.setStartPeriodNumber(startPeriodNumber);
        Integer endPeriodNumber = (Integer)Collections.max(periodNumberList);
        stockGatherSumReportParam.setEndPeriodNumber(endPeriodNumber);
        stockGatherSumReportParam.setPeriodNumberList(periodNumberList);
        boolean isGroupByPeriod = dataEntity.getBoolean("groupbyperiod");
        stockGatherSumReportParam.setGroupByPeriod(isGroupByPeriod);
        boolean noShowZeroInOut = dataEntity.getBoolean("noshowzeroinout");
        stockGatherSumReportParam.setNoShowZeroInOut(noShowZeroInOut);
        boolean showAllZero = dataEntity.getBoolean("showallzero");
        stockGatherSumReportParam.setShowAllZero(showAllZero);
        boolean onlyshowsumrow = dataEntity.getBoolean("onlyshowsumrow");
        stockGatherSumReportParam.setOnlyShowSumRow(onlyshowsumrow);
        boolean topsumrow = dataEntity.getBoolean("topsumrow");
        stockGatherSumReportParam.setTopSumRow(topsumrow);
        Long currencyId = dataEntity.getDynamicObject("localcurrency").getLong("id");
        stockGatherSumReportParam.setCurrencyId(currencyId);
        DynamicObjectCollection filter_ownerFrom = null;
        String filter_ownertype = dataEntity.getString("ownertypehead");
        stockGatherSumReportParam.setOwnertype(filter_ownertype);
        if (kd.bos.util.StringUtils.isNotEmpty((String)filter_ownertype)) {
            if ("bos_org".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        stockGatherSumReportParam.setOwnerFrom(filter_ownerFrom);
        DynamicObjectCollection filter_mulcalrange = dataEntity.getDynamicObjectCollection("mulcalrange");
        stockGatherSumReportParam.setMulcalrange(filter_mulcalrange);
        DynamicObjectCollection filter_storageOrg = dataEntity.getDynamicObjectCollection("mulstorageorg");
        stockGatherSumReportParam.setStorageOrg(filter_storageOrg);
        DynamicObjectCollection filter_warehouse = dataEntity.getDynamicObjectCollection("mulwarehouse");
        stockGatherSumReportParam.setWarehouse(filter_warehouse);
        DynamicObjectCollection filter_location = dataEntity.getDynamicObjectCollection("mullocation");
        stockGatherSumReportParam.setLocation(filter_location);
        DynamicObjectCollection filter_materialFrom = dataEntity.getDynamicObjectCollection("mulmaterial");
        stockGatherSumReportParam.setMaterialFrom(filter_materialFrom);
        DynamicObject filter_materialTo = dataEntity.getDynamicObject("materialto");
        stockGatherSumReportParam.setMaterialTo(filter_materialTo);
        String qtyShowCondition = dataEntity.getString("qtyshowcondition");
        stockGatherSumReportParam.setQtyShowCondition(qtyShowCondition);
        String amountShowCondition = dataEntity.getString("amountshowcondition");
        stockGatherSumReportParam.setAmountShowCondition(amountShowCondition);
        String filter_mulaccounttype = dataEntity.getString("mulaccounttype");
        stockGatherSumReportParam.setMulaccounttype(filter_mulaccounttype);
        DynamicObject materialgroupstandard = dataEntity.getDynamicObject("materialgroupstandard");
        stockGatherSumReportParam.setMaterialgroupstandard(materialgroupstandard);
        DynamicObjectCollection mulmaterialgroup = dataEntity.getDynamicObjectCollection("mulmaterialgroup");
        stockGatherSumReportParam.setMulmaterialgroup(mulmaterialgroup);
        DynamicObjectCollection mulwarehsgroup = dataEntity.getDynamicObjectCollection("mulwarehsgroup");
        stockGatherSumReportParam.setMulwarehsgroup(mulwarehsgroup);
        DynamicObjectCollection mulmatcategory = dataEntity.getDynamicObjectCollection("mulmatcategory");
        stockGatherSumReportParam.setMatcategory(mulmatcategory);
        boolean onlyqueryemptygroup = dataEntity.getBoolean("onlyqueryemptygroup");
        stockGatherSumReportParam.setOnlyqueryemptygroup(onlyqueryemptygroup);
        boolean notShowMaterialGroup = materialgroupstandard == null && (mulmaterialgroup == null || mulmaterialgroup.size() < 1);
        stockGatherSumReportParam.setNotShowMaterialGroup(notShowMaterialGroup);
        int hierarchylevel = dataEntity.getInt("level");
        stockGatherSumReportParam.setHierarchylevel(hierarchylevel);
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String[] showKeyCols = colsStr.split(",");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stock_std_col_repo");
        HashMap<String, IDataEntityProperty> dataEntityPropertyMap = new HashMap<String, IDataEntityProperty>();
        for (String showKeyCol : showKeyCols) {
            if (kd.bos.util.StringUtils.isEmpty((String)showKeyCol)) continue;
            IDataEntityProperty property = entityType.findProperty(showKeyCol);
            dataEntityPropertyMap.put(showKeyCol, property);
            if (!"owner".equals(showKeyCol)) continue;
            dataEntityPropertyMap.put("ownertype", entityType.findProperty("ownertype"));
        }
        boolean showdetail = dataEntity.getBoolean("showdetail");
        stockGatherSumReportParam.setColsStr(colsStr);
        stockGatherSumReportParam.setDataEntityPropertyMap(dataEntityPropertyMap);
        stockGatherSumReportParam.setNewBalanceFlag(this.isNewBalance);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            stockGatherSumReportParam.setCalorgIdSet(calOrgIds);
        }
        boolean showtotalflag = dataEntity.getBoolean("calshowtotal");
        stockGatherSumReportParam.setShowtotalflag(showtotalflag);
        String mulnojoinsumrange = (String)this.getModel().getValue("mulnojoinsumrange");
        stockGatherSumReportParam.setMulnojoinsumrange(mulnojoinsumrange);
        HashSet<Long> mulnosumbiztypeIdSet = new HashSet<Long>();
        DynamicObjectCollection mulnosumbiztypes = dataEntity.getDynamicObjectCollection("mulnosumbiztype");
        for (DynamicObject mulnosumbiztype : mulnosumbiztypes) {
            mulnosumbiztypeIdSet.add(mulnosumbiztype.getDynamicObject("fbasedataid").getLong("id"));
        }
        stockGatherSumReportParam.setMulnosumbiztypeIdSet(mulnosumbiztypeIdSet);
        HashSet<String> mulbizbillstrSet = new HashSet<String>();
        BplatReportUtil.setMulNoSumBiztypeSet(mulnojoinsumrange, mulbizbillstrSet);
        stockGatherSumReportParam.setMulbizbillstrSet(mulbizbillstrSet);
        boolean mulbeginconoutnoindata = dataEntity.getBoolean("mulbeginconoutnoindata");
        stockGatherSumReportParam.setMulbeginconoutnoindata(mulbeginconoutnoindata);
        List<Object> auxptyIds = CalAuxptyFilterHelper.getAuxptyIds(this.getView().getModel());
        stockGatherSumReportParam.setAuxptyIds(auxptyIds);
        boolean noShowZero = dataEntity.getBoolean("noshowzero");
        stockGatherSumReportParam.setNoShowZero(noShowZero);
        stockGatherSumReportParam.setShowdetail(showdetail);
        DynamicObjectCollection costsubelements = dataEntity.getDynamicObjectCollection("mulsubelementfilter");
        HashSet<Long> costsubelementSet = new HashSet<Long>(16);
        for (DynamicObject costsubelement : costsubelements) {
            costsubelementSet.add(costsubelement.getDynamicObject("fbasedataid").getLong("id"));
        }
        stockGatherSumReportParam.setCostsubelementSet(costsubelementSet);
        return stockGatherSumReportParam;
    }

    public DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = UserServiceHelper.getCurrentUserId();
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stock_gather_newrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
        this.resetFilterGrid();
        this.changedShowKeyCols();
        this.setSumKeyCol();
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getView().getModel(), (IFormView)this.getView());
        boolean showdetail = (Boolean)this.getModel().getValue("showdetail");
        if (showdetail) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
            this.getModel().setValue("mulsubelementfilter", null);
        }
        this.setMulSubelementFilter();
    }

    public void afterBindData(EventObject e) {
        boolean showdetail;
        super.afterBindData(e);
        this.changedShowKeyCols();
        String mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange");
        if (kd.bos.util.StringUtils.isEmpty((String)mulnojoinsumrangeStr)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulnosumbiztype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulnosumbiztype"});
        }
        boolean mulbeginconoutnoindata = (Boolean)this.getModel().getValue("mulbeginconoutnoindata");
        if (kd.bos.util.StringUtils.isNotEmpty((String)mulnojoinsumrangeStr) && mulbeginconoutnoindata && (mulnojoinsumrangeStr.contains("A") || mulnojoinsumrangeStr.contains("B"))) {
            String colsStr = "calorg,costaccount,material";
            this.getModel().setValue("showkeycols", (Object)colsStr);
        }
        if (showdetail = ((Boolean)this.getModel().getValue("showdetail")).booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
            this.getModel().setValue("mulsubelementfilter", null);
        }
        this.setMulSubelementFilter();
    }

    private void setSumKeyCol() {
        String colsStr = (String)this.getModel().getValue("showkeycols");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        if (!kd.bos.util.StringUtils.isEmpty((String)colsStr)) {
            String[] colsStrs = colsStr.split(",");
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"cal_stock_std_col_repo").getProperties();
            for (String col : colsStrs) {
                if (col.isEmpty() || !properties.containsKey((Object)col) || "costaccount".equals(col) || "calorg".equals(col) || "ownertype".equals(col)) continue;
                ComboItem item = null;
                item = "material".equals(col) ? new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599", (String)"StockGatherReportBplatForm_11", (String)"fi-cal-report", (Object[])new Object[0])), col) : new ComboItem(((IDataEntityProperty)properties.get((Object)col)).getDisplayName(), col);
                propertyItems.add(item);
            }
        }
        if (propertyItems.size() > 0) {
            ComboEdit sumkeycols = (ComboEdit)this.getControl("sumkeycols");
            sumkeycols.setComboItems(propertyItems);
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            String columnName = event.getColumnName();
            if (!HEAD_FIELD_LIST.contains(columnName)) continue;
            event.setFilter(true);
        }
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName) || !this.filterGridForDetail(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGridForDetail(String fieldName) {
        HashSet<String> set = new HashSet<String>();
        set.add("material.isuseauxpty");
        set.add("material.enablelot");
        set.add("material.group.fullname");
        set.add("material.group.longnumber");
        set.add("material.group.name");
        set.add("material.group.number");
        set.add("material.modelnum");
        set.add("materialcategory.number");
        set.add("materialcategory.longnumber");
        set.add("materialcategory.name");
        return !set.contains(fieldName);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("calorg");
        removedPros.add("owner");
        removedPros.add("ownertype");
        removedPros.add("storageorgunit");
        removedPros.add("warehouse");
        removedPros.add("location");
        removedPros.add("year");
        removedPros.add("month");
        removedPros.add("period");
        removedPros.add("endperiod");
        removedPros.add("baseunit");
        removedPros.add("currency");
        removedPros.add("qtyprecision");
        removedPros.add("calrange");
        removedPros.add("accounttype");
        removedPros.add("periodnumber");
        removedPros.add("group");
        removedPros.add("assist");
        removedPros.add("warehsgroup");
        removedPros.add("materialcategory");
        removedPros.add("tracknumber.description");
        removedPros.add("entryid");
        removedPros.add("mversion");
        removedPros.add("costelement");
        removedPros.add("costelementnum");
        removedPros.add("costsubelement");
        removedPros.add("costsubelementnum");
        return !removedPros.contains(split[0]);
    }

    private void hyperLinkMaterialNameClick(HyperLinkClickEvent evt) {
        DynamicObject costsubelement;
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = this.getView().getQueryParam().getFilter().clone();
        DynamicObject row = evt.getRowData();
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String[] showKeyCols = colsStr.split(",");
        HashSet<String> showKeyColsSet = new HashSet<String>(16);
        for (String showKeyCol : showKeyCols) {
            if (kd.bos.util.StringUtils.isEmpty((String)showKeyCol)) continue;
            showKeyColsSet.add(showKeyCol);
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "owner")) {
            String ownerType = row.getString("ownertype");
            DynamicObject info = row.getDynamicObject("owner");
            if ("bos_org".equals(ownerType)) {
                filter.getFilterItem("mulowner").setValue((Object)info);
            } else if ("bd_supplier".equals(ownerType)) {
                filter.getFilterItem("mulsupplierownerfrom").setValue((Object)info);
            } else if ("bd_customer".equals(ownerType)) {
                filter.getFilterItem("mulcustomerownerfrom").setValue((Object)info);
            }
            filter.getFilterItem("ownertypehead").setValue((Object)ownerType);
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "storageorgunit")) {
            filter.getFilterItem("mulstorageorg").setValue((Object)row.getDynamicObject("storageorgunit"));
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "warehsgroup")) {
            DynamicObject warehsgroup = row.getDynamicObject("warehsgroup");
            if (warehsgroup == null) {
                filter.addFilterItem("onlyqueryemptygroup", (Object)true);
            } else {
                filter.getFilterItem("mulwarehsgroup").setValue((Object)warehsgroup);
            }
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "warehouse")) {
            filter.getFilterItem("mulwarehouse").setValue((Object)row.getDynamicObject("warehouse"));
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "location") && row.getString("location") != null && kd.bos.util.StringUtils.isNotEmpty((String)row.getString("location").trim())) {
            filter.getFilterItem("mullocation").setValue((Object)row.getDynamicObject("location"));
        }
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "materialcategory")) {
            filter.getFilterItem("mulmatcategory").setValue((Object)row.getDynamicObject("materialcategory"));
        }
        DynamicObject info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_material"));
        info.set("id", row.getDynamicObject("material").get("id"));
        DynamicObjectCollection coll = new DynamicObjectCollection();
        coll.add((Object)info);
        filter.getFilterItem("mulmaterial").setValue((Object)coll);
        filter.getFilterItem("materialto").setValue((Object)info);
        filter.addFilterItem("ordertype", (Object)"A");
        filter.getFilterItem("qtyshowcondition").setValue(null);
        filter.getFilterItem("amountshowcondition").setValue(null);
        filter.getFilterItem("noshowzeroinout").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("onlyshowsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("topsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItems().remove(filter.getFilterItem("mulgrouptype"));
        filter.getFilterItems().remove(filter.getFilterItem("groupbyperiod"));
        filter.getFilterItems().remove(filter.getFilterItem("sumkeycols"));
        filter.getFilterItems().remove(filter.getFilterItem("showkeycols"));
        filter.getFilterItems().remove(filter.getFilterItem("calshowtotal"));
        filter.getFilterItems().remove(filter.getFilterItem("showqtycols"));
        filter.getFilterItems().remove(filter.getFilterItem("showtotalqty"));
        DynamicObject costaccount = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_bd_costaccount"));
        costaccount.set("id", row.getDynamicObject("costaccount").get("id"));
        DynamicObjectCollection costaccountcoll = new DynamicObjectCollection();
        costaccountcoll.add((Object)costaccount);
        filter.getFilterItem("mulcostaccount").setValue((Object)costaccountcoll);
        DynamicObject calOrg = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
        calOrg.set("id", row.getDynamicObject("calorg").get("id"));
        DynamicObjectCollection calOrgcoll = new DynamicObjectCollection();
        calOrgcoll.add((Object)calOrg);
        filter.getFilterItem("mulcalorg").setValue((Object)calOrgcoll);
        boolean groupByPeriod = filter.getFilterItem("groupbyperiod").getBoolean();
        Long costAccountId = row.getDynamicObject("costaccount").getLong("id");
        if (groupByPeriod) {
            String periodnumber = row.getString("periodnumber");
            int startYearNumber = Integer.parseInt(periodnumber.split("-")[0]);
            int endYearNumber = Integer.parseInt(periodnumber.split("-")[1]);
            DynamicObject startPeriod = this.getPeriodByYearMonth(costAccountId, null, startYearNumber / 100, startYearNumber % 100);
            DynamicObject endPeriod = this.getPeriodByYearMonth(costAccountId, null, endYearNumber / 100, endYearNumber % 100);
            filter.getFilterItem("startperiod").setValue((Object)startPeriod);
            filter.getFilterItem("endperiod").setValue((Object)endPeriod);
        } else {
            int periodnumber = Integer.parseInt(row.getString("periodnumber"));
            DynamicObject period = this.getPeriodByYearMonth(costAccountId, null, periodnumber / 100, periodnumber % 100);
            filter.getFilterItem("startperiod").setValue((Object)period);
            filter.getFilterItem("endperiod").setValue((Object)period);
        }
        String mulnojoinsumrange = (String)this.getModel().getValue("mulnojoinsumrange");
        filter.getFilterItem("mulnojoinsumrange").setValue((Object)mulnojoinsumrange);
        boolean mulbeginconoutnoindata = filter.getBoolean("mulbeginconoutnoindata");
        filter.getFilterItem("mulbeginconoutnoindata").setValue((Object)mulbeginconoutnoindata);
        boolean noshowzero = filter.getBoolean("noshowzero");
        filter.getFilterItem("noshowzero").setValue((Object)noshowzero);
        DynamicObjectCollection mulnosumbiztypes = filter.getDynamicObjectCollection("mulnosumbiztype");
        filter.getFilterItem("mulnosumbiztype").setValue((Object)mulnosumbiztypes);
        boolean showdetail = filter.getBoolean("showdetail");
        filter.getFilterItem("showdetail").setValue((Object)showdetail);
        DynamicObjectCollection mulsubelementfilter = filter.getDynamicObjectCollection("mulsubelementfilter");
        filter.getFilterItem("mulsubelementfilter").setValue((Object)mulsubelementfilter);
        if (showdetail && (costsubelement = row.getDynamicObject("costsubelement")) != null) {
            filter.getFilterItem("mulsubelementfilter").setValue((Object)costsubelement);
        }
        queryParam.setFilter(filter);
        ReportShowParameter showParameter = new ReportShowParameter();
        FilterGrid grid = (FilterGrid)this.getControl("commonfs");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)grid.getEntityNumber());
        ArrayList<String> groupKeys = new ArrayList<String>(showKeyColsSet);
        String chosenGroup = (String)this.getModel().getValue("showkeycols");
        List needSendToDetail = Arrays.stream(chosenGroup.split(",")).filter(a -> !StringUtils.isEmpty((CharSequence)a)).collect(Collectors.toList());
        HashSet<String> pageQueryFields = new HashSet<String>();
        Container container = (Container)this.getView().getControl("fsap");
        List items = container.getItems();
        for (Control item : items) {
            String key = item.getKey();
            if (!kd.bos.util.StringUtils.isEmpty((String)key) && key.startsWith("mul")) {
                pageQueryFields.add(key.substring(3));
                continue;
            }
            if (kd.bos.util.StringUtils.isEmpty((String)key)) continue;
            pageQueryFields.add(key);
        }
        needSendToDetail.removeAll(pageQueryFields);
        needSendToDetail.remove("ownertype");
        needSendToDetail.remove("group");
        needSendToDetail.remove("materialcategory");
        needSendToDetail.remove("storageorgunit");
        for (String needSend : needSendToDetail) {
            if (!groupKeys.contains(needSend)) continue;
            Object obj = row.get(needSend);
            SimpleFilterRow filterRow = new SimpleFilterRow();
            filterRow.setLogic("0");
            IDataEntityProperty pro = type.findProperty(needSend);
            if (pro instanceof FlexProp) continue;
            boolean isBaseData = pro instanceof BasedataProp;
            String string = needSend = isBaseData ? needSend + ".number" : needSend;
            if (obj == null) {
                filterRow.setFieldName(needSend);
                filterRow.setCompareType(this.getIsNull(pro));
            } else {
                filterRow.setFieldName(needSend);
                filterRow.setCompareType(this.getEqual(pro));
                ArrayList<FilterValue> vals = new ArrayList<FilterValue>(1);
                FilterValue fVal = new FilterValue();
                Object val = row.get(needSend);
                if (pro instanceof DateTimeProp && val instanceof Date) {
                    val = ((DateTimeProp)pro).getDateFormat().format((Date)val);
                }
                fVal.setValue(val);
                vals.add(fVal);
                filterRow.setValue(vals);
            }
            condition.getFilterRow().add(filterRow);
        }
        StockDetailRptParam stockDetailRptParam = new StockDetailRptParam();
        stockDetailRptParam.setCondition(condition);
        if (BplatReportUtil.hasGroupByName(showKeyColsSet, "assist")) {
            DynamicObject auxpty = row.getDynamicObject("assist");
            if (auxpty != null) {
                stockDetailRptParam.setAuxptyId(auxpty.getLong("id"));
            }
            stockDetailRptParam.setAuxptyInfos(null);
        } else {
            stockDetailRptParam.setAuxptyId(null);
            stockDetailRptParam.setAuxptyInfos(CalAuxptyFilterHelper.getAuxptyInfos(this.getModel()));
        }
        showParameter.setCustomParam(StockDetailRptParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)stockDetailRptParam));
        showParameter.setFormId("cal_stockdetailrpt_newrpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void changedSumKeyCols(PropertyChangedArgs e) {
        String colsStr = (String)this.getModel().getValue("sumkeycols");
        if (!kd.bos.util.StringUtils.isEmpty((String)colsStr)) {
            String material;
            String warehouse;
            String storageorgunitT;
            String storageorgunit;
            String ownerLessCol = null;
            String[] colsStrs = colsStr.split(",");
            HashSet<String> colsStrSet = new HashSet<String>(16);
            StringBuilder sb = new StringBuilder();
            for (String col : colsStrs) {
                if (kd.bos.util.StringUtils.isEmpty((String)col)) continue;
                colsStrSet.add(col);
                sb.append(col);
                sb.append(",");
            }
            colsStr = sb.toString();
            if (colsStrSet.contains("ownertype") && !colsStrSet.contains("owner")) {
                colsStr = colsStr.replace("ownertype", " ");
                ownerLessCol = "ownertype";
            }
            if ((storageorgunit = this.checkCoupleItem(colsStr, "warehouse", "storageorgunit")) != null) {
                colsStr = storageorgunit;
            }
            if ((storageorgunitT = this.checkCoupleItem(colsStr, "location", "storageorgunit")) != null && !colsStr.contains("storageorgunit")) {
                colsStr = storageorgunitT;
            }
            if ((warehouse = this.checkCoupleItem(colsStr, "location", "warehouse")) != null && !colsStr.contains("warehouse")) {
                colsStr = warehouse;
            }
            if ((material = this.checkCoupleItem(colsStr, "assist", "material")) != null && !colsStr.contains("material")) {
                colsStr = material;
            }
            if (storageorgunit != null || storageorgunitT != null || warehouse != null || ownerLessCol != null || material != null) {
                this.getModel().setValue("sumkeycols", (Object)colsStr);
            }
        }
    }

    private boolean hasMaterialGroupOtherFlag() {
        String colsStr = (String)this.getModel().getValue("showkeycols");
        if (kd.bos.util.StringUtils.isEmpty((String)colsStr)) {
            colsStr = "calorg,costaccount,material";
        }
        boolean hasGroup = false;
        String[] colsStrs = colsStr.split(",");
        HashSet<String> colsStrSet = new HashSet<String>(16);
        for (String col : colsStrs) {
            if (kd.bos.util.StringUtils.isEmpty((String)col)) continue;
            if ("group".equals(col)) {
                hasGroup = true;
            }
            colsStrSet.add(col);
        }
        return hasGroup && !BplatReportUtil.hasMaterialGroupOtherFlag(colsStrSet);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.setSumKeyCol();
    }

    private String getIsNull(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSISNULL.getId();
        }
        return pro instanceof ItemClassTypeProp ? CompareTypeEnum.COMBOBOXISNULL.getId() : CompareTypeEnum.ISNULL.getId();
    }

    private String getEqual(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSEQUALS.getId();
        }
        return pro instanceof ItemClassTypeProp ? CompareTypeEnum.CHECKBOXEQUAL.getId() : CompareTypeEnum.EQUAL.getId();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getModel(), (IFormView)this.getView());
    }

    public void click(EventObject evt) {
        CalAuxptyFilterHelper.click(evt, (IFormPlugin)this, this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("printview".equals(key)) {
            this.printOperation();
        }
    }

    private void printOperation() {
        try {
            String templeteId;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
            HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)this.getView().getEntityId(), (String)"4730fc9e000000ac");
            boolean hasAll = rs.hasAllOrgPerm();
            List hasPermOrgs = rs.getHasPermOrgs();
            if (this.getModel().getValue("mulcalorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"StockDetailRptFormPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            Object calOrg = this.getModel().getValue("mulcalorg");
            DynamicObjectCollection calOrgs = (DynamicObjectCollection)calOrg;
            HashSet<Long> orgs = new HashSet<Long>();
            for (Object calOrgDynamic : calOrgs) {
                orgs.add(calOrgDynamic == null ? 0L : calOrgDynamic.getDynamicObject("fbasedataid").getLong("id"));
            }
            HashSet<Long> noPermOrgIds = new HashSet<Long>(16);
            for (Long id : orgs) {
                if (hasAll || hasPermOrgs == null || hasPermOrgs.contains(id)) continue;
                noPermOrgIds.add(id);
                return;
            }
            if (noPermOrgIds.size() > 0) {
                logger.info("print user has no permission==>{}", noPermOrgIds);
                return;
            }
            ReportView rptFormView = (ReportView)this.getExportAllView();
            if (rptFormView == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
            int rowCount = listModel.getRowCount();
            if (rowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String formId = "cal_stock_gather_newrpt";
            Object defaultTemplateId = PrintHelper.getDefaultTemplateId((String)formId);
            if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"StockDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String printName = formId + "_printsetting";
            String curPrintPattern = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)printName);
            Map printSetting = null;
            if (!kd.bos.util.StringUtils.isEmpty((String)curPrintPattern)) {
                printSetting = (Map)SerializationUtils.fromJsonString((String)curPrintPattern, Map.class);
            }
            if (defaultTemplateId == null && (printSetting == null || printSetting.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String string = printSetting == null || kd.bos.util.StringUtils.isEmpty((String)((String)printSetting.get("templateid"))) ? (defaultTemplateId == null ? null : defaultTemplateId.toString()) : (templeteId = (String)printSetting.get("templateid"));
            if (kd.bos.util.StringUtils.isEmpty((String)templeteId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            PrintWork work = new PrintWork();
            PrintTask task = new PrintTask();
            task.setTplId(templeteId);
            task.setPageId(listModel.getPageId());
            task.setFormId("cal_stock_gather_newrpt");
            task.setPrintType("report");
            task.setPkIds(null);
            work.setTaskList(Collections.singletonList(task));
            work.setPrintLang(RequestContext.get().getLang().getLangTag());
            work.setExpType("pdf");
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
            String url = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
            url = String.format(url, prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            logger.error("StockgatherRptFormPlugin printOperation", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u53ef\u80fd\u8d85\u65f6\u4e86\uff0c\u8bf7\u8bd5\u7740\u70b9\u4e0b\u5237\u65b0\u6309\u94ae\u3002", (String)"StockDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
    }

    public IFormView getExportAllView() {
        ReportQueryParam queryParam = this.getQueryParam();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        this.asyncQuery(queryParam, reportList, null);
        return reportList.getView();
    }

    private void asyncQuery(ReportQueryParam queryParam, ReportList reportList, String materialIds) {
        IReportCache var13 = ReportCacheManager.getInstance().getCache();
        var13.setReportQueryParam(this.getView().getPageId(), queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)reportList.getReportModel();
        reportModel.setPageId(this.getView().getPageId());
        reportList.setAsynQuery(true);
        reportList.submitTask(queryParam, (Object)materialIds);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        CalAuxptyFilterHelper.closedCallBack(evt, this.getView());
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        CalAuxptyFilterHelper.loadOtherEntryFilter(scheme, this.getView().getModel(), this.getView());
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        CalAuxptyFilterHelper.saveEntryFilter((IFormView)this.getView(), "auxentry");
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        List headFilters;
        super.beforeFieldPostBack(e);
        String key = e.getKey();
        if ("sumkeycols".equals(key) && !(headFilters = this.getQueryParam().getFilter().getHeadFilters()).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u91cd\u7f6e\u6f0f\u6597\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ReportTplForm_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            this.getView().updateView(key);
            e.setCancel(true);
        }
    }
}

