/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.util.Iterator;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class BeginConDataReduceFuction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private List<Integer> periodNumberList;

    public BeginConDataReduceFuction(RowMeta rowMeta, List<Integer> periodNumberList) {
        this.rowMeta = rowMeta;
        this.periodNumberList = periodNumberList;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        int periodnumberIndex = this.rowMeta.getFieldIndex("periodnumber");
        int yearIndex = this.rowMeta.getFieldIndex("year");
        int monthIndex = this.rowMeta.getFieldIndex("month");
        String[] fieldNames = this.rowMeta.getFieldNames();
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            int rowPeriodNumber = row.getInteger(periodnumberIndex);
            for (Integer periodNumber : this.periodNumberList) {
                if (rowPeriodNumber >= periodNumber) continue;
                RowX newRow = new RowX(this.rowMeta.getFieldCount());
                for (String fieldName : fieldNames) {
                    if ("periodnumber".equals(fieldName)) {
                        newRow.set(periodnumberIndex, (Object)periodNumber);
                        continue;
                    }
                    if ("month".equals(fieldName)) {
                        newRow.set(monthIndex, (Object)(periodNumber % 100));
                        continue;
                    }
                    if ("year".equals(fieldName)) {
                        newRow.set(yearIndex, (Object)(periodNumber / 100));
                        continue;
                    }
                    newRow.set(this.rowMeta.getFieldIndex(fieldName), row.get(this.rowMeta.getFieldIndex(fieldName)));
                }
                collector.collect(newRow);
            }
        }
    }
}

