/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class ChangeBalDataDataGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private List<Integer> periodNumberList;

    public ChangeBalDataDataGroupReduceFunction(RowMeta rowMeta, List<Integer> periodNumberList) {
        this.rowMeta = rowMeta;
        this.periodNumberList = periodNumberList;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int yearIndex = this.rowMeta.getFieldIndex("year");
        int monthIndex = this.rowMeta.getFieldIndex("month");
        int periodIndex = this.rowMeta.getFieldIndex("period");
        int periodbeginqtyIndex = this.rowMeta.getFieldIndex("periodbeginqty");
        int periodbeginamountIndex = this.rowMeta.getFieldIndex("periodbeginamount");
        int periodinqtyIndex = this.rowMeta.getFieldIndex("periodinqty");
        int periodinamountIndex = this.rowMeta.getFieldIndex("periodinamount");
        int periodoutqtyIndex = this.rowMeta.getFieldIndex("periodoutqty");
        int periodoutamountIndex = this.rowMeta.getFieldIndex("periodoutamount");
        int periodendqtyIndex = this.rowMeta.getFieldIndex("periodendqty");
        int periodendamountIndex = this.rowMeta.getFieldIndex("periodendamount");
        int periodnumberIndex = this.rowMeta.getFieldIndex("periodnumber");
        int endperiodIndex = this.rowMeta.getFieldIndex("endperiod");
        String[] fieldNames = this.rowMeta.getFieldNames();
        for (RowX row : iterable) {
            int year = row.getInteger(yearIndex);
            int month = row.getInteger(monthIndex);
            int rowPeriodNumber = year * 100 + month;
            row.set(periodnumberIndex, (Object)rowPeriodNumber);
            int endperiod = row.getInteger(endperiodIndex);
            for (Integer periodNumber : this.periodNumberList) {
                if (rowPeriodNumber < periodNumber && endperiod > periodNumber) {
                    RowX newRow = new RowX(this.rowMeta.getFieldCount());
                    for (String fieldName : fieldNames) {
                        if ("month".equals(fieldName)) {
                            newRow.set(monthIndex, (Object)(periodNumber % 100));
                            continue;
                        }
                        if ("year".equals(fieldName)) {
                            newRow.set(yearIndex, (Object)(periodNumber / 100));
                            continue;
                        }
                        if ("period".equals(fieldName)) {
                            newRow.set(periodIndex, (Object)(periodNumber % 100));
                            continue;
                        }
                        if ("periodnumber".equals(fieldName)) {
                            newRow.set(periodnumberIndex, (Object)periodNumber);
                            continue;
                        }
                        newRow.set(this.rowMeta.getFieldIndex(fieldName), row.get(this.rowMeta.getFieldIndex(fieldName)));
                    }
                    BigDecimal periodendqty = row.getBigDecimal(periodendqtyIndex);
                    BigDecimal periodendamount = row.getBigDecimal(periodendamountIndex);
                    newRow.set(periodbeginqtyIndex, (Object)periodendqty);
                    newRow.set(periodbeginamountIndex, (Object)periodendamount);
                    newRow.set(periodinqtyIndex, (Object)BigDecimal.ZERO);
                    newRow.set(periodinamountIndex, (Object)BigDecimal.ZERO);
                    newRow.set(periodoutqtyIndex, (Object)BigDecimal.ZERO);
                    newRow.set(periodoutamountIndex, (Object)BigDecimal.ZERO);
                    collector.collect(newRow);
                    continue;
                }
                if (rowPeriodNumber != periodNumber) continue;
                collector.collect(row);
            }
        }
    }
}

