/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class ChangeCostelementGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public ChangeCostelementGroupReduceFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int periodbeginqtyIndex = this.rowMeta.getFieldIndex("periodbeginqty");
        int periodinqtyIndex = this.rowMeta.getFieldIndex("periodinqty");
        int periodoutqtyIndex = this.rowMeta.getFieldIndex("periodoutqty");
        int periodendqtyIndex = this.rowMeta.getFieldIndex("periodendqty");
        Iterator<RowX> iterator = iterable.iterator();
        HashSet<BigDecimal> periodbeginqtySet = new HashSet<BigDecimal>(16);
        HashSet<BigDecimal> periodinqtySet = new HashSet<BigDecimal>(16);
        HashSet<BigDecimal> periodoutqtySet = new HashSet<BigDecimal>(16);
        HashSet<BigDecimal> periodendqtySet = new HashSet<BigDecimal>(16);
        ArrayList<RowX> resultRowxS = new ArrayList<RowX>(16);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            BigDecimal periodbeginqty = row.getBigDecimal(periodbeginqtyIndex);
            if (periodbeginqty == null) {
                periodbeginqty = BigDecimal.ZERO;
            }
            periodbeginqtySet.add(periodbeginqty);
            BigDecimal periodinqty = row.getBigDecimal(periodinqtyIndex);
            if (periodinqty == null) {
                periodinqty = BigDecimal.ZERO;
            }
            periodinqtySet.add(periodinqty);
            BigDecimal periodoutqty = row.getBigDecimal(periodoutqtyIndex);
            if (periodoutqty == null) {
                periodoutqty = BigDecimal.ZERO;
            }
            periodoutqtySet.add(periodoutqty);
            BigDecimal periodendqty = row.getBigDecimal(periodendqtyIndex);
            if (periodendqty == null) {
                periodendqty = BigDecimal.ZERO;
            }
            periodendqtySet.add(periodendqty);
            row.set(periodbeginqtyIndex, (Object)BigDecimal.ZERO);
            row.set(periodinqtyIndex, (Object)BigDecimal.ZERO);
            row.set(periodoutqtyIndex, (Object)BigDecimal.ZERO);
            row.set(periodendqtyIndex, (Object)BigDecimal.ZERO);
            resultRowxS.add(row);
        }
        if (!resultRowxS.isEmpty()) {
            ((RowX)resultRowxS.get(0)).set(periodbeginqtyIndex, Collections.max(periodbeginqtySet));
            ((RowX)resultRowxS.get(0)).set(periodinqtyIndex, Collections.max(periodinqtySet));
            ((RowX)resultRowxS.get(0)).set(periodoutqtyIndex, Collections.max(periodoutqtySet));
            ((RowX)resultRowxS.get(0)).set(periodendqtyIndex, Collections.max(periodendqtySet));
            for (RowX row : resultRowxS) {
                collector.collect(row);
            }
        }
    }
}

