/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;

public class FilterCostPeriodsReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<Long, DynamicObject> costAccountStartPeriodMap;

    public FilterCostPeriodsReduceFunction(RowMeta rowMeta, StockGatherSumReportParam reportParam) {
        this.rowMeta = rowMeta;
        this.costAccountStartPeriodMap = reportParam.getCostAccountStartPeriodMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX rowX : iterable) {
            int periodNumber;
            int periodnumberIndex;
            int periodnumberRow;
            int costaccountIndex;
            Long costaccountId = rowX.getLong(costaccountIndex = this.rowMeta.getFieldIndex("costaccount"));
            DynamicObject startPeriod = this.costAccountStartPeriodMap.get(costaccountId);
            if (startPeriod != null && (periodnumberRow = rowX.getInteger(periodnumberIndex = this.rowMeta.getFieldIndex("periodnumber")).intValue()) < (periodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber"))) continue;
            collector.collect(rowX);
        }
    }
}

