/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.util.StringUtils;

public class PeriodCostsubelementAmountReFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private String amountShowCondition;

    public PeriodCostsubelementAmountReFunction(RowMeta rowMeta, String amountShowCondition) {
        this.rowMeta = rowMeta;
        this.amountShowCondition = amountShowCondition;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterator<Row> iterable, Collector collector) {
        int periodendamountIndex = this.rowMeta.getFieldIndex("periodendamount");
        BigDecimal totalPeriodendamount = BigDecimal.ZERO;
        ArrayList<Object[]> resultRows = new ArrayList<Object[]>(16);
        while (iterable.hasNext()) {
            Row row = iterable.next();
            BigDecimal periodendamount = row.getBigDecimal(periodendamountIndex);
            if (null == periodendamount) {
                periodendamount = BigDecimal.ZERO;
            }
            totalPeriodendamount = totalPeriodendamount.add(periodendamount);
            Object[] copyRowVals = this.copyRow(row, this.rowMeta);
            resultRows.add(copyRowVals);
        }
        for (Object[] row : resultRows) {
            if (!StringUtils.isNotEmpty((String)this.amountShowCondition)) continue;
            if ("A".equals(this.amountShowCondition) && totalPeriodendamount.compareTo(BigDecimal.ZERO) == 0) {
                collector.collect(row);
                continue;
            }
            if ("B".equals(this.amountShowCondition) && totalPeriodendamount.compareTo(BigDecimal.ZERO) != 0) {
                collector.collect(row);
                continue;
            }
            if ("C".equals(this.amountShowCondition) && totalPeriodendamount.compareTo(BigDecimal.ZERO) > 0) {
                collector.collect(row);
                continue;
            }
            if (!"D".equals(this.amountShowCondition) || totalPeriodendamount.compareTo(BigDecimal.ZERO) >= 0) continue;
            collector.collect(row);
        }
    }

    private Object[] copyRow(Row row, RowMeta rowMeta) {
        Object[] currRowVals = new Object[rowMeta.getFieldCount()];
        for (int index = 0; index < rowMeta.getFieldCount(); ++index) {
            currRowVals[index] = row.get(index);
        }
        return currRowVals;
    }
}

