/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class PeriodCostsubelementNoInOutReFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public PeriodCostsubelementNoInOutReFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterator<Row> iterable, Collector collector) {
        int periodinqtyIndex = this.rowMeta.getFieldIndex("periodinqty");
        int periodinamountIndex = this.rowMeta.getFieldIndex("periodinamount");
        int periodoutqtyIndex = this.rowMeta.getFieldIndex("periodoutqty");
        int periodoutamountIndex = this.rowMeta.getFieldIndex("periodoutamount");
        BigDecimal totalPeriodinqty = BigDecimal.ZERO;
        BigDecimal totalPeriodoutqty = BigDecimal.ZERO;
        BigDecimal totalPeriodinamount = BigDecimal.ZERO;
        BigDecimal totalPeriodoutamount = BigDecimal.ZERO;
        ArrayList<Object[]> resultRows = new ArrayList<Object[]>(16);
        while (iterable.hasNext()) {
            Row row = iterable.next();
            BigDecimal periodinqty = row.getBigDecimal(periodinqtyIndex);
            if (null == periodinqty) {
                periodinqty = BigDecimal.ZERO;
            }
            totalPeriodinqty = totalPeriodinqty.add(periodinqty);
            BigDecimal periodinamount = row.getBigDecimal(periodinamountIndex);
            if (null == periodinamount) {
                periodinamount = BigDecimal.ZERO;
            }
            totalPeriodinamount = totalPeriodinamount.add(periodinamount);
            BigDecimal periodoutqty = row.getBigDecimal(periodoutqtyIndex);
            if (null == periodoutqty) {
                periodoutqty = BigDecimal.ZERO;
            }
            totalPeriodoutqty = totalPeriodoutqty.add(periodoutqty);
            BigDecimal periodoutamount = row.getBigDecimal(periodoutamountIndex);
            if (null == periodoutamount) {
                periodoutamount = BigDecimal.ZERO;
            }
            totalPeriodoutamount = totalPeriodoutamount.add(periodoutamount);
            Object[] copyRowVals = this.copyRow(row, this.rowMeta);
            resultRows.add(copyRowVals);
        }
        for (Object[] row : resultRows) {
            if (totalPeriodinqty.compareTo(BigDecimal.ZERO) == 0 && totalPeriodinamount.compareTo(BigDecimal.ZERO) == 0 && totalPeriodoutqty.compareTo(BigDecimal.ZERO) == 0 && totalPeriodoutamount.compareTo(BigDecimal.ZERO) == 0) continue;
            collector.collect(row);
        }
    }

    private Object[] copyRow(Row row, RowMeta rowMeta) {
        Object[] currRowVals = new Object[rowMeta.getFieldCount()];
        for (int index = 0; index < rowMeta.getFieldCount(); ++index) {
            currRowVals[index] = row.get(index);
        }
        return currRowVals;
    }
}

