/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.util.StringUtils;

public class PeriodCostsubelementQtyReFunction
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private String qtyShowCondition;

    public PeriodCostsubelementQtyReFunction(RowMeta rowMeta, String qtyShowCondition) {
        this.rowMeta = rowMeta;
        this.qtyShowCondition = qtyShowCondition;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterator<Row> iterable, Collector collector) {
        int periodendqtyIndex = this.rowMeta.getFieldIndex("periodendqty");
        BigDecimal totalPeriodendqty = BigDecimal.ZERO;
        ArrayList<Object[]> resultRows = new ArrayList<Object[]>(16);
        while (iterable.hasNext()) {
            Row row = iterable.next();
            BigDecimal periodendqty = row.getBigDecimal(periodendqtyIndex);
            if (null == periodendqty) {
                periodendqty = BigDecimal.ZERO;
            }
            totalPeriodendqty = totalPeriodendqty.add(periodendqty);
            Object[] copyRowVals = this.copyRow(row, this.rowMeta);
            resultRows.add(copyRowVals);
        }
        for (Object[] row : resultRows) {
            if (!StringUtils.isNotEmpty((String)this.qtyShowCondition)) continue;
            if ("A".equals(this.qtyShowCondition) && totalPeriodendqty.compareTo(BigDecimal.ZERO) == 0) {
                collector.collect(row);
                continue;
            }
            if ("B".equals(this.qtyShowCondition) && totalPeriodendqty.compareTo(BigDecimal.ZERO) != 0) {
                collector.collect(row);
                continue;
            }
            if ("C".equals(this.qtyShowCondition) && totalPeriodendqty.compareTo(BigDecimal.ZERO) > 0) {
                collector.collect(row);
                continue;
            }
            if (!"D".equals(this.qtyShowCondition) || totalPeriodendqty.compareTo(BigDecimal.ZERO) >= 0) continue;
            collector.collect(row);
        }
    }

    private Object[] copyRow(Row row, RowMeta rowMeta) {
        Object[] currRowVals = new Object[rowMeta.getFieldCount()];
        for (int index = 0; index < rowMeta.getFieldCount(); ++index) {
            currRowVals[index] = row.get(index);
        }
        return currRowVals;
    }
}

