/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class ShowCostsubelementAmountReFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private String amountShowCondition;

    public ShowCostsubelementAmountReFunction(RowMeta rowMeta, String amountShowCondition) {
        this.rowMeta = rowMeta;
        this.amountShowCondition = amountShowCondition;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int periodendamountIndex = this.rowMeta.getFieldIndex("periodendamount");
        BigDecimal totalPeriodendamount = BigDecimal.ZERO;
        Iterator<RowX> iterator = iterable.iterator();
        HashSet<RowX> resultRows = new HashSet<RowX>(16);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            BigDecimal periodendamount = row.getBigDecimal(periodendamountIndex);
            if (null == periodendamount) {
                periodendamount = BigDecimal.ZERO;
            }
            totalPeriodendamount = totalPeriodendamount.add(periodendamount);
            resultRows.add(row);
        }
        for (RowX row : resultRows) {
            if (!StringUtils.isNotEmpty((String)this.amountShowCondition)) continue;
            if ("A".equals(this.amountShowCondition) && totalPeriodendamount.compareTo(BigDecimal.ZERO) == 0) {
                collector.collect(row);
                continue;
            }
            if ("B".equals(this.amountShowCondition) && totalPeriodendamount.compareTo(BigDecimal.ZERO) != 0) {
                collector.collect(row);
                continue;
            }
            if ("C".equals(this.amountShowCondition) && totalPeriodendamount.compareTo(BigDecimal.ZERO) > 0) {
                collector.collect(row);
                continue;
            }
            if (!"D".equals(this.amountShowCondition) || totalPeriodendamount.compareTo(BigDecimal.ZERO) >= 0) continue;
            collector.collect(row);
        }
    }
}

