/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class ShowCostsubelementNoInOutReFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public ShowCostsubelementNoInOutReFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int periodinqtyIndex = this.rowMeta.getFieldIndex("periodinqty");
        int periodinamountIndex = this.rowMeta.getFieldIndex("periodinamount");
        int periodoutqtyIndex = this.rowMeta.getFieldIndex("periodoutqty");
        int periodoutamountIndex = this.rowMeta.getFieldIndex("periodoutamount");
        BigDecimal totalPeriodinqty = BigDecimal.ZERO;
        BigDecimal totalPeriodoutqty = BigDecimal.ZERO;
        BigDecimal totalPeriodinamount = BigDecimal.ZERO;
        BigDecimal totalPeriodoutamount = BigDecimal.ZERO;
        Iterator<RowX> iterator = iterable.iterator();
        HashSet<RowX> resultRows = new HashSet<RowX>(16);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            BigDecimal periodinqty = row.getBigDecimal(periodinqtyIndex);
            if (null == periodinqty) {
                periodinqty = BigDecimal.ZERO;
            }
            totalPeriodinqty = totalPeriodinqty.add(periodinqty);
            BigDecimal periodinamount = row.getBigDecimal(periodinamountIndex);
            if (null == periodinamount) {
                periodinamount = BigDecimal.ZERO;
            }
            totalPeriodinamount = totalPeriodinamount.add(periodinamount);
            BigDecimal periodoutqty = row.getBigDecimal(periodoutqtyIndex);
            if (null == periodoutqty) {
                periodoutqty = BigDecimal.ZERO;
            }
            totalPeriodoutqty = totalPeriodoutqty.add(periodoutqty);
            BigDecimal periodoutamount = row.getBigDecimal(periodoutamountIndex);
            if (null == periodoutamount) {
                periodoutamount = BigDecimal.ZERO;
            }
            totalPeriodoutamount = totalPeriodoutamount.add(periodoutamount);
            resultRows.add(row);
        }
        for (RowX row : resultRows) {
            if (totalPeriodinqty.compareTo(BigDecimal.ZERO) == 0 && totalPeriodinamount.compareTo(BigDecimal.ZERO) == 0 && totalPeriodoutqty.compareTo(BigDecimal.ZERO) == 0 && totalPeriodoutamount.compareTo(BigDecimal.ZERO) == 0) continue;
            collector.collect(row);
        }
    }
}

