/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.function;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class ShowCostsubelementQtyReFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private String qtyShowCondition;

    public ShowCostsubelementQtyReFunction(RowMeta rowMeta, String qtyShowCondition) {
        this.rowMeta = rowMeta;
        this.qtyShowCondition = qtyShowCondition;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int periodendqtyIndex = this.rowMeta.getFieldIndex("periodendqty");
        BigDecimal totalPeriodendqty = BigDecimal.ZERO;
        Iterator<RowX> iterator = iterable.iterator();
        HashSet<RowX> resultRows = new HashSet<RowX>(16);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            BigDecimal periodendqty = row.getBigDecimal(periodendqtyIndex);
            if (null == periodendqty) {
                periodendqty = BigDecimal.ZERO;
            }
            totalPeriodendqty = totalPeriodendqty.add(periodendqty);
            resultRows.add(row);
        }
        for (RowX row : resultRows) {
            if (!StringUtils.isNotEmpty((String)this.qtyShowCondition)) continue;
            if ("A".equals(this.qtyShowCondition) && totalPeriodendqty.compareTo(BigDecimal.ZERO) == 0) {
                collector.collect(row);
                continue;
            }
            if ("B".equals(this.qtyShowCondition) && totalPeriodendqty.compareTo(BigDecimal.ZERO) != 0) {
                collector.collect(row);
                continue;
            }
            if ("C".equals(this.qtyShowCondition) && totalPeriodendqty.compareTo(BigDecimal.ZERO) > 0) {
                collector.collect(row);
                continue;
            }
            if (!"D".equals(this.qtyShowCondition) || totalPeriodendqty.compareTo(BigDecimal.ZERO) >= 0) continue;
            collector.collect(row);
        }
    }
}

