/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.base.NewReportDataHelper;
import kd.fi.cal.report.newreport.base.ToCharFieldDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;
import kd.fi.cal.report.newreport.stocksumlrpt.StockGatherSumReportParam;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.AddMaterialGroupDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.AddMaterialGroupInfoDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.AddMaterialGroupTotalDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.BeginInConNoinDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.BeginOutConNoinDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.ChangeBalDataDataXTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.ChangeBalanceDataDataXTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.ChangeFiledPriceDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.DeleteFieldDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.GroupByPeriodDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.InConNoinDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.OnlyShowSumRowDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.OrderSumKeyEmptyDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.OutConNoinDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.QtyAmountFilterDataxTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.QtyAmountFilterGroupByPeriodDataTransform;
import kd.fi.cal.report.newreport.stocksumlrpt.dataxtransform.UnionGroupRowDataxTransform;

public class StockGatherSumReportHandle
implements IReportDataHandle {
    private static final LocaleString width = new LocaleString("100px");
    private static final String MGID_FIELD = "mgid";
    private LocaleString locale_periodBegin = new LocaleString(this.getLocale_periodBegin());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());
    private LocaleString locale_materialNo = new LocaleString(this.getLocale_materialNo());
    private LocaleString locale_materialModel = new LocaleString(this.getLocale_materialModel());
    private StockGatherSumReportParam reportParam;

    private String getLocale_periodBegin() {
        return ResManager.loadKDString((String)"\u671f\u521d\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockGatherRptQueryPlugin_22", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockGatherRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNo() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockDetailRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialModel() {
        return ResManager.loadKDString((String)"\u7269\u6599\u89c4\u683c\u578b\u53f7", (String)"StockDetailRptQueryPlugin_25", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public void setupCtx(ReportDataCtx ctx) {
        Set sumKeyCols = ctx.getSumKeyCols();
        if (!sumKeyCols.isEmpty()) {
            ctx.getSumKeyCols().add("costaccount");
            ctx.getSumKeyCols().add("calorg");
        }
        if (BplatReportUtil.hasGroupByName(sumKeyCols, "owner") && !BplatReportUtil.hasGroupByName(sumKeyCols, "ownertype")) {
            ctx.getSumKeyCols().add("ownertype");
        }
        if (BplatReportUtil.hasGroupByName(ctx.getShowKeyCols(), "owner")) {
            ctx.getShowKeyCols().add("ownertype");
        }
        this.reportParam = (StockGatherSumReportParam)ctx.getParam(StockGatherSumReportParam.class.getName());
        boolean notShowMaterialGroup = this.reportParam.isNotShowMaterialGroup() && !BplatReportUtil.hasGroupByName(ctx.getShowKeyCols(), "group");
        this.reportParam.setNotShowMaterialGroup(notShowMaterialGroup);
        this.reportParam.setHasMaterialGroup(BplatReportUtil.hasGroupByName(ctx.getShowKeyCols(), "group"));
        this.reportParam.setSumKeyhasMaterialGroup(BplatReportUtil.hasGroupByName(ctx.getSumKeyCols(), "group"));
        boolean costsubelementHasTotal = false;
        boolean hasMaterialGroup = this.reportParam.isHasMaterialGroup();
        Set sumKeyColsSet = ctx.getSumKeyCols();
        if (hasMaterialGroup && !BplatReportUtil.hasMaterialGroupOtherFlag(ctx.getShowKeyCols())) {
            costsubelementHasTotal = true;
        } else if (sumKeyColsSet != null && sumKeyColsSet.size() > 0) {
            costsubelementHasTotal = true;
        }
        this.reportParam.setCostsubelementHasTotal(costsubelementHasTotal);
        this.addDefaultGroupField(ctx);
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        if (ctx.getCommonFs() != null) {
            this.reportParam.setCommonFilter(ctx.getCommonFs());
        } else {
            this.reportParam.setCommonFilter(null);
        }
        ctx.setCommonFs(null);
    }

    private void addDefaultGroupField(ReportDataCtx ctx) {
        ctx.getShowKeyCols().add("baseunit");
        ctx.getShowKeyCols().add("currency");
        ctx.getShowKeyCols().add("year");
        ctx.getShowKeyCols().add("month");
        ctx.getShowKeyCols().add("qtyprecision");
        ctx.getShowKeyCols().add("periodnumber");
        if (BplatReportUtil.hasGroupByName(ctx.getShowKeyCols(), "owner")) {
            ctx.getShowKeyCols().add("ownertype");
        }
        boolean notShowMaterialGroup = this.reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = this.reportParam.isHasMaterialGroup();
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            ctx.getShowKeyCols().add("group");
        }
        if (this.reportParam.isNewBalanceFlag()) {
            Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
            ctx.getShowKeyCols().addAll(allKeyCols);
            ctx.getShowKeyCols().add("invstatus");
            ctx.getShowKeyCols().add("invtype");
            ctx.getShowKeyCols().add("endperiod");
            ctx.getShowKeyCols().add("mversion");
            ctx.getShowKeyCols().add("configuredcode");
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        ArrayList<SrcBlockConf> resultBalanceSrcBlocks = new ArrayList<SrcBlockConf>();
        ArrayList<SrcBlockConf> resultBalSrcBlocks = new ArrayList<SrcBlockConf>();
        boolean showdetail = this.reportParam.isShowdetail();
        boolean showdetailUnBlockCol = false;
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            if ("cal_balance".equals(srcEntity) && !showdetail && !this.reportParam.isNewBalanceFlag()) {
                this.setCalBalanceBlockConf(resultBalanceSrcBlocks, blockConf, ctx);
                continue;
            }
            if ("cal_balance_subentity".equals(srcEntity) && showdetail && !this.reportParam.isNewBalanceFlag()) {
                this.setCalBalanceSubEntityBlockConf(resultBalanceSrcBlocks, blockConf, ctx);
                continue;
            }
            if ("cal_bal".equals(srcEntity) && this.reportParam.isNewBalanceFlag()) {
                NewReportDataHelper.addNewBalDimCols(ctx, blockConf, this.reportParam);
                this.setCalBalBlockConf(ctx, resultBalSrcBlocks, blockConf, showdetail);
                continue;
            }
            if ("cal_costrecord".equals(srcEntity) && !showdetail) {
                this.setCalCostRecordBlockConf(resultBalanceSrcBlocks, resultBalSrcBlocks, blockConf, ctx, showdetail);
                continue;
            }
            if (!"cal_costrecord_subentity".equals(srcEntity) || !showdetail) continue;
            this.setCalCostRecordBlockConf(resultBalanceSrcBlocks, resultBalSrcBlocks, blockConf, ctx, showdetail);
            showdetailUnBlockCol = true;
        }
        if (showdetail && !showdetailUnBlockCol) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u542f\u201c\u6309\u5206\u9879\u7ed3\u8f6c\u660e\u7ec6\u67e5\u770b\u62a5\u8868\u201d\u67e5\u8be2\u62a5\u8868\u65f6\u7531\u4e8e\u62a5\u8868\u6570\u636e\u6e90\u914d\u7f6e\u4e2d\u7f3a\u5931\u90e8\u5206\u6570\u636e\u5757\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"StockGatherSumReportHandle_0", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        if (this.reportParam.isNewBalanceFlag()) {
            ctx.getReportConf().setSrcBlockConf(resultBalSrcBlocks);
        } else {
            ctx.getReportConf().setSrcBlockConf(resultBalanceSrcBlocks);
        }
    }

    private void setCalBalanceBlockConf(List<SrcBlockConf> resultBalanceSrcBlocks, SrcBlockConf blockConf, ReportDataCtx ctx) {
        SrcBlockConf beginblockConf = new SrcBlockConf();
        beginblockConf.setDefVals(blockConf.getDefVals());
        beginblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        beginblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        beginblockConf.setSrcEntity(blockConf.getSrcEntity());
        beginblockConf.setType(blockConf.getType());
        beginblockConf.setUserFs(this.reportParam.getCommonFilter());
        QFilter q = new QFilter("period", "<=", (Object)this.reportParam.getEndPeriodNumber());
        q.and(new QFilter("endperiod", ">", (Object)this.reportParam.getStartPeriodNumber()));
        BplatReportUtil.getCommonQFilter(this.reportParam, q, "cal_balance");
        beginblockConf.setDataFs(q);
        List dataXTransforms = beginblockConf.getDataTransform();
        if (dataXTransforms != null) {
            dataXTransforms.add(new ChangeBalanceDataDataXTransform(ctx, this.reportParam.isShowdetail(), this.reportParam.getPeriodNumberList(), this.reportParam.isCostsubelementHasTotal()));
        }
        beginblockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(beginblockConf);
    }

    private void setCalBalanceSubEntityBlockConf(List<SrcBlockConf> resultBalanceSrcBlocks, SrcBlockConf blockConf, ReportDataCtx ctx) {
        SrcBlockConf beginblockConf = new SrcBlockConf();
        beginblockConf.setDefVals(blockConf.getDefVals());
        beginblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        beginblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        beginblockConf.setSrcEntity(blockConf.getSrcEntity());
        beginblockConf.setType(blockConf.getType());
        beginblockConf.setUserFs(this.reportParam.getCommonFilter());
        QFilter q = new QFilter("period", "<=", (Object)this.reportParam.getEndPeriodNumber());
        q.and(new QFilter("endperiod", ">", (Object)this.reportParam.getStartPeriodNumber()));
        BplatReportUtil.getCommonQFilter(this.reportParam, q, "cal_balance");
        beginblockConf.setDataFs(q);
        List dataXTransforms = beginblockConf.getDataTransform();
        if (dataXTransforms != null) {
            dataXTransforms.add(new ChangeBalanceDataDataXTransform(ctx, this.reportParam.isShowdetail(), this.reportParam.getPeriodNumberList(), this.reportParam.isCostsubelementHasTotal()));
        }
        beginblockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(beginblockConf);
    }

    private void setCalBalBlockConf(ReportDataCtx ctx, List<SrcBlockConf> resultBalSrcBlocks, SrcBlockConf blockConf, boolean showdetail) {
        SrcBlockConf beginblockConf = new SrcBlockConf();
        beginblockConf.setDefVals(blockConf.getDefVals());
        beginblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        beginblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        beginblockConf.setSrcEntity(blockConf.getSrcEntity());
        beginblockConf.setType(blockConf.getType());
        beginblockConf.setUserFs(this.reportParam.getCommonFilter());
        QFilter q = new QFilter("period", "<=", (Object)this.reportParam.getEndPeriodNumber());
        q.and(new QFilter("endperiod", ">", (Object)this.reportParam.getStartPeriodNumber()));
        BplatReportUtil.getCommonQFilter(this.reportParam, q, "cal_bal");
        beginblockConf.setDataFs(q);
        List dataXTransforms = beginblockConf.getDataTransform();
        if (dataXTransforms != null) {
            dataXTransforms.add(new ChangeBalDataDataXTransform(ctx, this.reportParam.getPeriodNumberList(), showdetail, this.reportParam.isCostsubelementHasTotal()));
        }
        beginblockConf.setAllowNotMatch(true);
        resultBalSrcBlocks.add(beginblockConf);
    }

    private void setCalCostRecordBlockConf(List<SrcBlockConf> resultBalanceSrcBlocks, List<SrcBlockConf> resultBalSrcBlocks, SrcBlockConf blockConf, ReportDataCtx ctx, boolean showdetail) {
        Map repoColFullSrcColMap;
        Map srcColMap;
        if (showdetail) {
            srcColMap = blockConf.getRepoColSrcColMap();
            srcColMap.put("configuredcode", "configuredcode");
            blockConf.setRepoColSrcColMap(srcColMap);
            repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.put("configuredcode", "entry.configuredcode");
            blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        }
        srcColMap = blockConf.getRepoColSrcColMap();
        srcColMap.put("entryid", "entryid");
        blockConf.setRepoColSrcColMap(srcColMap);
        repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.put("entryid", "entry.id");
        blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        String mulnojoinsumrange = this.reportParam.getMulnojoinsumrange();
        if (StringUtils.isNotEmpty((String)mulnojoinsumrange)) {
            HashSet<String> transtypeSet = new HashSet<String>(16);
            if (mulnojoinsumrange.contains("A")) {
                transtypeSet.add("A");
            }
            if (mulnojoinsumrange.contains("B")) {
                transtypeSet.add("B");
            }
            SrcBlockConf inblockConf = new SrcBlockConf();
            inblockConf.setDefVals(blockConf.getDefVals());
            inblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
            inblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
            inblockConf.setSrcEntity(blockConf.getSrcEntity());
            inblockConf.setType(blockConf.getType());
            inblockConf.setUserFs(this.reportParam.getCommonFilter());
            QFilter commonFilter = new QFilter("bookdate", ">=", (Object)this.reportParam.getFilter_startDate());
            commonFilter.and("bookdate", "<=", (Object)this.reportParam.getFilter_endDate());
            commonFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            commonFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
            commonFilter.and("billstatus", "=", (Object)"C");
            BplatReportUtil.getCostRecordQFilter(this.reportParam, commonFilter, "cal_costrecord");
            QFilter commonInFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            QFilter commonInFilter1 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            Set<Long> mulnosumbiztypeIdSet = this.reportParam.getMulnosumbiztypeIdSet();
            if (!transtypeSet.isEmpty()) {
                commonInFilter1.and("calbilltype", "=", (Object)"IN");
                if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                    commonInFilter1.and("biztype", "in", mulnosumbiztypeIdSet);
                }
                commonInFilter1.and("bizentityobject", "in", BplatReportUtil.getTransBizentityobjectSet());
                commonInFilter1.and("transtype", "in", transtypeSet);
            } else {
                commonInFilter1 = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            }
            QFilter commonInFilter2 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            Set<String> mulbizbillstrSet = BplatReportUtil.getOtherBizentityobjectSet(mulnojoinsumrange);
            if (mulbizbillstrSet != null && mulbizbillstrSet.size() > 0) {
                commonInFilter2.and("calbilltype", "=", (Object)"IN");
                if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                    commonInFilter2.and("biztype", "in", mulnosumbiztypeIdSet);
                }
                commonInFilter2.and("bizentityobject", "in", mulbizbillstrSet);
            } else {
                commonInFilter2 = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            }
            commonInFilter = commonInFilter1.or(commonInFilter2).and(commonFilter);
            inblockConf.setDataFs(commonInFilter);
            List dataXTransformsIn = inblockConf.getDataTransform();
            if (dataXTransformsIn != null) {
                dataXTransformsIn.add(new InConNoinDataxTransform(ctx, this.reportParam.isShowdetail(), this.reportParam.isCostsubelementHasTotal()));
            }
            inblockConf.setAllowNotMatch(true);
            resultBalSrcBlocks.add(inblockConf);
            resultBalanceSrcBlocks.add(inblockConf);
            SrcBlockConf outblockConf = new SrcBlockConf();
            outblockConf.setDefVals(blockConf.getDefVals());
            outblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
            outblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
            outblockConf.setSrcEntity(blockConf.getSrcEntity());
            outblockConf.setType(blockConf.getType());
            outblockConf.setUserFs(this.reportParam.getCommonFilter());
            QFilter commonOutFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            QFilter commonOutFilter1 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            if (!transtypeSet.isEmpty()) {
                commonOutFilter1.and("calbilltype", "=", (Object)"OUT");
                if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                    commonOutFilter1.and("biztype", "in", mulnosumbiztypeIdSet);
                }
                commonOutFilter1.and("bizentityobject", "in", BplatReportUtil.getTransBizentityobjectSet());
                commonOutFilter1.and("transtype", "in", transtypeSet);
            } else {
                commonOutFilter1 = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            }
            QFilter commonOutFilter2 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            if (mulbizbillstrSet != null && mulbizbillstrSet.size() > 0) {
                commonOutFilter2.and("calbilltype", "=", (Object)"OUT");
                if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                    commonOutFilter2.and("biztype", "in", mulnosumbiztypeIdSet);
                }
                commonOutFilter2.and("bizentityobject", "in", mulbizbillstrSet);
            } else {
                commonOutFilter2 = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            }
            commonOutFilter = commonOutFilter1.or(commonOutFilter2).and(commonFilter);
            outblockConf.setDataFs(commonOutFilter);
            List dataXTransformsOut = outblockConf.getDataTransform();
            if (dataXTransformsOut != null) {
                dataXTransformsOut.add(new OutConNoinDataxTransform(ctx, showdetail, this.reportParam.isCostsubelementHasTotal()));
            }
            outblockConf.setAllowNotMatch(true);
            resultBalSrcBlocks.add(outblockConf);
            resultBalanceSrcBlocks.add(outblockConf);
            boolean mulbeginconoutnoindata = this.reportParam.isMulbeginconoutnoindata();
            if (mulbeginconoutnoindata && (mulnojoinsumrange.contains("A") || mulnojoinsumrange.contains("B"))) {
                SrcBlockConf beginInblockConf = new SrcBlockConf();
                beginInblockConf.setDefVals(blockConf.getDefVals());
                beginInblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                beginInblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                beginInblockConf.setSrcEntity(blockConf.getSrcEntity());
                beginInblockConf.setType(blockConf.getType());
                beginInblockConf.setUserFs(this.reportParam.getCommonFilter());
                QFilter commonBeginInFilter = new QFilter("bookdate", "<", (Object)this.reportParam.getFilter_endStartDate());
                commonBeginInFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
                commonBeginInFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
                commonBeginInFilter.and("billstatus", "=", (Object)"C");
                HashSet<String> bizbillstrSet = new HashSet<String>(16);
                bizbillstrSet.add("im_transdirbill");
                bizbillstrSet.add("im_transoutbill");
                bizbillstrSet.add("im_transinbill");
                commonBeginInFilter.and("bizentityobject", "in", bizbillstrSet);
                commonBeginInFilter.and("calbilltype", "=", (Object)"IN");
                if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                    commonBeginInFilter.and("biztype", "in", mulnosumbiztypeIdSet);
                }
                if (!transtypeSet.isEmpty()) {
                    commonBeginInFilter.and("transtype", "in", transtypeSet);
                }
                BplatReportUtil.getCostRecordQFilter(this.reportParam, commonBeginInFilter, "cal_costrecord");
                beginInblockConf.setDataFs(commonBeginInFilter);
                List dataXTransformsBeginIn = beginInblockConf.getDataTransform();
                if (dataXTransformsBeginIn != null) {
                    dataXTransformsBeginIn.add(new BeginInConNoinDataxTransform(this.reportParam, ctx));
                }
                beginInblockConf.setAllowNotMatch(true);
                resultBalSrcBlocks.add(beginInblockConf);
                resultBalanceSrcBlocks.add(beginInblockConf);
                SrcBlockConf beginOutblockConf = new SrcBlockConf();
                beginOutblockConf.setDefVals(blockConf.getDefVals());
                beginOutblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                beginOutblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                beginOutblockConf.setSrcEntity(blockConf.getSrcEntity());
                beginOutblockConf.setType(blockConf.getType());
                beginOutblockConf.setUserFs(this.reportParam.getCommonFilter());
                QFilter commonBeginOutFilter = new QFilter("bookdate", "<", (Object)this.reportParam.getFilter_endStartDate());
                commonBeginOutFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
                commonBeginOutFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
                commonBeginOutFilter.and("billstatus", "=", (Object)"C");
                bizbillstrSet.add("im_transdirbill");
                bizbillstrSet.add("im_transoutbill");
                bizbillstrSet.add("im_transinbill");
                commonBeginOutFilter.and("bizentityobject", "in", bizbillstrSet);
                commonBeginOutFilter.and("calbilltype", "=", (Object)"OUT");
                if (mulnosumbiztypeIdSet != null && mulnosumbiztypeIdSet.size() > 0) {
                    commonBeginOutFilter.and("biztype", "in", mulnosumbiztypeIdSet);
                }
                if (!transtypeSet.isEmpty()) {
                    commonBeginOutFilter.and("transtype", "in", transtypeSet);
                }
                BplatReportUtil.getCostRecordQFilter(this.reportParam, commonBeginOutFilter, "cal_costrecord");
                beginOutblockConf.setDataFs(commonBeginOutFilter);
                List dataXTransformsBeginOut = beginOutblockConf.getDataTransform();
                if (dataXTransformsBeginOut != null) {
                    dataXTransformsBeginOut.add(new BeginOutConNoinDataxTransform(this.reportParam, ctx));
                }
                beginOutblockConf.setAllowNotMatch(true);
                resultBalSrcBlocks.add(beginOutblockConf);
                resultBalanceSrcBlocks.add(beginOutblockConf);
            }
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new AddMaterialGroupDataxTransform(ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        String[] colsStrs;
        ctx.getShowKeyCols().clear();
        ctx.getShowKeyCols().add("baseunit");
        ctx.getShowKeyCols().add("currency");
        ctx.getShowKeyCols().add("year");
        ctx.getShowKeyCols().add("month");
        ctx.getShowKeyCols().add("qtyprecision");
        ctx.getShowKeyCols().add("periodnumber");
        boolean showdetail = this.reportParam.isShowdetail();
        if (showdetail) {
            ctx.getShowKeyCols().add("costelement");
            ctx.getShowKeyCols().add("costsubelement");
            ctx.getShowKeyCols().add("costelementnum");
            ctx.getShowKeyCols().add("costsubelementnum");
        }
        boolean notShowMaterialGroup = this.reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = this.reportParam.isHasMaterialGroup();
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            ctx.getShowKeyCols().add("group");
        }
        for (String col : colsStrs = this.reportParam.getColsStr().split(",")) {
            if (StringUtils.isEmpty((String)col)) continue;
            ctx.getShowKeyCols().add(col);
        }
        if (BplatReportUtil.hasGroupByName(ctx.getShowKeyCols(), "owner")) {
            ctx.getShowKeyCols().add("ownertype");
        }
        ctx.setGroupPlans(new GroupPlan((Collection)ctx.getShowKeyCols(), (Collection)ctx.getShowQtyCols()));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        boolean isGroupByPeriod = this.reportParam.isGroupByPeriod();
        if (!isGroupByPeriod) {
            transCollector.add(new QtyAmountFilterDataxTransform(this.reportParam, ctx));
        }
        transCollector.add(new ChangeFiledPriceDataxTransform());
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        boolean hasMaterialGroup;
        Set sumKeyColsSet = ctx.getSumKeyCols();
        boolean isGroupByPeriod = this.reportParam.isGroupByPeriod();
        if (isGroupByPeriod) {
            transCollector.add(new GroupByPeriodDataxTransform(this.reportParam, ctx));
            transCollector.add(new QtyAmountFilterGroupByPeriodDataTransform(this.reportParam, ctx));
        }
        if ((hasMaterialGroup = this.reportParam.isHasMaterialGroup()) && !BplatReportUtil.hasMaterialGroupOtherFlag(ctx.getShowKeyCols())) {
            transCollector.add(new AddMaterialGroupInfoDataxTransform(this.reportParam));
            transCollector.add(new AddMaterialGroupTotalDataxTransform(this.reportParam, ctx));
        } else if (sumKeyColsSet != null && sumKeyColsSet.size() > 0) {
            transCollector.add(new UnionGroupRowDataxTransform(this.reportParam, ctx));
        } else {
            transCollector.add(new OrderSumKeyEmptyDataxTransform(this.reportParam, ctx));
        }
        boolean onlyShowSumRow = this.reportParam.isOnlyShowSumRow();
        if (onlyShowSumRow) {
            transCollector.add(new OnlyShowSumRowDataTransform());
        }
        transCollector.add(new DeleteFieldDataTransform(ctx, this.reportParam));
        if (!isGroupByPeriod) {
            transCollector.add(new ToCharFieldDataTransform("periodnumber"));
        }
        this.reportParam.closeMaterialCategory();
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(BplatReportUtil.getFilter(this.reportParam, true, false));
        return fs;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        boolean noShowZero = this.reportParam.isNoShowZero();
        if (this.reportParam.isHasMaterialGroup() && !BplatReportUtil.hasMaterialGroupOtherFlag(ctx.getShowKeyCols())) {
            int hierarchylevel = this.reportParam.getHierarchylevel();
            for (int i = 1; i <= hierarchylevel; ++i) {
                ReportColumn materialGroupId = new ReportColumn();
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_50", (String)"fi-cal-report", (Object[])new Object[0]), i);
                LocaleString locale_materialGroupNum = new LocaleString(msg);
                materialGroupId.setCaption(locale_materialGroupNum);
                materialGroupId.setWidth(width);
                materialGroupId.setFieldKey(MGID_FIELD + i);
                materialGroupId.setFieldType("basedata");
                materialGroupId.setEntityId("bd_materialgroup");
                materialGroupId.setDisplayProp("number");
                ReportColumn materialGroupName = ReportColumn.createBaseDataPropColumn((String)("mgname" + i), (String)(MGID_FIELD + i), (String)"name");
                String string = String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_51", (String)"fi-cal-report", (Object[])new Object[0]), i);
                LocaleString localeString = new LocaleString(string);
                materialGroupName.setCaption(localeString);
                materialGroupName.setWidth(width);
                cols.add((AbstractReportColumn)materialGroupId);
                cols.add((AbstractReportColumn)materialGroupName);
            }
        }
        ArrayList<AbstractReportColumn> reslutcols = new ArrayList<AbstractReportColumn>(cols.size());
        ArrayList<ReportColumn> periodbegincols = new ArrayList<ReportColumn>();
        ArrayList<ReportColumn> periodincols = new ArrayList<ReportColumn>();
        ArrayList<ReportColumn> periodOutcols = new ArrayList<ReportColumn>();
        ArrayList<ReportColumn> periodEndcols = new ArrayList<ReportColumn>();
        for (AbstractReportColumn abstractReportColumn : cols) {
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            String string = reportColumn.getFieldKey();
            if ("material_ref_number".equals(string)) {
                reportColumn.setCaption(this.locale_materialNo);
            }
            if ("material_ref_modelnum".equals(string)) {
                reportColumn.setCaption(this.locale_materialModel);
            }
            if (string.contains("periodbegin")) {
                reportColumn.setNoDisplayScaleZero(noShowZero);
                reportColumn.setZeroShow(false);
                if ("periodbeginqty".equals(string)) {
                    reportColumn.setFieldType("qty");
                    reportColumn.setMeasureUnitField("baseunit");
                } else if ("periodbeginprice".equals(string)) {
                    reportColumn.setFieldType("price");
                    reportColumn.setCurrencyField("currency");
                } else if ("periodbeginamount".equals(string)) {
                    reportColumn.setFieldType("amount");
                    reportColumn.setCurrencyField("currency");
                }
                periodbegincols.add(reportColumn);
                continue;
            }
            if (string.contains("periodin")) {
                reportColumn.setNoDisplayScaleZero(noShowZero);
                reportColumn.setZeroShow(false);
                if ("periodinqty".equals(string)) {
                    reportColumn.setFieldType("qty");
                    reportColumn.setMeasureUnitField("baseunit");
                } else if ("periodinprice".equals(string)) {
                    reportColumn.setFieldType("price");
                    reportColumn.setCurrencyField("currency");
                } else if ("periodinamount".equals(string)) {
                    reportColumn.setFieldType("amount");
                    reportColumn.setCurrencyField("currency");
                }
                periodincols.add(reportColumn);
                continue;
            }
            if (string.contains("periodout")) {
                reportColumn.setNoDisplayScaleZero(noShowZero);
                reportColumn.setZeroShow(false);
                if ("periodoutqty".equals(string)) {
                    reportColumn.setFieldType("qty");
                    reportColumn.setMeasureUnitField("baseunit");
                } else if ("periodoutprice".equals(string)) {
                    reportColumn.setFieldType("price");
                    reportColumn.setCurrencyField("currency");
                } else if ("periodoutamount".equals(string)) {
                    reportColumn.setFieldType("amount");
                    reportColumn.setCurrencyField("currency");
                }
                periodOutcols.add(reportColumn);
                continue;
            }
            if (string.contains("periodend")) {
                reportColumn.setNoDisplayScaleZero(noShowZero);
                reportColumn.setZeroShow(false);
                if ("periodendqty".equals(string)) {
                    reportColumn.setFieldType("qty");
                    reportColumn.setMeasureUnitField("baseunit");
                } else if ("periodendprice".equals(string)) {
                    reportColumn.setFieldType("price");
                    reportColumn.setCurrencyField("currency");
                } else if ("periodendamount".equals(string)) {
                    reportColumn.setFieldType("amount");
                    reportColumn.setCurrencyField("currency");
                }
                periodEndcols.add(reportColumn);
                continue;
            }
            reslutcols.add((AbstractReportColumn)reportColumn);
        }
        ReportColumnGroup begingroupCol = new ReportColumnGroup();
        begingroupCol.setCaption(this.locale_periodBegin);
        begingroupCol.setFieldKey("periodbegin");
        cols.add((AbstractReportColumn)begingroupCol);
        for (AbstractReportColumn abstractReportColumn : periodbegincols) {
            begingroupCol.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)begingroupCol);
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setCaption(this.locale_periodIn);
        reportColumnGroup.setFieldKey("periodin");
        cols.add((AbstractReportColumn)reportColumnGroup);
        for (AbstractReportColumn abstractReportColumn : periodincols) {
            reportColumnGroup.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)reportColumnGroup);
        ReportColumnGroup reportColumnGroup2 = new ReportColumnGroup();
        reportColumnGroup2.setCaption(this.locale_periodOut);
        reportColumnGroup2.setFieldKey("periodout");
        cols.add((AbstractReportColumn)reportColumnGroup2);
        for (AbstractReportColumn abstractReportColumn : periodOutcols) {
            reportColumnGroup2.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)reportColumnGroup2);
        ReportColumnGroup reportColumnGroup3 = new ReportColumnGroup();
        reportColumnGroup3.setCaption(this.locale_periodEnd);
        reportColumnGroup3.setFieldKey("periodend");
        cols.add((AbstractReportColumn)reportColumnGroup3);
        for (AbstractReportColumn abstractReportColumn : periodEndcols) {
            reportColumnGroup3.getChildren().add(abstractReportColumn);
        }
        reslutcols.add((AbstractReportColumn)reportColumnGroup3);
        return reslutcols;
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
        repoColFilter.addAll(this.reportParam.getOtherBalDims());
        repoColFilter.add("configuredcode");
    }
}

