/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stocksumlrpt.print;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.PrintHelper;

public class StockSumRptPrintNewPlugin
extends AbstractPrintPlugin {
    private static final Log log = LogFactory.getLog(StockSumRptPrintNewPlugin.class);
    String[] PRINT_FILTER_FIELD = new String[]{"startperiod", "endperiod"};
    String[] PRINT_LIST_HEAD = new String[]{"linetype", "calorg", "costaccount", "materialnumber", "materialname", "baseunit", "model", "currency", "period"};
    String[] PRINT_LIST_QTY = new String[]{"periodbeginqty", "periodinqty", "periodoutqty", "periodendqty"};
    String[] PRINT_LIST_PRICE = new String[]{"periodbeginprice", "periodinprice", "periodoutprice", "periodendprice"};
    String[] PRINT_LIST_SUM = new String[]{"periodbeginamount", "periodinamount", "periodoutamount", "periodendamount"};

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
    }

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return;
            }
            ReportList list = view.getReportList();
            ReportListModel listModel = (ReportListModel)list.getReportModel();
            if (listModel == null) {
                return;
            }
            ArrayList<DataRowSet> reportRows = new ArrayList<DataRowSet>(16);
            DataRowSet head = new DataRowSet();
            reportRows.add(head);
            e.setDataRowSets(reportRows);
        }
    }

    public void loadCustomData(CustomDataLoadEvent e) {
        super.loadCustomData(e);
        CustomDataSource dataSource = e.getDataSource();
        String pageId = dataSource.getPageId();
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return;
        }
        ReportList list = view.getReportList();
        ReportListModel model = (ReportListModel)list.getReportModel();
        int count = model.getRowCount();
        if (model != null) {
            if ("printhead".equals(dataSource.getDsName())) {
                DataRowSet typeContainer = new DataRowSet();
                ReportQueryParam param = model.getReportQueryParam();
                FilterInfo filter = param.getFilter();
                PrintHelper.setFilterValueToPrint((FilterInfo)filter, (DataRowSet)typeContainer, (String[])this.PRINT_FILTER_FIELD);
                List customDataRows = e.getCustomDataRows();
                customDataRows.add(typeContainer);
            } else {
                DynamicObjectCollection datas = model.getRowData(0, count);
                List field = dataSource.getQueryField();
                String[] listHeadFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])this.PRINT_LIST_HEAD);
                String[] qtyFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])this.PRINT_LIST_QTY);
                String[] priceFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])this.PRINT_LIST_PRICE);
                String[] sumFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])this.PRINT_LIST_SUM);
                FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
                List reportRows = e.getCustomDataRows();
                int seq = 1;
                DataRowSet printRow = null;
                for (DynamicObject rowData : datas) {
                    if (rowData != null) {
                        printRow = new DataRowSet();
                        printRow.add("seq", (Field)new TextField(String.valueOf(seq)));
                        ++seq;
                        StockSumRptPrintNewPlugin.handleStringFields(rowData, printRow, listHeadFields);
                        ReportQueryParam param = model.getReportQueryParam();
                        FilterInfo filter = param.getFilter();
                        DynamicObject currency = filter.getDynamicObject("localcurrency");
                        DynamicObject baseunit = rowData.getDynamicObject("baseunit");
                        StockSumRptPrintNewPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.FALSE, "precision", null, baseunit, fobj, qtyFields);
                        StockSumRptPrintNewPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "priceprecision", "sign", currency, fobj, priceFields);
                        StockSumRptPrintNewPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "amtprecision", "sign", currency, fobj, sumFields);
                    }
                    reportRows.add(printRow);
                }
            }
        }
    }

    protected static void handleNumPriceSumFields(DynamicObject rowData, DataRowSet printRow, boolean showZero, boolean isCurrency, String currencyField, String currencySign, DynamicObject currency, FormatObject fobj, String ... fieldKeys) {
        int defaultDigital = 10;
        String defaultSign = "";
        if (isCurrency && currencyField != null && currencyField.length() != 0 && currency != null && currency.getInt(currencyField) >= 0) {
            int digital = currency.getInt(currencyField);
            String sign = currency.getString(currencySign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
            fobj.getCurrencyFormat().setCurrencySymbols(sign != null && sign.length() != 0 ? sign : defaultSign);
        } else if (!isCurrency && currencyField != null && currencyField.length() != 0 && currency != null && currency.getInt(currencyField) >= 0) {
            int digital = currency.getInt(currencyField);
            fobj.getNumberFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
        } else {
            fobj.getNumberFormat().setMinimumFractionDigits(defaultDigital);
        }
        StockSumRptPrintNewPlugin.handleDecimalFields(rowData, printRow, fobj, showZero, isCurrency, fieldKeys);
    }

    protected static void handleDecimalFields(DynamicObject rowData, DataRowSet printRow, FormatObject fobj, boolean showZero, boolean isCurrency, String ... fieldKeys) {
        List propertySet = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        if (!propertySet.isEmpty()) {
            Format format = isCurrency ? FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj) : FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            Iterator iterator = propertySet.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                String fieldKey = (String)iterator.next();
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.add(fieldKey, (Field)new TextField(format.format(b)));
            }
        }
    }

    protected static void handleStringFields(DynamicObject rowData, DataRowSet printRow, String ... fieldKeys) {
        List existProperty = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        existProperty.add("period");
        existProperty.add("materialnumber");
        existProperty.add("materialname");
        existProperty.add("linetype");
        existProperty.add("model");
        Iterator iterator = existProperty.iterator();
        block19: while (iterator.hasNext()) {
            String fieldKey;
            switch (fieldKey = (String)iterator.next()) {
                case "baseunit": 
                case "currency": 
                case "calorg": 
                case "costaccount": {
                    printRow.add(fieldKey, (Field)new TextField(rowData.get(fieldKey) == null ? "" : ((DynamicObject)rowData.get(fieldKey)).getString("name")));
                    break;
                }
                case "materialname": {
                    printRow.add(fieldKey, (Field)new TextField(rowData.get("material") == null ? "" : ((DynamicObject)rowData.get("material")).getString("name")));
                    break;
                }
                case "materialnumber": {
                    printRow.add(fieldKey, (Field)new TextField(rowData.get("material") == null ? "" : ((DynamicObject)rowData.get("material")).getString("number")));
                    break;
                }
                case "period": {
                    printRow.add(fieldKey, (Field)new TextField(rowData.get("periodnumber") == null ? "" : rowData.getString("periodnumber")));
                    break;
                }
                case "model": {
                    printRow.add(fieldKey, (Field)new TextField(rowData.get("material") == null ? "" : ((DynamicObject)rowData.get("material")).getString("modelnum")));
                    break;
                }
                case "linetype": {
                    String linetype;
                    String string = linetype = rowData.getString("linetype") == null ? "" : rowData.getString("linetype");
                    if (StringUtils.isEmpty((String)linetype)) break;
                    if ("3".equals(linetype)) {
                        printRow.add(fieldKey, (Field)new TextField(StockSumRptPrintNewPlugin.getLocale_total()));
                    }
                    if ("4".equals(linetype)) {
                        printRow.add(fieldKey, (Field)new TextField(StockSumRptPrintNewPlugin.getLocale_period()));
                    }
                    if ("5".equals(linetype)) {
                        printRow.add(fieldKey, (Field)new TextField(StockSumRptPrintNewPlugin.getLocale_year()));
                    }
                    if ("6".equals(linetype)) {
                        printRow.add(fieldKey, (Field)new TextField(StockSumRptPrintNewPlugin.getLocale_all()));
                    }
                    if (!"7".equals(linetype)) continue block19;
                    printRow.add(fieldKey, (Field)new TextField(StockSumRptPrintNewPlugin.getLocale_alltotal()));
                    break;
                }
                default: {
                    printRow.add(fieldKey, (Field)new TextField(rowData.getString(fieldKey)));
                }
            }
        }
    }

    private static String getLocale_period() {
        return ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_30", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private static String getLocale_year() {
        return ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private static String getLocale_all() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_45", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private static String getLocale_alltotal() {
        return ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockGatherRptQueryPlugin_32", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private static String getLocale_total() {
        return ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockCostDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }
}

