/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockturnoverlrpt;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Output;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.report.newreport.base.CalBaseRptParam;
import kd.fi.cal.report.newreport.stockturnoverlrpt.StockTurnOverReportParam;

public class StockTurnOverReportUtil {
    public static boolean hasGroupByName(Set<String> showKeyCols, String keyName) {
        boolean hasGroupName = false;
        if (showKeyCols != null && showKeyCols.size() > 0 && !StringUtils.isBlank((String)keyName) && showKeyCols.contains(keyName)) {
            hasGroupName = true;
        }
        return hasGroupName;
    }

    public static QFilter getFilter(StockTurnOverReportParam reportParam, boolean isCostRecord) {
        HashSet<Long> set;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                if (isCostRecord) {
                    q.and("entry.material", "in", materialSet);
                } else {
                    q.and("material", "in", materialSet);
                }
            } else if (reportParam.getMaterialFrom().size() == 1) {
                if (isCostRecord) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
                } else {
                    q.and("material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
                }
            }
        }
        if (reportParam.getMaterialTo() != null) {
            if (isCostRecord) {
                q.and("entry.material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
            } else {
                q.and("material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
            }
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = StockTurnOverReportUtil.getWarehsGroupSet(reportParam);
        if (!warehsGroupSet.isEmpty()) {
            if (isCostRecord) {
                q.and("entry.warehouse.group", "in", warehsGroupSet);
            } else {
                q.and("warehouse.group", "in", warehsGroupSet);
            }
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            if (isCostRecord) {
                q.and("entry.warehouse", "in", set);
            } else {
                q.and("warehouse", "in", set);
            }
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            if (isCostRecord) {
                q.and("entry.location", "in", set);
            } else {
                q.and("location", "in", set);
            }
        }
        return q;
    }

    public static QFilter getAdjustFilter(StockTurnOverReportParam reportParam) {
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        q.and("billtype.billformid", "=", (Object)"im_saloutbill");
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = StockTurnOverReportUtil.getWarehsGroupSet(reportParam);
        if (!warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("entryentity.material", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("entryentity.material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        return q;
    }

    private static Set<Long> getWarehsGroupSet(StockTurnOverReportParam reportParam) {
        HashSet<Long> warehsGroupSet = new HashSet<Long>(8);
        DynamicObjectCollection filter_warehsgroup = reportParam.getMulwarehsgroup();
        if (filter_warehsgroup != null && filter_warehsgroup.size() > 0) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (DynamicObject info : filter_warehsgroup) {
                warehsGroupSet.add(info.getDynamicObject("fbasedataid").getLong("id"));
                warehsGroupF.or("longnumber", "like", (Object)(info.getDynamicObject("fbasedataid").getString("longnumber") + "%"));
            }
            if (!warehsGroupSet.isEmpty()) {
                DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
                for (DynamicObject warehsGroup : warehsGroupColl) {
                    warehsGroupSet.add(warehsGroup.getLong("id"));
                }
            }
        }
        return warehsGroupSet;
    }

    public static void getOwnerFilter(QFilter q, String filter_ownertype, DynamicObjectCollection filter_owner, String entityName) {
        if (StringUtils.isEmpty((String)filter_ownertype)) {
            return;
        }
        String entry = "";
        if ("cal_costrecord".equals(entityName)) {
            entry = "entry.";
        } else if ("cal_costadjustbill".equals(entityName)) {
            entry = "entryentity.";
        }
        q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        if (filter_owner != null && filter_owner.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(8);
            for (DynamicObject info : filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entry + "owner", "in", set);
        }
    }

    public static DataSet createDataSet(ReportDataCtx ctx, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        ctx.getCurrentJob().commit(60, TimeUnit.MINUTES);
        return ctx.getCurrentJob().readDataSet(resultId);
    }

    public static Set<String> addNewBalDimCols(ReportDataCtx ctx, SrcBlockConf blockConf, CalBaseRptParam baseRptParam) {
        HashSet<String> otherBalDims = new HashSet<String>(16);
        Set newBalDimFields = CalBalanceModelHelper.getDimField();
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        for (String dim : newBalDimFields) {
            if (allKeyColsA.contains(dim) || allKeyColsB.contains(dim) || allKeyColsC.contains(dim)) continue;
            otherBalDims.add(dim);
        }
        Map srcColMap = blockConf.getRepoColSrcColMap();
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        if (!otherBalDims.isEmpty()) {
            for (String dim : otherBalDims) {
                srcColMap.put(dim, dim);
                repoColFullSrcColMap.put(dim, dim);
            }
        }
        blockConf.setRepoColSrcColMap(srcColMap);
        blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        baseRptParam.setOtherBalDims(otherBalDims);
        return otherBalDims;
    }

    public static QFilter getBeginFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        return q;
    }

    public static QFilter getEndFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<=", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">", (Object)periodNumber));
        return q;
    }
}

