/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.function.CalGroupByPeriodMapFuction;

public class CalGroupByPeriodDataXTransform
implements IDataXTransform {
    public ReportDataCtx ctx;
    private DynamicObject startPeriod;
    private DynamicObject endPeriod;

    public CalGroupByPeriodDataXTransform(ReportDataCtx ctx, DynamicObject startPeriod, DynamicObject endPeriod) {
        this.ctx = ctx;
        this.startPeriod = startPeriod;
        this.endPeriod = endPeriod;
    }

    public DataSetX doTransform(DataSetX srcData) {
        String groupSelect = null;
        Set allKeyCols = this.ctx.getShowKeyCols();
        if (allKeyCols != null && allKeyCols.size() > 0) {
            StringBuilder builder = new StringBuilder();
            StringBuilder allbuilder = new StringBuilder();
            for (String keyCol : allKeyCols) {
                allbuilder.append(keyCol);
                allbuilder.append(",");
                if ("year".equals(keyCol) || "month".equals(keyCol) || "periodnumber".equals(keyCol)) continue;
                builder.append(keyCol);
                builder.append(",");
            }
            groupSelect = builder.substring(0, builder.length() - 1);
            srcData = srcData.groupBy(groupSelect.split(",")).sum("periodbeginamount").sum("periodendamount").sum("avgstock").sum("salecost").sum("turnrate").sum("turndays").sum("actualcost");
            ArrayList<Field> newfields = new ArrayList<Field>(16);
            ArrayList<Number> fieldsValues = new ArrayList<Number>(16);
            newfields.add(new Field("year", (DataType)DataType.IntegerType));
            fieldsValues.add(0);
            newfields.add(new Field("month", (DataType)DataType.IntegerType));
            fieldsValues.add(0);
            newfields.add(new Field("periodnumber", (DataType)DataType.StringType));
            fieldsValues.add(BigDecimal.ZERO);
            srcData = srcData.addFields(newfields.toArray(new Field[0]), fieldsValues.toArray());
            srcData = srcData.map((MapFunction)new CalGroupByPeriodMapFuction(srcData.getRowMeta(), this.startPeriod, this.endPeriod));
            groupSelect = allbuilder.substring(0, allbuilder.length() - 1);
            srcData = srcData.groupBy(groupSelect.split(",")).sum("periodbeginamount").sum("periodendamount").sum("avgstock").sum("salecost").sum("turnrate").sum("turndays").sum("actualcost");
        }
        return srcData;
    }
}

