/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockturnoverlrpt.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.stockturnoverlrpt.StockTurnOverReportParam;

public class StockTurnOverReportBplatForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e, this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Mulcalorgowner(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        }
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        HashSet<Long> periodIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> periodCostAccountMap = new HashMap<Long, DynamicObject>(16);
        if (costaccountList == null || costaccountList.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockGatherReportBplatForm_3", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        for (DynamicObject costaccount : costaccountList) {
            DynamicObject startPeriod = PeriodHelper.getCurrentPeriod((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (startPeriod == null) continue;
            periodIdSet.add(startPeriod.getLong("id"));
            periodCostAccountMap.put(startPeriod.getLong("id"), costaccount.getDynamicObject("fbasedataid"));
        }
        if (periodIdSet.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        Long periodId = (Long)Collections.min(periodIdSet);
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)((DynamicObject)periodCostAccountMap.get(periodId)));
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue("mulstorageorg");
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet warehouseIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg.getDynamicObject("fbasedataid"));
            warehouseIdSet.addAll(set);
        }
        if (warehouseIdSet.size() > 0) {
            q = new QFilter("id", "in", warehouseIdSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)model.getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = UserServiceHelper.getCurrentUserId();
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stock_gather_newrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "mulstorageorg", "mulwarehouse", "mullocation", "startperiod", "endperiod", "mulmaterial", "mulowner", "materialto");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("showkeycols".equals(key)) {
            this.changedShowKeyCols(e);
        }
    }

    private void changedShowKeyCols(PropertyChangedArgs e) {
        String warehouse;
        String storageorgunitT;
        String storageorgunit;
        String addOwnerType;
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String hasCostMatCal = null;
        if (StringUtils.isEmpty((String)colsStr)) {
            colsStr = "calorg,costaccount,material";
            hasCostMatCal = "material";
        }
        String ownerLessCol = null;
        String[] colsStrs = colsStr.split(",");
        HashSet<String> colsStrSet = new HashSet<String>(16);
        StringBuilder sb = new StringBuilder();
        for (String col : colsStrs) {
            if (StringUtils.isEmpty((String)col)) continue;
            colsStrSet.add(col);
            sb.append(col);
            sb.append(",");
        }
        if (!colsStrSet.contains("calorg")) {
            sb.append("calorg");
            sb.append(",");
            hasCostMatCal = "calorg";
        }
        if (!colsStrSet.contains("material")) {
            sb.append("material");
            sb.append(",");
            hasCostMatCal = "material";
        }
        if (!colsStrSet.contains("costaccount")) {
            sb.append("costaccount");
            sb.append(",");
            hasCostMatCal = "costaccount";
        }
        colsStr = sb.toString();
        if (colsStrSet.contains("ownertype") && !colsStrSet.contains("owner")) {
            colsStr = colsStr.replace("ownertype", " ");
            ownerLessCol = "ownertype";
            colsStrSet.remove("ownertype");
        }
        if ((addOwnerType = this.checkCoupleItem(colsStr, "owner", "ownertype")) != null) {
            colsStr = addOwnerType;
        }
        if ((storageorgunit = this.checkCoupleItem(colsStr, "warehouse", "storageorgunit")) != null) {
            colsStr = storageorgunit;
        }
        if ((storageorgunitT = this.checkCoupleItem(colsStr, "location", "storageorgunit")) != null && !colsStr.contains("storageorgunit")) {
            colsStr = storageorgunitT;
        }
        if ((warehouse = this.checkCoupleItem(colsStr, "location", "warehouse")) != null && !colsStr.contains("warehouse")) {
            colsStr = warehouse;
        }
        if (addOwnerType != null || storageorgunit != null || storageorgunitT != null || warehouse != null || hasCostMatCal != null || ownerLessCol != null) {
            this.getModel().setValue("showkeycols", (Object)colsStr);
        }
    }

    private String checkCoupleItem(String str, String hasVal, String addVal) {
        CharSequence[] items = str.split(",");
        int hasValIdx = -1;
        int addValIdx = -1;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].equals(hasVal)) {
                hasValIdx = i;
                continue;
            }
            if (!items[i].equals(addVal)) continue;
            addValIdx = i;
        }
        if (hasValIdx > -1 && addValIdx == -1) {
            items[hasValIdx] = hasVal + "," + addVal;
            return String.join((CharSequence)",", items) + ",";
        }
        return null;
    }

    private void calOrgChanged() {
        this.getModel().setValue("mulstorageorg", null);
        this.getModel().setValue("mulowner", null);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            this.getModel().setValue("mulcostaccount", null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue("mulcostaccount", (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue("mulcostaccount", null);
            }
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        this.getModel().setValue("mulowner", null);
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccounts) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        HashSet<Long> periodIds = new HashSet<Long>();
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            periodIds.add(period.getLong("id"));
        }
        if (periodIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long maxid = (Long)Collections.max(periodIds);
        Long minid = (Long)Collections.min(periodIds);
        this.getModel().setValue("startperiod", (Object)(periodIds.size() == 0 ? null : minid));
        this.getModel().setValue("endperiod", (Object)(periodIds.size() == 0 ? null : maxid));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        DynamicObjectCollection costaccountList = dataEntity.getDynamicObjectCollection("mulcostaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calOrgList == null || calOrgList.size() == 0 || costaccountList == null || costaccountList.size() == 0 || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        String colsStr = (String)this.getModel().getValue("showkeycols");
        if (StringUtils.isEmpty((String)colsStr)) {
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype,calpolicy.currency,calpolicy.currency.amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject startperiod = dataEntity.getDynamicObject("startperiod");
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        QFilter q = new QFilter("periodtype", "=", ((DynamicObject)costAccountInfoS.get(0)).get("calpolicy.periodtype"));
        q.and(new QFilter("isadjustperiod", "=", (Object)false));
        q.and("id", ">=", (Object)startperiod.getLong("id"));
        q.and("id", "<=", (Object)endperiod.getLong("id"));
        ArrayList<Integer> periodNumberList = new ArrayList<Integer>(16);
        DynamicObjectCollection periodcoll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        HashMap<Integer, Long> periodIdMap = new HashMap<Integer, Long>(16);
        for (DynamicObject info : periodcoll) {
            int periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            periodNumberList.add(periodNumber);
            Long periodId = info.getLong("id");
            periodIdMap.put(periodNumber, periodId);
        }
        if (!periodNumberList.isEmpty() && periodNumberList.size() > 12) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u67e5\u8be212\u4e2a\u671f\u95f4\u7684\u6570\u636e\u3002", (String)"StockTurnOverReportBplatForm_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        StockTurnOverReportParam stockTurnOverReportParam = this.buildStockTurnOverReportParam(dataEntity, costAccountInfoS, queryParam, periodNumberList, periodIdMap, periodcoll);
        this.getQueryParam().getCustomParam().put(StockTurnOverReportParam.class.getName(), stockTurnOverReportParam);
        return super.verifyQuery(queryParam);
    }

    private StockTurnOverReportParam buildStockTurnOverReportParam(DynamicObject dataEntity, DynamicObjectCollection costAccountInfoS, ReportQueryParam queryParam, List<Integer> periodNumberList, Map<Integer, Long> periodIdMap, DynamicObjectCollection periodcoll) {
        StockTurnOverReportParam stockTurnOverReportParam = new StockTurnOverReportParam();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        for (DynamicObject costaccount : costaccounts) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        Map costAccountStartPeriodMap = PeriodHelper.getStartPeriods(costaccountIdSet);
        stockTurnOverReportParam.setCostAccountStartPeriodMap(costAccountStartPeriodMap);
        stockTurnOverReportParam.setCostaccountIdSet(costaccountIdSet);
        DynamicObject startperiod = dataEntity.getDynamicObject("startperiod");
        stockTurnOverReportParam.setStartPeriod(startperiod);
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        stockTurnOverReportParam.setEndPeriod(endperiod);
        Date filter_endDate = endperiod.getDate("enddate");
        stockTurnOverReportParam.setFilter_endDate(filter_endDate);
        Date filter_startDate = startperiod.getDate("begindate");
        stockTurnOverReportParam.setFilter_startDate(filter_startDate);
        Date filter_endStartDate = endperiod.getDate("begindate");
        stockTurnOverReportParam.setFilter_endStartDate(filter_endStartDate);
        stockTurnOverReportParam.setPeriodNumberList(periodNumberList);
        stockTurnOverReportParam.setPeriodIdMap(periodIdMap);
        boolean isGroupByPeriod = dataEntity.getBoolean("groupbyperiod");
        int turnOverDays = 0;
        turnOverDays = isGroupByPeriod ? periodcoll.size() * 30 : 30;
        stockTurnOverReportParam.setTurnOverDays(turnOverDays);
        stockTurnOverReportParam.setGroupByPeriod(isGroupByPeriod);
        DynamicObjectCollection filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulowner");
        stockTurnOverReportParam.setOwnerFrom(filter_ownerFrom);
        DynamicObjectCollection filter_storageOrg = dataEntity.getDynamicObjectCollection("mulstorageorg");
        stockTurnOverReportParam.setStorageOrg(filter_storageOrg);
        DynamicObjectCollection filter_warehouse = dataEntity.getDynamicObjectCollection("mulwarehouse");
        stockTurnOverReportParam.setWarehouse(filter_warehouse);
        DynamicObjectCollection filter_location = dataEntity.getDynamicObjectCollection("mullocation");
        stockTurnOverReportParam.setLocation(filter_location);
        DynamicObjectCollection filter_materialFrom = dataEntity.getDynamicObjectCollection("mulmaterial");
        stockTurnOverReportParam.setMaterialFrom(filter_materialFrom);
        DynamicObject filter_materialTo = dataEntity.getDynamicObject("materialto");
        stockTurnOverReportParam.setMaterialTo(filter_materialTo);
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String[] showKeyCols = colsStr.split(",");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_turn_over_col_repo");
        HashMap<String, IDataEntityProperty> dataEntityPropertyMap = new HashMap<String, IDataEntityProperty>();
        for (String showKeyCol : showKeyCols) {
            if (StringUtils.isEmpty((String)showKeyCol)) continue;
            IDataEntityProperty property = entityType.findProperty(showKeyCol);
            dataEntityPropertyMap.put(showKeyCol, property);
        }
        stockTurnOverReportParam.setColsStr(colsStr);
        stockTurnOverReportParam.setDataEntityPropertyMap(dataEntityPropertyMap);
        stockTurnOverReportParam.setNewBalanceFlag(this.isNewBalance);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            stockTurnOverReportParam.setCalorgIdSet(calOrgIds);
        }
        return stockTurnOverReportParam;
    }

    public DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = UserServiceHelper.getCurrentUserId();
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_turn_over_newrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        this.resetFilterGrid();
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName) || !this.filterGridForDetail(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGridForDetail(String fieldName) {
        HashSet<String> set = new HashSet<String>();
        set.add("material.isuseauxpty");
        set.add("material.enablelot");
        set.add("material.group.fullname");
        set.add("material.group.longnumber");
        set.add("material.group.name");
        set.add("material.group.number");
        set.add("material.modelnum");
        set.add("materialcategory.number");
        set.add("materialcategory.longnumber");
        set.add("materialcategory.name");
        return !set.contains(fieldName);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("calorg");
        removedPros.add("material");
        removedPros.add("owner");
        removedPros.add("ownertype");
        removedPros.add("storageorgunit");
        removedPros.add("warehouse");
        removedPros.add("location");
        removedPros.add("year");
        removedPros.add("month");
        removedPros.add("period");
        removedPros.add("endperiod");
        removedPros.add("baseunit");
        removedPros.add("currency");
        removedPros.add("qtyprecision");
        removedPros.add("calrange");
        removedPros.add("accounttype");
        removedPros.add("periodnumber");
        removedPros.add("assist");
        removedPros.add("warehsgroup");
        removedPros.add("materialcategory");
        removedPros.add("tracknumber.description");
        removedPros.add("costelement");
        removedPros.add("costsubelement");
        removedPros.add("periodendcostdiff");
        removedPros.add("periodendstandardcost");
        removedPros.add("periodbegincostdiff");
        removedPros.add("beginstandardcost");
        removedPros.add("isstandard");
        removedPros.add("mversion");
        removedPros.add("invstatus");
        removedPros.add("invtype");
        removedPros.add("configuredcode");
        removedPros.add("tracknumber");
        return !removedPros.contains(split[0]);
    }
}

