/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockturnoverlrpt.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.stockturnoverlrpt.StockTurnOverReportParam;
import kd.fi.cal.report.newreport.stockturnoverlrpt.StockTurnOverReportUtil;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.CalBalAndBalanceGroupDataDataXTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.CalBalGroupDataDataXTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.CalCaculateAllDataXTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.CalGroupByPeriodDataXTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.ChangeCalBalAndBalLanceDataxTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.ChangeCostAdjustDataxTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.ChangeCostRecordDataxTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.DeleteFieldDataTransform;
import kd.fi.cal.report.newreport.stockturnoverlrpt.dataxtransform.TurnOverAddMaterialGroupDataxTransform;

public class StockTurnOverReportHandle
implements IReportDataHandle {
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_materialType = new LocaleString(this.getLocale_materialType());
    private LocaleString locale_materialNo = new LocaleString(this.getLocale_materialNo());
    private StockTurnOverReportParam reportParam;

    private String getLocale_materialType() {
        return ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"StockDetailRptQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNo() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockDetailRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (StockTurnOverReportParam)ctx.getParam(StockTurnOverReportParam.class.getName());
        this.addDefaultGroupField(ctx);
        ctx.setShowBlockEntity(false);
    }

    private void addDefaultGroupField(ReportDataCtx ctx) {
        ctx.getShowKeyCols().add("baseunit");
        ctx.getShowKeyCols().add("currency");
        ctx.getShowKeyCols().add("year");
        ctx.getShowKeyCols().add("month");
        ctx.getShowKeyCols().add("periodnumber");
        ctx.getShowKeyCols().add("isstandard");
        ctx.getShowKeyCols().add("costelement");
        ctx.getShowKeyCols().add("costsubelement");
        if (StockTurnOverReportUtil.hasGroupByName(ctx.getShowKeyCols(), "owner")) {
            ctx.getShowKeyCols().add("ownertype");
        }
        if (this.reportParam.isNewBalanceFlag()) {
            Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
            ctx.getShowKeyCols().addAll(allKeyCols);
            ctx.getShowKeyCols().add("invstatus");
            ctx.getShowKeyCols().add("invtype");
            ctx.getShowKeyCols().add("mversion");
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        ArrayList<SrcBlockConf> resultBalanceSrcBlocks = new ArrayList<SrcBlockConf>();
        ArrayList<SrcBlockConf> resultBalSrcBlocks = new ArrayList<SrcBlockConf>();
        for (SrcBlockConf blockConf : blockCollector) {
            SrcBlockConf endblockConf;
            List enddataXTransforms;
            QFilter endQ;
            QFilter endq;
            SrcBlockConf endblockConf2;
            List dataXTransforms;
            QFilter beginQ;
            QFilter q;
            SrcBlockConf beginblockConf;
            srcEntity = blockConf.getSrcEntity();
            List<Integer> periodNumberList = this.reportParam.getPeriodNumberList();
            if ("cal_balance_subentity".equals(srcEntity) && !this.reportParam.isNewBalanceFlag()) {
                for (Integer periodNumber : periodNumberList) {
                    beginblockConf = new SrcBlockConf();
                    beginblockConf.setDefVals(blockConf.getDefVals());
                    beginblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    beginblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    beginblockConf.setSrcEntity(blockConf.getSrcEntity());
                    beginblockConf.setType(blockConf.getType());
                    q = StockTurnOverReportUtil.getFilter(this.reportParam, false);
                    beginQ = StockTurnOverReportUtil.getBeginFilter(periodNumber);
                    q = q.and(beginQ);
                    beginblockConf.setDataFs(q);
                    dataXTransforms = beginblockConf.getDataTransform();
                    if (dataXTransforms != null) {
                        dataXTransforms.add(new ChangeCalBalAndBalLanceDataxTransform(periodNumber, "0"));
                        dataXTransforms.add(new CalBalAndBalanceGroupDataDataXTransform(ctx));
                    }
                    beginblockConf.setAllowNotMatch(true);
                    resultBalanceSrcBlocks.add(beginblockConf);
                    endblockConf2 = new SrcBlockConf();
                    endblockConf2.setDefVals(blockConf.getDefVals());
                    endblockConf2.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    endblockConf2.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    endblockConf2.setSrcEntity(blockConf.getSrcEntity());
                    endblockConf2.setType(blockConf.getType());
                    endq = StockTurnOverReportUtil.getFilter(this.reportParam, false);
                    endQ = StockTurnOverReportUtil.getEndFilter(periodNumber);
                    endq = endq.and(endQ);
                    endblockConf2.setDataFs(endq);
                    enddataXTransforms = endblockConf2.getDataTransform();
                    if (enddataXTransforms != null) {
                        enddataXTransforms.add(new ChangeCalBalAndBalLanceDataxTransform(periodNumber, "1"));
                        enddataXTransforms.add(new CalBalAndBalanceGroupDataDataXTransform(ctx));
                    }
                    endblockConf2.setAllowNotMatch(true);
                    resultBalanceSrcBlocks.add(endblockConf2);
                }
                continue;
            }
            if ("cal_bal".equals(srcEntity) && this.reportParam.isNewBalanceFlag()) {
                for (Integer periodNumber : periodNumberList) {
                    beginblockConf = new SrcBlockConf();
                    beginblockConf.setDefVals(blockConf.getDefVals());
                    beginblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    beginblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    beginblockConf.setSrcEntity(blockConf.getSrcEntity());
                    beginblockConf.setType(blockConf.getType());
                    q = StockTurnOverReportUtil.getFilter(this.reportParam, false);
                    beginQ = StockTurnOverReportUtil.getBeginFilter(periodNumber);
                    q = q.and(beginQ);
                    beginblockConf.setDataFs(q);
                    dataXTransforms = beginblockConf.getDataTransform();
                    if (dataXTransforms != null) {
                        dataXTransforms.add(new ChangeCalBalAndBalLanceDataxTransform(periodNumber, "0"));
                        dataXTransforms.add(new CalBalGroupDataDataXTransform(ctx));
                        dataXTransforms.add(new CalBalAndBalanceGroupDataDataXTransform(ctx));
                    }
                    beginblockConf.setAllowNotMatch(true);
                    resultBalSrcBlocks.add(beginblockConf);
                    endblockConf2 = new SrcBlockConf();
                    endblockConf2.setDefVals(blockConf.getDefVals());
                    endblockConf2.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    endblockConf2.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    endblockConf2.setSrcEntity(blockConf.getSrcEntity());
                    endblockConf2.setType(blockConf.getType());
                    endq = StockTurnOverReportUtil.getFilter(this.reportParam, false);
                    endQ = StockTurnOverReportUtil.getEndFilter(periodNumber);
                    endq = endq.and(endQ);
                    endblockConf2.setDataFs(endq);
                    enddataXTransforms = endblockConf2.getDataTransform();
                    if (enddataXTransforms != null) {
                        enddataXTransforms.add(new ChangeCalBalAndBalLanceDataxTransform(periodNumber, "1"));
                        enddataXTransforms.add(new CalBalGroupDataDataXTransform(ctx));
                        enddataXTransforms.add(new CalBalAndBalanceGroupDataDataXTransform(ctx));
                    }
                    endblockConf2.setAllowNotMatch(true);
                    resultBalSrcBlocks.add(endblockConf2);
                }
                continue;
            }
            if ("cal_costrecord".equals(srcEntity)) {
                for (Integer periodNumber : periodNumberList) {
                    endblockConf = new SrcBlockConf();
                    endblockConf.setDefVals(blockConf.getDefVals());
                    endblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                    endblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                    endblockConf.setSrcEntity(blockConf.getSrcEntity());
                    endblockConf.setType(blockConf.getType());
                    Long periodId = this.reportParam.getPeriodIdMap().get(periodNumber);
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
                    DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)periodId, (DynamicObjectType)entityType);
                    QFilter q2 = StockTurnOverReportUtil.getFilter(this.reportParam, true);
                    q2.and("issplitcreate", "=", (Object)"0");
                    q2.and("billtype.billformid", "=", (Object)"im_saloutbill");
                    q2.and("period", "=", (Object)periodId);
                    q2.and("bookdate", "<=", (Object)period.getDate("enddate"));
                    q2.and("bookdate", ">=", (Object)period.getDate("begindate"));
                    QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
                    q2.and(billStatusf);
                    endblockConf.setDataFs(q2);
                    List dataXTransforms2 = endblockConf.getDataTransform();
                    if (dataXTransforms2 != null) {
                        dataXTransforms2.add(new ChangeCostRecordDataxTransform(periodNumber, ctx));
                    }
                    endblockConf.setAllowNotMatch(true);
                    resultBalSrcBlocks.add(endblockConf);
                    resultBalanceSrcBlocks.add(endblockConf);
                }
                continue;
            }
            if (!"cal_costadjustbill".equals(srcEntity)) continue;
            for (Integer periodNumber : periodNumberList) {
                endblockConf = new SrcBlockConf();
                endblockConf.setDefVals(blockConf.getDefVals());
                endblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
                endblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
                endblockConf.setSrcEntity(blockConf.getSrcEntity());
                endblockConf.setType(blockConf.getType());
                q = StockTurnOverReportUtil.getAdjustFilter(this.reportParam);
                q.and("billtype.billformid", "=", (Object)"im_saloutbill");
                q.and("period", "=", (Object)this.reportParam.getPeriodIdMap().get(periodNumber));
                q.and("billstatus", "=", (Object)"C");
                QFilter actualQ = new QFilter("entryentity.accounttype", "!=", (Object)"D");
                QFilter standardQ1 = new QFilter("entryentity.accounttype", "=", (Object)"D");
                standardQ1.and("createtype", "!=", (Object)"M");
                QFilter standardQ2 = new QFilter("entryentity.accounttype", "=", (Object)"D");
                standardQ2.and("createtype", "=", (Object)"M");
                standardQ2.and("billsrctype", "=", (Object)"D");
                q.and(actualQ.or(standardQ1).or(standardQ2));
                endblockConf.setDataFs(q);
                List dataXTransforms3 = endblockConf.getDataTransform();
                if (dataXTransforms3 != null) {
                    dataXTransforms3.add(new ChangeCostAdjustDataxTransform(periodNumber, ctx));
                }
                endblockConf.setAllowNotMatch(true);
                resultBalSrcBlocks.add(endblockConf);
                resultBalanceSrcBlocks.add(endblockConf);
            }
        }
        if (this.reportParam.isNewBalanceFlag()) {
            ctx.getReportConf().setSrcBlockConf(resultBalSrcBlocks);
        } else {
            ctx.getReportConf().setSrcBlockConf(resultBalanceSrcBlocks);
        }
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        String[] colsStrs;
        ctx.getShowKeyCols().clear();
        ctx.getShowKeyCols().add("baseunit");
        ctx.getShowKeyCols().add("currency");
        ctx.getShowKeyCols().add("year");
        ctx.getShowKeyCols().add("month");
        ctx.getShowKeyCols().add("periodnumber");
        for (String col : colsStrs = this.reportParam.getColsStr().split(",")) {
            if (StringUtils.isEmpty((String)col)) continue;
            ctx.getShowKeyCols().add(col);
        }
        ctx.setGroupPlans(new GroupPlan((Collection)ctx.getShowKeyCols(), (Collection)ctx.getShowQtyCols()));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        boolean isGroupByPeriod = this.reportParam.isGroupByPeriod();
        if (isGroupByPeriod) {
            transCollector.add(new CalGroupByPeriodDataXTransform(ctx, this.reportParam.getStartPeriod(), this.reportParam.getEndPeriod()));
        }
        transCollector.add(new CalCaculateAllDataXTransform(ctx, this.reportParam.getTurnOverDays()));
        transCollector.add(new TurnOverAddMaterialGroupDataxTransform(ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DeleteFieldDataTransform(ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> reslutcols = new ArrayList<AbstractReportColumn>(cols.size());
        for (AbstractReportColumn col : cols) {
            ReportColumn reportCol = (ReportColumn)col;
            String fieldKey = reportCol.getFieldKey();
            if ("currency".equals(fieldKey)) {
                reportCol.setHide(true);
            }
            if (fieldKey.contains("material") && "material".equals(fieldKey)) {
                reportCol.setCaption(this.locale_materialNo);
            }
            reslutcols.add(col);
            if (!fieldKey.contains("material") || !fieldKey.contains("name")) continue;
            ReportColumn materialgroup = new ReportColumn();
            materialgroup.setCaption(this.locale_materialType);
            materialgroup.setWidth(width);
            materialgroup.setFieldKey("materialgroup");
            materialgroup.setFieldType("text");
            reslutcols.add((AbstractReportColumn)materialgroup);
        }
        return reslutcols;
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
    }
}

