/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.transdtlrpt;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.input.DbInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.transdtlrpt.TransDtlRptParam;

public class TransDtlRptHelper {
    public static TransDtlRptParam buildRptParam(IDataModel model) {
        String isPost;
        DynamicObject dataEntity = model.getDataEntity(true);
        TransDtlRptParam rptParam = new TransDtlRptParam();
        rptParam.setStartDate(dataEntity.getDate("startdate"));
        rptParam.setEndDate(dataEntity.getDate("enddate"));
        rptParam.setCalOrgIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulcalorg"));
        rptParam.setCostAccountIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulcostaccount"));
        rptParam.setStorageOrgIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulstorageorg"));
        rptParam.setWareHouseIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulwarehouse"));
        rptParam.setLocationIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mullocation"));
        rptParam.setAccountIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulaccount"));
        rptParam.setBiztypeIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulbiztype"));
        rptParam.setBilltypeIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulbilltype"));
        rptParam.setInvschemeIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulinvscheme"));
        rptParam.setStockTypeIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulmatcategory"));
        rptParam.setMaterialFrom(dataEntity.getDynamicObjectCollection("mulmaterial"));
        rptParam.setMaterialTo(model.getDataEntity().getDynamicObject("materialto"));
        rptParam.setProjectIdSet(ReportUtil.getMulBaseEditIdSet((IDataModel)model, (String)"mulproject"));
        rptParam.setBillno(model.getDataEntity().getString("billno"));
        rptParam.setBillNumber(model.getDataEntity().getString("billnumber"));
        rptParam.setIsgroupaccount(model.getDataEntity().getBoolean("isgroupaccount"));
        String voucherStatus = model.getDataEntity().getString("voucherstatus");
        if (voucherStatus != null && !"".equals(CommonUtils.trimComma((String)voucherStatus))) {
            rptParam.setVoucherStatus(CommonUtils.trimComma((String)voucherStatus).split(","));
        }
        if ((isPost = model.getDataEntity().getString("ispost")) != null && !"".equals(CommonUtils.trimComma((String)isPost))) {
            rptParam.setIsPost(CommonUtils.trimComma((String)isPost).split(","));
        }
        DynamicObjectCollection mulcostaccount = dataEntity.getDynamicObjectCollection("mulcostaccount");
        DynamicObjectCollection costAccounts = new DynamicObjectCollection();
        for (DynamicObject costAccount : mulcostaccount) {
            costAccounts.add((Object)costAccount.getDynamicObject("fbasedataid"));
        }
        ArrayList<String> filterRange_recordBill = new ArrayList<String>(16);
        ArrayList<String> filterRange_adjustBill = new ArrayList<String>(16);
        ArrayList<String> filterRange_diffBill = new ArrayList<String>(16);
        HashSet<String> queryObjects = new HashSet<String>(16);
        DynamicObjectCollection entry = model.getEntryEntity("entry");
        if (entry != null && !entry.isEmpty()) {
            int size = entry.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject entityobject = (DynamicObject)((DynamicObject)entry.get(i)).get("entityobject");
                if (entityobject == null) continue;
                String entityObjectId = String.valueOf(entityobject.getPkValue());
                queryObjects.add(entityObjectId);
                String billFilteStr = (String)((DynamicObject)entry.get(i)).get("billfilter_tag");
                if (billFilteStr.isEmpty() || "".equals(billFilteStr)) continue;
                if ("cal_costrecord_subentity".equals(entityObjectId) || "cal_costrecord".equals(entityObjectId)) {
                    filterRange_recordBill.add(billFilteStr);
                    continue;
                }
                if ("cal_costadjust_subentity".equals(entityObjectId) || "cal_costadjustbill".equals(entityObjectId)) {
                    filterRange_adjustBill.add(billFilteStr);
                    continue;
                }
                if (!"cal_stdcostdiffbill".equals(entityObjectId)) continue;
                filterRange_diffBill.add(billFilteStr);
            }
        }
        rptParam.setQueryObjects(queryObjects);
        rptParam.setFilterRange_recordBill(TransDtlRptHelper.getSchemeFilter(filterRange_recordBill, "cal_costrecord_subentity"));
        rptParam.setFilterRange_adjustBill(TransDtlRptHelper.getSchemeFilter(filterRange_adjustBill, "cal_costadjust_subentity"));
        rptParam.setFilterRange_diffBill(TransDtlRptHelper.getSchemeFilter(filterRange_diffBill, "cal_stdcostdiffbill"));
        return rptParam;
    }

    public static Set<QFilter> getSchemeFilter(List<String> filterList, String objectNumber) {
        if (filterList.isEmpty()) {
            return null;
        }
        HashSet<QFilter> filterSet = new HashSet<QFilter>(16);
        for (String filterStr : filterList) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            FilterCondition filterCondition = condition.getFilterCondition();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)objectNumber);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter baseQ = filterBuilder.getQFilter();
            String tran = condition.getExprTran();
            String experss = condition.getExpression();
            if (!"".equals(experss)) {
                QFilter expressFilter = QFilter.of((String)experss, (Object[])new Object[0]);
                if (baseQ != null) {
                    baseQ.and(expressFilter);
                } else {
                    baseQ = expressFilter;
                }
            }
            QFilter valiteQ = baseQ.copy();
            if ("cal_costrecord_subentity".equals(objectNumber)) {
                valiteQ.and("costaccount", "=", (Object)0L);
                valiteQ.and("bookdate", "=", (Object)new Date());
            }
            try {
                QueryServiceHelper.query((String)objectNumber, (String)"id", (QFilter[])valiteQ.toArray());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"TransactionDetailRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            }
            filterSet.add(baseQ);
        }
        return filterSet;
    }

    public static QFilter getBaseFilter(TransDtlRptParam rptParam, String entityNum) {
        QFilter q = new QFilter("costaccount", "in", rptParam.getCostAccountIdSet());
        q.and(new QFilter("bookdate", ">=", (Object)rptParam.getStartDate()));
        q.and(new QFilter("bookdate", "<=", (Object)rptParam.getEndDate()));
        if (rptParam.getBilltypeIdSet() != null && !rptParam.getBilltypeIdSet().isEmpty()) {
            q.and("billtype", "in", rptParam.getBilltypeIdSet());
        }
        if (rptParam.getBillno() != null && !"".equals(rptParam.getBillno())) {
            q.and("billno", "=", (Object)rptParam.getBillno());
        }
        Set<Long> storageOrgIdSet = rptParam.getStorageOrgIdSet();
        Set<Long> warehsGroupIdSet = rptParam.getWarehsGroupIdSet();
        Set<Long> wareHouseIdSet = rptParam.getWareHouseIdSet();
        Set<Long> locationIdSet = rptParam.getLocationIdSet();
        DynamicObjectCollection materialFrom = rptParam.getMaterialFrom();
        DynamicObject materialTo = rptParam.getMaterialTo();
        Set<Long> projectIdSet = rptParam.getProjectIdSet();
        Set<Long> biztypeIdSet = rptParam.getBiztypeIdSet();
        Set<Long> invschemeIdSet = rptParam.getInvschemeIdSet();
        Set<Long> stockTypeIdSet = rptParam.getStockTypeIdSet();
        String billNumber = rptParam.getBillNumber();
        if ("cal_costrecord_subentity".equals(entityNum)) {
            q.and("billstatus", "=", (Object)"C");
            if (storageOrgIdSet != null && !storageOrgIdSet.isEmpty()) {
                q.and("storageorgunit", "in", storageOrgIdSet);
            }
            if (warehsGroupIdSet != null && !warehsGroupIdSet.isEmpty()) {
                q.and("entry.warehouse.group", "in", warehsGroupIdSet);
            }
            if (wareHouseIdSet != null && !wareHouseIdSet.isEmpty()) {
                q.and("entry.warehouse", "in", wareHouseIdSet);
            }
            if (locationIdSet != null && !locationIdSet.isEmpty()) {
                q.and("entry.location", "in", locationIdSet);
            }
            if (projectIdSet != null && !projectIdSet.isEmpty()) {
                q.and("entry.project", "in", projectIdSet);
            }
            if (billNumber != null && !"".equals(billNumber)) {
                q.and("billnumber", "=", (Object)billNumber);
            }
            if (biztypeIdSet != null && !biztypeIdSet.isEmpty()) {
                q.and("biztype", "in", biztypeIdSet);
            }
            if (invschemeIdSet != null && !invschemeIdSet.isEmpty()) {
                q.and("invscheme", "in", invschemeIdSet);
            }
            if (stockTypeIdSet != null && !stockTypeIdSet.isEmpty()) {
                q.and("entry.stocktype", "in", stockTypeIdSet);
            }
            if (materialFrom != null && !materialFrom.isEmpty()) {
                if (materialFrom.size() > 1) {
                    HashSet<Long> materialSet = new HashSet<Long>();
                    for (DynamicObject material : materialFrom) {
                        materialSet.add(material.getDynamicObject("fbasedataid").getLong("id"));
                    }
                    q.and("entry.material.id", "in", materialSet);
                } else if (materialFrom.size() == 1) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
                }
            }
            if (materialTo != null) {
                q.and("entry.material.number", "<=", (Object)materialTo.getString("number"));
            }
        } else if ("cal_costadjust_subentity".equals(entityNum) || "cal_stdcostdiffbill".equals(entityNum)) {
            if ("cal_costadjust_subentity".equals(entityNum)) {
                q.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
            }
            if (storageOrgIdSet != null && !storageOrgIdSet.isEmpty()) {
                q.and("entryentity.storageorgunit", "in", storageOrgIdSet);
            }
            if (warehsGroupIdSet != null && !warehsGroupIdSet.isEmpty()) {
                q.and("entryentity.warehouse.group", "in", warehsGroupIdSet);
            }
            if (wareHouseIdSet != null && !wareHouseIdSet.isEmpty()) {
                q.and("entryentity.warehouse", "in", wareHouseIdSet);
            }
            if (locationIdSet != null && !locationIdSet.isEmpty()) {
                q.and("entryentity.location", "in", locationIdSet);
            }
            if (projectIdSet != null && !projectIdSet.isEmpty()) {
                q.and("entryentity.project", "in", projectIdSet);
            }
            if (billNumber != null && !"".equals(billNumber)) {
                q.and("entryentity.invbillnum", "=", (Object)billNumber);
            }
            if (stockTypeIdSet != null && !stockTypeIdSet.isEmpty()) {
                q.and("entryentity.stocktype", "in", stockTypeIdSet);
            }
            if (materialFrom != null && !materialFrom.isEmpty()) {
                if (materialFrom.size() > 1) {
                    HashSet<Long> materialSet = new HashSet<Long>();
                    for (DynamicObject material : materialFrom) {
                        materialSet.add(material.getDynamicObject("fbasedataid").getLong("id"));
                    }
                    q.and("entryentity.material.id", "in", materialSet);
                } else if (materialFrom.size() == 1) {
                    q.and("entryentity.material.number", ">=", (Object)((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
                }
            }
            if (materialTo != null) {
                q.and("entryentity.material.number", "<=", (Object)materialTo.getString("number"));
            }
            if (biztypeIdSet != null && !biztypeIdSet.isEmpty()) {
                q.and("entryentity.invbiztype", "in", biztypeIdSet);
            }
            if (invschemeIdSet != null && !invschemeIdSet.isEmpty()) {
                q.and(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            }
        }
        return q;
    }

    public static void cacheEntryAndFIds(ReportDataCtx ctx, DataSetX dataSetx, Set<Long> fidSet, Set<Long> entryIdSet) {
        DataSet dataSet = TransDtlRptHelper.createDataSet(ctx, dataSetx);
        for (Row row : dataSet) {
            entryIdSet.add(row.getLong("entryid"));
            fidSet.add(row.getLong("fid"));
        }
    }

    public static DataSet createDataSet(ReportDataCtx ctx, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        ctx.getCurrentJob().commit(60, TimeUnit.MINUTES);
        return ctx.getCurrentJob().readDataSet(resultId);
    }

    public static DataSet getBizVoucherDataSet(Set<Long> idSet, TransDtlRptParam rptParam) {
        String[] isPost;
        QFilter glVoucherQ = new QFilter("sourcebill", "in", idSet);
        String[] voucherStatus = rptParam.getVoucherStatus();
        if (voucherStatus != null && voucherStatus.length > 0) {
            glVoucherQ.and("billstatus", "in", (Object)voucherStatus);
        }
        if ((isPost = rptParam.getIsPost()) != null && isPost.length > 0) {
            glVoucherQ.and("ispost", "in", (Object)isPost);
        }
        DataSet glVoucherDataSet = QueryServiceHelper.queryDataSet((String)"query-gl_voucher", (String)"gl_voucher", (String)"id as glvoucherid,billno as glvoucher,bookeddate as bookeddate,billstatus as billstatus,ispost as isposted,creator as vouchercreator", (QFilter[])glVoucherQ.toArray(), null);
        HashSet<Long> glVoucherIdSet = new HashSet<Long>(16);
        for (Row row : glVoucherDataSet.copy()) {
            glVoucherIdSet.add(row.getLong("glvoucherid"));
        }
        if (glVoucherIdSet.isEmpty()) {
            if (TransDtlRptHelper.getIsOnlyVoucher(rptParam)) {
                return TransDtlRptHelper.getNewVoucherDataSet(rptParam);
            }
            return TransDtlRptHelper.getNullVoucherDataSet();
        }
        DBRoute route = new DBRoute("ai");
        SqlBuilder aiSqlBuilder = new SqlBuilder();
        aiSqlBuilder.append("select fid,fglvoucherid from t_ai_bizvoucher where", new Object[0]);
        aiSqlBuilder.appendIn("fglvoucherid", glVoucherIdSet.toArray());
        DataSet aiVoucher = DB.queryDataSet((String)"query-ai_voucher", (DBRoute)route, (SqlBuilder)aiSqlBuilder);
        aiVoucher = aiVoucher.leftJoin(glVoucherDataSet).on("fglvoucherid", "glvoucherid").select(new String[]{"fid"}, glVoucherDataSet.getRowMeta().getFieldNames()).finish();
        List<Set<Object>> fidList = TransDtlRptHelper.getEntryIds(aiVoucher.copy(), "fid");
        if (fidList.isEmpty()) {
            if (TransDtlRptHelper.getIsOnlyVoucher(rptParam)) {
                return TransDtlRptHelper.getNewVoucherDataSet(rptParam);
            }
            return TransDtlRptHelper.getNullVoucherDataSet();
        }
        String sqlSelect = "select fentryid as bizovucherentryid,fid,fsourcebillentryid as sourcebillentryid,faccountid as account,fdescription as description,fassgrpid as assgrp,flocaldebit as debitlocal,flocalcredit as creditlocal from t_ai_bizvoucherentry ";
        SqlBuilder nullSqlBuilder = new SqlBuilder();
        nullSqlBuilder.append(sqlSelect, new Object[0]);
        nullSqlBuilder.append("where 1 != 1", new Object[0]);
        DataSet nullDataSet = DB.queryDataSet((String)"query-ai_voucher", (DBRoute)route, (SqlBuilder)nullSqlBuilder);
        RowMeta rowMeta = nullDataSet.getRowMeta();
        ArrayList<DbInput> vouchersIO = new ArrayList<DbInput>(fidList.size());
        for (int arrayIndex = 0; arrayIndex < fidList.size(); ++arrayIndex) {
            Object[] fIds = fidList.get(arrayIndex).toArray();
            String sql = sqlSelect;
            sql = sql + "where 1=1 ";
            sql = sql + "and ";
            sql = sql + new QFilter("fid", "in", (Object)fIds).toString();
            Set<Long> accountIdSet = rptParam.getAccountIdSet();
            if (accountIdSet != null && !accountIdSet.isEmpty()) {
                sql = sql + " and ";
                sql = sql + new QFilter("faccountid", "in", accountIdSet).toString();
            }
            DbInput voucherInput = new DbInput("query-ai_voucher", route.getRouteKey(), sql, null, rowMeta);
            vouchersIO.add(voucherInput);
        }
        Algo algo = Algo.create((String)"query-ai_voucher");
        DataSet voucherDateSet = algo.createDataSet((Input[])vouchersIO.toArray(new DbInput[vouchersIO.size()]));
        String leftSelect = "bizovucherentryid,sourcebillentryid,account,description,assgrp,debitlocal,creditlocal";
        String rightSelect = "glvoucherid,glvoucher,bookeddate,billstatus,isposted,vouchercreator";
        voucherDateSet = voucherDateSet.leftJoin(aiVoucher).on("fid", "fid").select(leftSelect.split(","), rightSelect.split(",")).finish();
        voucherDateSet = voucherDateSet.addField("0", "newvoucherindex");
        voucherDateSet.getRowMeta().getField("newvoucherindex").setDataType((DataType)new IntegerType());
        voucherDateSet = voucherDateSet.select("bizovucherentryid,glvoucherid,sourcebillentryid,account,glvoucher,bookeddate,billstatus,isposted,vouchercreator,description,assgrp,creditlocal,debitlocal,newvoucherindex");
        if (TransDtlRptHelper.getIsOnlyVoucher(rptParam)) {
            DataSet newVoucherSet = TransDtlRptHelper.getNewVoucherDataSet(rptParam);
            voucherDateSet = voucherDateSet.union(newVoucherSet);
        }
        return voucherDateSet;
    }

    public static DataSet getNewVoucherDataSet(TransDtlRptParam rptParam) {
        String[] isPost;
        String[] voucherStatus;
        QFilter voucherQ = new QFilter("sourcesys", "!=", (Object)"/KIUHEXROK3D");
        Set<Long> accountIdSet = rptParam.getAccountIdSet();
        if (accountIdSet != null && !accountIdSet.isEmpty()) {
            voucherQ.and("entries.account", "in", accountIdSet);
        }
        if ((voucherStatus = rptParam.getVoucherStatus()) != null && voucherStatus.length > 0) {
            voucherQ.and("billstatus", "in", (Object)voucherStatus);
        }
        if ((isPost = rptParam.getIsPost()) != null && isPost.length > 0) {
            voucherQ.and("ispost", "in", (Object)isPost);
        }
        voucherQ.and("org", "in", rptParam.getCalOrgIdSet());
        voucherQ.and(new QFilter("bookeddate", ">=", (Object)rptParam.getStartDate()));
        voucherQ.and(new QFilter("bookeddate", "<=", (Object)rptParam.getEndDate()));
        DataSet newVoucherDataSet = QueryServiceHelper.queryDataSet((String)"query-gl_voucher", (String)"gl_voucher", (String)"id,billno as glvoucher,bookeddate,billstatus,ispost as isposted,creator as vouchercreator,entries.account as account,entries.edescription as description,entries.assgrp as assgrp,entries.debitlocal as debitlocal,entries.creditlocal as creditlocal", (QFilter[])voucherQ.toArray(), null);
        newVoucherDataSet = newVoucherDataSet.addField("1", "newvoucherindex");
        newVoucherDataSet.getRowMeta().getField("newvoucherindex").setDataType((DataType)new IntegerType());
        newVoucherDataSet = newVoucherDataSet.select("0l bizovucherentryid,id as glvoucherid,0l as sourcebillentryid,account,glvoucher,bookeddate,billstatus,isposted,vouchercreator,description,assgrp,creditlocal,debitlocal,newvoucherindex");
        return newVoucherDataSet;
    }

    public static DataSet getNullVoucherDataSet() {
        QFilter voucherQ = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        String nullSelect = "0l as bizovucherentryid,id as glvoucherid,0l as sourcebillentryid,entries.account as account,billno as glvoucher,bookeddate,billstatus,ispost as isposted,creator as vouchercreator,entries.edescription as description,entries.assgrp as assgrp,entries.creditlocal as creditlocal,entries.debitlocal as debitlocal,0 as newvoucherindex";
        DataSet nullVoucherDataSet = QueryServiceHelper.queryDataSet((String)"query-gl_voucher", (String)"gl_voucher", (String)nullSelect, (QFilter[])voucherQ.toArray(), null);
        nullVoucherDataSet.getRowMeta().getField("newvoucherindex").setDataType((DataType)new BigDecimalType());
        return nullVoucherDataSet;
    }

    public static List<Set<Object>> getEntryIds(DataSet dataSet, String idName) {
        ArrayList<Set<Object>> entryIdsArray = new ArrayList<Set<Object>>(16);
        HashSet<Object> entryIds = null;
        long index = 0L;
        for (Row row : dataSet) {
            if (index % 5000L == 0L) {
                entryIds = new HashSet<Object>();
                entryIdsArray.add(entryIds);
            }
            if (entryIds != null) {
                entryIds.add(row.get(idName));
            }
            ++index;
        }
        return entryIdsArray;
    }

    public static boolean getIsOnlyVoucher(TransDtlRptParam rptParam) {
        boolean isNullAccout = rptParam.getAccountIdSet() == null || rptParam.getAccountIdSet().isEmpty();
        boolean isNullVoucherStatus = rptParam.getVoucherStatus() == null || rptParam.getVoucherStatus().length < 1;
        boolean isNullPost = rptParam.getIsPost() == null || rptParam.getIsPost().length < 1;
        return !isNullAccout || !isNullVoucherStatus || !isNullPost;
    }

    public static void createHideColumns(List<AbstractReportColumn> cols) {
        for (AbstractReportColumn abstractReportColumn : cols) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            ReportColumn column = (ReportColumn)abstractReportColumn;
            String columnName = column.createColumn().get("dataIndex").toString();
            HashSet<String> hideFields = new HashSet<String>(16);
            hideFields.add("entryid");
            hideFields.add("fid");
            hideFields.add("fivoucherid");
            hideFields.add("carryovervoucherid");
            hideFields.add("glvoucherid");
            hideFields.add("tempvoucherid");
            hideFields.add("bizbillid");
            hideFields.add("dischargevoucherid");
            hideFields.add("feevoucherid");
            if (!hideFields.contains(columnName)) continue;
            column.setHide(true);
        }
    }
}

