/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.transdtlrpt.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;

public class GroupMatAccountGroupFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public GroupMatAccountGroupFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int matIdx = this.rowMeta.getFieldIndex("material");
        int linetypeIdx = this.rowMeta.getFieldIndex("linetype");
        int hasvoucherbizIdx = this.rowMeta.getFieldIndex("hasvoucherbizidx");
        int newvoucherIdx = this.rowMeta.getFieldIndex("newvoucherindex");
        int accountsumIdx = this.rowMeta.getFieldIndex("accountsumidx");
        int calorgIdx = this.rowMeta.getFieldIndex("calorg");
        int costAccountIdx = this.rowMeta.getFieldIndex("costaccount");
        int accountIdx = this.rowMeta.getFieldIndex("account");
        int materialnameIdx = this.rowMeta.getFieldIndex("materialname");
        int localcurrencyIdx = this.rowMeta.getFieldIndex("localcurrency");
        int baseqtyIdx = this.rowMeta.getFieldIndex("baseqty");
        int standardcostIdx = this.rowMeta.getFieldIndex("standardcost");
        int actualcostIdx = this.rowMeta.getFieldIndex("actualcost");
        int debitlocalIdx = this.rowMeta.getFieldIndex("debitlocal");
        int creditlocalIdx = this.rowMeta.getFieldIndex("creditlocal");
        Long calorg = null;
        Long costAccount = null;
        Long account = null;
        Long localcurrency = null;
        BigDecimal allQty = BigDecimal.ZERO;
        BigDecimal allStandardcost = BigDecimal.ZERO;
        BigDecimal allActualcost = BigDecimal.ZERO;
        BigDecimal allDebitlocal = BigDecimal.ZERO;
        BigDecimal allCreditlocal = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> matQtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> matStandardcostMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> matActualcostMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> matDebitlocalMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> matCreditlocalMap = new HashMap<Long, BigDecimal>(16);
        for (RowX rowX : iterable) {
            Long matId = rowX.getLong(matIdx);
            if (calorg == null) {
                calorg = rowX.getLong(calorgIdx);
            }
            if (costAccount == null) {
                costAccount = rowX.getLong(costAccountIdx);
            }
            if (account == null) {
                account = rowX.getLong(accountIdx);
            }
            if (localcurrency == null) {
                localcurrency = rowX.getLong(localcurrencyIdx);
            }
            BigDecimal baseQty = rowX.getBigDecimal(baseqtyIdx);
            BigDecimal standardcost = rowX.getBigDecimal(standardcostIdx);
            BigDecimal actualcost = rowX.getBigDecimal(actualcostIdx);
            BigDecimal debitlocal = rowX.getBigDecimal(debitlocalIdx);
            BigDecimal creditlocal = rowX.getBigDecimal(creditlocalIdx);
            if (baseQty != null) {
                allQty = allQty.add(baseQty);
                this.addMatValue(matQtyMap, matId, baseQty);
            }
            if (standardcost != null) {
                allStandardcost = allStandardcost.add(standardcost);
                this.addMatValue(matStandardcostMap, matId, standardcost);
            }
            if (actualcost != null) {
                allActualcost = allActualcost.add(actualcost);
                this.addMatValue(matActualcostMap, matId, actualcost);
            }
            if (debitlocal != null) {
                allDebitlocal = allDebitlocal.add(debitlocal);
                this.addMatValue(matDebitlocalMap, matId, debitlocal);
            }
            if (creditlocal != null) {
                allCreditlocal = allCreditlocal.add(creditlocal);
                this.addMatValue(matCreditlocalMap, matId, creditlocal);
            }
            rowX.set(hasvoucherbizIdx, (Object)1);
            collector.collect(rowX);
        }
        RowX accountSumRowX = new RowX(this.rowMeta.getFieldCount());
        accountSumRowX.set(calorgIdx, calorg);
        accountSumRowX.set(costAccountIdx, costAccount);
        accountSumRowX.set(accountIdx, (Object)account);
        accountSumRowX.set(localcurrencyIdx, (Object)localcurrency);
        accountSumRowX.set(materialnameIdx, (Object)ResManager.loadKDString((String)"\u79d1\u76ee\u603b\u8ba1", (String)"StockEstimateGroupQueryPlugin_25", (String)"fi-cal-report", (Object[])new Object[0]));
        accountSumRowX.set(baseqtyIdx, (Object)allQty);
        accountSumRowX.set(standardcostIdx, (Object)allStandardcost);
        accountSumRowX.set(actualcostIdx, (Object)allActualcost);
        accountSumRowX.set(debitlocalIdx, (Object)allDebitlocal);
        accountSumRowX.set(creditlocalIdx, (Object)allCreditlocal);
        accountSumRowX.set(accountsumIdx, (Object)1);
        accountSumRowX.set(newvoucherIdx, (Object)0);
        accountSumRowX.set(hasvoucherbizIdx, (Object)1);
        accountSumRowX.set(linetypeIdx, (Object)BigDecimal.ONE);
        collector.collect(accountSumRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void addMatValue(Map<Long, BigDecimal> matMap, Long matId, BigDecimal value) {
        BigDecimal matValue = matMap.get(matId);
        matValue = matValue == null ? value : matValue.add(value);
        matMap.put(matId, matValue);
    }
}

