/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.transdtlrpt.handle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.transdtlrpt.TransDtlRptHelper;
import kd.fi.cal.report.newreport.transdtlrpt.TransDtlRptParam;
import kd.fi.cal.report.newreport.transdtlrpt.transform.BolckDataXTransform;
import kd.fi.cal.report.newreport.transdtlrpt.transform.DoOrderTransfrom;
import kd.fi.cal.report.newreport.transdtlrpt.transform.GroupMatAccountTransform;
import kd.fi.cal.report.newreport.transdtlrpt.transform.JoinVoucherDataTransform;

public class TransDtlRptHandle
implements IReportDataHandle {
    private TransDtlRptParam rptParam;
    private Set<QFilter> filterRange_recordBill;
    private Set<QFilter> filterRange_adjustBill;
    private Set<QFilter> filterRange_diffBill;

    public void setupCtx(ReportDataCtx ctx) {
        ctx.setSumKeyCols(null);
        ctx.setSumKeyCols(null);
        ctx.setSumKeyCols4Count(null);
        this.rptParam = (TransDtlRptParam)ctx.getParam(TransDtlRptParam.class.getName());
        this.filterRange_recordBill = this.rptParam.getFilterRange_recordBill();
        this.filterRange_adjustBill = this.rptParam.getFilterRange_adjustBill();
        this.filterRange_diffBill = this.rptParam.getFilterRange_diffBill();
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        ArrayList<SrcBlockConf> resultBlocks = new ArrayList<SrcBlockConf>(16);
        for (SrcBlockConf blockConf : blockCollector) {
            String srcEntity = blockConf.getSrcEntity();
            this.setMoreBlockField(srcEntity, blockConf);
            if (srcEntity.equals("cal_costrecord_subentity")) {
                this.addBlockConfByRange(this.filterRange_recordBill, "cal_costrecord_subentity", blockConf, resultBlocks, ctx);
                continue;
            }
            if (srcEntity.equals("cal_costadjust_subentity")) {
                this.addBlockConfByRange(this.filterRange_adjustBill, "cal_costadjust_subentity", blockConf, resultBlocks, ctx);
                continue;
            }
            if (!srcEntity.equals("cal_stdcostdiffbill")) continue;
            this.addBlockConfByRange(this.filterRange_diffBill, "cal_stdcostdiffbill", blockConf, resultBlocks, ctx);
        }
        ctx.getReportConf().setSrcBlockConf(resultBlocks);
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new JoinVoucherDataTransform(this.rptParam, ctx));
        transCollector.add(new GroupMatAccountTransform(this.rptParam));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DoOrderTransfrom(this.rptParam));
        this.rptParam.closeMaterialCategory();
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        for (AbstractReportColumn col : cols) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn rptCol = (ReportColumn)col;
            String colKey = rptCol.getFieldKey();
            HashSet<String> linkFieldSet = new HashSet<String>(16);
            linkFieldSet.add("billno");
            linkFieldSet.add("billnumber");
            linkFieldSet.add("fivouchernum");
            linkFieldSet.add("carryovervouchernum");
            linkFieldSet.add("tempvouchernum");
            linkFieldSet.add("dischargevouchernum");
            linkFieldSet.add("feevouchernum");
            linkFieldSet.add("glvoucher");
            if (!linkFieldSet.contains(colKey)) continue;
            rptCol.setHyperlink(true);
        }
        TransDtlRptHelper.createHideColumns(cols);
        return cols;
    }

    private void addBlockConfByRange(Set<QFilter> filterRanges, String entityNum, SrcBlockConf blockConf, List<SrcBlockConf> resultBlocks, ReportDataCtx ctx) {
        if (!this.rptParam.getQueryObjects().contains(entityNum)) {
            return;
        }
        QFilter billQ = TransDtlRptHelper.getBaseFilter(this.rptParam, entityNum);
        if (filterRanges == null || filterRanges.isEmpty()) {
            this.addBlockConf(billQ, blockConf, resultBlocks, ctx);
            return;
        }
        for (QFilter q : filterRanges) {
            q = q.and(billQ.copy());
            this.addBlockConf(q, blockConf, resultBlocks, ctx);
        }
    }

    private void addBlockConf(QFilter q, SrcBlockConf blockConf, List<SrcBlockConf> resultBlocks, ReportDataCtx ctx) {
        SrcBlockConf srcBlockConf = new SrcBlockConf();
        srcBlockConf.setDefVals(blockConf.getDefVals());
        srcBlockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        srcBlockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        srcBlockConf.setSrcEntity(blockConf.getSrcEntity());
        srcBlockConf.setType(blockConf.getType());
        QFilter uniondataFs = srcBlockConf.getDataFs();
        if (uniondataFs != null) {
            q.and(uniondataFs);
        }
        srcBlockConf.setDataFs(q);
        List dataTransForm = srcBlockConf.getDataTransform();
        if (dataTransForm != null) {
            dataTransForm.add(new BolckDataXTransform());
        }
        srcBlockConf.setAllowNotMatch(true);
        resultBlocks.add(srcBlockConf);
    }

    private void setMoreBlockField(String entityNum, SrcBlockConf blockConf) {
        String entryIdName = "entry.id";
        String entrySeqName = "entry.seq";
        if ("cal_costadjust_subentity".equals(entityNum) || "cal_stdcostdiffbill".equals(entityNum)) {
            entryIdName = "entryentity.id";
            entrySeqName = "entryentity.seq";
        }
        Map srcColMap = blockConf.getRepoColSrcColMap();
        srcColMap.put("entryid", "entryid");
        blockConf.setRepoColSrcColMap(srcColMap);
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.put("entryid", entryIdName);
        blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        srcColMap = blockConf.getRepoColSrcColMap();
        srcColMap.put("entryseq", "entryseq");
        blockConf.setRepoColSrcColMap(srcColMap);
        repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.put("entryseq", entrySeqName);
        blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        srcColMap = blockConf.getRepoColSrcColMap();
        srcColMap.put("fid", "fid");
        blockConf.setRepoColSrcColMap(srcColMap);
        repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.put("fid", "id");
        blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        if ("cal_costadjust_subentity".equals(entityNum) || "cal_stdcostdiffbill".equals(entityNum)) {
            srcColMap = blockConf.getRepoColSrcColMap();
            srcColMap.put("bizentityobject", "bizentityobject");
            blockConf.setRepoColSrcColMap(srcColMap);
            repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.put("bizentityobject", "entryentity.invbizentityobject");
            blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
        }
    }
}

