/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.transdtlrpt.transform;

import java.math.BigDecimal;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.NullToZeroMapFunction;
import kd.fi.cal.report.newreport.transdtlrpt.TransDtlRptParam;
import kd.fi.cal.report.newreport.transdtlrpt.function.GroupMatAccountGroupFunction;

public class GroupMatAccountTransform
implements IDataXTransform {
    private TransDtlRptParam rptParam;

    public GroupMatAccountTransform(TransDtlRptParam reportParam) {
        this.rptParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (!this.rptParam.isgroupaccount()) {
            return srcData;
        }
        srcData = srcData.addFields(new Field[]{new Field("linetype", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        srcData = srcData.map((MapFunction)new NullToZeroMapFunction(srcData.getRowMeta(), new String[]{"hasvoucherbizidx", "account", "accountsumidx", "material", "mataccountsumidx", "glvoucherid", "newvoucherindex", "accountsumidx"}));
        DataSetX hasVoucherDS = srcData.filter("glvoucherid != 0l and newvoucherindex = 0");
        DataSetX otherVoucherDS = srcData.filter("glvoucherid = 0l or newvoucherindex = 1");
        hasVoucherDS = hasVoucherDS.groupBy(new String[]{"costaccount", "account"}).reduceGroup((GroupReduceFunction)new GroupMatAccountGroupFunction(hasVoucherDS.getRowMeta()));
        return hasVoucherDS.union(otherVoucherDS);
    }
}

