/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.transdtlrpt.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.estimatedtlrpt.function.NullToZeroMapFunction;
import kd.fi.cal.report.newreport.transdtlrpt.TransDtlRptHelper;
import kd.fi.cal.report.newreport.transdtlrpt.TransDtlRptParam;
import kd.fi.cal.report.newreport.transdtlrpt.function.CollectTop1GroupFunction;
import kd.fi.cal.report.newreport.transdtlrpt.function.DealRecordVoucherIndexMapFunction;
import kd.fi.cal.report.newreport.transdtlrpt.function.VoucherGroupFunction;

public class JoinVoucherDataTransform
implements IDataXTransform {
    private TransDtlRptParam rptParam;
    private ReportDataCtx ctx;
    private Set<Long> hasVoucherFidSet = new HashSet<Long>(16);
    private Set<Long> recordEntryIdSet = new HashSet<Long>(16);
    private Set<Long> adjustEntryIdSet = new HashSet<Long>(16);
    private Set<Long> diffEntryIdSet = new HashSet<Long>(16);

    public JoinVoucherDataTransform(TransDtlRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.rptParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.groupBy(new String[]{"fid", "entryid"}).reduceGroup((GroupReduceFunction)new CollectTop1GroupFunction(srcData.getRowMeta()));
        srcData = srcData.map((MapFunction)new DealRecordVoucherIndexMapFunction(srcData.getRowMeta()));
        DataSetX hasVoucherDS = srcData.filter("isvoucher = true");
        DataSetX recordHasVoucherDS = hasVoucherDS.filter("bizobject = 'cal_costrecord_subentity'");
        DataSetX adjustHasVoucherDS = hasVoucherDS.filter("bizobject = 'cal_costadjust_subentity'");
        DataSetX diffHasVoucherDS = hasVoucherDS.filter("bizobject = 'cal_stdcostdiffbill'");
        TransDtlRptHelper.cacheEntryAndFIds(this.ctx, recordHasVoucherDS, this.hasVoucherFidSet, this.recordEntryIdSet);
        TransDtlRptHelper.cacheEntryAndFIds(this.ctx, adjustHasVoucherDS, this.hasVoucherFidSet, this.adjustEntryIdSet);
        TransDtlRptHelper.cacheEntryAndFIds(this.ctx, diffHasVoucherDS, this.hasVoucherFidSet, this.diffEntryIdSet);
        DataSetX detailDataSetX = this.getDetailDateSet();
        DataSet voucherDS = TransDtlRptHelper.getBizVoucherDataSet(this.hasVoucherFidSet, this.rptParam);
        DataSetX voucherDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(voucherDS));
        voucherDataSetX = this.joinVoucherAndDtl(voucherDataSetX, detailDataSetX);
        voucherDataSetX = voucherDataSetX.groupBy(new String[]{"glvoucherid", "sourcebillentryid", "account", "glvoucher", "bookeddate", "billstatus", "isposted", "vouchercreator"}).reduceGroup((GroupReduceFunction)new VoucherGroupFunction(voucherDataSetX.getRowMeta()));
        srcData = this.joinBillAndVoucher(srcData, hasVoucherDS, voucherDataSetX);
        return srcData;
    }

    private DataSetX getDetailDateSet() {
        OrmInput recordDtlInput;
        DataSetX detailDataSetX = null;
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        if (!this.recordEntryIdSet.isEmpty()) {
            recordDtlInput = new OrmInput(this.getClass().getName(), "cal_costrecord_detail", "id as detailid,entryid", new QFilter("entryid", "in", this.recordEntryIdSet).toArray());
            billIOs.add(recordDtlInput);
        }
        if (!this.adjustEntryIdSet.isEmpty()) {
            OrmInput adjustDtlInput = new OrmInput(this.getClass().getName(), "cal_costadjust_detail", "id as detailid,entryid", new QFilter("entryid", "in", this.adjustEntryIdSet).toArray());
            billIOs.add(adjustDtlInput);
        }
        if (billIOs.isEmpty()) {
            recordDtlInput = new OrmInput(this.getClass().getName(), "cal_costrecord_detail", "id as detailid,entryid", QFilter.of((String)"1 != 1", (Object[])new Object[0]).toArray());
            billIOs.add(recordDtlInput);
        }
        detailDataSetX = this.ctx.getCurrentJob().fromInput((Input[])billIOs.toArray(new OrmInput[0]));
        return detailDataSetX;
    }

    private DataSetX joinVoucherAndDtl(DataSetX voucherDataSetX, DataSetX detailDataSetX) {
        String[] voucherFields = voucherDataSetX.getRowMeta().getFieldNames();
        voucherDataSetX = voucherDataSetX.leftJoin(detailDataSetX).on("sourcebillentryid", "entryid").select(voucherFields, new String[]{"entryid"});
        DataSetX hasEntryIdDSX = voucherDataSetX.filter("entryid != null");
        DataSetX noEntryIdDSX = voucherDataSetX.filter("entryid == null");
        hasEntryIdDSX = hasEntryIdDSX.groupBy(new String[]{"bizovucherentryid", "account", "glvoucherid", "sourcebillentryid"}).reduceGroup((GroupReduceFunction)new CollectTop1GroupFunction(hasEntryIdDSX.getRowMeta()));
        noEntryIdDSX = noEntryIdDSX.leftJoin(detailDataSetX).on("sourcebillentryid", "detailid").select(voucherFields, new String[]{"entryid"});
        voucherDataSetX = hasEntryIdDSX.union(noEntryIdDSX);
        return voucherDataSetX;
    }

    private DataSetX joinBillAndVoucher(DataSetX srcData, DataSetX hasVoucherDS, DataSetX voucherDataSetX) {
        HashSet<String> billSelectField = new HashSet<String>(16);
        billSelectField.addAll(Arrays.asList(srcData.getRowMeta().getFieldNames()));
        billSelectField.remove("description");
        billSelectField.remove("assgrp");
        billSelectField.remove("debitlocal");
        billSelectField.remove("creditlocal");
        billSelectField.remove("account");
        billSelectField.remove("vouchercreator");
        billSelectField.remove("billstatus");
        billSelectField.remove("isposted");
        billSelectField.remove("glvoucherid");
        billSelectField.remove("bookeddate");
        billSelectField.remove("glvoucher");
        billSelectField.remove("entryid");
        HashSet<String> voucherSelectField = new HashSet<String>(16);
        voucherSelectField.addAll(Arrays.asList(voucherDataSetX.getRowMeta().getFieldNames()));
        voucherSelectField.remove("fid");
        if (TransDtlRptHelper.getIsOnlyVoucher(this.rptParam)) {
            srcData = voucherDataSetX.leftJoin(hasVoucherDS).on("entryid", "entryid").select(voucherSelectField.toArray(new String[0]), billSelectField.toArray(new String[0]));
            srcData = srcData.map((MapFunction)new NullToZeroMapFunction(srcData.getRowMeta(), new String[]{"newvoucherindex"}));
        } else {
            srcData = srcData.leftJoin(voucherDataSetX).on("entryid", "entryid").select(billSelectField.toArray(new String[0]), voucherSelectField.toArray(new String[0]));
        }
        return srcData;
    }
}

