/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.print;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.cal.common.helper.PrintHelper;

public class StockDetailRptPrintNewPlugin
extends AbstractPrintPlugin {
    private static final Log log = LogFactory.getLog(StockDetailRptPrintNewPlugin.class);
    private static final String[] printHeadFieldKeys = new String[]{"id", "currentMateiralId"};
    private static final String[] printHeadFilter = new String[]{"calorg", "costaccount", "startperiod", "endperiod"};
    private static final String[] printHeadList = new String[]{"head_materialnumber", "head_materialname", "head_baseunit", "head_model", "head_group"};
    private static final String[] printListFieldKeys = new String[]{"year", "period", "isvoucher", "billno", "billtype"};
    private static final String printListPrecisionKeys = "head_precision";
    private static final String[] printListNumberFieldKeys = new String[]{"periodinqty", "periodoutqty", "periodendqty"};
    private static final String[] printListPriceFieldKeys = new String[]{"periodinprice", "periodoutprice", "periodendprice"};
    private static final String[] printListSumFieldKeys = new String[]{"periodinamount", "periodoutamount", "periodendamount"};

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
    }

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return;
            }
            ReportList list = view.getReportList();
            ReportListModel listModel = (ReportListModel)list.getReportModel();
            if (listModel == null) {
                return;
            }
            int count = listModel.getRowCount();
            DynamicObjectCollection rowDatas = listModel.getRowData(0, count);
            ArrayList<DataRowSet> reportRows = new ArrayList<DataRowSet>(16);
            HashMap<Integer, String> rowIndexsByPage = new HashMap<Integer, String>(16);
            int page = 1;
            HashSet<String> materialIds = new HashSet<String>(16);
            for (DynamicObject rowData : rowDatas) {
                String currentMaterial = rowData.getString("currentMateiralId");
                int rowNo = rowData.getInt("fseq");
                boolean contains = materialIds.add(currentMaterial);
                if (!contains) continue;
                DataRowSet head = new DataRowSet();
                head.add("id", (Field)new TextField(rowNo + ""));
                reportRows.add(head);
                if (materialIds.size() <= 1) continue;
                rowIndexsByPage.put(page, page - 1 + "-" + (rowNo - 1));
                page = rowNo;
            }
            if (rowDatas.size() > 0) {
                rowIndexsByPage.put(page, page - 1 + "-" + count);
            }
            ThreadCache.put((Object)"StockDetailRptPrintPlugin_rowInfo", rowIndexsByPage);
            e.setDataRowSets(reportRows);
        }
    }

    public void loadCustomData(CustomDataLoadEvent e) {
        super.loadCustomData(e);
        CustomDataSource dataSource = e.getDataSource();
        String pageId = dataSource.getPageId();
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return;
        }
        ReportList list = view.getReportList();
        ReportListModel model = (ReportListModel)list.getReportModel();
        if (model != null) {
            if ("printhead".equals(dataSource.getDsName())) {
                DataRowSet typeContainer = new DataRowSet();
                List field = dataSource.getQueryField();
                String[] headFilterFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])printHeadFilter);
                String[] headListFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])printHeadList);
                Map rowIndexsByPage = (Map)ThreadCache.get((Object)"StockDetailRptPrintPlugin_rowInfo");
                int index = Integer.parseInt(dataSource.getPkId().toString());
                String range = (String)rowIndexsByPage.get(index);
                String[] pageRange = range.split("-");
                int start = Integer.parseInt(pageRange[0]);
                int offset = Integer.parseInt(pageRange[1]) - start;
                DynamicObjectCollection datas = model.getRowData(start, offset);
                ReportQueryParam param = model.getReportQueryParam();
                FilterInfo filter = param.getFilter();
                PrintHelper.setFilterValueToPrint((FilterInfo)filter, (DataRowSet)typeContainer, (String[])headFilterFields);
                PrintHelper.setListValueToPrint((DynamicObject)((DynamicObject)datas.get(0)), (DataRowSet)typeContainer, (String[])headListFields);
                List customDataRows = e.getCustomDataRows();
                customDataRows.add(typeContainer);
            } else {
                Map rowDataMap = (Map)ThreadCache.get((Object)"StockDetailRptPrintPlugin_rowInfo");
                int index = Integer.parseInt(dataSource.getPkId().toString());
                String range = (String)rowDataMap.get(index);
                String[] pages = range.split("-");
                int start = Integer.parseInt(pages[0]);
                int offset = Integer.parseInt(pages[1]) - start;
                DynamicObjectCollection datas = model.getRowData(start, offset);
                List field = dataSource.getQueryField();
                String[] commonFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])printListFieldKeys);
                String[] numberFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])printListNumberFieldKeys);
                String[] priceFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])printListPriceFieldKeys);
                String[] sumFields = PrintHelper.getExistFromPrintAndCurrent((List)field, (String[])printListSumFieldKeys);
                FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
                List reportRows = e.getCustomDataRows();
                int seq = 1;
                DataRowSet printRow = null;
                for (DynamicObject rowData : datas) {
                    if (rowData != null) {
                        printRow = new DataRowSet();
                        printRow.add("seq", (Field)new TextField(String.valueOf(seq)));
                        ++seq;
                        StockDetailRptPrintNewPlugin.handleStringFields(rowData, printRow, commonFields);
                        ReportQueryParam param = model.getReportQueryParam();
                        FilterInfo filter = param.getFilter();
                        DynamicObject currency = filter.getDynamicObject("localcurrency");
                        StockDetailRptPrintNewPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.FALSE, printListPrecisionKeys, null, currency, fobj, numberFields);
                        StockDetailRptPrintNewPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "priceprecision", "sign", currency, fobj, priceFields);
                        StockDetailRptPrintNewPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "amtprecision", "sign", currency, fobj, sumFields);
                    }
                    reportRows.add(printRow);
                }
            }
        }
    }

    protected static void handleNumPriceSumFields(DynamicObject rowData, DataRowSet printRow, boolean showZero, boolean isCurrency, String currencyField, String currencySign, DynamicObject currency, FormatObject fobj, String ... fieldKeys) {
        int defaultDigital = 10;
        String defaultSign = "";
        if (isCurrency && currencyField != null && currencyField.length() != 0 && currency != null && currency.getInt(currencyField) >= 0) {
            int digital = currency.getInt(currencyField);
            String sign = currency.getString(currencySign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
            fobj.getCurrencyFormat().setCurrencySymbols(sign != null && sign.length() != 0 ? sign : defaultSign);
        } else if (!isCurrency && currencyField != null && currencyField.length() != 0 && rowData.getInt(currencyField) >= 0) {
            int digital = rowData.getInt(currencyField);
            fobj.getNumberFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
        } else {
            fobj.getNumberFormat().setMinimumFractionDigits(defaultDigital);
        }
        StockDetailRptPrintNewPlugin.handleDecimalFields(rowData, printRow, fobj, showZero, isCurrency, fieldKeys);
    }

    protected static void handleDecimalFields(DynamicObject rowData, DataRowSet printRow, FormatObject fobj, boolean showZero, boolean isCurrency, String ... fieldKeys) {
        List propertySet = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        if (!propertySet.isEmpty()) {
            Format format = isCurrency ? FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj) : FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            Iterator iterator = propertySet.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                String fieldKey = (String)iterator.next();
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.add(fieldKey, (Field)new TextField(format.format(b)));
            }
        }
    }

    protected static void handleStringFields(DynamicObject rowData, DataRowSet printRow, String ... fieldKeys) {
        List existProperty = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        for (String fieldKey : existProperty) {
            if (StockDetailRptPrintNewPlugin.isEqualSpecial(fieldKey, "period")) {
                printRow.add(fieldKey, (Field)(rowData.getInt(fieldKey) > 0 ? new TextField(String.valueOf(rowData.getInt(fieldKey))) : new TextField("")));
                continue;
            }
            if (StockDetailRptPrintNewPlugin.isEqualSpecial(fieldKey, "isvoucher")) {
                printRow.add(fieldKey, (Field)(rowData.getBoolean(fieldKey) ? new TextField(ResManager.loadKDString((String)"\u662f", (String)"StockDetailRptPrintPlugin_0", (String)"fi-cal-report", (Object[])new Object[0])) : new TextField("")));
                continue;
            }
            printRow.add(fieldKey, (Field)new TextField(rowData.getString(fieldKey)));
        }
    }

    private static boolean isEqualSpecial(String fieldKey, String target) {
        return fieldKey != null && fieldKey.length() != 0 && target.equals(fieldKey);
    }
}

