/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.print;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.cal.common.helper.PrintHelper;

public class StockDetailRptPrintPlugin
extends AbstractPrintServicePlugin {
    private static final Log log = LogFactory.getLog(StockDetailRptPrintPlugin.class);
    private static final String[] printHeadFieldKeys = new String[]{"id", "currentMateiralId"};
    private static final String[] printHeadFilter = new String[]{"calorg", "costaccount", "startperiod", "endperiod"};
    private static final String[] printHeadList = new String[]{"head_materialnumber", "head_materialname", "head_baseunit", "head_model", "head_group"};
    private static final String[] printListFieldKeys = new String[]{"year", "period", "isvoucher", "billno", "billtype"};
    private static final String printListPrecisionKeys = "head_precision";
    private static final String[] printListNumberFieldKeys = new String[]{"periodinqty", "periodoutqty", "periodendqty"};
    private static final String[] printListPriceFieldKeys = new String[]{"periodinprice", "periodoutprice", "periodendprice"};
    private static final String[] printListSumFieldKeys = new String[]{"periodinamount", "periodoutamount", "periodendamount"};

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        ReportView view;
        ReportListModel reportModel = (ReportListModel)ThreadCache.get((Object)"stockDetailRptPrinter");
        if (reportModel == null && (view = (ReportView)SessionManager.getCurrent().getView(e.getPageId())) != null) {
            ReportList list = view.getReportList();
            reportModel = (ReportListModel)list.getReportModel();
        }
        if (reportModel == null) {
            return;
        }
        ArrayList<DynamicObject> reportRows = new ArrayList<DynamicObject>(16);
        int count = reportModel.getRowCount();
        ReportQueryParam reportQueryParam = reportModel.getReportQueryParam();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Map<Integer, String> rowIndexsByPage = new HashMap<Integer, String>(16);
        try {
            if (!e.isMainDs()) {
                if ("printhead".equals(e.getDataSourceName())) {
                    DynamicObjectType typeContainer = new DynamicObjectType();
                    String[] headFilterFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])printHeadFilter);
                    String[] headListFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])printHeadList);
                    PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[][])new String[][]{headFilterFields, headListFields});
                    rowIndexsByPage = (Map)ThreadCache.get((Object)"StockDetailRptPrintPlugin_rowInfo");
                    int index = Integer.parseInt(e.getFilter().getValue().toString());
                    String range = (String)rowIndexsByPage.get(index);
                    String[] pageRange = range.split("-");
                    int start = Integer.parseInt(pageRange[0]);
                    int offset = Integer.parseInt(pageRange[1]) - start;
                    DynamicObjectCollection datas = reportModel.getRowData(start, offset);
                    DynamicObject reportRow = new DynamicObject(typeContainer);
                    PrintHelper.setFilterValueToPrint((FilterInfo)filterInfo, (DynamicObject)reportRow, (String[])headFilterFields);
                    PrintHelper.setListValueToPrint((DynamicObject)((DynamicObject)datas.get(0)), (DynamicObject)reportRow, (String[])headListFields);
                    reportRows.add(reportRow);
                    e.setDataEntities(reportRows);
                } else {
                    Map rowDataMap = (Map)ThreadCache.get((Object)"StockDetailRptPrintPlugin_rowInfo");
                    int index = Integer.parseInt(e.getFilter().getValue().toString());
                    String range = (String)rowDataMap.get(index);
                    String[] pages = range.split("-");
                    int start = Integer.parseInt(pages[0]);
                    int offset = Integer.parseInt(pages[1]) - start;
                    DynamicObjectCollection datas = reportModel.getRowData(start, offset);
                    DynamicObjectType typeContainer = new DynamicObjectType();
                    String[] commonFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])printListFieldKeys);
                    String[] numberFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])printListNumberFieldKeys);
                    String[] priceFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])printListPriceFieldKeys);
                    String[] sumFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])printListSumFieldKeys);
                    PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[][])new String[][]{commonFields, numberFields, priceFields, sumFields});
                    PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[])new String[]{"seq"});
                    FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
                    int seq = 1;
                    DynamicObject printRow = null;
                    for (DynamicObject rowData : datas) {
                        if (rowData != null) {
                            printRow = new DynamicObject(typeContainer);
                            printRow.set("seq", (Object)seq++);
                            StockDetailRptPrintPlugin.handleStringFields(rowData, printRow, commonFields);
                            DynamicObject currency = filterInfo.getDynamicObject("localcurrency");
                            StockDetailRptPrintPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.FALSE, printListPrecisionKeys, null, currency, fobj, numberFields);
                            StockDetailRptPrintPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "priceprecision", "sign", currency, fobj, priceFields);
                            StockDetailRptPrintPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "amtprecision", "sign", currency, fobj, sumFields);
                        }
                        reportRows.add(printRow);
                    }
                    e.setDataEntities(reportRows);
                }
            } else {
                DynamicObjectType typeContainer = new DynamicObjectType();
                PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[])printHeadFieldKeys);
                DynamicObjectCollection rowDatas = reportModel.getRowData(0, count);
                int page = 1;
                HashSet<String> materialIds = new HashSet<String>(16);
                for (DynamicObject rowData : rowDatas) {
                    String currentMaterial = rowData.getString("currentMateiralId");
                    int rowNo = rowData.getInt("fseq");
                    boolean contains = materialIds.add(currentMaterial);
                    if (!contains) continue;
                    DynamicObject head = new DynamicObject(typeContainer);
                    head.set("id", (Object)rowNo);
                    reportRows.add(head);
                    if (materialIds.size() <= 1) continue;
                    rowIndexsByPage.put(page, page - 1 + "-" + (rowNo - 1));
                    page = rowNo;
                }
                if (rowDatas.size() > 0) {
                    rowIndexsByPage.put(page, page - 1 + "-" + count);
                }
                ThreadCache.put((Object)"StockDetailRptPrintPlugin_rowInfo", rowIndexsByPage);
                e.setDataEntities(reportRows);
            }
        }
        catch (Exception e1) {
            log.error("StockDetailRptPrintPlugin customPrintDataEntities", (Throwable)e1);
        }
    }

    protected static void handleNumPriceSumFields(DynamicObject rowData, DynamicObject printRow, boolean showZero, boolean isCurrency, String currencyField, String currencySign, DynamicObject currency, FormatObject fobj, String ... fieldKeys) {
        int defaultDigital = 10;
        String defaultSign = "";
        if (isCurrency && currencyField != null && currencyField.length() != 0 && currency != null && currency.getInt(currencyField) >= 0) {
            int digital = currency.getInt(currencyField);
            String sign = currency.getString(currencySign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
            fobj.getCurrencyFormat().setCurrencySymbols(sign != null && sign.length() != 0 ? sign : defaultSign);
        } else if (!isCurrency && currencyField != null && currencyField.length() != 0 && rowData.getInt(currencyField) >= 0) {
            int digital = rowData.getInt(currencyField);
            fobj.getNumberFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
        } else {
            fobj.getNumberFormat().setMinimumFractionDigits(defaultDigital);
        }
        StockDetailRptPrintPlugin.handleDecimalFields(rowData, printRow, fobj, showZero, isCurrency, fieldKeys);
    }

    protected static void handleDecimalFields(DynamicObject rowData, DynamicObject printRow, FormatObject fobj, boolean showZero, boolean isCurrency, String ... fieldKeys) {
        List propertySet = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        if (!propertySet.isEmpty()) {
            Format format = isCurrency ? FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj) : FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            Iterator iterator = propertySet.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                String fieldKey = (String)iterator.next();
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.set(fieldKey, (Object)format.format(b));
            }
        }
    }

    protected static void handleStringFields(DynamicObject rowData, DynamicObject printRow, String ... fieldKeys) {
        List existProperty = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        for (String fieldKey : existProperty) {
            if (StockDetailRptPrintPlugin.isEqualSpecial(fieldKey, "period")) {
                printRow.set(fieldKey, rowData.getInt(fieldKey) > 0 ? Integer.valueOf(rowData.getInt(fieldKey)) : "");
                continue;
            }
            if (StockDetailRptPrintPlugin.isEqualSpecial(fieldKey, "isvoucher")) {
                printRow.set(fieldKey, (Object)(rowData.getBoolean(fieldKey) ? ResManager.loadKDString((String)"\u662f", (String)"StockDetailRptPrintPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]) : ""));
                continue;
            }
            printRow.set(fieldKey, (Object)rowData.getString(fieldKey));
        }
    }

    private static boolean isEqualSpecial(String fieldKey, String target) {
        return fieldKey != null && fieldKey.length() != 0 && target.equals(fieldKey);
    }
}

