/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.print;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.cal.common.helper.PrintHelper;

public class StockEstimateGroupRptPrintPlugin
extends AbstractPrintServicePlugin {
    private static final Log log = LogFactory.getLog(StockEstimateGroupRptPrintPlugin.class);
    private static final String[] PRINT_HEAD = new String[]{"id"};
    private static final String[] PRINT_FILTER_FIELD = new String[]{"calorg"};
    private static final String[] PRINT_LIST_FIELD = new String[]{"period"};
    private static final String[] PRINT_LIST_HEAD = new String[]{"materialname", "materialnumber"};
    private static final String[] PRINT_LIST_QTY = new String[]{"beforeperiodqty", "periodinqty", "periodwriteoffqty", "periodendqty"};
    private static final String[] PRINT_LIST_PRICE = new String[]{"beforeperiodprice", "periodinprice", "periodwriteoffprice", "periodendprice"};
    private static final String[] PRINT_LIST_SUM = new String[]{"beforeperiodamount", "periodinamount", "periodwriteoffamount", "periodendamount"};

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        ReportView view;
        ReportListModel reportModel = (ReportListModel)ThreadCache.get((Object)"stockEstimateGroupRptPrinter");
        if (reportModel == null && (view = (ReportView)SessionManager.getCurrent().getView(e.getPageId())) != null) {
            ReportList list = view.getReportList();
            reportModel = (ReportListModel)list.getReportModel();
        }
        if (reportModel == null) {
            return;
        }
        ArrayList<DynamicObject> reportRows = new ArrayList<DynamicObject>(16);
        int count = reportModel.getRowCount();
        ReportQueryParam reportQueryParam = reportModel.getReportQueryParam();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        try {
            if (!e.isMainDs()) {
                if ("printHead".equals(e.getDataSourceName())) {
                    DynamicObjectType typeContainer = new DynamicObjectType();
                    String[] headListFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])PRINT_LIST_FIELD);
                    String[] headFilterFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])PRINT_FILTER_FIELD);
                    PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[])headListFields);
                    PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[])headFilterFields);
                    DynamicObjectCollection datas = reportModel.getRowData(0, count);
                    DynamicObject reportRow = new DynamicObject(typeContainer);
                    PrintHelper.setFilterValueToPrint((FilterInfo)filterInfo, (DynamicObject)reportRow, (String[])PRINT_FILTER_FIELD);
                    PrintHelper.setListValueToPrint((DynamicObject)((DynamicObject)datas.get(0)), (DynamicObject)reportRow, (String[])headListFields);
                    reportRows.add(reportRow);
                    e.setDataEntities(reportRows);
                } else {
                    DynamicObjectCollection datas = reportModel.getRowData(0, count);
                    DynamicObjectType typeContainer = new DynamicObjectType();
                    String[] listHeadFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])PRINT_LIST_HEAD);
                    String[] listFilterFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])PRINT_FILTER_FIELD);
                    String[] qtyFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])PRINT_LIST_QTY);
                    String[] priceFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])PRINT_LIST_PRICE);
                    String[] sumFields = PrintHelper.getExistFromPrintAndCurrent((CustomPrintDataEntitiesArgs)e, (String[])PRINT_LIST_SUM);
                    PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[][])new String[][]{listFilterFields, listHeadFields, qtyFields, priceFields, sumFields});
                    PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[])new String[]{"seq"});
                    FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
                    int seq = 1;
                    DynamicObject printRow = null;
                    for (DynamicObject rowData : datas) {
                        if (rowData != null) {
                            printRow = new DynamicObject(typeContainer);
                            printRow.set("seq", (Object)seq++);
                            StockEstimateGroupRptPrintPlugin.handleStringFields(rowData, printRow, listHeadFields);
                            DynamicObject currency = filterInfo.getDynamicObject("localcurrency");
                            StockEstimateGroupRptPrintPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.FALSE, "qtyprecision", null, currency, fobj, qtyFields);
                            StockEstimateGroupRptPrintPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "priceprecision", "sign", currency, fobj, priceFields);
                            StockEstimateGroupRptPrintPlugin.handleNumPriceSumFields(rowData, printRow, Boolean.FALSE, Boolean.TRUE, "amtprecision", "sign", currency, fobj, sumFields);
                        }
                        reportRows.add(printRow);
                    }
                    e.setDataEntities(reportRows);
                }
            } else {
                DynamicObjectType typeContainer = new DynamicObjectType();
                PrintHelper.registerStringProperty((DynamicObjectType)typeContainer, (String[])PRINT_HEAD);
                DynamicObject head = new DynamicObject(typeContainer);
                reportRows.add(head);
                e.setDataEntities(reportRows);
            }
        }
        catch (Exception e1) {
            log.error("StockEstimateGroupRptPrintPlugin customPrintDataEntities", (Throwable)e1);
        }
    }

    protected static void handleNumPriceSumFields(DynamicObject rowData, DynamicObject printRow, boolean showZero, boolean isCurrency, String currencyField, String currencySign, DynamicObject currency, FormatObject fobj, String ... fieldKeys) {
        int defaultDigital = 10;
        String defaultSign = "";
        if (isCurrency && currencyField != null && currencyField.length() != 0 && currency != null && currency.getInt(currencyField) >= 0) {
            int digital = currency.getInt(currencyField);
            String sign = currency.getString(currencySign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
            fobj.getCurrencyFormat().setCurrencySymbols(sign != null && sign.length() != 0 ? sign : defaultSign);
        } else if (!isCurrency && currencyField != null && currencyField.length() != 0 && rowData.getInt(currencyField) >= 0) {
            int digital = rowData.getInt(currencyField);
            fobj.getNumberFormat().setMinimumFractionDigits(digital >= 0 ? digital : defaultDigital);
        } else {
            fobj.getNumberFormat().setMinimumFractionDigits(defaultDigital);
        }
        StockEstimateGroupRptPrintPlugin.handleDecimalFields(rowData, printRow, fobj, showZero, isCurrency, fieldKeys);
    }

    protected static void handleDecimalFields(DynamicObject rowData, DynamicObject printRow, FormatObject fobj, boolean showZero, boolean isCurrency, String ... fieldKeys) {
        List propertySet = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        if (!propertySet.isEmpty()) {
            Format format = isCurrency ? FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj) : FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            Iterator iterator = propertySet.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                String fieldKey = (String)iterator.next();
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.set(fieldKey, (Object)format.format(b));
            }
        }
    }

    protected static void handleStringFields(DynamicObject rowData, DynamicObject printRow, String ... fieldKeys) {
        List existProperty = PrintHelper.existProperty((DynamicObject)rowData, (String[])fieldKeys);
        for (String fieldKey : existProperty) {
            if (StockEstimateGroupRptPrintPlugin.isEqualSpecial(fieldKey, "period")) {
                printRow.set(fieldKey, rowData.getInt(fieldKey) > 0 ? Integer.valueOf(rowData.getInt(fieldKey)) : "");
                continue;
            }
            printRow.set(fieldKey, (Object)rowData.getString(fieldKey));
        }
    }

    private static boolean isEqualSpecial(String fieldKey, String target) {
        return fieldKey != null && fieldKey.length() != 0 && target.equals(fieldKey);
    }
}

