/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBufferPoolManager;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.DateUtils;

public class CalInTimeBufferPoolRptQueryPlugin
extends AbstractReportListDataPlugin {
    private int top;
    private Set<String> billNos;
    private List<Long> matFromIds;
    private Date endDate;
    private Date startDate;
    private long billid;
    private long entryId;
    private boolean isShowErrorMat = true;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        this.init(reportQueryParam);
        DataSet bufferDs = this.getBufferDs();
        CalInTimeBufferPoolManager manager = new CalInTimeBufferPoolManager();
        Map entityIdEidsMap = manager.getEntityIdEidsMap(bufferDs.copy());
        DataSet billDs = manager.getBillDs(entityIdEidsMap);
        bufferDs = this.bufferJoinPoolDs(bufferDs, billDs);
        Map<Long, Long> recordEidBillIdOrWfRecordIdMap = this.getRecordEidBillIdOrWfRecordId(entityIdEidsMap);
        bufferDs = this.bufferJoinLogDS(bufferDs, recordEidBillIdOrWfRecordIdMap);
        return bufferDs;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List oldColumns = super.getColumns(columns);
        ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>(16);
        for (AbstractReportColumn abstractReportColumn : oldColumns) {
            ReportColumn column = (ReportColumn)abstractReportColumn;
            String columnName = column.createColumn().get("dataIndex").toString();
            if ("times".equals(columnName) || "caltime".equals(columnName)) {
                column.setHide(!this.isShowErrorMat);
            }
            newColumns.add((AbstractReportColumn)column);
        }
        return newColumns;
    }

    private DataSet getBufferDs() {
        String calBufferPoolEntity = "cal_bufferpool";
        Set fields = EntityMetadataCache.getDataEntityType((String)calBufferPoolEntity).getAllFields().keySet();
        String sels = String.join((CharSequence)",", fields);
        QFilter matIdsFilter = null;
        if (this.matFromIds != null) {
            matIdsFilter = new QFilter("material", "in", this.matFromIds);
        }
        Set<Long> billIds = this.getBillIds();
        QFilter billIdsFilter = null;
        if (billIds != null) {
            billIdsFilter = new QFilter("billid", "in", billIds);
        }
        QFilter startDateFilter = null;
        if (this.startDate != null) {
            startDateFilter = new QFilter("bookdate", ">=", (Object)this.startDate);
        }
        QFilter endDateFilter = null;
        if (this.endDate != null) {
            endDateFilter = new QFilter("bookdate", "<=", (Object)this.endDate);
        }
        QFilter billIdFilter = null;
        if (this.billid != 0L) {
            billIdFilter = new QFilter("billid", "=", (Object)this.billid);
        }
        QFilter entryIdFilter = null;
        if (this.entryId != 0L) {
            entryIdFilter = new QFilter("entryid", "=", (Object)this.entryId);
        }
        DataSet bufferDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)calBufferPoolEntity, (String)sels, (QFilter[])new QFilter[]{matIdsFilter, billIdsFilter, startDateFilter, endDateFilter, billIdFilter, entryIdFilter}, (String)"bookdate desc,actiontime desc", (int)this.top);
        return bufferDs;
    }

    private Set<Long> getBillIds() {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (this.billNos == null) {
            return null;
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        String selFields = "id,billno";
        QFilter billNoFilter = new QFilter("billno", "in", this.billNos);
        OrmInput recordOI = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", selFields, new QFilter[]{billNoFilter});
        inputs.add(recordOI);
        OrmInput adjustOI = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costadjustbill", selFields, new QFilter[]{billNoFilter});
        inputs.add(adjustOI);
        OrmInput initOI = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_initbill", selFields, new QFilter[]{billNoFilter});
        inputs.add(initOI);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet allBillDs = algo.createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
        for (Row row : allBillDs) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private void init(ReportQueryParam reportQueryParam) {
        FilterInfo filter = reportQueryParam.getFilter();
        this.top = filter.getInt("topcount");
        String billNoStr = filter.getString("billnos");
        if (StringUtils.isNotEmpty((String)billNoStr)) {
            this.billNos = new HashSet<String>(16);
            this.billNos.addAll(Arrays.asList(billNoStr.split("\\s+|[\\r\\n]+")));
        }
        DynamicObjectCollection mulMatDycs = filter.getDynamicObjectCollection("mulmaterial");
        this.matFromIds = null;
        if (mulMatDycs != null && mulMatDycs.size() > 0) {
            this.matFromIds = new ArrayList<Long>(16);
            for (DynamicObject matDyc : mulMatDycs) {
                this.matFromIds.add((Long)matDyc.getPkValue());
            }
        }
        this.startDate = filter.getDate("startdate");
        this.endDate = filter.getDate("enddate");
        if (this.endDate != null) {
            this.endDate = DateUtils.getDayEndTime((Date)this.endDate);
        }
        this.billid = filter.getLong("billid");
        this.entryId = filter.getLong("entryid");
        this.isShowErrorMat = filter.getBoolean("showerrormat");
    }

    private DataSet bufferJoinLogDS(DataSet bufferDs, Map<Long, Long> recordEidBillIdOrWfRecordIdMap) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        bizBillIds.addAll(recordEidBillIdOrWfRecordIdMap.values());
        QFilter bizBillIdsF = new QFilter("bizbillid", "in", bizBillIds);
        String logSels = "id,entry.costrecordeid eid,bizbillid,entry.errorinfo as errorinfo,entry.errorinfo_tag as errorinfo_tag";
        DataSet businessLogDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_businesslog", (String)logSels, (QFilter[])new QFilter[]{bizBillIdsF}, null);
        bufferDs = bufferDs.leftJoin(businessLogDs).on("entryid", "eid").select(bufferDs.getRowMeta().getFieldNames(), new String[]{"errorinfo", "errorinfo_tag"}).finish().orderBy(new String[]{"bookdate desc", "actiontime desc"});
        if (this.isShowErrorMat) {
            String selectFields = "material,times,caltime";
            DataSet errorMatIdDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_failcostdomain", (String)selectFields, null, null).groupBy(new String[]{"material"}).max("times").max("caltime").finish();
            Object[] fieldNames = bufferDs.getRowMeta().getFieldNames();
            Object[] newFields = (String[])kd.bos.dataentity.utils.ArrayUtils.removeElement((Object[])fieldNames, (Object)"errorinfo_tag");
            newFields = (String[])ArrayUtils.concatAll((Object[])newFields, (Object[][])new String[][]{{"case when actionname = 'UNAUDIT' then '' else errorinfo_tag end as errorinfo_tag"}});
            bufferDs = bufferDs.leftJoin(errorMatIdDs).on("material", "material").select((String[])newFields, new String[]{"times", "caltime"}).finish();
        }
        return bufferDs;
    }

    private DataSet bufferJoinPoolDs(DataSet bufferDs, DataSet billDs) {
        if (billDs != null) {
            String[] poolFields = bufferDs.getRowMeta().getFieldNames();
            String[] billFields = billDs.getRowMeta().getFieldNames();
            HashSet<String> billFieldSet = new HashSet<String>(Arrays.asList(billFields));
            billFieldSet.removeAll(Arrays.asList(poolFields));
            bufferDs = bufferDs.leftJoin(billDs).on("billid", "billid").on("entryid", "entryid").on("entity", "entity").select(poolFields, billFieldSet.toArray(new String[0])).finish();
        }
        return bufferDs;
    }

    private Map<Long, Long> getRecordEidBillIdOrWfRecordId(Map<String, Map<Long, Set<Long>>> posEntityIdEidsMap) {
        HashMap<Long, Long> recordEidBillIdOrWfRecordIdMap = new HashMap<Long, Long>(16);
        Map<Long, Set<Long>> idEidsMap = posEntityIdEidsMap.get("cal_costrecord");
        if (idEidsMap == null) {
            idEidsMap = posEntityIdEidsMap.get("cal_costrecord_subentity");
        }
        if (idEidsMap == null || idEidsMap.isEmpty()) {
            return recordEidBillIdOrWfRecordIdMap;
        }
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Set<Long> eIds : idEidsMap.values()) {
            entryIds.addAll(eIds);
        }
        QFilter idF = new QFilter("id", "in", idEidsMap.keySet());
        QFilter entryIdF = new QFilter("entry.id", "in", entryIds);
        String selectFields = "bizbillid,entry.bizbillentryid as bizbillentryid,entry.id as entryid,bizentityobject as entity";
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])new QFilter[]{idF, entryIdF}, null);
        for (Row row : costRecordDs) {
            Long eId = row.getLong("entryid");
            Long bizBillId = row.getLong("bizbillid");
            recordEidBillIdOrWfRecordIdMap.put(eId, bizBillId);
        }
        return recordEidBillIdOrWfRecordIdMap;
    }
}

