/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class CalOutRptDtlRptQueryPlugin
extends AbstractReportListDataPlugin {
    private boolean onlyShowSubSum = false;
    private static final String[] showSubSumOrder = new String[]{"caltime desc", "rptid", "matrixtype", "bookdate", "auditdate", "billno", "entryid", "sumtype desc", "costsubelement"};
    private static final String[] noShowSumOrder = new String[]{"caltime desc", "rptid", "matrixtype", "costsubelement", "bookdate", "auditdate", "billno", "entryid", "sumtype desc"};
    private DynamicObject filterSerDyc;
    private QFilter comFilter;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        this.init(reportQueryParam);
        DataSet dataSet = this.getDataSet();
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        HashSet<String> hidColumns = new HashSet<String>();
        hidColumns.add("entity");
        List comFilterfieldItem = ((ComboProp)EntityMetadataCache.getDataEntityType((String)"cal_caloutrpt_dtl_rpt").findProperty("comfilterfield")).getComboItems();
        HashSet<String> comFilterFields = new HashSet<String>(16);
        for (ValueMapItem comfilterfield : comFilterfieldItem) {
            String filterField = comfilterfield.getValue();
            comFilterFields.add(filterField);
        }
        if (this.onlyShowSubSum) {
            hidColumns.add("costsubelement");
        }
        for (AbstractReportColumn col : cols) {
            String refBasedataProp;
            boolean refBaseNotShow;
            boolean isShow;
            ReportColumn rptCol = (ReportColumn)col;
            boolean bl = isShow = rptCol.getFieldKey().equals("sumtype") || comFilterFields.contains(rptCol.getFieldKey());
            if (!isShow || hidColumns.contains(rptCol.getFieldKey())) {
                rptCol.setHide(true);
            }
            if (!(refBaseNotShow = (refBasedataProp = rptCol.getRefBasedataProp()) != null && comFilterFields.contains(refBasedataProp))) continue;
            rptCol.setHide(false);
        }
        return cols;
    }

    private void init(ReportQueryParam reportQueryParam) {
        String filterSerDycStr = (String)reportQueryParam.getCustomParam().get("filterSerDycStr");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_caloutrpt_dtl_rpt");
        Object[] desDycObjs = DynamicObjectSerializeUtil.deserialize((String)filterSerDycStr, (DynamicObjectType)entityType);
        this.filterSerDyc = (DynamicObject)desDycObjs[0];
        String comFilterStr = (String)reportQueryParam.getCustomParam().get("comFilter");
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)comFilterStr, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"cal_caloutrpt_dtl"), filterCondition);
        filterBuilder.buildFilter();
        this.comFilter = filterBuilder.getQFilter();
        this.onlyShowSubSum = this.filterSerDyc.getBoolean("onlyshowsubsum");
    }

    private DataSet getDataSet() {
        List<QFilter> filters = this.getFilters();
        String entity = "cal_caloutrpt_dtl";
        HashSet<String> fields = new HashSet<String>(EntityMetadataCache.getDataEntityType((String)entity).getAllFields().keySet());
        fields.add("'0' as sumtype");
        String sels = String.join((CharSequence)",", fields);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)sels, (QFilter[])filters.toArray(new QFilter[0]), null);
        dataSet.getRowMeta().getField("sumtype").setDataType((DataType)DataType.StringType);
        boolean showSubSum = this.filterSerDyc.getBoolean("showsubsum");
        boolean onlyShowSubSum = this.filterSerDyc.getBoolean("onlyshowsubsum");
        if (showSubSum) {
            DataSet billSubSumDs = this.getSubSumDs(fields, dataSet);
            DataSet matrixTypeSumDs = this.getMatrixTypeSumDs(fields, billSubSumDs);
            dataSet = onlyShowSubSum ? billSubSumDs.union(matrixTypeSumDs) : dataSet.union(new DataSet[]{billSubSumDs, matrixTypeSumDs});
        } else {
            DataSet matrixTypeSumDs = this.getMatrixTypeSumDs(fields, dataSet);
            dataSet = dataSet.union(matrixTypeSumDs);
        }
        String[] orderFields = showSubSumOrder;
        if (!showSubSum) {
            orderFields = noShowSumOrder;
        }
        dataSet = dataSet.orderBy(orderFields);
        return dataSet;
    }

    private DataSet getSubSumDs(Set<String> fields, DataSet dataSet) {
        String[] srcFieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> newFields = new ArrayList<String>(16);
        String[] stringArray = srcFieldNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String srcFieldName;
            String curFieldName = srcFieldName = stringArray[i];
            if (srcFieldName.equals("sumtype")) {
                curFieldName = "'1'";
            } else if (curFieldName.equals("costsubelement")) {
                curFieldName = " 0L ";
            } else if (curFieldName.equals("remark")) {
                curFieldName = "''";
            }
            curFieldName = curFieldName + " as " + srcFieldName;
            newFields.add(curFieldName);
        }
        HashSet<String> subSumGroupFields = new HashSet<String>(fields);
        subSumGroupFields.remove("sumtype");
        subSumGroupFields.remove("costsubelement");
        subSumGroupFields.remove("remark");
        Set<String> qtyFields = this.getQtyFields();
        subSumGroupFields.removeAll(qtyFields);
        DataSet billEntrySumDs = dataSet.groupBy(subSumGroupFields.toArray(new String[0])).max("inqty").sum("incost").max("outqty").sum("outcost").sum("inunitcost").sum("outunitcost").finish().select(newFields.toArray(new String[0]));
        return billEntrySumDs;
    }

    private DataSet getMatrixTypeSumDs(Set<String> fields, DataSet dataSet) {
        HashSet<String> typeGroupFields = new HashSet<String>(fields);
        typeGroupFields.remove("sumtype");
        HashSet<String> wrapFields = new HashSet<String>(Arrays.asList("entryid", "entity", "billno", "costpricesource", "remark", "bookdate", "auditdate", "billtypename"));
        Set<String> qtyFields = this.getQtyFields();
        typeGroupFields.removeAll(wrapFields);
        typeGroupFields.removeAll(qtyFields);
        String[] srcFieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> newFields = new ArrayList<String>(16);
        String[] stringArray = srcFieldNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String srcFieldName;
            String curFieldName = srcFieldName = stringArray[i];
            if (srcFieldName.equals("sumtype")) {
                curFieldName = "'2'";
            } else if (curFieldName.equals("inunitcost")) {
                curFieldName = "case when inqty <> 0 then Round(incost/inqty,10) else 0 end ";
            } else if (curFieldName.equals("outunitcost")) {
                curFieldName = "case when outqty <> 0 then Round(outcost/outqty,10) else 0 end  ";
            } else if (wrapFields.contains(curFieldName)) {
                curFieldName = this.getDeFaultValueStr(dataSet.getRowMeta(), curFieldName);
            } else if (curFieldName.equals("billtypename")) {
                curFieldName = " '' ";
            }
            curFieldName = curFieldName + " as " + srcFieldName;
            newFields.add(curFieldName);
        }
        DataSet matrixTypeSumDs = dataSet.groupBy(typeGroupFields.toArray(new String[0])).sum("inqty").sum("incost").sum("outqty").sum("outcost").finish().select(newFields.toArray(new String[0]));
        return matrixTypeSumDs;
    }

    private Set<String> getQtyFields() {
        return new HashSet<String>(Arrays.asList("inunitcost", "inqty", "incost", "outunitcost", "outqty", "outcost"));
    }

    private List<QFilter> getFilters() {
        long rptId;
        QFilter periodIdFilter;
        Date startTimeFilter = this.filterSerDyc.getDate("starttimefilter");
        Date endtimefilterilter = this.filterSerDyc.getDate("endtimefilter");
        DynamicObjectCollection costAcctDycs = this.filterSerDyc.getDynamicObjectCollection("mulcostaccountfilter");
        DynamicObject startPeriodDyc = this.filterSerDyc.getDynamicObject("startperiodfilter");
        DynamicObject endPeriodDyc = this.filterSerDyc.getDynamicObject("endperiodfilter");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        QFilter timeFilter = new QFilter("caltime", ">=", (Object)startTimeFilter);
        timeFilter.and("caltime", "<=", (Object)endtimefilterilter);
        filters.add(timeFilter);
        if (costAcctDycs != null) {
            HashSet<Long> acctIds = new HashSet<Long>(16);
            for (DynamicObject costAcctDyc : costAcctDycs) {
                DynamicObject curDyc = costAcctDyc.getDynamicObject("fbasedataid");
                if (curDyc == null) continue;
                acctIds.add(curDyc.getLong("id"));
            }
            QFilter acctFilter = new QFilter("costaccount", "in", acctIds);
            filters.add(acctFilter);
        }
        if (startPeriodDyc != null) {
            periodIdFilter = new QFilter("periodid", ">=", startPeriodDyc.getPkValue());
            filters.add(periodIdFilter);
        }
        if (endPeriodDyc != null) {
            periodIdFilter = new QFilter("periodid", "<=", endPeriodDyc.getPkValue());
            filters.add(periodIdFilter);
        }
        if ((rptId = this.filterSerDyc.getLong("rptidfilter")) != 0L) {
            QFilter rptIdFilter = new QFilter("rptid", "in", (Object)rptId);
            filters.add(rptIdFilter);
        }
        if (this.comFilter != null) {
            filters.add(this.comFilter);
        }
        return filters;
    }

    private String getDeFaultValueStr(RowMeta resultRowMeta, String field) {
        DataType dataType = resultRowMeta.getField(field).getDataType();
        String defaultValue = null;
        if (dataType instanceof LongType) {
            defaultValue = "0L";
        } else if (dataType instanceof StringType) {
            defaultValue = "''";
        } else if (dataType instanceof IntegerType) {
            defaultValue = "0";
        } else if (dataType instanceof BigDecimalType) {
            defaultValue = "0";
        } else if (dataType instanceof BooleanType) {
            defaultValue = "'1'";
        }
        return defaultValue;
    }
}

