/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.formula.StandGroupBaseDataConverter;
import kd.fi.cal.common.helper.MaterialCategoryHelper;

public class FallPriceProvRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(FallPriceProvRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private boolean filter_groupSum;
    private DynamicObject filter_currency;
    private QFilter baseQfilter = null;
    private String s1 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockEstimateDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    private MaterialCategoryHelper materialCategoryHelper = null;
    private DynamicObjectCollection filter_mulMaterialCategory;
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_MaterialCategoryNum = new LocaleString(this.getLocale_MaterialCategoryNum());
    private LocaleString locale_MaterialCategoryName = new LocaleString(this.getLocale_MaterialCategoryName());

    private String getLocale_MaterialCategoryNum() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_55", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_MaterialCategoryName() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_56", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            DataSet periodBeginBalanceDataSet = this.getPeriodBeginBalanceDataSet();
            DataSet periodReplenishDataSet = this.getPeriodReplenishDataSet();
            DataSet periodRushDataSet = this.getPeriodRushDataSet();
            DataSet dataSet = this.unionAllDataSet(periodBeginBalanceDataSet, periodReplenishDataSet, periodRushDataSet);
            dataSet = this.calMaterailCategoryDataSet(dataSet);
            dataSet = this.processGroupDataSet(dataSet);
            return dataSet.orderBy(new String[]{"year", "period", "ordercol"});
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("FallPriceProvRpt=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                    sBuilder.append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private DataSet calMaterailCategoryDataSet(DataSet dataSet) {
        if (this.filter_groupSum) {
            DataSet[] dataSets = new DataSet[]{dataSet};
            dataSet = dataSets[0].leftJoin(this.materialCategoryHelper.getMaterialCategoryDataSet(true)).on("materialid", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialcategory"}).finish();
        } else {
            DataSet[] dataSets = dataSet.splitByFilter(new String[]{"owner = null or owner = 0", "owner <> null and owner <> 0"}, false);
            DataSet dataSet1 = dataSets[0].leftJoin(this.materialCategoryHelper.getMaterialCategoryDataSet(true)).on("materialid", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialcategory"}).finish();
            DataSet dataSet2 = dataSets[1].leftJoin(this.materialCategoryHelper.getMaterialCategoryDataSet(true)).on("materialid", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialcategory"}).finish();
            dataSet = dataSet1.union(dataSet2);
        }
        return dataSet;
    }

    private DataSet processGroupDataSet(DataSet dataSet) {
        if (this.filter_groupSum) {
            dataSet = dataSet.select(this.getFinalSelects("groupFields"));
        } else {
            DataSet ownerSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name,number", null, null);
            dataSet = dataSet.join(ownerSet, JoinType.LEFT).on("owner", "id").select(this.getFinalSelects("joinOwnerLeft").split(","), this.getFinalSelects("joinOwnerRight").split(",")).finish();
        }
        CharSequence[] fields = dataSet.getRowMeta().getFieldNames();
        dataSet = this.filter_currency != null ? dataSet.select(String.join((CharSequence)",", fields) + "," + this.filter_currency.getPkValue().toString() + " as currency") : dataSet.select(String.join((CharSequence)",", fields) + "," + null + " as currency");
        return dataSet;
    }

    private DataSet unionAllDataSet(DataSet periodBeginBalanceDataSet, DataSet periodReplenishDataSet, DataSet periodRushDataSet) {
        if (this.filter_groupSum) {
            DataSet ReplenishAndRushDataset = periodReplenishDataSet.union(periodRushDataSet).groupBy(new String[]{"materialid", "materialnum", "materialname", "baseunit", "period"}).sum("periodbeginbalance").sum("periodreplenish").sum("periodrush").finish();
            periodBeginBalanceDataSet = periodBeginBalanceDataSet.groupBy(new String[]{"materialid", "materialnum", "materialname", "baseunit", "period"}).sum("periodbeginbalance").sum("periodreplenish").sum("periodrush").finish();
            DataSet dimDataset = periodBeginBalanceDataSet.union(ReplenishAndRushDataset).groupBy(new String[]{"materialid", "materialnum", "materialname", "baseunit"}).finish().select("materialid,materialnum,materialname,baseunit,'0' as onfield");
            QFilter q = new QFilter("periodyear*100+periodnumber", ">=", (Object)this.filter_startPeriodNumber);
            q.and("periodyear*100+periodnumber", "<=", (Object)this.filter_endPeriodNumber);
            DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
            q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
            q.and("isadjustperiod", "=", (Object)false);
            DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"'0' as onfield,periodyear*100+periodnumber as period", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
            DataSet periodDimDataSet = periodDataSet.join(dimDataset, JoinType.LEFT).on("onfield", "onfield").select(new String[]{"period"}, new String[]{"materialid", "materialnum", "materialname", "baseunit"}).finish();
            DataSet dataSet1 = periodDimDataSet.join(periodBeginBalanceDataSet, JoinType.LEFT).on("materialid", "materialid").on("materialnum", "materialnum").on("materialname", "materialname").on("baseunit", "baseunit").select(new String[]{"materialid", "materialnum", "materialname", "baseunit", "period"}, new String[]{"periodbeginbalance"}).finish().select("materialid,materialnum,materialname,baseunit,Cast(period as Integer) as period,case when periodbeginbalance=null then 0 else periodbeginbalance end as periodbeginbalance");
            DataSet dataSet2 = dataSet1.join(ReplenishAndRushDataset, JoinType.LEFT).on("materialid", "materialid").on("materialnum", "materialnum").on("materialname", "materialname").on("baseunit", "baseunit").on("period", "period").select(new String[]{"materialid", "materialnum", "materialname", "baseunit", "period", "periodbeginbalance"}, new String[]{"periodreplenish", "periodrush"}).finish();
            dataSet2 = dataSet2.select("materialid,materialnum,materialname,baseunit,period,case when periodbeginbalance = null then 0 else periodbeginbalance end as periodbeginbalance,case when periodreplenish = null then 0 else periodreplenish end as periodreplenish,case when periodrush = null then 0 else periodrush end as periodrush");
            dataSet2 = dataSet2.orderBy(new String[]{"materialid", "materialnum", "materialname", "baseunit", "period"});
            dataSet2 = dataSet2.select(this.getFinalSelects("processGroupPeriodBeginBalance"));
            dataSet2 = dataSet2.select("0 as ordercol,materialid,materialnum,materialname,baseunit,period,periodbeginbalance,periodreplenish,periodrush,periodbeginbalance+periodreplenish-periodrush as periodendbalance");
            dataSet2 = dataSet2.where("(periodbeginbalance <> 0 and periodbeginbalance <> null) or (periodreplenish <> 0 and periodreplenish <> null) or (periodrush <> 0 and periodrush <> null) or (periodendbalance <> 0 and periodendbalance <> null)");
            dataSet2 = dataSet2.union(dataSet2.groupBy(new String[]{"period"}).sum("periodbeginbalance").sum("periodreplenish").sum("periodrush").sum("periodendbalance").finish().select("1 as ordercol,null as materialid,null as materialnum,'" + this.s1 + "' as materialname, null as baseunit,period,periodbeginbalance,periodreplenish,periodrush,periodendbalance"));
            return dataSet2;
        }
        DataSet ReplenishAndRushDataset = periodReplenishDataSet.union(periodRushDataSet).groupBy((this.getFinalSelects("baseField") + ",period").split(",")).sum("periodbeginbalance").sum("periodreplenish").sum("periodrush").finish();
        DataSet dimDataset = periodBeginBalanceDataSet.union(ReplenishAndRushDataset.copy()).groupBy(this.getFinalSelects("baseField").split(",")).finish().select(this.getFinalSelects("baseField") + ",'0' as onfield");
        QFilter q = new QFilter("periodyear*100+periodnumber", ">=", (Object)this.filter_startPeriodNumber);
        q.and("periodyear*100+periodnumber", "<=", (Object)this.filter_endPeriodNumber);
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"'0' as onfield,periodyear*100+periodnumber as period", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        DataSet periodDimDataSet = periodDataSet.join(dimDataset, JoinType.LEFT).on("onfield", "onfield").select(new String[]{"period"}, this.getFinalSelects("baseField").split(",")).finish();
        JoinDataSet joindataSet1 = periodDimDataSet.join(periodBeginBalanceDataSet, JoinType.LEFT);
        for (String onField : this.getFinalSelects("baseField").split(",")) {
            joindataSet1 = joindataSet1.on(onField, onField);
        }
        DataSet dataSet1 = joindataSet1.select((this.getFinalSelects("baseField") + ",period").split(","), new String[]{"periodbeginbalance"}).finish().select(this.getFinalSelects("baseField") + ",Cast(period as Integer) as period,case when periodbeginbalance=null then 0 else periodbeginbalance end as periodbeginbalance");
        JoinDataSet joinDataSet2 = dataSet1.join(ReplenishAndRushDataset, JoinType.LEFT);
        for (String onField : this.getFinalSelects("baseField").split(",")) {
            joinDataSet2 = joinDataSet2.on(onField, onField);
        }
        joinDataSet2 = joinDataSet2.on("period", "period");
        DataSet dataSet2 = joinDataSet2.select((this.getFinalSelects("baseField") + ",period,periodbeginbalance").split(","), new String[]{"periodreplenish", "periodrush"}).finish();
        dataSet2 = dataSet2.select(this.getFinalSelects("baseField") + ",period,case when periodbeginbalance = null then 0 else periodbeginbalance end as periodbeginbalance,case when periodreplenish = null then 0 else periodreplenish end as periodreplenish,case when periodrush = null then 0 else periodrush end as periodrush");
        dataSet2 = dataSet2.orderBy((this.getFinalSelects("baseField") + ",period").split(","));
        dataSet2 = dataSet2.select(this.getFinalSelects("processPeriodBeginBalance"));
        dataSet2 = dataSet2.select(this.getFinalSelects("baseField") + ",0 as ordercol,period,periodbeginbalance,periodreplenish,periodrush,periodbeginbalance+periodreplenish-periodrush as periodendbalance");
        dataSet2 = dataSet2.where("(periodbeginbalance <> 0 and periodbeginbalance <> null) or (periodreplenish <> 0 and periodreplenish <> null) or (periodrush <> 0 and periodrush <> null) or (periodendbalance <> 0 and periodendbalance <> null)");
        dataSet2 = dataSet2.union(dataSet2.groupBy(new String[]{"period"}).sum("periodbeginbalance").sum("periodreplenish").sum("periodrush").sum("periodendbalance").finish().select(this.getFinalSelects("nullBaseField") + ",null as materialid,null as materialnum,'" + this.s1 + "' as materialname,null as baseunit,1 as ordercol,period,periodbeginbalance,periodreplenish,periodrush,periodendbalance"));
        return dataSet2;
    }

    private DataSet getPeriodRushDataSet() {
        QFilter periodRushFilter = new QFilter("period", ">=", (Object)this.filter_startPeriodNumber);
        periodRushFilter.and("period", "<=", (Object)this.filter_endPeriodNumber);
        periodRushFilter.and(this.baseQfilter);
        DataSet periodRushDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_price_revbill", (String)(this.getFinalSelects("baseAsField") + ",period,0 as replenishamount, entry.curperiodrushamount as periodrush"), (QFilter[])periodRushFilter.toArray(), null).select(this.getFinalSelects("nullAsEmpty") + ",period,periodrush").groupBy((this.getFinalSelects("baseField") + ",period").split(",")).sum("periodrush").finish().select(this.getFinalSelects("baseField") + ",period,0 as periodbeginbalance,0 as periodreplenish,periodrush");
        return periodRushDataSet;
    }

    private DataSet getPeriodReplenishDataSet() {
        QFilter periodReplenishFilter = new QFilter("period", ">=", (Object)this.filter_startPeriodNumber);
        periodReplenishFilter.and("period", "<=", (Object)this.filter_endPeriodNumber);
        periodReplenishFilter.and(this.baseQfilter);
        DataSet periodReplenishDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_price_provbill", (String)(this.getFinalSelects("baseAsField") + ",period,entry.replenishamount as periodreplenish"), (QFilter[])periodReplenishFilter.toArray(), null).select(this.getFinalSelects("nullAsEmpty") + ",period,periodreplenish").groupBy((this.getFinalSelects("baseField") + ",period").split(",")).sum("periodreplenish").finish().select(this.getFinalSelects("baseField") + ",period,0 as periodbeginbalance,periodreplenish,0 as periodrush");
        return periodReplenishDataSet;
    }

    private DataSet getPeriodBeginBalanceDataSet() {
        QFilter beforePeriodFilter = new QFilter("period", "<", (Object)this.filter_startPeriodNumber);
        beforePeriodFilter.and(this.baseQfilter);
        DataSet beforePeriodReplenishDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_price_provbill", (String)(this.getFinalSelects("baseAsField") + ",entry.invagefrom invagefrom,entry.invageto invageto,entry.expirydatefrom expirydatefrom,entry.expirydateto expirydateto,period as replenishperiod,case when isinitbill = '0' then entry.requireamount else entry.hasamount end as requireamount"), (QFilter[])beforePeriodFilter.toArray(), null).select(this.getFinalSelects("nullAsEmpty") + ",invagefrom,invageto,expirydatefrom,expirydateto,replenishperiod,requireamount");
        String baseField = "invagefrom,invageto,expirydatefrom,expirydateto," + this.getFinalSelects("baseField");
        beforePeriodReplenishDataSet = beforePeriodReplenishDataSet.groupBy(baseField.split(",")).max("replenishperiod").maxP("replenishperiod", "requireamount").finish();
        DataSet beforePeriodRushDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_price_revbill", (String)(this.getFinalSelects("baseAsField") + ",entry.invagefrom invagefrom,entry.invageto invageto,entry.expirydatefrom expirydatefrom,entry.expirydateto expirydateto,period as rushperiod,entry.curperiodrushamount as rushamount"), (QFilter[])beforePeriodFilter.toArray(), null).select(this.getFinalSelects("nullAsEmpty") + ",invagefrom,invageto,expirydatefrom,expirydateto,rushperiod,rushamount");
        JoinDataSet joindataSet = beforePeriodReplenishDataSet.join(beforePeriodRushDataSet, JoinType.LEFT);
        for (String onField : baseField.split(",")) {
            joindataSet = joindataSet.on(onField, onField);
        }
        DataSet dataSet = joindataSet.select((baseField + ",replenishperiod,requireamount").split(","), new String[]{"rushperiod", "rushamount"}).finish().select(baseField + ",replenishperiod as period,case when rushperiod is null then -1 else rushperiod end as rushperiod, requireamount, case when rushamount is null then 0 else rushamount end as rushamount");
        DataSet hasRushDS = dataSet.where("period < rushperiod");
        DataSet noRushDS = dataSet.where("period > rushperiod").select(baseField + ",period,rushperiod,requireamount,0 as rushamount");
        dataSet = hasRushDS.union(noRushDS);
        dataSet = dataSet.groupBy((baseField + ",period").split(",")).max("requireamount").sum("rushamount").finish().groupBy((this.getFinalSelects("baseField") + ",period").split(",")).sum("requireamount").sum("rushamount").finish().select(this.getFinalSelects("baseField") + ",period,requireamount-rushamount as periodbeginbalance,0 as periodreplenish,0 as periodrush");
        return dataSet;
    }

    private void init(ReportQueryParam param) {
        Set materialIds;
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        DynamicObject materialgroup = this.filterInfo.getDynamicObject("materialgroup");
        DynamicObjectCollection mulmaterial = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        DynamicObject materialto = this.filterInfo.getDynamicObject("materialto");
        this.filter_groupSum = this.filterInfo.getBoolean("groupsum");
        this.filter_currency = this.filterInfo.getDynamicObject("localcurrency");
        this.baseQfilter = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        this.baseQfilter.and("billstatus", "=", (Object)"C");
        if (materialgroup != null) {
            Object mgs = this.filterInfo.getValue("groupstandard");
            mgs = mgs == null ? Long.valueOf(730148448254487552L) : ((DynamicObject)mgs).getPkValue();
            Iterator baseDataParser = new StandGroupBaseDataConverter("bd_materialgroupdetail", "material");
            ArrayList<Long> list = new ArrayList<Long>(8);
            list.add(materialgroup.getLong("id"));
            Set matIds = baseDataParser.getBaseDataIdsByStandGroupId((Long)mgs, list);
            this.baseQfilter.and("entry.material", "in", (Object)matIds);
        }
        if (mulmaterial != null) {
            if (mulmaterial.size() > 1) {
                HashSet<String> materialSet = new HashSet<String>();
                for (DynamicObject materialFrom : mulmaterial) {
                    materialSet.add(materialFrom.getString("number"));
                }
                this.baseQfilter.and("entry.material.number", "in", materialSet);
            } else if (mulmaterial.size() == 1) {
                this.baseQfilter.and("entry.material.number", ">=", (Object)((DynamicObject)mulmaterial.get(0)).getString("number"));
                if (materialto != null) {
                    this.baseQfilter.and("entry.material.number", "<=", (Object)materialto.getString("number"));
                }
            }
        }
        DynamicObjectCollection costacconts = new DynamicObjectCollection();
        costacconts.add((Object)this.filter_costAccount);
        this.filter_mulMaterialCategory = this.filterInfo.getDynamicObjectCollection("mulmatcategory");
        this.materialCategoryHelper = new MaterialCategoryHelper(costacconts, null, this.filter_mulMaterialCategory);
        if (this.materialCategoryHelper != null && this.filter_mulMaterialCategory != null && (materialIds = this.materialCategoryHelper.getMaterialIds()) != null && !materialIds.isEmpty()) {
            this.baseQfilter.and("entry.material", "in", (Object)materialIds);
        }
    }

    private String getFinalSelects(String s) {
        String string = "";
        switch (s) {
            case "baseAsField": {
                string = "entry.owner as owner,entry.storageorgunit.number as storageorgnum,entry.storageorgunit.name as storageorgname,entry.warehouse.number as warehousenum,entry.warehouse.name as warehousename,entry.location.number as locationnum,entry.location.name as locationname,entry.lot as lot,entry.assist as assist,entry.project.name as projectname,entry.configuredcode as configuredcode,entry.material.id as materialid,entry.material.number as materialnum,entry.material.name as materialname,entry.baseunit.name as baseunit";
                break;
            }
            case "nullAsEmpty": {
                string = "owner,case when storageorgnum = null then '' else storageorgnum end as storageorgnum,case when storageorgname = null then '' else storageorgname end as storageorgname,case when warehousenum = null then '' else warehousenum end as warehousenum,case when warehousename = null then '' else warehousename end as warehousename,case when locationnum = null then '' else locationnum end as locationnum,case when locationname = null then '' else locationname end as locationname,lot,assist,case when projectname = null then '' else projectname end as projectname,case when configuredcode = null then 0 else configuredcode end as configuredcode,case when materialid == null then 0 else materialid end as materialid,case when materialnum = null then '' else materialnum end as materialnum,case when materialname = null then '' else materialname end as materialname,case when baseunit = null then '' else baseunit end as baseunit";
                break;
            }
            case "baseField": {
                string = "owner,storageorgnum,storageorgname,warehousenum,warehousename,locationnum,locationname,lot,assist,projectname,configuredcode,materialid,materialnum,materialname,baseunit";
                break;
            }
            case "nullBaseField": {
                string = "null as owner,null as storageorgnum,null as storageorgname,null as warehousenum,null as warehousename,null as locationnum,null as locationname,null as lot,null as assist,null as projectname,null as configuredcode";
                break;
            }
            case "processPeriodBeginBalance": {
                string = "owner,storageorgnum,storageorgname,warehousenum,warehousename,locationnum,locationname,lot,assist,projectname,configuredcode,materialid,materialnum,materialname,baseunit,period,case when PreRowValue(owner)= owner and PreRowValue(storageorgnum)= storageorgnum  and PreRowValue(storageorgname)= storageorgname and PreRowValue(warehousenum)= warehousenum and PreRowValue(warehousename)= warehousename and PreRowValue(locationnum)= locationnum and PreRowValue(locationname)= locationname and PreRowValue(lot)= lot and PreRowValue(assist)= assist and PreRowValue(projectname)= projectname and PreRowValue(configuredcode)= configuredcode and PreRowValue(materialid)= materialid and PreRowValue(materialnum)= materialnum and PreRowValue(materialname)= materialname and PreRowValue(baseunit)= baseunit then PreRowValue(periodbeginbalance)+PreRowValue(periodreplenish)-PreRowValue(periodrush) else periodbeginbalance end as periodbeginbalance,periodreplenish,periodrush";
                break;
            }
            case "processGroupPeriodBeginBalance": {
                string = "materialid,materialnum,materialname,baseunit,period,case when PreRowValue(materialid) = materialid  and PreRowValue(materialnum) = materialnum and PreRowValue(materialname) = materialname and PreRowValue(baseunit)= baseunit  then PreRowValue(periodbeginbalance)+PreRowValue(periodreplenish)-PreRowValue(periodrush)  else periodbeginbalance end as periodbeginbalance,periodreplenish,periodrush";
                break;
            }
            case "groupFields": {
                string = "ordercol,materialid,materialnum,materialname,baseunit,period/100 as year,period%100 as period,periodbeginbalance,periodreplenish,periodrush,periodendbalance,materialcategory";
                break;
            }
            case "joinOwnerLeft": {
                string = "ordercol,storageorgnum,storageorgname,warehousenum,warehousename,locationnum,locationname,lot,assist,projectname,configuredcode,materialid,materialnum,materialname,baseunit,period/100 as year,period%100 as period,periodbeginbalance,periodreplenish,periodrush,periodendbalance,materialcategory";
                break;
            }
            case "joinOwnerRight": {
                string = "number as ownernum,name as ownername";
            }
        }
        return string;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List oldColumns = super.getColumns(columns);
        ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>();
        if (this.filter_groupSum) {
            for (AbstractReportColumn abstractReportColumn : oldColumns) {
                ReportColumn column = (ReportColumn)abstractReportColumn;
                String columnName = column.createColumn().get("dataIndex").toString();
                if ("ownernum".equals(columnName) || "ownername".equals(columnName) || "storageorgnum".equals(columnName) || "storageorgname".equals(columnName) || "warehousenum".equals(columnName) || "warehousename".equals(columnName) || "locationnum".equals(columnName) || "locationname".equals(columnName) || "lot".equals(columnName) || "assist".equals(columnName) || "projectname".equals(columnName) || "configuredcode".equals(columnName)) {
                    column.setHide(true);
                }
                newColumns.add((AbstractReportColumn)column);
            }
            this.createMaterialCategoryColumns(newColumns);
            return newColumns;
        }
        this.createMaterialCategoryColumns(oldColumns);
        return oldColumns;
    }

    private void createMaterialCategoryColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_MaterialCategoryNum, this.locale_MaterialCategoryName, "materialcategory", "bd_materialcategory");
    }

    private void createGroupTypeColumns(List<AbstractReportColumn> cols, LocaleString numCaption, LocaleString nameCaption, String fieldKey, String entityId) {
        ReportColumn id = ReportColumn.createBaseDataColumn((String)fieldKey, (String)entityId);
        id.setDisplayProp("number");
        id.setCaption(numCaption);
        id.setWidth(width);
        ReportColumn name = ReportColumn.createBaseDataPropColumn((String)(fieldKey + "name"), (String)fieldKey, (String)"name");
        name.setCaption(nameCaption);
        name.setWidth(width);
        cols.add((AbstractReportColumn)id);
        cols.add((AbstractReportColumn)name);
    }
}

