/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.model.CalBillRule;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.report.queryplugin.InvCKAccountRptParams;

public class InvCKAccountRptQueryPlugin
extends AbstractReportListDataPlugin {
    private InvCKAccountRptParams rptParams = null;
    private static final String CALBAL = "2";
    private List<String> groupDims;
    private Map<String, String> rptDimCalBillDimMap = new HashMap<String, String>(16);
    private Boolean isNewPeriodBal = false;
    private Map<String, List<CalBillRule>> inCalBillRuleMap;
    private Map<String, List<CalBillRule>> outCalBillRuleMap;

    public DataSet query(ReportQueryParam queryParam, Object paramObject) {
        this.init(queryParam);
        List<OrmInput> allBillIOs = this.getInvBalanceDataSet();
        String[] groupFieldArray = this.groupDims.toArray(new String[0]);
        List<OrmInput> calBillIOs = this.getCalBalanceDataSet();
        allBillIOs.addAll(calBillIOs);
        String filterStr = "(invqty <> 0 or calqty <> 0)";
        if (this.rptParams.isIsonlydiff()) {
            filterStr = filterStr + " and ediffqty <> 0";
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
        unionDataSet.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            DynamicObject periodDyc = this.rptParams.isIsinit() ? null : this.getYearPeriodByDate(this.rptParams.getCostAccount().getPkValue(), DateUtils.getDayStartTime((Date)this.rptParams.getEnddate()));
            int yearPeriod = periodDyc == null ? 1 : periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
            DataSet calNewDs = this.getNewCalBgnDs(this.getOrgIds(), yearPeriod);
            unionDataSet = unionDataSet.union(calNewDs);
        }
        unionDataSet.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
        unionDataSet = this.queryMatNum(unionDataSet);
        unionDataSet = unionDataSet.groupBy(groupFieldArray).sum("invqty").sum("(invqty - invqty) + calqty", "calqty").sum("calqty - invqty", "ediffqty").finish().filter(filterStr);
        if (unionDataSet != null) {
            Field[] rptFields = unionDataSet.getRowMeta().getFields();
            ArrayList<String> sumRptfs = new ArrayList<String>(rptFields.length);
            DataSet sumDataSet = unionDataSet.groupBy(new String[0]).sum("invqty").sum("calqty").sum("ediffqty").finish();
            for (Field item : rptFields) {
                String rptf = item.getName();
                if ("ematerialnum".equals(rptf)) {
                    String msg;
                    rptf = msg = String.format(ResManager.loadKDString((String)"%1$s\u603b\u8ba1%2$s", (String)"StockGatherRptQueryPlugin_54", (String)"fi-cal-report", (Object[])new Object[0]), "'", "' as " + item);
                } else if (!rptf.contains("qty")) {
                    rptf = "null as " + rptf;
                }
                sumRptfs.add(rptf);
            }
            unionDataSet = unionDataSet.union(sumDataSet.select(sumRptfs.toArray(new String[0])));
        }
        return unionDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createHideColumns(cols);
        return cols;
    }

    protected String[] getGroupFields() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("estorageorg,ematerial,ematerialnum,ebaseunit");
        if (this.rptParams.isShowwarehs()) {
            sb.append(",ewarehs");
        }
        if (this.rptParams.isShowlocation()) {
            sb.append(",elocation");
        }
        if (this.rptParams.isShowowner()) {
            sb.append(",eownertype,eowner");
        }
        if (this.rptParams.isShowinvtype()) {
            sb.append(",einvtype");
        }
        if (this.rptParams.isShowinvstatus()) {
            sb.append(",einvstatus");
        }
        if (this.rptParams.isShowauxpty()) {
            sb.append(",eauxpty");
        }
        if (this.rptParams.isShowproject()) {
            sb.append(",eproject");
        }
        if (this.rptParams.isShowlot()) {
            sb.append(",elot");
        }
        return sb.toString().split(",");
    }

    private String getInvBalanceSelector() {
        HashMap<String, String> rptDimBillDimMap = new HashMap<String, String>(16);
        rptDimBillDimMap.put("estorageorg", "org");
        rptDimBillDimMap.put("ematerial", "material");
        rptDimBillDimMap.put("ematerialnum", "material.number");
        rptDimBillDimMap.put("ebaseunit", "baseunit");
        rptDimBillDimMap.put("ewarehs", "warehouse");
        rptDimBillDimMap.put("elocation", "location");
        rptDimBillDimMap.put("eownertype", "ownertype");
        rptDimBillDimMap.put("eowner", "owner");
        rptDimBillDimMap.put("einvtype", "invtype");
        rptDimBillDimMap.put("einvstatus", "invstatus");
        rptDimBillDimMap.put("eauxpty", "auxpty");
        rptDimBillDimMap.put("eproject", "project");
        rptDimBillDimMap.put("elot", "lotnumber");
        StringBuilder sb = new StringBuilder();
        for (String dim : this.groupDims) {
            sb.append((String)rptDimBillDimMap.get(dim));
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
        }
        if (this.isNewPeriodBal.booleanValue()) {
            sb.append("baseqty_bal as invqty, 0 as calqty");
        } else {
            sb.append("endbaseqty as invqty, 0 as calqty");
        }
        return sb.toString();
    }

    protected String getCalBalanceSelector() {
        HashMap<String, String> rptDimBillDimMap = new HashMap<String, String>(16);
        rptDimBillDimMap.put("estorageorg", "storageorgunit");
        rptDimBillDimMap.put("ematerial", "material");
        rptDimBillDimMap.put("ematerialnum", "material.number");
        rptDimBillDimMap.put("ebaseunit", "baseunit");
        rptDimBillDimMap.put("ewarehs", "warehouse");
        rptDimBillDimMap.put("elocation", "location");
        rptDimBillDimMap.put("eownertype", "ownertype");
        rptDimBillDimMap.put("eowner", "owner");
        rptDimBillDimMap.put("einvtype", "invtype");
        rptDimBillDimMap.put("einvstatus", "invstatus");
        rptDimBillDimMap.put("eauxpty", "assist");
        rptDimBillDimMap.put("eproject", "project");
        rptDimBillDimMap.put("elot", "lot");
        StringBuilder sb = new StringBuilder();
        for (String dim : this.groupDims) {
            if ("ematerialnum".equals(dim)) continue;
            sb.append((String)rptDimBillDimMap.get(dim));
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
            if (!"ematerial".equals(dim)) continue;
            sb.append((String)rptDimBillDimMap.get(dim));
            sb.append(".number as ematerialnum,");
        }
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            sb.append("0 as invqty,baseqty_bal as calqty");
        } else {
            sb.append("0 as invqty,periodendqty as calqty");
        }
        return sb.toString();
    }

    protected List<OrmInput> getInvBalanceDataSet() {
        ArrayList<OrmInput> invBillIOs = new ArrayList<OrmInput>(16);
        OrmInput invBalIO = this.getInvBgnQtyDataSet();
        invBillIOs.add(invBalIO);
        if (!this.rptParams.isIsinit()) {
            this.initCalBillRules();
            List<OrmInput> invRecBillIOs = this.getInvRecQtyDataSet();
            invBillIOs.addAll(invRecBillIOs);
            List<OrmInput> invSedBillIOs = this.getInvSedQtyDataSet();
            invBillIOs.addAll(invSedBillIOs);
        }
        return invBillIOs;
    }

    private void initCalBillRules() {
        if (this.rptParams.isIsinit()) {
            return;
        }
        this.initCalDimMap();
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadAllRules();
        this.inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        this.outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
    }

    private void initCalDimMap() {
        this.rptDimCalBillDimMap.put("estorageorg", "org");
        this.rptDimCalBillDimMap.put("ematerial", "material");
        this.rptDimCalBillDimMap.put("ebaseunit", "baseunit");
        this.rptDimCalBillDimMap.put("ewarehs", "warehouse");
        this.rptDimCalBillDimMap.put("elocation", "location");
        this.rptDimCalBillDimMap.put("eownertype", "ownertype");
        this.rptDimCalBillDimMap.put("eowner", "owner");
        this.rptDimCalBillDimMap.put("einvtype", "invtype");
        this.rptDimCalBillDimMap.put("einvstatus", "invstatus");
        this.rptDimCalBillDimMap.put("eauxpty", "assistproperty");
        this.rptDimCalBillDimMap.put("eproject", "project");
        this.rptDimCalBillDimMap.put("elot", "lot");
    }

    protected List<OrmInput> getCalBalanceDataSet() {
        List<Object> orgIds = this.getOrgIds();
        DynamicObject periodDyc = this.rptParams.isIsinit() ? null : this.getYearPeriodByDate(this.rptParams.getCostAccount().getPkValue(), DateUtils.getDayStartTime((Date)this.rptParams.getEnddate()));
        int yearPeriod = periodDyc == null ? 1 : periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
        Date periodBeginDate = periodDyc == null ? null : periodDyc.getDate("begindate");
        ArrayList<OrmInput> calBillIOs = new ArrayList<OrmInput>(16);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (!isNewBalance) {
            OrmInput calBalIO = this.getCalBgnDs(orgIds, yearPeriod);
            calBillIOs.add(calBalIO);
        }
        if (!this.rptParams.isIsinit()) {
            OrmInput calRecBillIO = this.getCalRecOrSedDs(orgIds, periodBeginDate, true);
            calBillIOs.add(calRecBillIO);
            OrmInput calSedBillIO = this.getCalRecOrSedDs(orgIds, periodBeginDate, false);
            calBillIOs.add(calSedBillIO);
        }
        return calBillIOs;
    }

    protected OrmInput getCalBgnDs(List<Object> orgIds, int yearPeriod) {
        List<Object> matIds;
        String selectFields = this.getCalBalanceSelector();
        QFilter filter = new QFilter("storageorgunit", "in", (Object)orgIds.toArray());
        QFilter periodf = new QFilter("period", "<", (Object)yearPeriod);
        periodf.and(new QFilter("endperiod", ">=", (Object)yearPeriod));
        filter.and(periodf);
        filter.and(new QFilter("costaccount", "=", this.rptParams.getCostAccount().getPkValue()));
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("owner", "in", (Object)this.rptParams.getOwners()));
        List<Object> warehouseIds = this.getDycsIds(this.rptParams.getWarehouse());
        if (warehouseIds.size() > 0) {
            filter.and(new QFilter("warehouse", "in", warehouseIds));
        }
        if ((matIds = this.getDycsIds(this.rptParams.getMaterialIds())).size() > 0) {
            filter.and(new QFilter("material", "in", matIds));
        }
        OrmInput billIO = new OrmInput(InvCKAccountRptQueryPlugin.class + "getCalBgnDs", "cal_balance", selectFields, new QFilter[]{filter});
        return billIO;
    }

    protected DataSet getNewCalBgnDs(List<Object> orgIds, int yearPeriod) {
        List<Object> matIds;
        String selectFields = this.getCalBalanceSelector();
        QFilter filter = new QFilter("storageorgunit", "in", (Object)orgIds.toArray());
        QFilter periodf = new QFilter("period", "<", (Object)yearPeriod);
        periodf.and(new QFilter("endperiod", ">=", (Object)yearPeriod));
        filter.and(periodf);
        filter.and(new QFilter("costaccount", "=", this.rptParams.getCostAccount().getPkValue()));
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("owner", "in", (Object)this.rptParams.getOwners()));
        List<Object> warehouseIds = this.getDycsIds(this.rptParams.getWarehouse());
        if (warehouseIds.size() > 0) {
            filter.and(new QFilter("warehouse", "in", warehouseIds));
        }
        if ((matIds = this.getDycsIds(this.rptParams.getMaterialIds())).size() > 0) {
            filter.and(new QFilter("material", "in", matIds));
        }
        String dimStr = CalBalanceModelHelper.getDimFields((boolean)false);
        String selects = dimStr + ",material.number,baseqty_bal,baseunit";
        DataSet calBalDs = QueryServiceHelper.queryDataSet((String)(InvCKAccountRptQueryPlugin.class + "getCalBgnDs"), (String)"cal_bal", (String)selects, (QFilter[])new QFilter[]{filter}, null);
        ArrayList<String> groupDims = new ArrayList<String>(Arrays.asList(dimStr.split(",")));
        groupDims.add("material.number");
        groupDims.add("baseunit");
        calBalDs = calBalDs.groupBy(groupDims.toArray(new String[0])).max("baseqty_bal").finish().select(selectFields);
        return calBalDs;
    }

    private OrmInput getCalRecOrSedDs(List<Object> orgIds, Date periodBeginDate, boolean isRec) {
        List<Object> matIds;
        String selectFields = this.getCalRecordSelector(isRec);
        QFilter filter = new QFilter("storageorgunit", "in", (Object)orgIds.toArray());
        filter.and(new QFilter("issplitcreate", "=", (Object)false));
        filter.and(new QFilter("isinitbill", "=", (Object)false));
        if (periodBeginDate != null) {
            filter.and(new QFilter("bookdate", ">=", (Object)periodBeginDate));
        }
        filter.and(new QFilter("bookdate", "<=", (Object)this.rptParams.getEnddate()));
        filter.and(new QFilter("costaccount", "=", this.rptParams.getCostAccount().getPkValue()));
        filter.and(new QFilter("calbilltype", "=", (Object)(isRec ? "IN" : "OUT")));
        filter.and(new QFilter("entry.ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("entry.owner", "in", (Object)this.rptParams.getOwners()));
        filter.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        List<Object> warehouseIds = this.getDycsIds(this.rptParams.getWarehouse());
        if (warehouseIds.size() > 0) {
            filter.and(new QFilter("entry.warehouse", "in", warehouseIds));
        }
        if ((matIds = this.getDycsIds(this.rptParams.getMaterialIds())).size() > 0) {
            filter.and(new QFilter("entry.material", "in", matIds));
        }
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        filter.and(billStatusf);
        OrmInput billIO = new OrmInput(InvCKAccountRptQueryPlugin.class + "getCalRecOrSedDs", "cal_costrecord", selectFields, new QFilter[]{filter});
        return billIO;
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        boolean isHiedOwenType = false;
        int owenTypeIndex = 0;
        for (int i = 0; i < cols.size(); ++i) {
            ReportColumn column = (ReportColumn)cols.get(i);
            String columnName = column.createColumn().get("dataIndex").toString();
            if ("ewarehs".equals(columnName) && !this.rptParams.isShowwarehs()) {
                column.setHide(true);
                continue;
            }
            if ("elocation".equals(columnName) && !this.rptParams.isShowlocation()) {
                column.setHide(true);
                continue;
            }
            if ("eowner".equals(columnName) && !this.rptParams.isShowowner()) {
                column.setHide(true);
                isHiedOwenType = true;
                continue;
            }
            if ("einvtype".equals(columnName) && !this.rptParams.isShowinvtype()) {
                column.setHide(true);
                continue;
            }
            if ("einvstatus".equals(columnName) && !this.rptParams.isShowinvstatus()) {
                column.setHide(true);
                continue;
            }
            if ("eproject".equals(columnName) && !this.rptParams.isShowproject()) {
                column.setHide(true);
                continue;
            }
            if ("elot".equals(columnName) && !this.rptParams.isShowlot()) {
                column.setHide(true);
                continue;
            }
            if ("eauxpty".equals(columnName) && !this.rptParams.isShowauxpty()) {
                column.setHide(true);
                continue;
            }
            if (!"eownertype".equals(columnName)) continue;
            owenTypeIndex = i;
        }
        if (isHiedOwenType) {
            ((ReportColumn)cols.get(owenTypeIndex)).setHide(true);
        }
    }

    private void init(ReportQueryParam param) {
        this.rptParams = new InvCKAccountRptParams();
        FilterInfo filterInfo = param.getFilter();
        this.rptParams.setStorageOrgUnit(filterInfo.getDynamicObjectCollection("storageorg"));
        this.rptParams.setCostAccount(filterInfo.getDynamicObject("costaccount"));
        this.rptParams.setWarehouse(filterInfo.getDynamicObjectCollection("warehouse"));
        this.rptParams.setMaterialIds(filterInfo.getDynamicObjectCollection("material"));
        this.rptParams.setShowwarehs(filterInfo.getBoolean("showwarehs"));
        this.rptParams.setShowlocation(filterInfo.getBoolean("showlocation"));
        this.rptParams.setShowowner(filterInfo.getBoolean("showowner"));
        this.rptParams.setShowauxpty(filterInfo.getBoolean("showauxpty"));
        this.rptParams.setShowproject(filterInfo.getBoolean("showproject"));
        this.rptParams.setShowlot(filterInfo.getBoolean("showlot"));
        this.rptParams.setShowinvtype(filterInfo.getBoolean("showinvtype"));
        this.rptParams.setShowinvstatus(filterInfo.getBoolean("showinvstatus"));
        this.rptParams.setEnddate(DateUtils.getDayEndTime((Date)filterInfo.getDate("enddate")));
        this.rptParams.setIsonlydiff(filterInfo.getBoolean("isonlydiff"));
        this.rptParams.setIsinit(filterInfo.getBoolean("isinit"));
        this.rptParams.setOwners(AccountingSysHelper.getOwners((Long)this.rptParams.getCostAccount().getLong("id")));
        this.groupDims = new ArrayList<String>(Arrays.asList(this.getGroupFields()));
        this.initCalBillRules();
        this.isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
    }

    protected List<Object> getOrgIds() {
        ArrayList<Object> orgIds = new ArrayList<Object>();
        for (DynamicObject item : this.rptParams.getStorageOrgUnit()) {
            orgIds.add(item.getPkValue());
        }
        return orgIds;
    }

    public DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)false);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    private String getCalRecordSelector(boolean isRec) {
        HashMap<String, String> rptDimBillDimMap = new HashMap<String, String>(16);
        rptDimBillDimMap.put("estorageorg", "storageorgunit");
        rptDimBillDimMap.put("ematerial", "entry.material");
        rptDimBillDimMap.put("ematerialnum", "entry.material.number");
        rptDimBillDimMap.put("ebaseunit", "entry.baseunit");
        rptDimBillDimMap.put("ewarehs", "entry.warehouse");
        rptDimBillDimMap.put("elocation", "entry.location");
        rptDimBillDimMap.put("eownertype", "entry.ownertype");
        rptDimBillDimMap.put("eowner", "entry.owner");
        rptDimBillDimMap.put("einvtype", "entry.invtype");
        rptDimBillDimMap.put("einvstatus", "entry.invstatus");
        rptDimBillDimMap.put("eauxpty", "entry.assist");
        rptDimBillDimMap.put("eproject", "entry.project");
        rptDimBillDimMap.put("elot", "entry.lot");
        StringBuilder sb = new StringBuilder();
        for (String dim : this.groupDims) {
            sb.append((String)rptDimBillDimMap.get(dim));
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
        }
        sb.append("0 as invqty,");
        sb.append(isRec ? "entry.baseqty as calqty" : "0 - entry.baseqty as calqty");
        return sb.toString();
    }

    protected OrmInput getInvBgnQtyDataSet() {
        List<Object> matIds;
        String selectFields = this.getInvBalanceSelector();
        QFilter filter = new QFilter("org", "in", this.getOrgIds());
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        int period = 1;
        if (!this.rptParams.isIsinit()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.rptParams.getEnddate());
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            period = year * 100 + month;
        }
        QFilter periodf = new QFilter("period", "<", (Object)period);
        periodf.and(new QFilter("endperiod", ">=", (Object)period));
        filter.and(periodf);
        if (!this.isNewPeriodBal.booleanValue()) {
            filter.and(new QFilter("balancetype", "=", (Object)CALBAL));
        }
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("owner", "in", (Object)this.rptParams.getOwners()));
        List<Object> warehouseIds = this.getDycsIds(this.rptParams.getWarehouse());
        if (warehouseIds.size() > 0) {
            filter.and(new QFilter("warehouse", "in", warehouseIds));
        }
        if ((matIds = this.getDycsIds(this.rptParams.getMaterialIds())).size() > 0) {
            filter.and(new QFilter("material", "in", matIds));
        }
        String entityName = "im_invbalance";
        if (this.isNewPeriodBal.booleanValue()) {
            entityName = "im_cal_periodbalance";
        }
        OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + "getInvBalanceDataSet", entityName, selectFields, new QFilter[]{filter});
        return billIO;
    }

    protected List<OrmInput> getInvRecQtyDataSet() {
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(this.inCalBillRuleMap.size());
        for (Map.Entry<String, List<CalBillRule>> item : this.inCalBillRuleMap.entrySet()) {
            String formId = item.getKey();
            for (CalBillRule inCalBillRule : item.getValue()) {
                StringBuilder sb = new StringBuilder();
                Map calBillFieldBizBillFieldMap = inCalBillRule.getCalBizFieldMap();
                this.appendBizBillDim(calBillFieldBizBillFieldMap, sb);
                sb.append((String)calBillFieldBizBillFieldMap.get("baseqty"));
                sb.append(" as invqty,0 as calqty");
                List<QFilter> filters = this.getInvBaseFilter(calBillFieldBizBillFieldMap);
                filters.addAll(inCalBillRule.getBillFilters());
                filters.add(new QFilter("billstatus", "=", (Object)"C"));
                if (formId.contains("im_mdc_")) {
                    filters.add(new QFilter("billtype.billformid.number", "=", (Object)formId));
                }
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + item.getKey(), item.getKey(), sb.toString(), filters.toArray(new QFilter[0]));
                billsIO.add(billIO);
            }
        }
        return billsIO;
    }

    protected List<OrmInput> getInvSedQtyDataSet() {
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(this.outCalBillRuleMap.size());
        for (Map.Entry<String, List<CalBillRule>> item : this.outCalBillRuleMap.entrySet()) {
            String formId = item.getKey();
            for (CalBillRule outCalBillRule : item.getValue()) {
                Map calBizFieldMap = outCalBillRule.getCalBizFieldMap();
                StringBuilder sb = new StringBuilder();
                this.appendBizBillDim(calBizFieldMap, sb);
                sb.append("0 - ");
                sb.append((String)calBizFieldMap.get("baseqty"));
                sb.append(" as invqty, 0 as calqty");
                List<QFilter> filters = this.getInvBaseFilter(calBizFieldMap);
                filters.addAll(outCalBillRule.getBillFilters());
                filters.add(new QFilter("billstatus", "=", (Object)"C"));
                if (formId.contains("im_mdc_")) {
                    filters.add(new QFilter("billtype.billformid.number", "=", (Object)formId));
                }
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + item.getKey(), item.getKey(), sb.toString(), filters.toArray(new QFilter[0]));
                billsIO.add(billIO);
            }
        }
        return billsIO;
    }

    private void appendBizBillDim(Map<String, String> calBillFieldBizBillFieldMap, StringBuilder sb) {
        for (String dim : this.groupDims) {
            if ("ematerialnum".equals(dim)) continue;
            String key = this.rptDimCalBillDimMap.get(dim);
            String bizBillField = calBillFieldBizBillFieldMap.get(key);
            if (StringUtils.isEmpty((CharSequence)bizBillField)) {
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cal_incalbill").getProperty(key);
                if (property instanceof BasedataProp) {
                    sb.append("0");
                } else if (property instanceof TextProp) {
                    sb.append("''");
                } else {
                    sb.append(bizBillField);
                }
            } else {
                if ("ematerial".equals(dim)) {
                    bizBillField = this.getInvMaterialMasterId(bizBillField);
                }
                sb.append(bizBillField);
            }
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
            if (!"ematerial".equals(dim)) continue;
            sb.append("'' as ematerialnum,");
        }
    }

    private List<QFilter> getInvBaseFilter(Map<String, String> calFieldBizFieldMap) {
        List<Object> matIds;
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.rptParams.getEnddate());
        calendar.set(5, 1);
        Date firstDayOfMonth = calendar.getTime();
        String orgField = calFieldBizFieldMap.get("org");
        baseFilters.add(new QFilter(orgField, "in", this.getOrgIds()));
        String bizTimeField = calFieldBizFieldMap.get("bookdate");
        baseFilters.add(new QFilter(bizTimeField, "<=", (Object)this.rptParams.getEnddate()));
        baseFilters.add(new QFilter(bizTimeField, ">=", (Object)DateUtils.getDayStartTime((Date)firstDayOfMonth)));
        String bizTypeField = calFieldBizFieldMap.get("biztype");
        baseFilters.add(new QFilter(bizTypeField, "not in", (Object)CommonSettingHelper.getNotUpdBalBizType()));
        String isInitBillField = calFieldBizFieldMap.get("isinitbill");
        if (StringUtils.isNotEmpty((CharSequence)isInitBillField)) {
            baseFilters.add(new QFilter(isInitBillField, "=", (Object)false));
        }
        String ownerField = calFieldBizFieldMap.get("owner");
        baseFilters.add(new QFilter(ownerField, "in", (Object)this.rptParams.getOwners()));
        String ownerTypeField = calFieldBizFieldMap.get("ownertype");
        baseFilters.add(new QFilter(ownerTypeField, "=", (Object)"bos_org"));
        List<Object> warehouseIds = this.getDycsIds(this.rptParams.getWarehouse());
        if (warehouseIds.size() > 0) {
            String warehouseField = calFieldBizFieldMap.get("warehouse");
            baseFilters.add(new QFilter(warehouseField, "in", warehouseIds));
        }
        if ((matIds = this.getDycsIds(this.rptParams.getMaterialIds())).size() > 0) {
            String materialField = calFieldBizFieldMap.get("material");
            materialField = this.getInvMaterialMasterId(materialField);
            baseFilters.add(new QFilter(materialField, "in", matIds));
        }
        return baseFilters;
    }

    private DataSet unionDataSet(DataSet oneDataSet, DataSet otherDataSet) {
        oneDataSet = oneDataSet == null ? otherDataSet : (otherDataSet == null ? oneDataSet : oneDataSet.union(otherDataSet));
        return oneDataSet;
    }

    private List<Object> getDycsIds(DynamicObjectCollection dycs) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (dycs != null) {
            for (DynamicObject item : dycs) {
                ids.add(item.getPkValue());
            }
        }
        return ids;
    }

    private String getInvMaterialMasterId(String materialField) {
        if (materialField.contains("billentry.material.masterid")) {
            materialField = "billentry.materialmasterid";
        } else if (materialField.contains("billentry.afterentity.material1.masterid")) {
            materialField = "billentry.afterentity.materialmasterid1";
        }
        return materialField;
    }

    private DataSet queryMatNum(DataSet unionDataSet) {
        DataSet ematerialDs = unionDataSet.copy().groupBy(new String[]{"ematerial"}).finish();
        HashSet<Object> matIds = new HashSet<Object>(16);
        QFilter matFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (Row row : ematerialDs) {
            matIds.add(row.get("ematerial"));
        }
        if (matIds.size() < 500000) {
            matFilter = new QFilter("id", "in", matIds);
        }
        DataSet matDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{matFilter}, null);
        String[] fieldNames = unionDataSet.getRowMeta().getFieldNames();
        ArrayList<String> newFieldNames = new ArrayList<String>(fieldNames.length);
        for (String item : fieldNames) {
            if (item.equals("ematerialnum")) {
                item = "number as ematerialnum";
            }
            newFieldNames.add(item);
        }
        unionDataSet = unionDataSet.join(matDs).on("ematerial", "id").select(newFieldNames.toArray(new String[0])).finish();
        return unionDataSet;
    }
}

