/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.model.CalBillRule;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.report.queryplugin.InvCKAccountRptQueryPlugin;
import kd.fi.cal.report.queryplugin.InvCKCostCKCalRptParams;

public class InvCKCostCKCalRptQueryPlugin
extends AbstractReportListDataPlugin {
    private InvCKCostCKCalRptParams rptParams = null;
    private List<String> groupDims;
    private Map<String, List<CalBillRule>> inCalBillRuleMap = new HashMap<String, List<CalBillRule>>(16);
    private Map<String, List<CalBillRule>> outCalBillRuleMap = new HashMap<String, List<CalBillRule>>(16);
    private Map<String, List<CalBillRule>> initCalBillRuleMap = new HashMap<String, List<CalBillRule>>(16);
    private Map<String, String> rptDimCalBillDimMap = new HashMap<String, String>(16);

    public DataSet query(ReportQueryParam queryParam, Object paramObject) {
        this.init(queryParam);
        List<OrmInput> invBillIOs = this.getInvBillDataSet();
        List<OrmInput> calBillIOs = this.getCalBalanceDataSet();
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        if (invBillIOs.size() == 0) {
            RowMeta rowMeta = new RowMeta(new Field[]{new Field("storageorgunit", (DataType)DateType.LongType), new Field("ematerial", (DataType)DateType.LongType)});
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta).build();
        }
        invBillIOs.addAll(calBillIOs);
        ArrayList<OrmInput> newInvBillIOs = new ArrayList<OrmInput>(16);
        OrmInput firstOrmInput = invBillIOs.get(0);
        RowMeta rowMeta = ORM.create().createRowMeta(firstOrmInput.getEntityName(), firstOrmInput.getSelectFields());
        rowMeta.getField("ebiztype").setDataType((DataType)DataType.LongType);
        rowMeta.getField("einvscheme").setDataType((DataType)DataType.LongType);
        rowMeta.getField("invqty").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("eseq").setDataType((DataType)DataType.IntegerType);
        rowMeta.getField("calqty").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("calprice").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("calamount").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("ebilltype").setDataType((DataType)DataType.StringType);
        for (OrmInput invBillIO : invBillIOs) {
            OrmInput curInput = new OrmInput(invBillIO.getAlgoKey(), invBillIO.getEntityName(), invBillIO.getSelectFields(), invBillIO.getFilters(), rowMeta);
            newInvBillIOs.add(curInput);
        }
        invBillIOs = newInvBillIOs;
        DataSet invUnionCalDataSet = algo.createDataSet((Input[])invBillIOs.toArray(new OrmInput[invBillIOs.size()]));
        invUnionCalDataSet.getRowMeta().getField("inouttype").setDataType((DataType)DataType.StringType);
        invUnionCalDataSet = invUnionCalDataSet.groupBy(new String[]{"estorageorg", "ematerial", "ematerialnum", "ebaseunit", "bizbillno", "einvtype", "eownertype", "eowner", "ewarehs", "elocation", "ebilltype", "eentryid", "inouttype", "calbillno"}).max("ebiztype").max("einvscheme").max("invqty").max("eseq").max("calqty").max("calprice").max("calamount").finish();
        invUnionCalDataSet = invUnionCalDataSet.addField("case when calqty <> invqty then '0' else '1' end", "balance");
        invUnionCalDataSet = invUnionCalDataSet.addField("case when calqty is not null then invqty - calqty else invqty end", "invcalcheck");
        invUnionCalDataSet.getRowMeta().getField("balance").setDataType((DataType)DataType.BooleanType);
        invUnionCalDataSet.getRowMeta().getField("invcalcheck").setDataType((DataType)DataType.BigDecimalType);
        if (this.rptParams.isShowcostdata()) {
            List<OrmInput> costBillIOs = this.getCostDataSet();
            DataSet costDataSet = algo.createDataSet((Input[])costBillIOs.toArray(new OrmInput[costBillIOs.size()]));
            costDataSet = costDataSet.groupBy(new String[]{"costbillno", "sourcebillentry", "ecostobject", "costqty"}).sum("costprice").sum("costamount").finish();
            invUnionCalDataSet = invUnionCalDataSet.leftJoin(costDataSet).on("eentryid", "sourcebillentry").select(new String[]{"estorageorg", "ematerial", "ematerialnum", "ebaseunit", "bizbillno", "einvtype", "eownertype", "eowner", "ewarehs", "elocation", "ebiztype", "einvscheme", "invqty", "ebilltype", "eentryid", "eseq", "calbillno", "calqty", "calprice", "calamount"}, new String[]{"costqty", "costbillno", "ecostobject", "costprice", "costamount"}).finish();
            invUnionCalDataSet = invUnionCalDataSet.addField("case when calqty <> invqty or costqty <> invqty or costqty <> calqty or calamount <> costamount then '0' else '1' end", "balance");
            invUnionCalDataSet = invUnionCalDataSet.addField("case when calqty is not null then invqty - calqty else invqty end", "invcalcheck");
            invUnionCalDataSet = invUnionCalDataSet.addField("case when costqty is not null then invqty - costqty else invqty end", "invcostxcheck");
            invUnionCalDataSet = invUnionCalDataSet.addField("case when costqty is not null then costqty - calqty else calqty end", "costcalckamount");
            invUnionCalDataSet = invUnionCalDataSet.addField("case when costamount is not null then costamount - calamount else calamount end", "costcalckprice");
            invUnionCalDataSet.getRowMeta().getField("balance").setDataType((DataType)DataType.BooleanType);
            invUnionCalDataSet.getRowMeta().getField("invcalcheck").setDataType((DataType)DataType.BigDecimalType);
            invUnionCalDataSet.getRowMeta().getField("invcostxcheck").setDataType((DataType)DataType.BigDecimalType);
            invUnionCalDataSet.getRowMeta().getField("costcalckamount").setDataType((DataType)DataType.BigDecimalType);
            invUnionCalDataSet.getRowMeta().getField("costcalckprice").setDataType((DataType)DataType.BigDecimalType);
            DynamicObjectCollection costobjectDys = this.rptParams.getCostobject();
            if (costobjectDys != null && !costobjectDys.isEmpty()) {
                HashSet<Long> costobjectSet = new HashSet<Long>();
                for (DynamicObject costobject : costobjectDys) {
                    costobjectSet.add(costobject.getLong("id"));
                }
                invUnionCalDataSet = invUnionCalDataSet.filter(new QFilter("ecostobject", "in", costobjectSet).toString());
            }
        }
        if (this.rptParams.isOnlyshowerror()) {
            invUnionCalDataSet = this.rptParams.isShowcostdata() ? invUnionCalDataSet.filter("calqty <> invqty or costqty <> invqty or costqty <> calqty or calamount <> costamount") : invUnionCalDataSet.filter("calqty <> invqty");
        }
        invUnionCalDataSet.getRowMeta().getField("ebilltype").setDataType((DataType)DataType.StringType);
        invUnionCalDataSet.getRowMeta().getField("einvscheme").setDataType((DataType)DataType.LongType);
        invUnionCalDataSet = invUnionCalDataSet.addField(String.valueOf(this.rptParams.getCurrency().getLong("id")), "currencyid");
        invUnionCalDataSet.getRowMeta().getField("currencyid").setDataType((DataType)DataType.LongType);
        return invUnionCalDataSet;
    }

    protected List<OrmInput> getInvBillDataSet() {
        ArrayList<OrmInput> invBillIOs = new ArrayList<OrmInput>(16);
        List<OrmInput> invInitBillIOs = this.getInvInitQtyDataSet();
        invBillIOs.addAll(invInitBillIOs);
        List<OrmInput> invRecBillIOs = this.getInvRecQtyDataSet();
        invBillIOs.addAll(invRecBillIOs);
        List<OrmInput> invSedBillIOs = this.getInvSedQtyDataSet();
        invBillIOs.addAll(invSedBillIOs);
        return invBillIOs;
    }

    protected List<OrmInput> getInvInitQtyDataSet() {
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(this.initCalBillRuleMap.size());
        List<String> orderShowFields = this.getOrderShowFields();
        HashMap<String, String> rptShowFieldCalBillFieldMap = new HashMap<String, String>(16);
        rptShowFieldCalBillFieldMap.put("estorageorg", "storageorgunit");
        rptShowFieldCalBillFieldMap.put("ematerial", "material");
        rptShowFieldCalBillFieldMap.put("ebaseunit", "baseunit");
        rptShowFieldCalBillFieldMap.put("bizbillno", "billno");
        rptShowFieldCalBillFieldMap.put("einvtype", "invtype");
        rptShowFieldCalBillFieldMap.put("eownertype", "ownertype");
        rptShowFieldCalBillFieldMap.put("eowner", "owner");
        rptShowFieldCalBillFieldMap.put("ewarehs", "warehouse");
        rptShowFieldCalBillFieldMap.put("elocation", "location");
        rptShowFieldCalBillFieldMap.put("invqty", "baseqty");
        rptShowFieldCalBillFieldMap.put("calbillno", "billno");
        for (Map.Entry<String, List<CalBillRule>> item : this.initCalBillRuleMap.entrySet()) {
            for (CalBillRule initCalBillRule : item.getValue()) {
                StringBuilder sb = new StringBuilder();
                Map initCalBizFieldMap = initCalBillRule.getCalBizFieldMap();
                for (String orderShowField : orderShowFields) {
                    String baseQtyField;
                    if ("ematerialnum".equals(orderShowField)) continue;
                    if ("ebilltype".equals(orderShowField)) {
                        sb.append("'");
                        sb.append(item.getKey());
                        sb.append("'");
                        sb.append(" as ebilltype,");
                        continue;
                    }
                    if ("ebiztype".equals(orderShowField)) {
                        sb.append("id - id as ebiztype,");
                        continue;
                    }
                    if ("eseq".equals(orderShowField)) {
                        sb.append(((String)initCalBizFieldMap.get("baseqty")).replace("1", "").replace("baseqty", "seq"));
                        sb.append(" as eseq,");
                        continue;
                    }
                    if ("eentryid".equals(orderShowField)) {
                        sb.append(((String)initCalBizFieldMap.get("baseqty")).replace("1", "").replace("baseqty", "id"));
                        sb.append(" as eentryid,");
                        continue;
                    }
                    if ("inouttype".equals(orderShowField)) {
                        sb.append("'IN' as inouttype,");
                        continue;
                    }
                    if ("ematerial".equals(orderShowField)) {
                        String matField = (String)initCalBizFieldMap.get(rptShowFieldCalBillFieldMap.get("ematerial"));
                        sb.append(matField);
                        sb.append(" as ");
                        sb.append(orderShowField);
                        sb.append(",");
                        sb.append(matField);
                        sb.append(".number as ematerialnum,");
                        continue;
                    }
                    if ("einvscheme".equals(orderShowField)) {
                        sb.append("id - id as einvscheme,");
                        continue;
                    }
                    if ("calprice".equals(orderShowField)) {
                        baseQtyField = (String)initCalBizFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calprice,");
                        continue;
                    }
                    if ("calqty".equals(orderShowField)) {
                        baseQtyField = (String)initCalBizFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calqty,");
                        continue;
                    }
                    if ("calamount".equals(orderShowField)) {
                        baseQtyField = (String)initCalBizFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calamount,");
                        continue;
                    }
                    String calBillField = (String)rptShowFieldCalBillFieldMap.get(orderShowField);
                    String invBillField = (String)initCalBizFieldMap.get(calBillField);
                    if (StringUtils.isEmpty((CharSequence)invBillField)) {
                        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cal_initbill").getProperty(calBillField);
                        if (property instanceof BasedataProp) {
                            sb.append("0");
                        } else if (property instanceof TextProp) {
                            sb.append("''");
                        } else {
                            sb.append(invBillField);
                        }
                    } else {
                        sb.append(invBillField);
                    }
                    sb.append(" as ");
                    sb.append(orderShowField);
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                List<QFilter> filters = this.getInvBaseFilter(initCalBizFieldMap, true);
                filters.addAll(initCalBillRule.getBillFilters());
                filters.add(new QFilter("billstatus", "=", (Object)"C"));
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + item.getKey(), item.getKey(), sb.toString(), filters.toArray(new QFilter[0]));
                this.setFieldType(billIO);
                billsIO.add(billIO);
            }
        }
        return billsIO;
    }

    private void setFieldType(OrmInput billIO) {
        billIO.getRowMeta().getField("ebiztype").setDataType((DataType)DataType.LongType);
        billIO.getRowMeta().getField("einvscheme").setDataType((DataType)DataType.LongType);
        billIO.getRowMeta().getField("invqty").setDataType((DataType)DataType.BigDecimalType);
        billIO.getRowMeta().getField("eseq").setDataType((DataType)DataType.IntegerType);
        billIO.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
        billIO.getRowMeta().getField("calprice").setDataType((DataType)DataType.BigDecimalType);
        billIO.getRowMeta().getField("calamount").setDataType((DataType)DataType.BigDecimalType);
        billIO.getRowMeta().getField("ebilltype").setDataType((DataType)DataType.StringType);
    }

    protected List<OrmInput> getInvRecQtyDataSet() {
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(this.inCalBillRuleMap.size());
        List<String> orderShowFields = this.getOrderShowFields();
        HashMap<String, String> rptShowFieldCalBillFieldMap = new HashMap<String, String>(16);
        rptShowFieldCalBillFieldMap.put("estorageorg", "org");
        rptShowFieldCalBillFieldMap.put("ematerial", "material");
        rptShowFieldCalBillFieldMap.put("ebaseunit", "baseunit");
        rptShowFieldCalBillFieldMap.put("bizbillno", "billno");
        rptShowFieldCalBillFieldMap.put("einvtype", "invtype");
        rptShowFieldCalBillFieldMap.put("eownertype", "ownertype");
        rptShowFieldCalBillFieldMap.put("eowner", "owner");
        rptShowFieldCalBillFieldMap.put("ewarehs", "warehouse");
        rptShowFieldCalBillFieldMap.put("elocation", "location");
        rptShowFieldCalBillFieldMap.put("ebiztype", "biztype");
        rptShowFieldCalBillFieldMap.put("einvscheme", "invscheme");
        rptShowFieldCalBillFieldMap.put("invqty", "baseqty");
        rptShowFieldCalBillFieldMap.put("calbillno", "billno");
        for (Map.Entry<String, List<CalBillRule>> item : this.inCalBillRuleMap.entrySet()) {
            String formId = item.getKey();
            for (CalBillRule inCalBillRule : item.getValue()) {
                StringBuilder sb = new StringBuilder();
                Map initCalBillInitInvBillFieldMap = inCalBillRule.getCalBizFieldMap();
                for (String orderShowField : orderShowFields) {
                    String baseQtyField;
                    if ("ematerialnum".equals(orderShowField)) continue;
                    if ("ebilltype".equals(orderShowField)) {
                        sb.append("'");
                        sb.append(item.getKey());
                        sb.append("'");
                        sb.append(" as ebilltype,");
                        continue;
                    }
                    if ("eseq".equals(orderShowField)) {
                        sb.append(((String)initCalBillInitInvBillFieldMap.get("baseqty")).replace("1", "").replace("baseqty", "seq"));
                        sb.append(" as eseq,");
                        continue;
                    }
                    if ("eentryid".equals(orderShowField)) {
                        sb.append(((String)initCalBillInitInvBillFieldMap.get("baseqty")).replace("1", "").replace("baseqty", "id"));
                        sb.append(" as eentryid,");
                        continue;
                    }
                    if ("inouttype".equals(orderShowField)) {
                        sb.append("'IN' as inouttype,");
                        continue;
                    }
                    if ("ematerial".equals(orderShowField)) {
                        String matField = (String)initCalBillInitInvBillFieldMap.get(rptShowFieldCalBillFieldMap.get("ematerial"));
                        sb.append(matField);
                        sb.append(" as ");
                        sb.append(orderShowField);
                        sb.append(",");
                        sb.append((String)initCalBillInitInvBillFieldMap.get(rptShowFieldCalBillFieldMap.get("ematerial")));
                        sb.append(".number as ematerialnum,");
                        continue;
                    }
                    if ("calprice".equals(orderShowField)) {
                        baseQtyField = (String)initCalBillInitInvBillFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calprice,");
                        continue;
                    }
                    if ("calqty".equals(orderShowField)) {
                        baseQtyField = (String)initCalBillInitInvBillFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calqty,");
                        continue;
                    }
                    if ("calamount".equals(orderShowField)) {
                        baseQtyField = (String)initCalBillInitInvBillFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calamount,");
                        continue;
                    }
                    String calBillField = (String)rptShowFieldCalBillFieldMap.get(orderShowField);
                    String invBillField = (String)initCalBillInitInvBillFieldMap.get(calBillField);
                    if (StringUtils.isEmpty((CharSequence)invBillField)) {
                        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cal_initbill").getProperty(calBillField);
                        if (property instanceof BasedataProp) {
                            sb.append("0");
                        } else if (property instanceof TextProp) {
                            sb.append("''");
                        } else {
                            sb.append(invBillField);
                        }
                    } else {
                        sb.append(invBillField);
                    }
                    sb.append(" as ");
                    sb.append(orderShowField);
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                List<QFilter> filters = this.getInvBaseFilter(initCalBillInitInvBillFieldMap, false);
                filters.addAll(inCalBillRule.getBillFilters());
                if (formId.contains("im_mdc_")) {
                    filters.add(new QFilter("billtype.billformid.number", "=", (Object)formId));
                }
                filters.add(new QFilter("billstatus", "=", (Object)"C"));
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + item.getKey(), item.getKey(), sb.toString(), filters.toArray(new QFilter[0]));
                this.setFieldType(billIO);
                billsIO.add(billIO);
            }
        }
        return billsIO;
    }

    protected List<OrmInput> getInvSedQtyDataSet() {
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(this.outCalBillRuleMap.size());
        List<String> orderShowFields = this.getOrderShowFields();
        HashMap<String, String> rptShowFieldCalBillFieldMap = new HashMap<String, String>(16);
        rptShowFieldCalBillFieldMap.put("estorageorg", "org");
        rptShowFieldCalBillFieldMap.put("ematerial", "material");
        rptShowFieldCalBillFieldMap.put("ebaseunit", "baseunit");
        rptShowFieldCalBillFieldMap.put("bizbillno", "billno");
        rptShowFieldCalBillFieldMap.put("einvtype", "invtype");
        rptShowFieldCalBillFieldMap.put("eownertype", "ownertype");
        rptShowFieldCalBillFieldMap.put("eowner", "owner");
        rptShowFieldCalBillFieldMap.put("ewarehs", "warehouse");
        rptShowFieldCalBillFieldMap.put("elocation", "location");
        rptShowFieldCalBillFieldMap.put("ebiztype", "biztype");
        rptShowFieldCalBillFieldMap.put("einvscheme", "invscheme");
        rptShowFieldCalBillFieldMap.put("invqty", "baseqty");
        rptShowFieldCalBillFieldMap.put("calbillno", "billno");
        for (Map.Entry<String, List<CalBillRule>> item : this.outCalBillRuleMap.entrySet()) {
            String formId = item.getKey();
            for (CalBillRule outCalBillRule : item.getValue()) {
                StringBuilder sb = new StringBuilder();
                Map initCalBizFieldMap = outCalBillRule.getCalBizFieldMap();
                for (String orderShowField : orderShowFields) {
                    String baseQtyField;
                    if ("ematerialnum".equals(orderShowField)) continue;
                    if ("ebilltype".equals(orderShowField)) {
                        sb.append("'");
                        sb.append(item.getKey());
                        sb.append("'");
                        sb.append(" as ebilltype,");
                        continue;
                    }
                    if ("eseq".equals(orderShowField)) {
                        sb.append(((String)initCalBizFieldMap.get("baseqty")).replace("1", "").replace("baseqty", "seq"));
                        sb.append(" as eseq,");
                        continue;
                    }
                    if ("eentryid".equals(orderShowField)) {
                        sb.append(((String)initCalBizFieldMap.get("baseqty")).replace("1", "").replace("baseqty", "id"));
                        sb.append(" as eentryid,");
                        continue;
                    }
                    if ("inouttype".equals(orderShowField)) {
                        sb.append("'OUT' as inouttype,");
                        continue;
                    }
                    if ("ematerial".equals(orderShowField)) {
                        String matField = (String)initCalBizFieldMap.get(rptShowFieldCalBillFieldMap.get("ematerial"));
                        sb.append(matField);
                        sb.append(" as ");
                        sb.append(orderShowField);
                        sb.append(",");
                        sb.append((String)initCalBizFieldMap.get(rptShowFieldCalBillFieldMap.get("ematerial")));
                        sb.append(".number as ematerialnum,");
                        continue;
                    }
                    if ("calprice".equals(orderShowField)) {
                        baseQtyField = (String)initCalBizFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calprice,");
                        continue;
                    }
                    if ("calqty".equals(orderShowField)) {
                        baseQtyField = (String)initCalBizFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calqty,");
                        continue;
                    }
                    if ("calamount".equals(orderShowField)) {
                        baseQtyField = (String)initCalBizFieldMap.get("baseqty");
                        sb.append(baseQtyField);
                        sb.append(" - ");
                        sb.append(baseQtyField);
                        sb.append(" as calamount,");
                        continue;
                    }
                    String calBillField = (String)rptShowFieldCalBillFieldMap.get(orderShowField);
                    String invBillField = (String)initCalBizFieldMap.get(calBillField);
                    if (StringUtils.isEmpty((CharSequence)invBillField)) {
                        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cal_initbill").getProperty(calBillField);
                        if (property instanceof BasedataProp) {
                            sb.append("0");
                        } else if (property instanceof TextProp) {
                            sb.append("''");
                        } else {
                            sb.append(invBillField);
                        }
                    } else {
                        sb.append(invBillField);
                    }
                    sb.append(" as ");
                    sb.append(orderShowField);
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                List<QFilter> filters = this.getInvBaseFilter(initCalBizFieldMap, false);
                filters.addAll(outCalBillRule.getBillFilters());
                if (formId.contains("im_mdc_")) {
                    filters.add(new QFilter("billtype.billformid.number", "=", (Object)formId));
                }
                filters.add(new QFilter("billstatus", "=", (Object)"C"));
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + item.getKey(), item.getKey(), sb.toString(), filters.toArray(new QFilter[0]));
                this.setFieldType(billIO);
                billsIO.add(billIO);
            }
        }
        return billsIO;
    }

    private List<QFilter> getInvBaseFilter(Map<String, String> calFieldBizFieldMap, boolean isInitBill) {
        String bizTypeField;
        Date enddate1;
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        baseFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        String orgField = isInitBill ? calFieldBizFieldMap.get("storageorgunit") : calFieldBizFieldMap.get("org");
        baseFilters.add(new QFilter(orgField, "in", this.getOrgIds()));
        String bizTimeField = calFieldBizFieldMap.get("bookdate");
        Date startdate1 = this.rptParams.getStartdate();
        if (startdate1 != null) {
            Calendar startdate = Calendar.getInstance();
            startdate.setTime(startdate1);
            Date startdateTime = startdate.getTime();
            baseFilters.add(new QFilter(bizTimeField, ">=", (Object)DateUtils.getDayStartTime((Date)startdateTime)));
        }
        if ((enddate1 = this.rptParams.getEnddate()) != null) {
            baseFilters.add(new QFilter(bizTimeField, "<=", (Object)enddate1));
        }
        if (StringUtils.isNotEmpty((CharSequence)(bizTypeField = calFieldBizFieldMap.get("biztype")))) {
            baseFilters.add(new QFilter(bizTypeField, "not in", (Object)CommonSettingHelper.getNotUpdBalBizType()));
        }
        String ownerField = calFieldBizFieldMap.get("owner");
        baseFilters.add(new QFilter(ownerField, "in", (Object)this.rptParams.getOwners()));
        String ownerTypeField = calFieldBizFieldMap.get("ownertype");
        baseFilters.add(new QFilter(ownerTypeField, "=", (Object)"bos_org"));
        String storagebillnos = this.rptParams.getStoragebillnos();
        if (storagebillnos != null && !storagebillnos.isEmpty()) {
            String materialField = calFieldBizFieldMap.get("billno");
            String[] storagebillnoArray = storagebillnos.split(",");
            baseFilters.add(new QFilter(materialField, "in", (Object)storagebillnoArray));
        }
        DynamicObjectCollection filter_materialFrom = this.rptParams.getMaterialfrom();
        DynamicObject filter_materialTo = this.rptParams.getMaterialto();
        String material = calFieldBizFieldMap.get("material");
        if (filter_materialFrom != null && !filter_materialFrom.isEmpty()) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                baseFilters.add(new QFilter(material, "in", materialSet));
            } else if (filter_materialFrom.size() == 1) {
                baseFilters.add(new QFilter(material + ".number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number")));
            }
        }
        if (filter_materialTo != null) {
            baseFilters.add(new QFilter(material + ".number", "<=", (Object)filter_materialTo.getString("number")));
        }
        return baseFilters;
    }

    protected List<Object> getOrgIds() {
        ArrayList<Object> orgIds = new ArrayList<Object>();
        for (DynamicObject item : this.rptParams.getStorageOrgUnit()) {
            orgIds.add(item.getPkValue());
        }
        return orgIds;
    }

    private List<Object> getDycsIds(DynamicObjectCollection dycs) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (dycs != null) {
            for (DynamicObject item : dycs) {
                ids.add(item.getPkValue());
            }
        }
        return ids;
    }

    private void initCalBillRules(DynamicObject[] calBillRuleDycs) {
        this.initCalDimMap();
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadRulesWithInitBill(calBillRuleDycs);
        this.inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        this.outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
        this.initCalBillRuleMap = calBillRuleHelper.getInitCalBillRuleMap();
    }

    private void initCalDimMap() {
        this.rptDimCalBillDimMap.put("estorageorg", "org");
        this.rptDimCalBillDimMap.put("ematerial", "material");
        this.rptDimCalBillDimMap.put("bizbillno", "billno");
        this.rptDimCalBillDimMap.put("ebaseunit", "baseunit");
        this.rptDimCalBillDimMap.put("ewarehs", "warehouse");
        this.rptDimCalBillDimMap.put("elocation", "location");
        this.rptDimCalBillDimMap.put("eownertype", "ownertype");
        this.rptDimCalBillDimMap.put("eowner", "owner");
        this.rptDimCalBillDimMap.put("einvtype", "invtype");
        this.rptDimCalBillDimMap.put("ebiztype", "biztype");
        this.rptDimCalBillDimMap.put("einvscheme", "invscheme");
    }

    private void init(ReportQueryParam param) {
        this.rptParams = new InvCKCostCKCalRptParams();
        FilterInfo filterInfo = param.getFilter();
        DynamicObjectCollection ruleDycs = filterInfo.getDynamicObjectCollection("billtype");
        ArrayList<Long> billRuleIds = new ArrayList<Long>(16);
        for (DynamicObject item : ruleDycs) {
            Long billRuleId = item.getLong("id");
            billRuleIds.add(billRuleId);
        }
        DynamicObjectCollection billRules = QueryServiceHelper.query((String)"cal_calbillrule", (String)"id", (QFilter[])new QFilter("id", "in", billRuleIds).toArray());
        this.rptParams.setBilltype(billRules);
        this.initCalBillRules((DynamicObject[])this.rptParams.getBilltype().toArray((Object[])new DynamicObject[0]));
        this.rptParams.setStorageOrgUnit(filterInfo.getDynamicObjectCollection("storageorg"));
        this.rptParams.setCostAccount(filterInfo.getDynamicObject("costaccount"));
        this.rptParams.setCurrency(filterInfo.getDynamicObject("currency"));
        this.rptParams.setStartdate(filterInfo.getDate("startdate"));
        this.rptParams.setEnddate(DateUtils.getDayEndTime((Date)filterInfo.getDate("enddate")));
        this.rptParams.setStoragebillnos(filterInfo.getString("storagebillnos"));
        this.rptParams.setMaterialfrom(filterInfo.getDynamicObjectCollection("materialfrom"));
        this.rptParams.setCostobject(filterInfo.getDynamicObjectCollection("costobject"));
        this.rptParams.setMaterialto(filterInfo.getDynamicObject("materialto"));
        this.rptParams.setShowcostdata(filterInfo.getBoolean("showcostdata"));
        this.rptParams.setOnlyshowerror(filterInfo.getBoolean("onlyshowerror"));
        this.rptParams.setOwners(AccountingSysHelper.getOwners((Long)this.rptParams.getCostAccount().getLong("id")));
        this.groupDims = new ArrayList<String>(Arrays.asList(this.getGroupFields()));
    }

    private String getCalInitSelector() {
        HashMap<String, String> rptDimBillDimMap = new HashMap<String, String>(16);
        rptDimBillDimMap.put("estorageorg", "entryentity.storageorgunit");
        rptDimBillDimMap.put("ematerial", "entryentity.material");
        rptDimBillDimMap.put("ematerialnum", "entryentity.material.number");
        rptDimBillDimMap.put("ebaseunit", "entryentity.baseunit");
        rptDimBillDimMap.put("bizbillno", "billno");
        rptDimBillDimMap.put("einvtype", "entryentity.invtype");
        rptDimBillDimMap.put("eownertype", "entryentity.ownertype");
        rptDimBillDimMap.put("eowner", "entryentity.owner");
        rptDimBillDimMap.put("ewarehs", "entryentity.warehouse");
        rptDimBillDimMap.put("elocation", "entryentity.location");
        rptDimBillDimMap.put("ebiztype", "id-id");
        rptDimBillDimMap.put("einvscheme", "id-id");
        rptDimBillDimMap.put("invqty", "entryentity.baseqty - entryentity.baseqty");
        rptDimBillDimMap.put("ebilltype", "'im_initbill'");
        rptDimBillDimMap.put("eentryid", "entryentity.bizbillentryid");
        rptDimBillDimMap.put("inouttype", "'IN'");
        rptDimBillDimMap.put("eseq", "entryentity.seq");
        rptDimBillDimMap.put("calbillno", "billno");
        rptDimBillDimMap.put("calqty", "entryentity.baseqty");
        rptDimBillDimMap.put("calprice", "entryentity.price");
        rptDimBillDimMap.put("calamount", "entryentity.amount");
        StringBuilder sb = new StringBuilder();
        for (String orderShowField : this.getOrderShowFields()) {
            String billField = (String)rptDimBillDimMap.get(orderShowField);
            sb.append(billField);
            sb.append(" as ");
            sb.append(orderShowField);
            sb.append(",");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private List<String> getOrderShowFields() {
        ArrayList<String> orderShowFields = new ArrayList<String>(16);
        orderShowFields.add("estorageorg");
        orderShowFields.add("ematerial");
        orderShowFields.add("ematerialnum");
        orderShowFields.add("ebaseunit");
        orderShowFields.add("bizbillno");
        orderShowFields.add("einvtype");
        orderShowFields.add("eownertype");
        orderShowFields.add("eowner");
        orderShowFields.add("ewarehs");
        orderShowFields.add("elocation");
        orderShowFields.add("ebiztype");
        orderShowFields.add("einvscheme");
        orderShowFields.add("invqty");
        orderShowFields.add("ebilltype");
        orderShowFields.add("eentryid");
        orderShowFields.add("inouttype");
        orderShowFields.add("eseq");
        orderShowFields.add("calbillno");
        orderShowFields.add("calqty");
        orderShowFields.add("calprice");
        orderShowFields.add("calamount");
        return orderShowFields;
    }

    private String getCalRecordSelector(boolean isRec) {
        LinkedHashMap<String, String> rptDimBillDimMap = new LinkedHashMap<String, String>(16, 0.75f, false);
        rptDimBillDimMap.put("estorageorg", "storageorgunit");
        rptDimBillDimMap.put("ematerial", "entry.material");
        rptDimBillDimMap.put("ematerialnum", "entry.material.number");
        rptDimBillDimMap.put("ebaseunit", "entry.baseunit");
        rptDimBillDimMap.put("bizbillno", "billnumber");
        rptDimBillDimMap.put("einvtype", "entry.invtype");
        rptDimBillDimMap.put("eownertype", "entry.ownertype");
        rptDimBillDimMap.put("eowner", "entry.owner");
        rptDimBillDimMap.put("ewarehs", "entry.warehouse");
        rptDimBillDimMap.put("elocation", "entry.location");
        rptDimBillDimMap.put("ebiztype", "biztype");
        rptDimBillDimMap.put("einvscheme", "invscheme");
        rptDimBillDimMap.put("invqty", "entry.baseqty - entry.baseqty");
        rptDimBillDimMap.put("ebilltype", "bizentityobject");
        rptDimBillDimMap.put("eentryid", "entry.bizbillentryid");
        if (isRec) {
            rptDimBillDimMap.put("inouttype", "'IN'");
        } else {
            rptDimBillDimMap.put("inouttype", "'OUT'");
        }
        rptDimBillDimMap.put("eseq", "entry.seq - entry.seq");
        rptDimBillDimMap.put("calbillno", "billnumber");
        rptDimBillDimMap.put("calqty", "entry.baseqty");
        StringBuilder sb = new StringBuilder();
        for (String orderShowField : this.getOrderShowFields()) {
            if ("calamount".equals(orderShowField)) {
                sb.append("(case when entry.accounttype = 'D' then entry.standardcost else entry.actualcost end ) as calamount,");
                continue;
            }
            if ("calprice".equals(orderShowField)) {
                sb.append("(case when entry.accounttype = 'D' then entry.unitstandardcost else entry.unitactualcost end ) as calprice,");
                continue;
            }
            String billField = (String)rptDimBillDimMap.get(orderShowField);
            sb.append(billField);
            sb.append(" as ");
            sb.append(orderShowField);
            sb.append(",");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    protected String[] getGroupFields() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("estorageorg,ematerial,ematerialnum,ebaseunit,bizbillno,einvtype,eownertype,eowner,ewarehs,elocation,ebiztype,einvscheme");
        return sb.toString().split(",");
    }

    private void appendBizBillDim(Map<String, String> calBillFieldBizBillFieldMap, StringBuilder sb, boolean isInitBill) {
        for (String dim : this.groupDims) {
            if ("ematerialnum".equals(dim)) continue;
            String key = this.rptDimCalBillDimMap.get(dim);
            String bizBillField = calBillFieldBizBillFieldMap.get(key);
            if ("estorageorg".equals(dim) && isInitBill) {
                bizBillField = calBillFieldBizBillFieldMap.get("storageorgunit");
            }
            if (StringUtils.isEmpty((CharSequence)bizBillField)) {
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cal_incalbill").getProperty(key);
                if (property instanceof BasedataProp) {
                    sb.append("0");
                } else if (property instanceof TextProp) {
                    sb.append("''");
                } else {
                    sb.append(bizBillField);
                }
            } else {
                sb.append(bizBillField);
            }
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
            if (!"ematerial".equals(dim)) continue;
            sb.append(bizBillField);
            sb.append(".number as ematerialnum,");
        }
    }

    protected List<OrmInput> getCalBalanceDataSet() {
        List<Object> orgIds = this.getOrgIds();
        ArrayList<OrmInput> calBillIOs = new ArrayList<OrmInput>(16);
        if (this.initCalBillRuleMap.size() > 0) {
            OrmInput calInitBillIO = this.getInitDs(orgIds);
            calBillIOs.add(calInitBillIO);
        }
        List<OrmInput> calRecBillIOs = this.getCalRecOrSedDs(orgIds, true);
        calBillIOs.addAll(calRecBillIOs);
        List<OrmInput> calSedBillIOs = this.getCalRecOrSedDs(orgIds, false);
        calBillIOs.addAll(calSedBillIOs);
        return calBillIOs;
    }

    protected OrmInput getInitDs(List<Object> orgIds) {
        Date enddate;
        String selectFields = this.getCalInitSelector();
        QFilter filter = new QFilter("entryentity.storageorgunit", "in", (Object)orgIds.toArray());
        Date startdate = this.rptParams.getStartdate();
        if (startdate != null) {
            filter.and(new QFilter("bookdate", ">=", (Object)startdate));
        }
        if ((enddate = this.rptParams.getEnddate()) != null) {
            filter.and(new QFilter("bookdate", "<=", (Object)enddate));
        }
        filter.and(new QFilter("costaccount", "=", this.rptParams.getCostAccount().getPkValue()));
        filter.and(new QFilter("entryentity.ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("entryentity.owner", "in", (Object)this.rptParams.getOwners()));
        List<Object> matIds = this.getDycsIds(this.rptParams.getMaterialfrom());
        if (matIds.size() > 0) {
            filter.and(new QFilter("entryentity.material", "in", matIds));
        }
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        String billNos = this.rptParams.getStoragebillnos();
        if (billNos != null && !billNos.isEmpty()) {
            filter.and(new QFilter("billno", "in", (Object)billNos));
        }
        OrmInput billIO = new OrmInput(InvCKAccountRptQueryPlugin.class + "getInitDs", "cal_initbill", selectFields, new QFilter[]{filter});
        this.setFieldType(billIO);
        return billIO;
    }

    protected List<OrmInput> getCalRecOrSedDs(List<Object> orgIds, boolean isRec) {
        OrmInput billIO;
        QFilter filterCopy;
        Date enddate;
        String selectFields = this.getCalRecordSelector(isRec);
        QFilter filter = new QFilter("storageorgunit", "in", (Object)orgIds.toArray());
        filter.and(new QFilter("issplitcreate", "=", (Object)false));
        filter.and(new QFilter("isinitbill", "=", (Object)false));
        Date startdate = this.rptParams.getStartdate();
        if (startdate != null) {
            filter.and(new QFilter("bookdate", ">=", (Object)startdate));
        }
        if ((enddate = this.rptParams.getEnddate()) != null) {
            filter.and(new QFilter("bookdate", "<=", (Object)enddate));
        }
        filter.and(new QFilter("costaccount", "=", this.rptParams.getCostAccount().getPkValue()));
        filter.and(new QFilter("calbilltype", "=", (Object)(isRec ? "IN" : "OUT")));
        filter.and(new QFilter("entry.ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("entry.owner", "in", (Object)this.rptParams.getOwners()));
        filter.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        HashSet<String> entityKeys = new HashSet<String>(16);
        entityKeys.addAll(this.inCalBillRuleMap.keySet());
        entityKeys.addAll(this.outCalBillRuleMap.keySet());
        filter.and(new QFilter("bizentityobject", "in", entityKeys));
        List<Object> matIds = this.getDycsIds(this.rptParams.getMaterialfrom());
        if (matIds.size() > 0) {
            filter.and(new QFilter("entry.material", "in", matIds));
        }
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        filter.and(billStatusf);
        String billNos = this.rptParams.getStoragebillnos();
        if (billNos != null && !billNos.isEmpty()) {
            filter.and(new QFilter("billnumber", "in", (Object)billNos));
        }
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        for (String inEntity : this.inCalBillRuleMap.keySet()) {
            filterCopy = filter.copy();
            filterCopy.and(new QFilter("bizentityobject", "=", (Object)inEntity));
            filterCopy.and(new QFilter("calbilltype", "=", (Object)"IN"));
            billIO = new OrmInput(InvCKAccountRptQueryPlugin.class + "getCalRecOrSedDs", "cal_costrecord", selectFields, new QFilter[]{filterCopy});
            this.setFieldType(billIO);
            billIOs.add(billIO);
        }
        for (String outEntity : this.outCalBillRuleMap.keySet()) {
            filterCopy = filter.copy();
            filterCopy.and(new QFilter("bizentityobject", "=", (Object)outEntity));
            filterCopy.and(new QFilter("calbilltype", "=", (Object)"OUT"));
            billIO = new OrmInput(InvCKAccountRptQueryPlugin.class + "getCalRecOrSedDs", "cal_costrecord", selectFields, new QFilter[]{filterCopy});
            this.setFieldType(billIO);
            billIOs.add(billIO);
        }
        return billIOs;
    }

    public DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)false);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    protected List<OrmInput> getCostDataSet() {
        ArrayList<OrmInput> costBillIOs = new ArrayList<OrmInput>(16);
        OrmInput factnedOutBillIO = this.getFactnedoutDs();
        costBillIOs.add(factnedOutBillIO);
        OrmInput matallocBillIO = this.getMatallocDs();
        costBillIOs.add(matallocBillIO);
        return costBillIOs;
    }

    private OrmInput getFactnedoutDs() {
        String selectFields = this.getFactnedoutSelector();
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("entrycost.costaccount", "=", this.rptParams.getCostAccount().getPkValue()));
        OrmInput billIO = new OrmInput(InvCKAccountRptQueryPlugin.class + "getCostRecOrSedDs", "cad_factnedoutputbill", selectFields, new QFilter[]{filter});
        return billIO;
    }

    private OrmInput getMatallocDs() {
        String selectFields = this.gettMatallocSelector();
        QFilter filter = new QFilter("costaccount", "=", this.rptParams.getCostAccount().getPkValue());
        OrmInput billIO = new OrmInput(InvCKAccountRptQueryPlugin.class + "getCostRecOrSedDs", "sca_matalloc", selectFields, new QFilter[]{filter});
        return billIO;
    }

    private String gettMatallocSelector() {
        HashMap<String, String> rptDimBillDimMap = new HashMap<String, String>(16);
        rptDimBillDimMap.put("costbillno", "billno");
        rptDimBillDimMap.put("sourcebillentry", "matusesrcbillentryid");
        rptDimBillDimMap.put("ecostobject", "entryentity.costobejctentry");
        rptDimBillDimMap.put("costprice", "entryentity.price");
        rptDimBillDimMap.put("costamount", "useamount");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry dimEntry : rptDimBillDimMap.entrySet()) {
            sb.append((String)dimEntry.getValue());
            sb.append(" as ");
            sb.append((String)dimEntry.getKey());
            sb.append(",");
        }
        sb.append("useqty as costqty");
        return sb.toString();
    }

    private String getFactnedoutSelector() {
        HashMap<String, String> rptDimBillDimMap = new HashMap<String, String>(16);
        rptDimBillDimMap.put("costbillno", "billno");
        rptDimBillDimMap.put("sourcebillentry", "sourcebillentry");
        rptDimBillDimMap.put("ecostobject", "entryentity.costobject");
        rptDimBillDimMap.put("costprice", "entrycost.stdprice");
        rptDimBillDimMap.put("costamount", "entrycost.amount");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry dimEntry : rptDimBillDimMap.entrySet()) {
            sb.append((String)dimEntry.getValue());
            sb.append(" as ");
            sb.append((String)dimEntry.getKey());
            sb.append(",");
        }
        sb.append("completeqty as costqty");
        return sb.toString();
    }
}

