/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.ReportUtil;

public class SalesEstimateDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(SalesEstimateDetailRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private long baseUnitId;
    private long currencyId;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private String filter_mullot;
    private DynamicObjectCollection filter_trackNumber;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_customerFrom;
    private DynamicObject filter_customerTo;
    private String filter_billno;
    private DynamicObjectCollection filter_billtype;
    private boolean filter_noShowZeroInOut;
    private Date filter_endDate;
    private long materialId;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private LocaleString local_periodIn = new LocaleString(this.getLocal_periodIn());
    private LocaleString local_periodWriteoff = new LocaleString(this.getLocal_periodWriteoff());
    private LocaleString local_periodNotWriteoff = new LocaleString(this.getLocal_periodNotWriteoff());
    private LocaleString local_periodEnd = new LocaleString(this.getLocal_periodEnd());
    private LocaleString local_qty = new LocaleString(this.getLocal_qty());
    private LocaleString local_price = new LocaleString(this.getLocal_price());
    private LocaleString local_amount = new LocaleString(this.getLocal_amount());
    private LocaleString local_baseUnit = new LocaleString(this.getLocal_baseUnit());
    private LocaleString local_currency = new LocaleString(this.getLocal_currency());
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_assistProperty = new LocaleString(this.getLocale_assistProperty());
    private DataSet ownerSet;

    private String getLocal_periodIn() {
        return ResManager.loadKDString((String)"\u51fa\u5e93", (String)"SalesEstimateDetailRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodWriteoff() {
        return ResManager.loadKDString((String)"\u5df2\u6838\u9500", (String)"SalesEstimateDetailRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodNotWriteoff() {
        return ResManager.loadKDString((String)"\u672a\u6838\u9500", (String)"SalesEstimateDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodEnd() {
        return ResManager.loadKDString((String)"\u7ed3\u5b58", (String)"SalesEstimateDetailRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"SalesEstimateDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"SalesEstimateDetailRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"SalesEstimateDetailRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"SalesEstimateDetailRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"SalesEstimateDetailRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistProperty() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"StockEstimateDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            DataSet periodInDataSet = this.getPeriodInDataSet();
            DataSet periodWriteoffDataSet = this.getPeriodWriteoffDataSet();
            DataSet periodNotWriteoffDataSet = this.getPeriodNotWriteoffDataSet();
            DataSet dataSet = this.unionAllDataSet(periodInDataSet, periodWriteoffDataSet, periodNotWriteoffDataSet);
            dataSet = this.unionPeriodBalanceDataSet(dataSet);
            dataSet = this.unionToalDataSet(dataSet);
            dataSet = dataSet.orderBy(new String[]{"ordercol1", "year", "period", "ordercol2", "bookdate", "auditdate", "billnumber"});
            dataSet = dataSet.addField("owner", "ownernumber");
            return dataSet;
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("salesEstimateDetailRpt=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.filter_endDate = this.filter_endPeriod.getDate("enddate");
        Object filterInfoStr = this.filterInfo.getFilterItem("currentMaterialId").getValue();
        this.materialId = Long.parseLong((String)filterInfoStr);
        DynamicObjectCollection materialColl = QueryServiceHelper.query((String)"bd_material", (String)"baseunit.id", (QFilter[])new QFilter("id", "=", (Object)this.materialId).toArray());
        if (materialColl.size() > 0) {
            this.baseUnitId = ((DynamicObject)materialColl.get(0)).getLong("baseunit.id");
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_mullot = this.filterInfo.getString("mullot");
        this.filter_trackNumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_customerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomer");
        this.filter_customerTo = this.filterInfo.getDynamicObject("customerto");
        this.filter_billno = this.filterInfo.getString("billno");
        this.filter_billtype = this.filterInfo.getDynamicObjectCollection("mulbilltype");
        this.filter_noShowZeroInOut = this.filterInfo.getBoolean("noshowzeroinout");
        this.ownerSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name,number", null, null);
    }

    private DataSet getPeriodInDataSet() {
        QFilter q = this.getPeriodInFilter();
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodInSelects(), (QFilter[])q.toArray(), null).groupBy(this.getFinalSelects("base").split(",")).sum("periodinqty").sum("periodinamount").min("auditdate").finish().select(this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("periodin"));
        return dataSet;
    }

    private QFilter getPeriodInFilter() {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        q.and("isinitbill", "=", (Object)false);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private String getPeriodInSelects() {
        String s = "period.periodyear as year, period.periodnumber as period, entry.ownertype as ownertype, entry.owner as owner, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.location.number as locationnumber, entry.location.name as locationname, bizdate,auditdate,bookdate,billnumber, entry.balancecustomer as customer, billtype.name as biztype, entry.assist as assist, entry.baseqty as periodinqty,entry.actualcost as periodinamount, entry.lot as lot,entry.tracknumber as tracknumber";
        return s;
    }

    private DataSet getPeriodWriteoffDataSet() {
        QFilter q = this.getPeriodWriteoffFilter();
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodWriteoffSelects(), (QFilter[])q.toArray(), null).groupBy(this.getFinalSelects("base").split(",")).sum("periodwriteoffqty").sum("periodwriteoffamount").min("auditdate").finish().select(this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("periodwriteoff"));
        return dataSet;
    }

    private QFilter getPeriodWriteoffFilter() {
        QFilter q = this.getBaseFilter();
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private String getPeriodWriteoffSelects() {
        String s = "writeoffperiod.periodyear as year, writeoffperiod.periodnumber as period, entry.ownertype as ownertype, entry.owner as owner, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.location.number as locationnumber, entry.location.name as locationname, bizdate,auditdate,bookdate, billnumber, entry.balancecustomer as customer, billtype.name as biztype, entry.assist as assist, entry.baseqty as periodwriteoffqty,entry.actualcost as periodwriteoffamount, entry.lot as lot,entry.tracknumber as tracknumber";
        return s;
    }

    private DataSet getPeriodNotWriteoffDataSet() {
        QFilter baseFilter = this.getBaseFilter();
        QFilter inFilter = new QFilter("writeoffperiod", "<=", this.filter_endPeriod.getPkValue());
        inFilter.and("issplitcreate", "=", (Object)false);
        inFilter.and(new QFilter("writeoffendperiod", "=", (Object)0).or("writeoffendperiod", ">", this.filter_startPeriod.getPkValue()));
        inFilter.and(baseFilter);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        inFilter.and(billStatusf);
        DataSet inDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getInSelect(), (QFilter[])inFilter.toArray(), null);
        DataSet inDSCopy = inDS.copy();
        HashSet<Long> ancestorentryidSet = new HashSet<Long>(16);
        for (Row row : inDSCopy) {
            ancestorentryidSet.add(row.getLong("entryid"));
        }
        QFilter woFilter = new QFilter("writeoffstatus", "=", (Object)"A");
        woFilter.and("issplitcreate", "=", (Object)true);
        woFilter.and("entry.ancestorentryid", "in", ancestorentryidSet);
        woFilter.and(baseFilter);
        woFilter.and("writeoffperiod", "<=", this.filter_endPeriod.getPkValue());
        woFilter.and(billStatusf);
        DataSet woDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getWOSelect(), (QFilter[])woFilter.toArray(), null);
        DataSet periodDS = this.getPeriodDataSet();
        DataSet ds = periodDS.join(inDS, JoinType.CROSS).select(new String[]{"allperiodid", "year", "period"}, this.getStringArr("NotWriteOffIn")).finish().where("inperiod <= allperiodid and (writeoffendperiod = 0 or writeoffendperiod > allperiodid)");
        ds = ds.select(this.getFinalSelects("periodnotwoAddzero")).union(ds.join(woDS, JoinType.LEFT).on("entryid", "subentryid").select(this.getStringArr("NotWriteOffLeft"), new String[]{"writeoffperiod", "woqty", "woamount"}).finish().where("writeoffperiod = null or writeoffperiod <= allperiodid").select(this.getFinalSelects("periodnotwonull2zero")));
        ds = ds.groupBy(this.getStringArr("sumNotWriteOffGSA")).max("inqty").max("inamount").sum("woqty").sum("woamount").min("auditdate").finish().select(this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("periodnotwriteoff")).where("periodnotwriteoffqty <> 0 or periodnotwriteoffamount <> 0");
        return ds;
    }

    private String getWOSelect() {
        String s = "entry.ancestorentryid as subentryid,writeoffperiod,entry.baseqty as woqty,entry.actualcost as woamount";
        return s;
    }

    private String getInSelect() {
        String s = "entry.id as entryid,period as inperiod,writeoffendperiod,entry.ownertype as ownertype, entry.owner as owner, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.location.number as locationnumber, entry.location.name as locationname, bizdate,auditdate,bookdate, billnumber, entry.balancecustomer as customer, billtype.name as biztype, entry.assist as assist, entry.baseqty as inqty,entry.actualcost as inamount, entry.lot as lot,entry.tracknumber as tracknumber";
        return s;
    }

    private DataSet unionAllDataSet(DataSet periodInDataSet, DataSet periodWriteoffDataSet, DataSet periodNotWriteoffDataSet) {
        DataSet dataSet = periodInDataSet.union(periodWriteoffDataSet).union(periodNotWriteoffDataSet).groupBy(this.getFinalSelects("base").split(",")).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").min("auditdate").finish().select((this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("calall")).split(","));
        dataSet = dataSet.select(this.getFinalSelects("all"));
        return dataSet.addField("1", "ordercol2");
    }

    private DataSet unionPeriodBalanceDataSet(DataSet dataSet) {
        DataSet beforePeriodDataSet = this.getBeforePeriodDataSet();
        if (!this.filter_noShowZeroInOut) {
            DataSet periodDataSet = this.getPeriodDataSet();
            dataSet = periodDataSet.join(dataSet, JoinType.LEFT).on("year", "year").on("period", "period").select(new String[]{"year", "period"}, "ownertype,owner,storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate, billnumber, customer, biztype, assist, lot,tracknumber, periodinqty, periodinprice, periodinamount, periodwriteoffqty, periodwriteoffprice, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffprice, periodnotwriteoffamount, ordercol2".split(",")).finish().select(this.getFinalSelects("allandbeforeperiod"));
        }
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"SalesEstimateDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
        dataSet = dataSet.union(dataSet.where("periodinamount <> 0 or periodwriteoffamount <>0 or periodnotwriteoffamount<>0 or periodinqty <> 0 or periodwriteoffqty <>0 or periodnotwriteoffqty<>0").groupBy(new String[]{"year", "period"}).finish().select(("year,period,null as ownertype, 0 as owner, null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as customer, '" + s + "' as biztype, null as assist, null as lot,null as tracknumber, 0 as periodinqty,0 as periodinprice,0 as periodinamount,0 as periodwriteoffqty,0 as periodwriteoffprice,0 as periodwriteoffamount,0 as periodnotwriteoffqty,0 as periodnotwriteoffprice,0 as periodnotwriteoffamount, 0 as ordercol2").split(",")));
        dataSet = dataSet.join(beforePeriodDataSet, JoinType.LEFT).on("ordercol2", "ordercol2").select((this.getFinalSelects("all") + ",ordercol2").split(","), new String[]{"periodbalanceqty", "periodbalanceamount"}).finish().select(this.getFinalSelects("allandbalancenonull"));
        dataSet = dataSet.orderBy(new String[]{"year", "period", "ordercol2", "bookdate", "auditdate", "billnumber"}).select((this.getFinalSelects("all") + ",case when PreRowValue(periodbalanceqty)=null then periodbalanceqty else PreRowValue(periodbalanceqty) + periodinqty- periodwriteoffqty end as periodbalanceqty, case when PreRowValue(periodbalanceamount)=null then periodbalanceamount else PreRowValue(periodbalanceamount)+ periodinamount-periodwriteoffamount end as periodbalanceamount,ordercol2,0 as ordercol1").split(","));
        DataSet initInDataSet = this.getInitDataSet();
        dataSet = dataSet.join(initInDataSet, JoinType.LEFT).on("ordercol1", "ordercol1").select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1").split(","), new String[]{"year as rYear", "period as rPeriod", "initqty", "initamount"}).finish().select(this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,case when rYear = null then 0 else rYear end as rYear, case when rPeriod = null then 0 else rPeriod end as rPeriod,case when initqty = null then 0 else initqty end as initqty, case when initamount = null then 0 else initamount end as initamount").select(this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,rYear,rPeriod,case when year*100+period >= rYear*100+rPeriod then initqty else 0 end as initqty, case when year*100+period >= rYear*100+rPeriod then initamount else 0 end as initamount");
        dataSet = dataSet.groupBy((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1").split(",")).sum("initqty").sum("initamount").finish().select(this.getFinalSelects("all") + ",periodbalanceqty + initqty as periodbalanceqty,periodbalanceamount + initamount as periodbalanceamount,ordercol2,ordercol1");
        return dataSet.orderBy(new String[]{"year", "period", "ordercol2 desc"}).select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,case when ordercol2=0 and PreRowValue(ordercol2)=1 then 1 else 0 end as flag").split(",")).where("ordercol2=1 or (ordercol2=0 and (periodbalanceqty <> 0 or periodbalanceamount<>0)) or (flag = 1)").select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1").split(","));
    }

    private DataSet getPeriodDataSet() {
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id as allperiodid,periodyear as year,periodnumber as period", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
    }

    private DataSet getInitDataSet() {
        QFilter q = this.getInitFilter();
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getInitSelects(), (QFilter[])q.toArray(), null).select("year,period,initqty,initamount, Cast(ordercol1 as Integer) as ordercol1");
        return initDataSet;
    }

    private String getInitSelects() {
        String s = "period.periodyear as year, period.periodnumber as period,entry.baseqty as initqty,entry.actualcost as initamount, 0 as ordercol1";
        return s;
    }

    private QFilter getInitFilter() {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        q.and("isinitbill", "=", (Object)true);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private DataSet getBeforePeriodDataSet() {
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        DataSet beforePeriodInDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodInSelect(), (QFilter[])this.getBeforePeriodInFilter1().and(billStatusf).toArray(), null).union(QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodInSelect(), (QFilter[])this.getBeforePeriodInFilter2().and(billStatusf).toArray(), null)).groupBy(new String[]{"ordercol2"}).sum("beforeperiodinqty").sum("beforeperiodinamount").finish();
        DataSet beforePeriodWriteOffDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodWriteOffSelect(), (QFilter[])this.getBeforePeriodWriteOffFilter1().and(billStatusf).toArray(), null).union(QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodWriteOffSelect(), (QFilter[])this.getBeforePeriodWriteOffFilter2().and(billStatusf).toArray(), null)).groupBy(new String[]{"ordercol2"}).sum("beforeperiodwriteoffqty").sum("beforeperiodwriteoffamount").finish();
        DataSet dataSet = beforePeriodInDataSet.join(beforePeriodWriteOffDataSet, JoinType.LEFT).on("ordercol2", "ordercol2").select(new String[]{"beforeperiodinqty", "beforeperiodinamount", "ordercol2"}, new String[]{"beforeperiodwriteoffqty", "beforeperiodwriteoffamount"}).finish().select(this.getFinalSelects("beforeperiod"));
        dataSet = dataSet.select("beforeperiodinqty-beforeperiodwriteoffqty as periodbalanceqty, beforeperiodinamount-beforeperiodwriteoffamount as periodbalanceamount, 0 as ordercol2");
        return dataSet;
    }

    private String getBeforePeriodInSelect() {
        String s = "entry.baseqty as beforeperiodinqty,entry.actualcost as beforeperiodinamount, 0 as ordercol2";
        return s;
    }

    private String getBeforePeriodWriteOffSelect() {
        String s = "entry.baseqty as beforeperiodwriteoffqty,entry.actualcost as beforeperiodwriteoffamount, 0 as ordercol2";
        return s;
    }

    private QFilter getBeforePeriodInFilter1() {
        QFilter q = this.getBaseFilter();
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("writeoffendperiod", "=", (Object)0);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private QFilter getBeforePeriodInFilter2() {
        QFilter q = this.getBaseFilter();
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffendperiod.periodyear*100+writeoffendperiod.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private QFilter getBeforePeriodWriteOffFilter1() {
        QFilter q = this.getBaseFilter();
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("writeoffendperiod", "=", (Object)0);
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private QFilter getBeforePeriodWriteOffFilter2() {
        QFilter q = this.getBaseFilter();
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffendperiod.periodyear*100+writeoffendperiod.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private DataSet unionToalDataSet(DataSet dataSet) {
        String s1 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"SalesEstimateDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
        DataSet totalDataSet = dataSet.groupBy(new String[]{"year", "period"}).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").finish().select(("year,period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as customer, '" + s1 + "' as biztype, null as assist, null as lot,null as tracknumber, periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,0 as periodbalanceqty,0 as periodbalanceamount, 2 as ordercol2, 0 as ordercol1").split(","));
        String s2 = ResManager.loadKDString((String)"\u603b\u5408\u8ba1", (String)"SalesEstimateDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
        DataSet overallTotalDataSet = totalDataSet.where("ordercol2=2").groupBy(null).sum("periodinqty").sum("periodinamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("periodwriteoffqty").sum("periodwriteoffamount").finish().select(("0 as year,0 as period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupname,null as warehsgroupnumber,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as customer, '" + s2 + "' as biztype, null as assist, null as lot,null as tracknumber, periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,0 as periodbalanceqty,0 as periodbalanceamount, 2 as ordercol2, 1 as ordercol1").split(","));
        totalDataSet = dataSet.where("ordercol2 = 0").union(totalDataSet).orderBy(new String[]{"ordercol1", "year", "period", "ordercol2"}).select("year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,customer,biztype, assist, lot,tracknumber, periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,case when ordercol2 = 2 and PreRowValue(ordercol2)=0 then PreRowValue(periodbalanceqty) + periodinqty- periodwriteoffqty else  periodbalanceqty end as periodbalanceqty, case when ordercol2 = 2 and PreRowValue(ordercol2)=0 then PreRowValue(periodbalanceamount)+ periodinamount-periodwriteoffamount else periodbalanceamount end as periodbalanceamount,ordercol2,ordercol1".split(",")).select("year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,customer,biztype, assist, lot,tracknumber, periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodbalanceqty as periodnotwriteoffqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodnotwriteoffprice,periodbalanceamount as periodnotwriteoffamount,periodbalanceqty, periodbalanceamount,ordercol2,ordercol1".split(",")).where("ordercol2 = 2");
        overallTotalDataSet = totalDataSet.where("ordercol2 = 2").orderBy(new String[]{"year desc", "period desc"}).top(1).union(overallTotalDataSet).orderBy(new String[]{"ordercol1", "year", "period", "ordercol2"}).select("year,period,ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,customer, biztype, assist, lot,tracknumber, periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,case when ordercol1 = 1 then PreRowValue(periodbalanceqty) else periodbalanceqty end as periodbalanceqty, case when ordercol1 = 1 then PreRowValue(periodbalanceamount) else periodbalanceamount end as periodbalanceamount,ordercol2,ordercol1".split(",")).select("year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,customer,biztype, assist, lot,tracknumber, periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodbalanceqty as periodnotwriteoffqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodnotwriteoffprice,periodbalanceamount as periodnotwriteoffamount,periodbalanceqty, periodbalanceamount,ordercol2,ordercol1".split(",")).where("ordercol1 = 1");
        return dataSet.union(totalDataSet).union(overallTotalDataSet).select(("year,period,ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,customer,biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,periodbalanceqty, periodbalanceamount,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodbalanceprice,ordercol2,ordercol1," + this.currencyId + " as currencyid," + this.baseUnitId + " as baseunitid," + this.materialId + " as materialid").split(","));
    }

    private QFilter getBaseFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("entry.material", "=", (Object)this.materialId);
        if (this.filter_mullot != null && !this.filter_mullot.equals("")) {
            q.and("entry.lot", "=", (Object)this.filter_mullot);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entry.tracknumber", "in", set);
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_customerFrom != null) {
            if (this.filter_customerFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : this.filter_customerFrom) {
                    set.add(info.getPkValue());
                }
                q.and("entry.balancecustomer.id", "in", set);
            } else {
                q.and("entry.balancecustomer.id", ">=", (Object)((DynamicObject)this.filter_customerFrom.get(0)).getLong("id"));
                if (this.filter_customerTo != null) {
                    q.and("entry.balancecustomer.id", "<=", (Object)this.filter_customerTo.getLong("id"));
                }
            }
        }
        if (this.filter_billno.length() >= 1) {
            q.and("billnumber", "=", (Object)this.filter_billno);
        }
        if (this.filter_billtype != null) {
            set = new HashSet();
            for (DynamicObject billtype : this.filter_billtype) {
                set.add(billtype.getPkValue());
            }
            q.and("bizentityobject", "in", set);
        } else {
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("outsplitebiztype");
            HashSet<Object> set2 = new HashSet<Object>();
            for (DynamicObject bizobject : bizobjects) {
                set2.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("bizentityobject", "in", set2);
            q.and("calbilltype", "=", (Object)"OUT");
        }
        return q;
    }

    private String[] getStringArr(String s) {
        switch (s) {
            case "woGSA": {
                return new String[]{"writeoffperiod", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "auditdate", "bookdate", "billnumber", "customer", "biztype", "assist", "woqty", "woamount", "lot", "tracknumber"};
            }
            case "sumNotWriteOffGSA": {
                return new String[]{"allperiodid", "year", "period", "entryid", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "bookdate", "billnumber", "customer", "biztype", "assist", "lot", "tracknumber"};
            }
            case "NotWriteOffIn": {
                return new String[]{"entryid", "inperiod", "writeoffendperiod", "inqty", "inamount", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "auditdate", "bookdate", "billnumber", "customer", "biztype", "assist", "lot", "tracknumber"};
            }
            case "NotWriteOffLeft": {
                return new String[]{"allperiodid", "year", "period", "entryid", "inperiod", "inqty", "inamount", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "auditdate", "bookdate", "billnumber", "customer", "biztype", "assist", "lot", "tracknumber"};
            }
        }
        return null;
    }

    private String getFinalSelects(String s) {
        String string = "";
        switch (s) {
            case "base": {
                string = "year,period,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,bookdate,billnumber,customer,biztype,assist,lot,tracknumber";
                break;
            }
            case "baseNotContainPeriod": {
                string = "ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,customer,biztype,assist,lot,tracknumber";
                break;
            }
            case "periodnotwoAddzero": {
                string = "allperiodid,year,period,entryid,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,customer,biztype,assist,lot,tracknumber,inqty,inamount,0 as woqty,0 as woamount";
                break;
            }
            case "periodnotwonull2zero": {
                string = "allperiodid,year,period,entryid,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,customer,biztype,assist,lot,tracknumber,inqty,inamount,case when woqty = null then 0 else woqty end as woqty,case when woamount = null then 0 else woamount end as woamount";
                break;
            }
            case "periodin": {
                string = "periodinqty, periodinamount, 0 as periodwriteoffqty,0 as periodwriteoffamount,0 as periodnotwriteoffqty,0 as periodnotwriteoffamount";
                break;
            }
            case "periodwriteoff": {
                string = "0 as periodinqty, 0 as periodinamount, periodwriteoffqty, periodwriteoffamount,0 as periodnotwriteoffqty,0 as periodnotwriteoffamount";
                break;
            }
            case "inandwriteoff": {
                string = "periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount";
                break;
            }
            case "periodnotwriteoff": {
                string = "0 as periodinqty, 0 as periodinamount, 0 as periodwriteoffqty,0 as periodwriteoffamount,case when woqty = null then inqty else inqty-woqty end as periodnotwriteoffqty,case when woamount = null then inamount else inamount-woamount end as periodnotwriteoffamount";
                break;
            }
            case "calall": {
                string = "periodinqty, case when periodinqty= 0 or periodinqty= null then 0 else periodinamount/periodinqty end as periodinprice, periodinamount, periodwriteoffqty, case when periodwriteoffqty =0 or periodwriteoffqty =null then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice, periodwriteoffamount,case when periodnotwriteoffqty = null then 0 else periodnotwriteoffqty end as periodnotwriteoffqty,case when periodnotwriteoffqty = 0 or periodnotwriteoffqty = null then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,case when periodnotwriteoffamount = null then 0 else periodnotwriteoffamount end as periodnotwriteoffamount";
                break;
            }
            case "alltemp": {
                string = "year, period, storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate, billnumber, customer, biztype, assist, lot,tracknumber, periodinqty, periodinprice, periodinamount, periodwriteoffqty, periodwriteoffprice, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffprice, periodnotwriteoffamount";
                break;
            }
            case "all": {
                string = "year,period,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,customer,biztype,assist,lot,tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount";
                break;
            }
            case "beforeperiod": {
                string = "case when beforeperiodinqty = null then 0 else beforeperiodinqty end as beforeperiodinqty, case when beforeperiodinamount = null then 0 else beforeperiodinamount end as beforeperiodinamount, case when beforeperiodwriteoffqty = null then 0 else beforeperiodwriteoffqty end as beforeperiodwriteoffqty, case when beforeperiodwriteoffamount = null then 0 else beforeperiodwriteoffamount end as beforeperiodwriteoffamount,ordercol2";
                break;
            }
            case "allandbeforeperiod": {
                String s3 = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockCostDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
                string = "year, period, ownertype,owner, storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate, billnumber, customer, case when ordercol2 <> 1 then '" + s3 + "' else biztype end as biztype, assist, lot,tracknumber, case when ordercol2 <> 1 then 0 else periodinqty end as periodinqty, case when ordercol2 <> 1 then 0 else periodinprice end as periodinprice, case when ordercol2 <> 1 then 0 else periodinamount end as periodinamount, case when ordercol2 <> 1 then 0 else periodwriteoffqty end as periodwriteoffqty, case when ordercol2 <> 1 then 0 else periodwriteoffprice end as periodwriteoffprice, case when ordercol2 <> 1 then 0 else periodwriteoffamount end as periodwriteoffamount, case when ordercol2 <> 1 then 0 else periodnotwriteoffqty end as periodnotwriteoffqty, case when ordercol2 <> 1 then 0 else periodnotwriteoffprice end as periodnotwriteoffprice,case when ordercol2 <> 1 then 0 else periodnotwriteoffamount end as periodnotwriteoffamount, case when ordercol2 <> 1 then 0 else ordercol2 end as ordercol2";
                break;
            }
            case "allandbalancenonull": {
                string = "year, period, ownertype,owner, storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate, billnumber, customer, biztype, assist, lot,tracknumber, periodinqty, periodinprice, periodinamount, periodwriteoffqty, periodwriteoffprice, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffprice, periodnotwriteoffamount,case when periodbalanceqty = null then 0 else periodbalanceqty end as periodbalanceqty, case when periodbalanceamount = null then 0 else periodbalanceamount end as periodbalanceamount,ordercol2";
            }
        }
        return string;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createColumnCaptions(cols);
        this.createHideColumns(cols);
        return super.getColumns(columns);
    }

    private void createColumnCaptions(List<AbstractReportColumn> cols) {
        this.createAssistPropertyColumns(cols);
        this.createColumnCaption(cols, this.local_periodIn, "periodin");
        this.createColumnCaption(cols, this.local_periodWriteoff, "periodwriteoff");
        this.createColumnCaption(cols, this.local_periodNotWriteoff, "periodnotwriteoff");
        this.createColumnCaption(cols, this.local_periodEnd, "periodbalance");
    }

    private void createAssistPropertyColumns(List<AbstractReportColumn> cols) {
        ReportColumn assist = new ReportColumn();
        assist.setCaption(this.locale_assistProperty);
        assist.setWidth(width);
        assist.setFieldKey("assist");
        assist.setFieldType("flex");
        assist.setRefBasedataProp("materialid");
        assist.setEntityId("bd_auxproperty");
        cols.add((AbstractReportColumn)assist);
    }

    private void createColumnCaption(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.local_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.local_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.local_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.local_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.local_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        ReportColumn bizEntityObject = new ReportColumn();
        bizEntityObject.setCaption(this.local_currency);
        bizEntityObject.setWidth(width);
        bizEntityObject.setFieldKey("bizentityobject");
        bizEntityObject.setFieldType("text");
        bizEntityObject.setHide(true);
        ReportColumn billId = new ReportColumn();
        billId.setCaption(this.local_currency);
        billId.setWidth(width);
        billId.setFieldKey("billid");
        billId.setFieldType("text");
        billId.setHide(true);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        cols.add((AbstractReportColumn)bizEntityObject);
        cols.add((AbstractReportColumn)billId);
    }
}

