/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.ReportUtil;

public class SalesEstimateGroupQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(SalesEstimateGroupQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private long startPeriodId;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private boolean isGroupByPeriod;
    private String groupType;
    private String groupByCols;
    private String selectField;
    private String[] orderByCol = null;
    private String strcatlot = "";
    private Date filter_endDate;
    private StringBuilder exFieldAsField = new StringBuilder();
    private StringBuilder exFieldStr = new StringBuilder();
    private Set<String> exFieldSet = new HashSet<String>(16);
    private Map<String, String> exFieldTypeMap = new HashMap<String, String>(16);
    private Map<String, String> exFieldFilterMap = new HashMap<String, String>(16);
    private long currencyId;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private DynamicObjectCollection filter_customer;
    private DynamicObjectCollection filter_tracknumber;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString local_beforeperiod = new LocaleString(this.getLocal_beforeperiod());
    private LocaleString local_periodout = new LocaleString(this.getLocal_periodOut());
    private LocaleString local_periodwriteoff = new LocaleString(this.getLocal_periodWriteoff());
    private LocaleString local_periodnotwriteoff = new LocaleString(this.getLocal_periodNotWriteoff());
    private LocaleString local_periodend = new LocaleString(this.getLocal_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_amount = new LocaleString(this.getLocale_amount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_storageOrgNum = new LocaleString(this.getLocale_storageOrgNum());
    private LocaleString locale_storageOrgName = new LocaleString(this.getLocale_storageOrgName());
    private LocaleString locale_warehouseNum = new LocaleString(this.getLocale_warehouseNum());
    private LocaleString locale_warehouseName = new LocaleString(this.getLocale_warehouseName());
    private LocaleString locale_warehouseGroupNum = new LocaleString(this.getLocale_WarehouseGroupNum());
    private LocaleString locale_warehouseGroupName = new LocaleString(this.getLocale_WarehouseGroupName());
    private LocaleString locale_ownerType = new LocaleString(this.getLocale_ownerType());
    private LocaleString locale_ownerNum = new LocaleString(this.getLocale_ownerNum());
    private LocaleString locale_ownerName = new LocaleString(this.getLocale_ownerName());
    private LocaleString locale_customerNum = new LocaleString(this.getLocale_customerNum());
    private LocaleString locale_customerName = new LocaleString(this.getLocale_customerName());
    private LocaleString locale_materialNum = new LocaleString(this.getLocale_materialNum());
    private LocaleString locale_materialName = new LocaleString(this.getLocale_materialName());
    private LocaleString locale_lotName = new LocaleString(this.getLocale_lotName());
    private LocaleString locale_trackName = new LocaleString(this.getLocale_trackName());
    public static final String BASESTR = "calorg,ownertype,owner,lot,tracknumber,period,periodid,materialid,materialname,materialnumber,baseunitid,qtyprecision,customerid,customernumber,customername,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname";
    public static final String BASESTR_NO_PERIOD = "calorg,ownertype,owner,lot,tracknumber,materialid,materialname,materialnumber,baseunitid,qtyprecision,customerid,customernumber,customername,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname";

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"SalesEstimateGroupQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_beforeperiod() {
        return ResManager.loadKDString((String)"\u671f\u521d", (String)"SalesEstimateGroupQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodOut() {
        return ResManager.loadKDString((String)"\u51fa\u5e93", (String)"SalesEstimateGroupQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodWriteoff() {
        return ResManager.loadKDString((String)"\u5df2\u6838\u9500", (String)"SalesEstimateGroupQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodNotWriteoff() {
        return ResManager.loadKDString((String)"\u672a\u6838\u9500", (String)"SalesEstimateGroupQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodEnd() {
        return ResManager.loadKDString((String)"\u7ed3\u5b58", (String)"SalesEstimateGroupQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"SalesEstimateGroupQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"SalesEstimateGroupQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"SalesEstimateGroupQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"SalesEstimateGroupQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgNum() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801", (String)"SalesEstimateGroupQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgName() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0", (String)"SalesEstimateGroupQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u7f16\u7801", (String)"SalesEstimateGroupQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u540d\u79f0", (String)"SalesEstimateGroupQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_41", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_42", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_ownerType() {
        return ResManager.loadKDString((String)"\u8d27\u4e3b\u7c7b\u578b", (String)"SalesEstimateGroupQueryPlugin_22", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_ownerNum() {
        return ResManager.loadKDString((String)"\u8d27\u4e3b\u7f16\u7801", (String)"SalesEstimateGroupQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_ownerName() {
        return ResManager.loadKDString((String)"\u8d27\u4e3b\u540d\u79f0", (String)"SalesEstimateGroupQueryPlugin_15", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_customerNum() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u7f16\u7801", (String)"SalesEstimateGroupQueryPlugin_16", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_customerName() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u540d\u79f0", (String)"SalesEstimateGroupQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNum() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockDetailRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"StockDetailRptQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_lotName() {
        return ResManager.loadKDString((String)"\u6279\u53f7", (String)"StockGatherRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_trackName() {
        return ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"StockGatherRptQueryPlugin_61", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_model() {
        return ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"StockGatherRptQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg) throws Throwable {
        try {
            this.init(param);
            DataSet periodoutDataSet = this.getPeriodOutDataSet();
            DataSet periodwriteoffDataSet = this.getPeriodWriteoffDataSet();
            DataSet beforePeriodDataSet = this.getBeforePeriodDataSet();
            DataSet dataSet = this.unionAllDataset(periodoutDataSet, periodwriteoffDataSet, beforePeriodDataSet);
            dataSet = this.addSumAndTotalDataSet(dataSet);
            dataSet = this.addOwnerNameDataSet(dataSet);
            return dataSet;
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("SalesEstimateGroupQueryPlugin=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.startPeriodId = this.filter_startPeriod.getLong("id");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.filter_endDate = this.filter_endPeriod.getDate("enddate");
        this.isGroupByPeriod = this.filterInfo.getBoolean("groupbyperiod");
        this.groupType = this.filterInfo.getString("grouptype");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        this.filter_customer = this.filterInfo.getDynamicObjectCollection("mulcustomer");
        this.filter_tracknumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.cacheExFields();
        switch (this.groupType) {
            case "A": {
                this.groupByCols = "materialid,materialname,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname";
                this.orderByCol = new String[]{"materialid", "period"};
                break;
            }
            case "B": {
                this.groupByCols = "materialid,materialname,storageorgid,storageorgnumber,storageorgname,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as storageorgid, null as storageorgnumber, null as storageorgname";
                this.orderByCol = new String[]{"materialid", "storageorgid", "period"};
                this.strcatlot = " and PreRowValue(storageorgid) = storageorgid ";
                break;
            }
            case "C": {
                this.groupByCols = "materialid,materialname,warehouseid,warehousenumber,warehousename,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as warehouseid, null as warehousenumber, null as warehousename";
                this.orderByCol = new String[]{"materialid", "warehouseid", "period"};
                this.strcatlot = " and PreRowValue(warehouseid) = warehouseid ";
                break;
            }
            case "D": {
                this.groupByCols = "materialid,materialname,customerid,customernumber,customername,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as customerid, null as customernumber, null as customername";
                this.orderByCol = new String[]{"materialid", "customerid", "period"};
                this.strcatlot = " and PreRowValue(customerid) = customerid ";
                break;
            }
            case "E": {
                this.groupByCols = "materialid,materialname,ownertype,owner,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as ownertype, 0 as owner";
                this.orderByCol = new String[]{"materialid", "ownertype", "owner", "period"};
                this.strcatlot = " and PreRowValue(ownertype) = ownertype and PreRowValue(owner) = owner ";
                break;
            }
            case "F": {
                this.groupByCols = "materialid,materialname,lot,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as lot";
                this.orderByCol = new String[]{"materialid", "lot", "period"};
                this.strcatlot = " and PreRowValue(lot) = lot ";
                break;
            }
            case "G": {
                this.groupByCols = "materialid,materialname,warehsgroupid,warehsgroupnumber,warehsgroupname,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as warehsgroupid, null as warehsgroupnumber, null as warehsgroupname";
                this.orderByCol = new String[]{"materialid", "warehsgroupid", "period"};
                this.strcatlot = " and PreRowValue(warehsgroupid) = warehsgroupid ";
                break;
            }
            case "H": {
                this.groupByCols = "materialid,materialname,tracknumber,materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as tracknumber";
                this.orderByCol = new String[]{"materialid", "tracknumber", "period"};
                this.strcatlot = " and PreRowValue(tracknumber) = tracknumber ";
                break;
            }
            default: {
                this.groupByCols = "materialid,materialname," + this.groupType + ",materialnumber,baseunitid,qtyprecision";
                this.selectField = "null as materialid, null as materialname, null as " + this.groupType;
                this.orderByCol = new String[]{"materialid", this.groupType, "period"};
                this.strcatlot = " and PreRowValue(" + this.groupType + ") = " + this.groupType + " ";
            }
        }
    }

    private void cacheExFields() {
        MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        MainEntityType rptEntity = MetadataServiceHelper.getDataEntityType((String)"cal_salesestimatesumrpt");
        ComboProp groupTypeProperty = (ComboProp)rptEntity.findProperty("grouptype");
        List propComboItems = groupTypeProperty.getComboItems();
        for (ValueMapItem valueMapItem : propComboItems) {
            IDataEntityProperty billFieldProperty;
            String value = valueMapItem.getValue();
            if (StringUtils.isEmpty((String)value) || value.length() <= 1 || (billFieldProperty = billEntity.findProperty(value)) == null) continue;
            if (billFieldProperty.getParent() instanceof EntryType) {
                String entryKey = billFieldProperty.getParent().getName();
                this.exFieldAsField.append(entryKey);
                this.exFieldAsField.append(".");
                this.exFieldAsField.append(value);
                this.exFieldAsField.append(" as ");
                this.exFieldAsField.append(value);
                this.exFieldAsField.append(",");
                this.exFieldFilterMap.put(value + "_filter", entryKey + "." + value);
            } else {
                this.exFieldAsField.append(value);
                this.exFieldAsField.append(",");
                this.exFieldFilterMap.put(value + "_filter", value);
            }
            this.exFieldStr.append(",");
            this.exFieldStr.append(value);
            this.exFieldSet.add(value);
            IDataEntityProperty rptFieldProperty = rptEntity.findProperty(value + "_filter");
            if (rptFieldProperty instanceof MulBasedataProp) {
                this.exFieldTypeMap.put(value + "_filter", "MulBasedataProp");
                continue;
            }
            if (rptFieldProperty instanceof BasedataProp) {
                this.exFieldTypeMap.put(value + "_filter", "BasedataProp");
                continue;
            }
            if (!(rptFieldProperty instanceof TextProp)) continue;
            this.exFieldTypeMap.put(value + "_filter", "TextProp");
        }
    }

    private DataSet getPeriodOutDataSet() {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodInSelects(), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy((BASESTR + this.exFieldStr).split(",")).sum("periodinqty").sum("periodinamount").finish().select(BASESTR + this.exFieldStr + ", periodinqty, periodinamount, 0.0 as periodwriteoffqty, 0.0 as periodwriteoffamount, 0.0 as periodnotwriteoffqty, 0.0 as periodnotwriteoffamount, 0.0 as beforeperiodqty, 0.0 as beforeperiodamount");
        return dataSet;
    }

    private String getPeriodInSelects() {
        String s = "calorg.id as calorg,entry.ownertype as ownertype, entry.owner as owner, entry.lot as lot,entry.tracknumber.number as tracknumber, billnumber, bizdate,bookdate, entry.balancecustomer.id as customerid, entry.balancecustomer.number as customernumber, entry.balancecustomer.name as customername, billtype.name as biztype, entry.material.id as materialid, entry.material.name as materialname, entry.material.number as materialnumber, entry.baseunit as baseunitid,entry.baseunit.precision as qtyprecision,storageorgunit.id as storageorgid, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.id as warehouseid, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.warehouse.group.id as warehsgroupid, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, period.id as periodid, to_char(period.periodyear*100+period.periodnumber) as period, entry.assist as assist, " + this.exFieldAsField + "case when entry.baseqty = null then 0 else entry.baseqty end as periodinqty, entry.location.id as locationid, case when entry.actualcost = null then 0 else entry.actualcost end as periodinamount";
        return s;
    }

    private DataSet getPeriodWriteoffDataSet() {
        QFilter q = this.getBaseFilter();
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodWriteoffSelects(), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy((BASESTR + this.exFieldStr).split(",")).sum("periodwriteoffqty").sum("periodwriteoffamount").finish().select(BASESTR + this.exFieldStr + ", 0 as periodinqty, 0 as periodinamount, periodwriteoffqty, periodwriteoffamount, 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, 0 as beforeperiodqty, 0 as beforeperiodamount");
        return dataSet;
    }

    private String getPeriodWriteoffSelects() {
        String s = "calorg.id as calorg, entry.ownertype as ownertype, entry.owner as owner, entry.lot as lot,entry.tracknumber.number as tracknumber, billnumber, bizdate,bookdate, writeoffperiod.id as periodid, to_char(writeoffperiod.periodyear*100 + writeoffperiod.periodnumber) as period, entry.balancecustomer.id as customerid, entry.balancecustomer.number as customernumber, entry.balancecustomer.name as customername, entry.material.id as materialid, entry.material.name as materialname, entry.material.number as materialnumber, entry.baseunit as baseunitid,entry.baseunit.precision as qtyprecision,storageorgunit.id as storageorgid, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.id as warehouseid, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.warehouse.group.id as warehsgroupid, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.location.id as locationid, entry.assist as assist, billtype.name as biztype, " + this.exFieldAsField + "case when entry.baseqty = null then 0 else entry.baseqty end as periodwriteoffqty, case when writeoffstatus = 'A' then 'A' else 'B' end as writeoffstatus, case when entry.actualcost = null then 0 else entry.actualcost end as periodwriteoffamount";
        return s;
    }

    private DataSet getBeforePeriodDataSet() {
        QFilter q1 = this.getBaseFilter();
        q1.and("issplitcreate", "=", (Object)false);
        q1.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q1.and(billStatusf);
        String periodInSelects = this.getPeriodInSelects();
        DataSet periodInDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)periodInSelects, (QFilter[])q1.toArray(), null);
        periodInDataSet = periodInDataSet.groupBy((BASESTR_NO_PERIOD + this.exFieldStr).split(",")).sum("periodinqty").sum("periodinamount").finish().select(BASESTR_NO_PERIOD + this.exFieldStr + ", periodinqty, periodinamount, 0 as periodwriteoffqty, 0 as periodwriteoffamount");
        QFilter q2 = this.getBaseFilter();
        q2.and("writeoffstatus", "=", (Object)"A");
        q2.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q2.and(billStatusf);
        String periodWriteoffSelects = this.getPeriodWriteoffSelects();
        DataSet periodWriteOffDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)periodWriteoffSelects, (QFilter[])q2.toArray(), null).groupBy((BASESTR_NO_PERIOD + this.exFieldStr).split(",")).sum("periodwriteoffqty").sum("periodwriteoffamount").finish().select(BASESTR_NO_PERIOD + this.exFieldStr + ", 0 as periodinqty, 0 as periodinamount, periodwriteoffqty, periodwriteoffamount");
        JoinDataSet joinDataSet = periodInDataSet.join(periodWriteOffDataSet, JoinType.LEFT).on("calorg", "calorg").on("ownertype", "ownertype").on("owner", "owner").on("lot", "lot").on("tracknumber", "tracknumber").on("materialid", "materialid").on("customerid", "customerid").on("storageorgid", "storageorgid").on("warehouseid", "warehouseid").on("warehsgroupid", "warehsgroupid");
        for (String exField : this.exFieldSet) {
            joinDataSet = joinDataSet.on(exField, exField);
        }
        DataSet dataSet = joinDataSet.select((BASESTR_NO_PERIOD + this.exFieldStr + ", periodinqty, periodinamount").split(","), "periodwriteoffqty, periodwriteoffamount".split(",")).finish().select(BASESTR_NO_PERIOD + this.exFieldStr + ", case when periodwriteoffqty = null then 0 else periodwriteoffqty end as periodwriteoffqty, case when periodwriteoffamount = null then 0 else periodwriteoffamount end as periodwriteoffamount, case when periodinqty = null then 0 else periodinqty end as periodinqty, case when periodinamount = null then 0 else periodinamount end as periodinamount");
        String period = "'" + this.filter_startPeriodNumber + "'";
        String str = "calorg,ownertype, owner, lot, tracknumber, " + period + " as period, " + this.startPeriodId + " as periodid, materialid, materialname, materialnumber, baseunitid, qtyprecision, customerid, customernumber, customername, storageorgid, storageorgnumber, storageorgname, warehouseid, warehousenumber, warehousename, warehsgroupid, warehsgroupnumber, warehsgroupname" + this.exFieldStr + ",0 as periodinqty, 0 as periodinamount, 0 as periodwriteoffqty, 0 as periodwriteoffamount";
        dataSet = dataSet.select(str + ", 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, periodinqty - periodwriteoffqty as beforeperiodqty, periodinamount - periodwriteoffamount as beforeperiodamount");
        str = "calorg,ownertype, owner, lot, tracknumber, period, Cast(periodid as Long) as periodid, materialid, materialname, materialnumber, baseunitid, qtyprecision, customerid, customernumber, customername, storageorgid, storageorgnumber, storageorgname, warehouseid, warehousenumber, warehousename, warehsgroupid, warehsgroupnumber, warehsgroupname" + this.exFieldStr + ",periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount";
        dataSet = dataSet.select(str + ",periodnotwriteoffqty,periodnotwriteoffamount,beforeperiodqty,beforeperiodamount");
        return dataSet;
    }

    private StringBuilder getGroupBys() {
        StringBuilder groupbys = new StringBuilder();
        groupbys.append("period,periodid,calorg,").append(this.groupByCols);
        return groupbys;
    }

    private StringBuilder getSelects1() {
        StringBuilder groupbys = new StringBuilder();
        groupbys.append("period,periodid,calorg,").append(this.selectField);
        return groupbys;
    }

    private StringBuilder getSelects2() {
        StringBuilder groupbys = new StringBuilder();
        groupbys.append("null as period, 0 as periodid,calorg, ").append(this.selectField);
        return groupbys;
    }

    private DataSet unionAllDataset(DataSet periodoutDataset, DataSet periodWriteoffDataset, DataSet beforeperiodDataset) {
        String allCols = "period, periodid, calorg, materialid, materialname, materialnumber, Cast(baseunitid as Long) as baseunitid, Cast(qtyprecision as Integer) as  qtyprecision, customerid, customernumber, customername, storageorgid, storageorgnumber, storageorgname, warehouseid, warehousenumber, warehousename, warehsgroupid, warehsgroupnumber, warehsgroupname,ownertype, owner, lot, tracknumber" + this.exFieldStr + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount,periodwriteoffqty,  periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount";
        String groupbys = this.getGroupBys().toString();
        DataSet initDataSet = this.getInitDataSet(BASESTR);
        DataSet dataSet = periodoutDataset.union(new DataSet[]{periodWriteoffDataset, beforeperiodDataset, initDataSet.select(BASESTR + this.exFieldStr + this.getInitUnioinSelect())}).select(allCols);
        DataSet periodDataSet = this.getPeriodDataSet();
        JoinDataSet joinDS = periodDataSet.join(dataSet.groupBy(groupbys.substring(16).split(",")).finish(), JoinType.CROSS).select(new String[]{"period", "periodid"}, groupbys.substring(16).split(",")).finish().join(dataSet, JoinType.LEFT);
        for (String onField : groupbys.split(",")) {
            onField = onField.trim();
            joinDS = joinDS.on(onField, onField);
        }
        dataSet = joinDS.select(groupbys.split(","), new String[]{"beforeperiodqty", "beforeperiodamount", "periodinqty", "periodinamount", "periodwriteoffqty", "periodwriteoffamount", "periodnotwriteoffqty", "periodnotwriteoffamount"}).finish();
        dataSet = dataSet.select(this.getFinalSelects("coverNullToZero"));
        dataSet = dataSet.groupBy(groupbys.split(",")).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("beforeperiodqty").sum("beforeperiodamount").finish().select(this.getFinalSelects("unionandsum"));
        dataSet = dataSet.orderBy(this.orderByCol);
        dataSet = this.filter_startPeriodNumber == this.filter_endPeriodNumber ? dataSet.select(this.getFinalSelects("periodendOne")) : dataSet.select(this.getFinalSelects("periodendMul")).select(this.getFinalSelects("endTobefore"));
        JoinDataSet joinDataSet = dataSet.join(initDataSet, JoinType.LEFT);
        for (String onField : groupbys.substring(16).split(",")) {
            onField = onField.trim();
            joinDataSet = joinDataSet.on(onField, onField);
        }
        dataSet = joinDataSet.select((groupbys + ",beforeperiodqty,beforeperiodamount,periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffamount,periodendqty,periodendamount").split(","), new String[]{"period as beginperiod", "initqty", "initamount"}).finish().select(groupbys + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount,periodendqty,periodendamount,case when beginperiod = null then '0' else beginperiod end as beginperiod,case when initqty = null then 0 else initqty end as initqty,case when initamount = null then 0 else initamount end as initamount").select(groupbys + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount,periodendqty,periodendamount,beginperiod,case when period < beginperiod then 0 else initqty end as initqty,case when period < beginperiod then 0 else initamount end as initamount");
        dataSet = dataSet.groupBy((groupbys + ",beforeperiodqty,beforeperiodamount,periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffamount,periodendqty,periodendamount").split(",")).sum("initqty").sum("initamount").finish().select(groupbys + ", beforeperiodqty+ initqty as beforeperiodqty, beforeperiodamount+initamount as  beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount,periodendqty+initqty as periodendqty,periodendamount+initamount as periodendamount");
        dataSet = dataSet.where("beforeperiodqty<>0 OR beforeperiodamount<>0 OR periodinqty<>0 OR periodinamount<>0 OR periodwriteoffqty<>0 OR periodwriteoffamount<>0 OR periodnotwriteoffqty<>0 OR periodnotwriteoffamount<>0 OR periodendqty<>0 OR periodendamount<>0");
        return dataSet;
    }

    private String getInitUnioinSelect() {
        return ",0 as periodinqty, 0 as periodinamount, 0 as periodwriteoffqty, 0 as periodwriteoffamount, 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, 0 as beforeperiodqty, 0 as beforeperiodamount";
    }

    private DataSet getPeriodDataSet() {
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id as periodid,to_char(periodyear*100+periodnumber) as period", (QFilter[])new QFilter[]{q}, (String)"id asc");
    }

    private DataSet getInitDataSet(String groupbys) {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)true);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodInSelects(), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy((groupbys + this.exFieldStr).split(",")).sum("periodinqty", "initqty").sum("periodinamount", "initamount").finish();
        return dataSet;
    }

    private DataSet addSumAndTotalDataSet(DataSet dataSet) {
        String s1 = ResManager.loadKDString((String)"\u672c\u671f\u5c0f\u8ba1", (String)"StockEstimateGroupQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
        String string2 = this.getSelects1().toString() + ", '" + s1 + "' as materialnumber, baseunitid, qtyprecision, beforeperiodqty, beforeperiodamount, periodinqty, periodinamount,periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, periodendqty, periodendamount";
        String string22 = this.getSelects1().toString() + ", '" + s1 + "' as materialnumber, baseunitid, qtyprecision, beforeperiodqty, beforeperiodamount, periodinqty, periodinamount,periodwriteoffqty, periodwriteoffamount, periodendqty as periodnotwriteoffqty, periodendamount as periodnotwriteoffamount, periodendqty, periodendamount";
        DataSet littleDataSet = dataSet.copy().groupBy(new String[]{"period", "calorg", "periodid"}).sum("beforeperiodqty").sum("beforeperiodamount").sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("periodendqty").sum("periodendamount").maxP("qtyprecision", "baseunitid").max("qtyprecision").finish().select(string2).select(string22);
        String s2 = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockEstimateGroupQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
        String string3 = this.getSelects2() + ", '" + s2 + "' as materialnumber, baseunitid, qtyprecision, 0 as beforeperiodqty, 0 as beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, periodendqty, periodendamount";
        DataSet totalAllDataSet = littleDataSet.groupBy(new String[]{"calorg"}).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").maxP("qtyprecision", "baseunitid").max("qtyprecision").finish().select("calorg,baseunitid,qtyprecision,periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount,0 as periodendqty,0 as periodendamount").union(littleDataSet.orderBy(new String[]{"period desc"}).top(1).select("calorg,baseunitid,qtyprecision,0 as periodinqty,0 as periodinamount,0 as periodwriteoffqty,0 as periodwriteoffamount,periodendqty,periodendamount")).groupBy(new String[]{"calorg"}).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodendqty").sum("periodendamount").maxP("qtyprecision", "baseunitid").max("qtyprecision").finish().select(string3);
        this.orderByCol = new String[]{"period"};
        dataSet = dataSet.union(littleDataSet).orderBy(this.orderByCol).union(totalAllDataSet).select(this.getFinalSelects("addprice"));
        return dataSet;
    }

    private DataSet addOwnerNameDataSet(DataSet dataSet) {
        if (this.isGroupByPeriod) {
            dataSet = dataSet.addField("concat(concat('" + this.filter_startPeriodNumber + "','-'),'" + this.filter_endPeriodNumber + "')", "period");
        }
        if (this.groupType.equals("E")) {
            dataSet = dataSet.addField("owner", "ownernumber");
        }
        return dataSet;
    }

    private String getFinalSelects(String s) {
        String string = this.getGroupBys().toString();
        switch (s) {
            case "unionandsum": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount";
                break;
            }
            case "coverNullToZero": {
                string = string + ", case when beforeperiodqty = null then 0 else beforeperiodqty end as beforeperiodqty, case when beforeperiodamount = null then 0 else beforeperiodamount end as beforeperiodamount, case when periodinqty = null then 0 else periodinqty end as periodinqty, case when periodinamount = null then 0 else periodinamount end as periodinamount, case when periodwriteoffqty = null then 0 else periodwriteoffqty end as periodwriteoffqty, case when periodwriteoffamount = null then 0 else periodwriteoffamount end as periodwriteoffamount, case when periodnotwriteoffqty = null then 0 else periodnotwriteoffqty end as periodnotwriteoffqty, case when periodnotwriteoffamount = null then 0 else periodnotwriteoffamount end as periodnotwriteoffamount";
                break;
            }
            case "calnotwriteoff": {
                string = ", periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, case when periodinqty <> 0 then periodinqty-periodwriteoffqty else periodnotwriteoffqty end as periodnotwriteoffqty, case when periodinamount <> 0 then periodinamount-periodwriteoffamount else periodnotwriteoffamount end as periodnotwriteoffamount";
                break;
            }
            case "periodendOne": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, beforeperiodqty + periodinqty - periodwriteoffqty as periodendqty, beforeperiodamount + periodinamount - periodwriteoffamount as periodendamount";
                break;
            }
            case "periodendMul": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, case when PreRowValue(materialid) <> null and  PreRowValue(materialid) = materialid" + this.strcatlot + " \t\tthen PreRowValue(periodendqty) + periodinqty - periodwriteoffqty \t\t\telse beforeperiodqty + periodinqty - periodwriteoffqty end as periodendqty, case when PreRowValue(materialid) <> null and  PreRowValue(materialid) = materialid" + this.strcatlot + " \t\tthen PreRowValue(periodendamount) + periodinamount - periodwriteoffamount \t\t\telse beforeperiodamount + periodinamount - periodwriteoffamount end as periodendamount";
                break;
            }
            case "endTobefore": {
                string = string + ", case when PreRowValue(materialid) = materialid " + this.strcatlot + " then PreRowValue(periodendqty) else beforeperiodqty end as beforeperiodqty, case when PreRowValue(materialid) = materialid " + this.strcatlot + " then PreRowValue(periodendamount) else beforeperiodamount end as beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, periodendqty, periodendamount";
                break;
            }
            case "periodendTonotwriteoff": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodendqty, periodendamount, periodendqty as periodnotwriteoffqty, periodendamount as periodnotwriteoffamount";
                break;
            }
            case "addprice": {
                string = string + ", beforeperiodqty, beforeperiodamount, case when beforeperiodqty = 0 then 0 else beforeperiodamount/beforeperiodqty end as beforeperiodprice,  periodinqty, periodinamount, case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice, periodnotwriteoffqty,  periodwriteoffqty, periodwriteoffamount, case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice, periodnotwriteoffamount, case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice, periodendqty, periodendamount, case when periodendqty = 0 then 0 else periodendamount/periodendqty end as periodendprice, " + this.currencyId + " as currencyid";
                break;
            }
            case "addowner": {
                string = string + ", beforeperiodqty, beforeperiodamount, beforeperiodprice, periodinqty, periodinamount,  periodinprice, periodwriteoffqty, periodwriteoffamount, periodwriteoffprice, periodnotwriteoffqty, periodnotwriteoffamount, periodnotwriteoffprice, periodendqty, periodendamount, periodendprice, currencyid, ownername, ownernumber";
            }
        }
        return string;
    }

    private QFilter getBaseFilter() {
        Object set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entry.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_customer != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_customer) {
                set.add(info.getPkValue());
            }
            q.and("entry.balancecustomer.id", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("entry.tracknumber.id", "in", set);
        }
        for (Map.Entry entry : this.exFieldTypeMap.entrySet()) {
            String[] strings;
            String str;
            String filterKeyName = (String)entry.getKey();
            String filterType = (String)entry.getValue();
            String fieldFilter = this.exFieldFilterMap.get(filterKeyName);
            if ("MulBasedataProp".equals(filterType)) {
                DynamicObjectCollection dyc = this.filterInfo.getDynamicObjectCollection(filterKeyName);
                if (dyc == null || dyc.size() <= 0) continue;
                HashSet<Long> idSet = new HashSet<Long>(dyc.size());
                for (DynamicObject dynamicObject : dyc) {
                    idSet.add(dynamicObject.getLong("id"));
                }
                q.and(fieldFilter, "in", idSet);
                continue;
            }
            if ("BasedataProp".equals(filterType)) {
                DynamicObject dy = this.filterInfo.getDynamicObject(filterKeyName);
                if (dy == null) continue;
                q.and(fieldFilter, "=", dy.getPkValue());
                continue;
            }
            if (!"TextProp".equals(filterType) || !StringUtils.isNotEmpty((String)(str = this.filterInfo.getString(filterKeyName))) || (strings = str.split("[\\s\\n\\r\\;\\,]+")).length <= 0) continue;
            q.and(fieldFilter, "in", (Object)strings);
        }
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection dynamicObjectCollection = setting.getDynamicObjectCollection("outsplitebiztype");
        HashSet<Object> set2 = new HashSet<Object>();
        for (DynamicObject bizobject : dynamicObjectCollection) {
            set2.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
        }
        q.and("bizentityobject", "in", set2);
        q.and("calbilltype", "=", (Object)"OUT");
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createColumnsByGroupType(cols);
        this.createMaterialColumns(cols);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        this.hideExFieldColumns(cols);
        return cols;
    }

    private void hideExFieldColumns(List<AbstractReportColumn> cols) {
        for (AbstractReportColumn abstractReportColumn : cols) {
            ReportColumn column;
            String columnName;
            if (!(abstractReportColumn instanceof ReportColumn) || !this.exFieldSet.contains(columnName = (column = (ReportColumn)abstractReportColumn).createColumn().get("dataIndex").toString()) || this.groupType.equals(columnName)) continue;
            column.setHide(true);
        }
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.local_beforeperiod, "beforeperiod");
        this.createDecimalColumn(cols, this.local_periodout, "periodin");
        this.createDecimalColumn(cols, this.local_periodwriteoff, "periodwriteoff");
        this.createDecimalColumn(cols, this.local_periodnotwriteoff, "periodnotwriteoff");
        this.createDecimalColumn(cols, this.local_periodend, "periodend");
    }

    private void createMaterialColumns(List<AbstractReportColumn> cols) {
        ReportColumn materialNumber = new ReportColumn();
        materialNumber.setCaption(this.locale_materialNum);
        materialNumber.setWidth(width);
        materialNumber.setFieldKey("materialnumber");
        materialNumber.setFieldType("text");
        ReportColumn materialName = new ReportColumn();
        materialName.setCaption(this.locale_materialName);
        materialName.setWidth(width);
        materialName.setFieldKey("materialname");
        materialName.setFieldType("text");
        Tips tips = new Tips("text", "");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u8868", (String)"StockGatherRptQueryPlugin_33", (String)"fi-cal-report", (Object[])new Object[0])));
        materialName.setCtlTips(tips);
        materialName.setHyperlink(true);
        ReportColumn materialid = new ReportColumn();
        materialid.setCaption(this.locale_materialNum);
        materialid.setWidth(width);
        materialid.setFieldKey("materialid");
        materialid.setFieldType("basedata");
        materialid.setEntityId("bd_material");
        materialid.setHide(true);
        cols.add((AbstractReportColumn)materialNumber);
        cols.add((AbstractReportColumn)materialName);
        cols.add((AbstractReportColumn)materialid);
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.locale_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.locale_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.locale_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
        if ("periodnotwriteoff".equals(fieldKey)) {
            qty.setHide(true);
            price.setHide(true);
            amount.setHide(true);
        }
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.locale_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        ReportColumn year = new ReportColumn();
        year.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"SalesEstimateGroupQueryPlugin_20", (String)"fi-cal-report", (Object[])new Object[0])));
        year.setWidth(width);
        year.setFieldKey("year");
        year.setFieldType("integer");
        year.setHide(true);
        ReportColumn month = new ReportColumn();
        month.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"SalesEstimateGroupQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0])));
        month.setWidth(width);
        month.setFieldKey("month");
        month.setFieldType("integer");
        month.setHide(true);
        cols.add((AbstractReportColumn)year);
        cols.add((AbstractReportColumn)month);
    }

    private void createStorageColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_storageOrgNum, this.locale_storageOrgName, "storageorg");
    }

    private void createWarehouseColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseNum, this.locale_warehouseName, "warehouse");
    }

    private void createCustomerColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_customerNum, this.locale_customerName, "customer");
    }

    private void createColumnsByGroupType(List<AbstractReportColumn> cols) {
        if (this.hasGroup(this.groupType, "B")) {
            this.createStorageColumns(cols);
        }
        if (this.hasGroup(this.groupType, "C")) {
            this.createWarehouseColumns(cols);
        }
        if (this.hasGroup(this.groupType, "D")) {
            this.createCustomerColumns(cols);
        }
        if (!this.hasGroup(this.groupType, "E")) {
            ReportUtil.hideOwnerColumns(cols);
        }
        if (this.hasGroup(this.groupType, "F")) {
            this.createLotColumn(cols);
        }
        if (this.hasGroup(this.groupType, "G")) {
            this.createWarehsColumn(cols);
        }
        if (this.hasGroup(this.groupType, "H")) {
            this.createTrackNumColumn(cols);
        }
    }

    private void createWarehsColumn(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseGroupNum, this.locale_warehouseGroupName, "warehsgroup");
    }

    private void createLotColumn(List<AbstractReportColumn> cols) {
        ReportColumn lot = new ReportColumn();
        lot.setCaption(this.locale_lotName);
        lot.setWidth(width);
        lot.setFieldKey("lot");
        lot.setFieldType("text");
        cols.add((AbstractReportColumn)lot);
    }

    private void createTrackNumColumn(List<AbstractReportColumn> cols) {
        ReportColumn tracknumber = new ReportColumn();
        tracknumber.setCaption(this.locale_trackName);
        tracknumber.setWidth(width);
        tracknumber.setFieldKey("tracknumber");
        tracknumber.setFieldType("text");
        cols.add((AbstractReportColumn)tracknumber);
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private void createGroupTypeColumns(List<AbstractReportColumn> cols, LocaleString numCaption, LocaleString nameCaption, String fieldKey) {
        ReportColumn number = new ReportColumn();
        number.setCaption(numCaption);
        number.setWidth(width);
        number.setFieldKey(fieldKey + "number");
        number.setFieldType("text");
        ReportColumn name = new ReportColumn();
        name.setCaption(nameCaption);
        name.setWidth(width);
        name.setFieldKey(fieldKey + "name");
        name.setFieldType("text");
        ReportColumn id = new ReportColumn();
        id.setCaption(numCaption);
        id.setWidth(width);
        id.setFieldKey(fieldKey + "id");
        id.setFieldType("text");
        id.setHide(true);
        cols.add((AbstractReportColumn)number);
        cols.add((AbstractReportColumn)name);
        cols.add((AbstractReportColumn)id);
    }
}

