/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.fallprice.DealCalRangeFunction;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;

public class StockAgeRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockAgeRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private String groupType;
    private boolean onlyShowSumRow;
    private boolean materialClassSum;
    private Date endDate;
    private Date startDate;
    private int startPeriod;
    private Date intervalStartDate;
    private DynamicObject filter_costAccount;
    private String filter_ownertype;
    private DynamicObjectCollection filter_owner;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private String[] filter_lot;
    private DynamicObjectCollection filter_tracknumber;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private Set<Long> materialIds;
    private String[] intervalDays;
    private boolean isContainDiffer;
    private String filterFields;
    private DataSet calrangeDataSet;
    private int amountPrecision;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private Set<Long> notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
    private static final String COSTADJUST = "costadjust";
    private static final String COSTRECORD = "costrecord";
    private static final String BALANCE = "balance";
    private static long transOutBillType = 508390081774497792L;
    private static long transInBillType = 474446067409107968L;
    private String[] calrangeGroupNames = new String[]{"material", "baseunit", "calrange"};
    private String[] calNotEmptyRangeGroupNames = new String[]{"material", "baseunit", "calrange"};
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private String divStr;
    private Set<Long> emptyRangeIds;
    private Set<String> calDimensionSet = new HashSet<String>(16);
    private boolean calByCostElement;

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.amountPrecision = this.filterInfo.getDynamicObject("localcurrency").getInt("amtprecision");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_owner = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_owner = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_owner = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_tracknumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        this.groupType = this.filterInfo.getString("mulgrouptype");
        this.onlyShowSumRow = this.filterInfo.getBoolean("onlyshowsumrow");
        this.materialClassSum = this.filterInfo.getBoolean("materialclasssum");
        if (this.groupType == null) {
            this.groupType = ",A,";
        }
        this.endDate = this.filterInfo.getDate("enddate");
        this.intervalDays = this.filterInfo.getString("intervaldays").split(",");
        Long costAccountId = this.filter_costAccount.getLong("id");
        DynamicObject currentPeriod = PeriodHelper.getPeriodByDate((Date)this.endDate, (Long)costAccountId);
        this.startPeriod = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
        this.startDate = currentPeriod.getDate("begindate");
        this.endDate = DateUtils.getDayEndTime((Date)this.endDate);
        int sumIntervalDay = 0;
        for (int i = 0; i < this.intervalDays.length; ++i) {
            sumIntervalDay += Integer.parseInt(this.intervalDays[i]);
        }
        this.intervalStartDate = this.getTargetDateBySubDay(this.endDate, sumIntervalDay);
        this.materialIds = new HashSet<Long>();
        DynamicObject calOrg = this.filterInfo.getDynamicObject("calorg");
        this.isContainDiffer = (Boolean)ParamsHelper.getAppParam((long)calOrg.getLong("id"), (String)"iscontaindiffer");
        this.filterFields = this.getFilterfields();
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)this.filter_costAccount.getLong("id"), (String)"cal_bd_costaccount");
        this.divStr = accountDyc.getString("dividebasis.dividebasis");
        this.divStr = this.divStr.replace("storageorgunit", "storageorg");
        this.divStr = this.divStr.replace("calorg", "calorgid");
        this.calrangeGroupNames = (String[])ArrayUtils.concatAll((Object[])this.calrangeGroupNames, (Object[][])new String[][]{this.divStr.split(",")});
        this.emptyRangeIds = this.getEmptyEntryRangeIds();
        this.calDimensionSet = StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr());
        this.calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
    }

    private Date getTargetDateBySubDay(Date endDate, int sumIntervalDay) {
        long endDateTime = endDate.getTime();
        long endPeriodDateTime = endDateTime - 86400000L * (long)sumIntervalDay;
        return new Date(endPeriodDateTime);
    }

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        try {
            this.init(param);
            DataSet resultDataSet = this.getResultDataSet();
            return resultDataSet;
        }
        catch (Exception e) {
            logger.info("StockAgeRpt=" + e.getMessage());
            throw e;
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List nowColumns = super.getColumns(columns);
        this.setNeedHiddenColumn(columns, this.hanldeSumrefColumn());
        return nowColumns;
    }

    private Set<String> hanldeSumrefColumn() {
        String[] groupTypes;
        HashSet<String> hiddenColumn = new HashSet<String>();
        hiddenColumn.add("warehouse");
        hiddenColumn.add("location");
        hiddenColumn.add("project");
        hiddenColumn.add("auxpty");
        hiddenColumn.add("ownernumber");
        hiddenColumn.add("ownertype");
        hiddenColumn.add("owner");
        hiddenColumn.add("group");
        hiddenColumn.add("storageorg");
        hiddenColumn.add("tracknumber");
        for (String type : groupTypes = this.getGroupTypeFields()) {
            hiddenColumn.remove(type);
        }
        if (hiddenColumn.contains("warehouse")) {
            hiddenColumn.add("warehousename");
        }
        if (hiddenColumn.contains("location")) {
            hiddenColumn.add("locationname");
        }
        if (!hiddenColumn.contains("location")) {
            hiddenColumn.remove("storageorg");
            hiddenColumn.remove("group");
            hiddenColumn.remove("warehouse");
            hiddenColumn.remove("warehousename");
        } else if (!hiddenColumn.contains("warehouse")) {
            hiddenColumn.remove("storageorg");
            hiddenColumn.remove("group");
        } else if (!hiddenColumn.contains("group")) {
            hiddenColumn.remove("storageorg");
        }
        if (!hiddenColumn.contains("ownernumber")) {
            hiddenColumn.remove("ownertype");
            hiddenColumn.remove("owner");
        }
        return hiddenColumn;
    }

    private String[] getGroupTypeFields() {
        String sumRef = this.groupType;
        if (sumRef != null) {
            String[] fieldArray = sumRef.split(",");
            return fieldArray;
        }
        return new String[0];
    }

    private void setNeedHiddenColumn(List<AbstractReportColumn> columns, Set<String> hiddenColumn) {
        for (AbstractReportColumn abstractReportColumn : columns) {
            if (abstractReportColumn instanceof ReportColumn) {
                ReportColumn column = (ReportColumn)abstractReportColumn;
                if (!hiddenColumn.contains(column.getFieldKey())) continue;
                column.setHide(true);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            ReportColumnGroup columnGroup = (ReportColumnGroup)abstractReportColumn;
            for (AbstractReportColumn child : columnGroup.getChildren()) {
                ReportColumn column = (ReportColumn)child;
                if (!hiddenColumn.contains(column.getFieldKey())) continue;
                column.setHide(true);
            }
        }
    }

    private DataSet getResultDataSet() {
        DataSet prevPeriodEndSet = this.getPrevPeriodEndDataSet();
        DataSet costRecordDataSet = this.getCostRecordDataSet();
        this.getMaterialIds(prevPeriodEndSet.copy(), costRecordDataSet.copy());
        DataSet costAdjustDataSet = this.getCostAdjustDataSet();
        DataSet costDiffBillDataSet = this.getCostdiffBillDataSet();
        DataSet sumDataSet = this.buildSumDataSet(prevPeriodEndSet, costRecordDataSet, costAdjustDataSet, costDiffBillDataSet);
        sumDataSet = this.filterGroupFields(sumDataSet);
        DataSet allDataSet = this.handleIntervalDayGroupData(sumDataSet);
        allDataSet = this.dealAmountField(allDataSet);
        allDataSet = this.joinOwnerDataSet(allDataSet);
        DataSet resultDataSet = this.handleClassifiedMaterialDataSet(allDataSet);
        resultDataSet = this.onlyShowSumRow ? this.addMatGroupSumRow(resultDataSet) : this.addSumRow(resultDataSet);
        return resultDataSet;
    }

    private DataSet joinOwnerDataSet(DataSet resultDataSet) {
        if (this.hasGroup(this.groupType, "owner")) {
            resultDataSet = resultDataSet.addField("owner", "ownernumber");
        }
        return resultDataSet;
    }

    private DataSet dealAmountField(DataSet resultDataSet) {
        String groupStr = this.getCommonGroupBy(false);
        StringBuilder select = new StringBuilder(groupStr);
        select.append(",calrange,baseqty,actualamount + standardamount as amount,currencyid");
        String[] intervalDays = this.filterInfo.getString("intervaldays").split(",");
        for (int i = 0; i < intervalDays.length; ++i) {
            String qtyField = "range" + i + "qty";
            String actualField = "range" + i + "actualamount";
            String standardField = "range" + i + "standardamount";
            String amountField = "range" + i + "amount";
            select.append(',').append(qtyField).append(',').append(actualField).append('+').append(standardField).append(" as ").append(amountField);
        }
        return resultDataSet.select(select.toString());
    }

    private DataSet handleIntervalDayGroupData(DataSet sumDataSet) {
        DataSet rangeCostRecordSet = this.getAllIntervalDaysCostRecordDataSet();
        DataSet rangeCostAdjustSet = this.getAllIntervalDaysCostAdjustDataSet();
        DataSet rangeCostDiffBillSet = this.getAllIntervalDaysCostdiffBillDataSet();
        DataSet rangeInitBillSet = this.getAllIntervalDaysInitBillDataSet();
        String unionSelect = this.getFinalFields(true);
        rangeCostRecordSet = rangeCostRecordSet.select(unionSelect).union(rangeInitBillSet.select(unionSelect));
        String[] intervalDays = this.filterInfo.getString("intervaldays").split(",");
        StringBuilder leftFields = new StringBuilder(this.getCommonGroupBy(false)).append(",calrange,baseqty,standardamount,actualamount,hasbaseqty,hasstandardamount,hasactualamount");
        StringBuilder tempFields = new StringBuilder(this.getCommonGroupBy(false)).append(",calrange,baseqty,standardamount,actualamount");
        sumDataSet = sumDataSet.addField("baseqty", "hasbaseqty").addField("standardamount", "hasstandardamount").addField("actualamount", "hasactualamount");
        int sumDay = 0;
        int prevDay = 0;
        for (int i = 0; i < intervalDays.length - 1; ++i) {
            int intervalDay = Integer.parseInt(intervalDays[i]);
            DataSet intervalSet = this.getIntervalRangeDataSet(rangeCostRecordSet.copy(), rangeCostAdjustSet.copy(), rangeCostDiffBillSet.copy(), sumDay += intervalDay, prevDay);
            prevDay = sumDay;
            String prefixField = "range" + i;
            String rightFields = "baseqty as " + prefixField + "qty,standardamount as " + prefixField + "standardamount,actualamount as " + prefixField + "actualamount";
            JoinDataSet joinDataSet = sumDataSet.leftJoin(intervalSet).on("material", "material").on("calrange", "calrange");
            joinDataSet = this.getTargetJoinDataSet(joinDataSet, false);
            sumDataSet = joinDataSet.select(leftFields.toString().split(","), rightFields.split(",")).finish();
            String dealAmountField = this.getDealAmountField(leftFields.toString(), prefixField);
            String judgeHasField = this.getJudgeHasField(tempFields.toString(), prefixField);
            sumDataSet = sumDataSet.select(dealAmountField).select(judgeHasField);
            rightFields = prefixField + "qty," + prefixField + "standardamount," + prefixField + "actualamount";
            leftFields.append(',').append(rightFields);
            tempFields.append(',').append(rightFields);
        }
        String prefixField = "range" + (intervalDays.length - 1);
        String moreXDayField = this.getMoreXDayField(leftFields.toString(), prefixField);
        sumDataSet = sumDataSet.select(moreXDayField);
        String currencyid = this.filterInfo.getDynamicObject("localcurrency").getPkValue().toString();
        sumDataSet = sumDataSet.addField(currencyid, "currencyid");
        return sumDataSet;
    }

    private DataSet getAllIntervalDaysCostRecordDataSet() {
        QFilter q = this.getCostRecordFilter();
        q.and("bookdate", "<=", (Object)this.endDate);
        q.and("bookdate", ">=", (Object)this.intervalStartDate);
        q.and("entry.material", "in", this.materialIds);
        QFilter billTypeFilter = QFilter.of((String)"calbilltype = 'IN' and entry.baseqty > 0", (Object[])new Object[0]);
        billTypeFilter.or(QFilter.of((String)"calbilltype = 'OUT' and entry.baseqty < 0", (Object[])new Object[0]));
        q.and(billTypeFilter);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        String fields = this.getCostRecordFields(true);
        DataSet rangeSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)fields, (QFilter[])new QFilter[]{q}, null);
        String filterStr = this.getNoStatisticalFilterStr();
        rangeSet = rangeSet.filter(filterStr);
        DataSet transBillSet = this.getTransBillDataSet(rangeSet.copy());
        String transdirFields = "transtype,ingroup,outgroup,inwarehouse,outwarehouse,inlocation,outlocation,inowner,outowner,outcostaccount,outcalrange";
        String[] rangeFields = rangeSet.getRowMeta().getFieldNames();
        rangeSet = rangeSet.leftJoin(transBillSet).on("bizbillentryid", "bizbillentryid").on("material", "material").select(rangeFields, transdirFields.split(",")).finish();
        String filterString = null;
        if (this.hasGroup(this.groupType, "location")) {
            filterString = "(inlocation = null and outlocation <> null) or (inlocation <> null and outlocation = null) or (inlocation = null and outlocation = null and (inwarehouse = null or outwarehouse = null or (inwarehouse <> null and outwarehouse <> null and inwarehouse <> outwarehouse))) or (inlocation <> null and outlocation <> null and inlocation <> outlocation)";
        } else if (this.hasGroup(this.groupType, "warehouse")) {
            filterString = "inwarehouse = null or outwarehouse = null or (inwarehouse <> null and outwarehouse <> null and inwarehouse <> outwarehouse)";
        } else if (this.hasGroup(this.groupType, "group")) {
            filterString = "transtype <> 'A' or ingroup = null or outgroup = null or (ingroup <> null and outgroup <> null and ingroup <> outgroup)";
        } else if (this.hasGroup(this.groupType, "storageorg")) {
            filterString = "transtype <> 'A'";
        } else if (this.hasGroup(this.groupType, "owner")) {
            filterString = "inowner = null or outowner = null or (inowner <> null and outowner <> null and inowner <> outowner)";
        } else if (this.groupType.equals(",A,")) {
            filterString = "costaccountid = null or outcostaccount = null or  (costaccountid <> outcostaccount)";
        }
        if (filterString != null) {
            String calrangeFilterString = " or (calrange <> null and outcalrange <> null and calrange <> outcalrange)";
            rangeSet = rangeSet.filter(filterString + calrangeFilterString);
        }
        if (!this.hasGroup(this.groupType, "location")) {
            rangeSet = rangeSet.filter("billtype.id <> 757727698490869760");
        }
        return rangeSet;
    }

    private DataSet getAllIntervalDaysCostAdjustDataSet() {
        QFilter q = this.getCostAdjustFilter();
        q.and("bookdate", "<=", (Object)this.endDate);
        q.and("bookdate", ">=", (Object)this.intervalStartDate);
        q.and("entryentity.material", "in", this.materialIds);
        q.and("isupdatecost", "=", (Object)"1");
        DataSet costAdjustSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustFields(this.isContainDiffer, true), (QFilter[])new QFilter[]{q}, null);
        return costAdjustSet;
    }

    private DataSet getAllIntervalDaysCostdiffBillDataSet() {
        QFilter q = this.getCostAdjustFilter();
        q.and("bookdate", "<=", (Object)this.endDate);
        q.and("bookdate", ">=", (Object)this.intervalStartDate);
        q.and("entryentity.material", "in", this.materialIds);
        q.and("isupdatecost", "=", (Object)"1");
        DataSet costDiffBillSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCostdiffBillFields(this.isContainDiffer, true), (QFilter[])new QFilter[]{q}, null);
        return costDiffBillSet;
    }

    private DataSet getAllIntervalDaysInitBillDataSet() {
        QFilter q = this.getCostAdjustFilter();
        q.and("entryentity.stockindate", "<=", (Object)this.endDate);
        q.and("entryentity.stockindate", ">=", (Object)this.intervalStartDate);
        q.and("entryentity.material", "in", this.materialIds);
        DataSet initBillSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)this.getInitBillFields(true), (QFilter[])new QFilter[]{q}, null);
        return initBillSet;
    }

    private DataSet getTransBillDataSet(DataSet costRecordSet) {
        ArrayList<Long> bizBillEntryIdList = new ArrayList<Long>();
        HashSet<Long> transZaiTuEntryIdSet = new HashSet<Long>();
        HashSet<Long> transOutEntryIdSet = new HashSet<Long>();
        HashSet<Long> transInEntryIdSet = new HashSet<Long>();
        HashSet<Long> transInZaiTuIdSet = new HashSet<Long>();
        Date mindate = null;
        Date maxdate = null;
        HashSet<Long> storageorgIds = new HashSet<Long>(16);
        for (Row row : costRecordSet.copy()) {
            Long bizbillentryid = row.getLong("bizbillentryid");
            bizBillEntryIdList.add(bizbillentryid);
            Date bookdate = row.getDate("bookdate");
            if (mindate == null || mindate.after(bookdate)) {
                mindate = bookdate;
            }
            if (maxdate == null || maxdate.before(bookdate)) {
                maxdate = bookdate;
            }
            Long storageorgId = row.getLong("storageorg");
            storageorgIds.add(storageorgId);
        }
        String fields = "transtype,billentry.id as bizbillentryid,billentry.material.masterid as material,billentry.warehouse.group as ingroup,billentry.outwarehouse.group as outgroup,billentry.warehouse as inwarehouse,billentry.outwarehouse as outwarehouse,billentry.location as inlocation,billentry.outlocation as outlocation,billentry.owner as inowner,billentry.outowner as outowner";
        QFilter q = new QFilter("billentry.id", "in", bizBillEntryIdList);
        DataSet transdirBillSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_transdirbill", (String)fields, (QFilter[])q.toArray(), null);
        QFilter outBillFilter = new QFilter("entry.bizbillentryid", "in", bizBillEntryIdList);
        outBillFilter.and("calbilltype", "=", (Object)"OUT");
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        outBillFilter.and(billStatusf);
        outBillFilter.and("costaccount", "=", this.filter_costAccount.getPkValue());
        outBillFilter.and("bookdate", "<=", (Object)maxdate);
        outBillFilter.and("bookdate", ">=", (Object)mindate);
        DataSet dirCostRecordSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.bizbillentryid as bizbillentryid,costaccount as outcostaccount,entry.calrange as outcalrange", (QFilter[])outBillFilter.toArray(), null);
        transdirBillSet = transdirBillSet.leftJoin(dirCostRecordSet).on("bizbillentryid", "bizbillentryid").select(transdirBillSet.getRowMeta().getFieldNames(), new String[]{"outcostaccount", "outcalrange"}).finish();
        String allFields = "transtype,bizbillentryid,material,ingroup,outgroup,inwarehouse,outwarehouse,inlocation,outlocation,inowner,outowner,outcostaccount,outcalrange";
        transdirBillSet = transdirBillSet.select(allFields);
        DataSet transInInDateSet = costRecordSet.copy().filter("billtype.id = " + transInBillType);
        mindate = null;
        maxdate = null;
        storageorgIds = new HashSet(16);
        for (Row row : transInInDateSet) {
            Long bizbillentryid = row.getLong("bizbillentryid");
            transInEntryIdSet.add(bizbillentryid);
            Date bookdate = row.getDate("bookdate");
            if (mindate == null || mindate.after(bookdate)) {
                mindate = bookdate;
            }
            if (maxdate == null || maxdate.before(bookdate)) {
                maxdate = bookdate;
            }
            Long storageorgId = row.getLong("storageorg");
            storageorgIds.add(storageorgId);
        }
        QFilter transInFilter = new QFilter("entry.bizbillentryid", "in", transInEntryIdSet);
        transInFilter.and("calbilltype", "=", (Object)"OUT");
        transInFilter.and("billtype.id", "=", (Object)transInBillType);
        transInFilter.and("costaccount", "=", this.filter_costAccount.getPkValue());
        transInFilter.and("bookdate", "<=", (Object)maxdate);
        transInFilter.and("bookdate", ">=", (Object)mindate);
        DataSet transInOutSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.bizbillentryid as bizbillentryid", (QFilter[])transInFilter.toArray(), null);
        for (Row row : transInOutSet) {
            Long bizbillentryid = row.getLong("bizbillentryid");
            transInZaiTuIdSet.add(bizbillentryid);
        }
        transInEntryIdSet.removeAll(transInZaiTuIdSet);
        DataSet transInBillSet = this.getTransBillByTransType(transInEntryIdSet, "IN", storageorgIds, maxdate, mindate);
        String ZaiTuIdSetString = ((Object)transInZaiTuIdSet).toString();
        ZaiTuIdSetString = ZaiTuIdSetString.substring(1, ZaiTuIdSetString.length() - 1);
        DataSet transZaiTUDataSet = null;
        if (ZaiTuIdSetString != null && !"".equals(ZaiTuIdSetString)) {
            String filterString = "billtype.id = " + transOutBillType + " and calbilltype = 'IN' or bizbillentryid in (" + ZaiTuIdSetString + ")";
            transZaiTUDataSet = costRecordSet.copy().filter(filterString);
            String transOutInFields = "material,warehouse as inwarehouse,group as ingroup,location as inlocation,owner as inowner,storageorg as instorageorg,bizbillentryid";
            String transOutOutFields = "entry.warehouse as outwarehouse,entry.warehouse.group as outgroup,entry.location as outlocation,entry.owner as outowner,storageorgunit as outstorageorg,entry.bizbillentryid as bizbillentryid,costaccount as outcostaccount,entry.calrange as outcalrange";
            transZaiTUDataSet = transZaiTUDataSet.select(transOutInFields);
            for (Row row : transZaiTUDataSet.copy()) {
                Long bizbillentryid = row.getLong("bizbillentryid");
                transZaiTuEntryIdSet.add(bizbillentryid);
            }
            QFilter transOutFilter = new QFilter("entry.bizbillentryid", "in", transZaiTuEntryIdSet);
            transOutFilter.and("calbilltype", "=", (Object)"OUT");
            DataSet transOutOutSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)transOutOutFields, (QFilter[])transOutFilter.toArray(), null);
            String transLeftFields = "material,inwarehouse,ingroup,inlocation,inowner,instorageorg,bizbillentryid";
            String transRightFields = "outwarehouse,outgroup,outlocation,outowner,outstorageorg,outcostaccount,outcalrange";
            String transOutFinalFields = "material,ingroup,inwarehouse,inlocation,inowner,outwarehouse,outgroup,outlocation,outowner,case when instorageorg=outstorageorg then 'A' else 'B' end as transtype,bizbillentryid,outcostaccount,outcalrange";
            transZaiTUDataSet = transZaiTUDataSet.join(transOutOutSet).on("bizbillentryid", "bizbillentryid").select(transLeftFields.split(","), transRightFields.split(",")).finish();
            transZaiTUDataSet = transZaiTUDataSet.select(transOutFinalFields).select(allFields);
        }
        DataSet transOutDataSet = costRecordSet.filter("billtype.id = " + transOutBillType + " and calbilltype = 'OUT'");
        mindate = null;
        maxdate = null;
        storageorgIds = new HashSet(16);
        for (Row row : transOutDataSet) {
            Long bizbillentryid = row.getLong("bizbillentryid");
            transOutEntryIdSet.add(bizbillentryid);
            Date bookdate = row.getDate("bookdate");
            if (mindate == null || mindate.after(bookdate)) {
                mindate = bookdate;
            }
            if (maxdate == null || maxdate.before(bookdate)) {
                maxdate = bookdate;
            }
            Long storageorgId = row.getLong("storageorg");
            storageorgIds.add(storageorgId);
        }
        DataSet transOutBillSet = this.getTransBillByTransType(transOutEntryIdSet, "OUT", storageorgIds, maxdate, mindate);
        DataSet transBillSet = transdirBillSet.union(transInBillSet).union(transOutBillSet);
        if (transZaiTUDataSet != null) {
            transBillSet = transBillSet.union(transZaiTUDataSet);
        }
        return transBillSet;
    }

    private DataSet getTransBillByTransType(Set<Long> transEntryIdSet, String type, Set<Long> storageorgIds, Date maxdate, Date mindate) {
        String transRecordRightFields;
        String transRecordLeftFields;
        String recordFields;
        String selectFields;
        String entityNum;
        String allFields = "transtype,bizbillentryid,material,ingroup,outgroup,inwarehouse,outwarehouse,inlocation,outlocation,inowner,outowner,outcostaccount,outcalrange";
        if ("IN".equals(type)) {
            entityNum = "im_transinbill";
            selectFields = "transtype,billentry.material.masterid as material,billentry.warehouse as inwarehouse,billentry.warehouse.group as ingroup, billentry.location as inlocation,billentry.owner as inowner,billentry.srcbillentryid as srcbillentryid,billentry.srcbillid as srcbillid,billentry.id as bizbillentryid";
            recordFields = "entry.warehouse as outwarehouse,entry.warehouse.group as outgroup,entry.location as outlocation,entry.owner as outowner,entry.bizbillentryid as entryid,costaccount as outcostaccount,entry.calrange as outcalrange";
            transRecordLeftFields = "transtype,material,inwarehouse,ingroup,inlocation,inowner,bizbillentryid";
            transRecordRightFields = "outwarehouse,outgroup,outlocation,outowner,outcostaccount,outcalrange";
        } else {
            entityNum = "im_transoutbill";
            selectFields = "transtype,billentry.material.masterid as material,billentry.warehouse as outwarehouse,billentry.warehouse.group as outgroup, billentry.location as outlocation,billentry.owner as outowner,billentry.srcbillentryid as srcbillentryid,billentry.srcbillid as srcbillid,billentry.id as bizbillentryid";
            recordFields = "entry.warehouse as inwarehouse,entry.warehouse.group as ingroup,entry.location as inlocation,entry.owner as inowner,entry.bizbillentryid as entryid,costaccount as outcostaccount,entry.calrange as outcalrange";
            transRecordLeftFields = "transtype,material,outwarehouse,outgroup,outlocation,outowner,bizbillentryid";
            transRecordRightFields = "inwarehouse,ingroup,inlocation,inowner,outcostaccount,outcalrange";
        }
        QFilter transQ = new QFilter("billentry.id", "in", transEntryIdSet);
        transQ.and("org", "in", storageorgIds);
        transQ.and("bookdate", "<=", (Object)maxdate);
        transQ.and("bookdate", ">=", (Object)mindate);
        DataSet transBillSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNum, (String)selectFields, (QFilter[])transQ.toArray(), null);
        HashSet<Long> bizBillEntryIds = new HashSet<Long>();
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (Row row : transBillSet.copy()) {
            Long entryId = row.getLong("srcbillentryid");
            Long billid = row.getLong("srcbillid");
            bizBillEntryIds.add(entryId);
            bizBillIds.add(billid);
        }
        QFilter transRecordFilter = new QFilter("entry.bizbillentryid", "in", bizBillEntryIds);
        QFilter transReocrdIdsFilter = new QFilter("bizBillId", "in", bizBillIds);
        transRecordFilter.and(transReocrdIdsFilter);
        transRecordFilter.and("costaccount", "=", this.filter_costAccount.getPkValue());
        transRecordFilter.and("bizbillid", "in", bizBillIds);
        DataSet transOutBillSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)recordFields, (QFilter[])transRecordFilter.toArray(), null);
        transBillSet = transBillSet.leftJoin(transOutBillSet).on("srcbillentryid", "entryid").select(transRecordLeftFields.split(","), transRecordRightFields.split(",")).finish();
        transBillSet = transBillSet.select(allFields);
        return transBillSet;
    }

    private JoinDataSet getTargetJoinDataSet(JoinDataSet joinDataSet, boolean isNeedFilterFields) {
        HashSet<Object> joinStrSet = new HashSet<Object>(16);
        if (this.hasGroup(this.groupType, "owner")) {
            joinDataSet = joinDataSet.on("ownertype", "ownertype");
            joinDataSet = joinDataSet.on("owner", "owner");
            joinStrSet.add("ownertype");
            joinStrSet.add("owner");
        }
        if (this.hasGroup(this.groupType, "storageorg")) {
            joinDataSet = joinDataSet.on("storageorg", "storageorg");
            joinStrSet.add("storageorg");
        }
        if (this.hasGroup(this.groupType, "group")) {
            if (!this.hasGroup(this.groupType, "storageorg")) {
                joinDataSet = joinDataSet.on("storageorg", "storageorg");
                joinStrSet.add("storageorg");
            }
            joinDataSet = joinDataSet.on("group", "group");
            joinStrSet.add("group");
        }
        if (this.hasGroup(this.groupType, "warehouse")) {
            if (!this.hasGroup(this.groupType, "storageorg") && !this.hasGroup(this.groupType, "group")) {
                joinDataSet = joinDataSet.on("storageorg", "storageorg");
                joinStrSet.add("storageorg");
            }
            if (!this.hasGroup(this.groupType, "group")) {
                joinDataSet = joinDataSet.on("group", "group");
                joinStrSet.add("group");
            }
            joinDataSet = joinDataSet.on("warehouse", "warehouse");
            joinStrSet.add("warehouse");
        }
        if (this.hasGroup(this.groupType, "location")) {
            if (!(this.hasGroup(this.groupType, "storageorg") || this.hasGroup(this.groupType, "group") || this.hasGroup(this.groupType, "warehouse"))) {
                joinDataSet = joinDataSet.on("storageorg", "storageorg");
                joinStrSet.add("storageorg");
            }
            if (!this.hasGroup(this.groupType, "group") && !this.hasGroup(this.groupType, "warehouse")) {
                joinDataSet = joinDataSet.on("group", "group");
                joinStrSet.add("group");
            }
            if (!this.hasGroup(this.groupType, "warehouse")) {
                joinDataSet = joinDataSet.on("warehouse", "warehouse");
                joinStrSet.add("warehouse");
            }
            joinDataSet = joinDataSet.on("location", "location");
            joinStrSet.add("location");
        }
        if (this.hasGroup(this.groupType, "lot")) {
            joinDataSet = joinDataSet.on("lot", "lot");
            joinStrSet.add("lot");
        }
        if (this.hasGroup(this.groupType, "tracknumber")) {
            joinDataSet = joinDataSet.on("tracknumber", "tracknumber");
            joinStrSet.add("tracknumber");
        }
        if (this.hasGroup(this.groupType, "assist")) {
            joinDataSet = joinDataSet.on("assist", "assist");
            joinStrSet.add("assist");
        }
        if (isNeedFilterFields && this.filterFields != null) {
            for (String name : this.filterFields.split(",")) {
                joinDataSet = joinDataSet.on(name, name);
                joinStrSet.add(name);
            }
        }
        if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
            for (String calDimension : this.calDimensionSet) {
                if (joinStrSet.contains(calDimension) || !this.hasGroup(this.groupType, calDimension)) continue;
                joinDataSet = joinDataSet.on(calDimension, calDimension);
            }
        }
        return joinDataSet;
    }

    private GroupbyDataSet getGroupDataSet(GroupbyDataSet groupDataSet) {
        HashSet<Object> maxPStrSet = new HashSet<Object>(16);
        if (this.hasGroup(this.groupType, "owner")) {
            groupDataSet = groupDataSet.maxP("actualamount", "ownertype");
            groupDataSet = groupDataSet.maxP("actualamount", "owner");
            maxPStrSet.add("ownertype");
            maxPStrSet.add("owner");
        }
        if (this.hasGroup(this.groupType, "storageorg")) {
            groupDataSet = groupDataSet.maxP("actualamount", "storageorg");
            maxPStrSet.add("storageorg");
        }
        if (this.hasGroup(this.groupType, "group")) {
            if (!this.hasGroup(this.groupType, "storageorg")) {
                groupDataSet = groupDataSet.maxP("actualamount", "storageorg");
                maxPStrSet.add("storageorg");
            }
            groupDataSet = groupDataSet.maxP("actualamount", "group");
            maxPStrSet.add("group");
        }
        if (this.hasGroup(this.groupType, "warehouse")) {
            if (!this.hasGroup(this.groupType, "storageorg") && !this.hasGroup(this.groupType, "group")) {
                groupDataSet = groupDataSet.maxP("actualamount", "storageorg");
                maxPStrSet.add("storageorg");
            }
            if (!this.hasGroup(this.groupType, "group")) {
                groupDataSet = groupDataSet.maxP("actualamount", "group");
                maxPStrSet.add("group");
            }
            groupDataSet = groupDataSet.maxP("actualamount", "warehouse");
            maxPStrSet.add("warehouse");
        }
        if (this.hasGroup(this.groupType, "location")) {
            if (!(this.hasGroup(this.groupType, "storageorg") || this.hasGroup(this.groupType, "group") || this.hasGroup(this.groupType, "warehouse"))) {
                groupDataSet = groupDataSet.maxP("actualamount", "storageorg");
                maxPStrSet.add("storageorg");
            }
            if (!this.hasGroup(this.groupType, "group") && !this.hasGroup(this.groupType, "warehouse")) {
                groupDataSet = groupDataSet.maxP("actualamount", "group");
                maxPStrSet.add("group");
            }
            if (!this.hasGroup(this.groupType, "warehouse")) {
                groupDataSet = groupDataSet.maxP("actualamount", "warehouse");
                maxPStrSet.add("warehouse");
            }
            groupDataSet = groupDataSet.maxP("actualamount", "location");
            maxPStrSet.add("location");
        }
        if (this.hasGroup(this.groupType, "lot")) {
            groupDataSet = groupDataSet.maxP("actualamount", "lot");
            maxPStrSet.add("lot");
        }
        if (this.hasGroup(this.groupType, "tracknumber")) {
            groupDataSet = groupDataSet.maxP("actualamount", "tracknumber");
            maxPStrSet.add("tracknumber");
        }
        if (this.hasGroup(this.groupType, "assist")) {
            groupDataSet = groupDataSet.maxP("actualamount", "assist");
            maxPStrSet.add("assist");
        }
        if (this.filterFields != null) {
            for (String name : this.filterFields.split(",")) {
                groupDataSet = groupDataSet.maxP("actualamount", name);
                maxPStrSet.add(name);
            }
        }
        if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
            for (String calDimension : this.calDimensionSet) {
                if (maxPStrSet.contains(calDimension) || !this.hasGroup(this.groupType, calDimension)) continue;
                groupDataSet = groupDataSet.maxP("actualamount", calDimension);
            }
        }
        return groupDataSet;
    }

    private String getMoreXDayField(String leftFields, String prefixField) {
        String qtyField = prefixField + "qty";
        String standardAmountField = prefixField + "standardamount";
        String actualAmountField = prefixField + "actualamount";
        StringBuilder resultStr = new StringBuilder(leftFields).append(",");
        String[] intervalDays = this.filterInfo.getString("intervaldays").split(",");
        StringBuilder qtyStr = new StringBuilder("baseqty");
        StringBuilder standardStr = new StringBuilder("standardamount");
        StringBuilder actualStr = new StringBuilder("actualamount");
        for (int i = 0; i < intervalDays.length - 1; ++i) {
            String prevPrefixField = "range" + i;
            qtyStr = qtyStr.append(" - ").append(prevPrefixField).append("qty");
            standardStr = standardStr.append(" - ").append(prevPrefixField).append("standardamount");
            actualStr = actualStr.append(" - ").append(prevPrefixField).append("actualamount");
        }
        resultStr.append((CharSequence)qtyStr).append(" as ").append(qtyField).append(',');
        resultStr.append((CharSequence)standardStr).append(" as ").append(standardAmountField).append(',');
        resultStr.append((CharSequence)actualStr).append(" as ").append(actualAmountField);
        return resultStr.toString();
    }

    private String getDealAmountField(String leftFields, String prefixField) {
        String qtyField = prefixField + "qty";
        String standardAmountField = prefixField + "standardamount";
        String actualAmountField = prefixField + "actualamount";
        String resultStr = leftFields + ", case when " + qtyField + "= null then 0 else " + qtyField + " end as " + qtyField + ", case when " + standardAmountField + " <> null  then  " + standardAmountField + " else 0 end as " + standardAmountField + ", case when " + actualAmountField + " <> null then " + actualAmountField + " else 0 end as " + actualAmountField;
        return resultStr;
    }

    private String getJudgeHasField(String leftFields, String prefixField) {
        String qtyField = prefixField + "qty";
        String standardAmountField = prefixField + "standardamount";
        String actualAmountField = prefixField + "actualamount";
        String resultStr = leftFields + " ,case when hasbaseqty > " + qtyField + " then hasbaseqty - " + qtyField + " else 0  end as hasbaseqty  ,case when hasbaseqty > " + qtyField + " then " + qtyField + " else hasbaseqty  end as " + qtyField + " ,case when hasstandardamount > " + standardAmountField + " then hasstandardamount - " + standardAmountField + " else 0  end as hasstandardamount  ,case when hasstandardamount > " + standardAmountField + " then " + standardAmountField + " else hasstandardamount  end as " + standardAmountField + " ,case when hasbaseqty <= " + qtyField + " then 0   when hasactualamount > " + actualAmountField + " then hasactualamount - " + actualAmountField + " else 0  end as hasactualamount  ,case when hasbaseqty <= " + qtyField + " then hasactualamount    when hasactualamount > " + actualAmountField + " then " + actualAmountField + " else hasactualamount  end as " + actualAmountField;
        return resultStr;
    }

    private DataSet getIntervalRangeDataSet(DataSet rangeCostRecordSet, DataSet rangeCostAdjustSet, DataSet rangeCostDiffBillSet, int sumDay, int prevDay) {
        Date endRangeDate = this.getTargetDateBySubDay(this.endDate, prevDay);
        Date startRangeDate = this.getTargetDateBySubDay(this.endDate, sumDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String filterStr = "date(year(bookdate),month(bookdate),day(bookdate)) <= date(year(%1$s),month(%1$s),day(%1$s))  and date(year(bookdate),month(bookdate),day(bookdate)) >=  date(year(%2$s),month(%2$s),day(%2$s))";
        String endDateStr = "to_date('" + sdf.format(endRangeDate) + "','yyyy-MM-dd')";
        String startDateStr = "to_date('" + sdf.format(startRangeDate) + "','yyyy-MM-dd')";
        filterStr = String.format(filterStr, endDateStr, startDateStr);
        String[] groupStrs = ("calrange," + this.getCommonGroupBy(true)).split(",");
        rangeCostRecordSet = rangeCostRecordSet.filter(filterStr);
        HashMap<String, List<Map<String, Object>>> paramsMap = new HashMap<String, List<Map<String, Object>>>(16);
        for (Row row : rangeCostRecordSet.copy()) {
            ArrayList params;
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            Long calorgId = row.getLong("calorgid");
            String[] costAccountId = row.getLong("costaccountid");
            Long storageorgId = row.getLong("storageorg");
            String paramKey = calorgId + "_" + costAccountId;
            param.put("uniqueID", row.getLong("entryid"));
            param.put("invorg", storageorgId);
            param.put("date", this.endDate);
            param.put("material", row.getLong("material"));
            param.put("priority", "0");
            if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
                for (String calDimension : this.calDimensionSet) {
                    Object value = row.get(calDimension);
                    if (value != null) {
                        if (value instanceof DynamicObject) {
                            param.put(calDimension, ((DynamicObject)value).getPkValue());
                            continue;
                        }
                        param.put(calDimension, value);
                        continue;
                    }
                    param.put(calDimension, 0L);
                }
            }
            if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
                params = new ArrayList(16);
                params.add(param);
                paramsMap.put(paramKey, params);
                continue;
            }
            params.add(param);
        }
        if (this.isContainDiffer) {
            String finalField = this.getFinalFields(true);
            rangeCostRecordSet = rangeCostRecordSet.select(finalField);
        } else {
            DataSet costInfoSet = this.getStandardPriceDataSet(this.materialIds, paramsMap);
            rangeCostRecordSet = rangeCostRecordSet.join(costInfoSet, JoinType.LEFT).on("entryid", "entryid").select(rangeCostRecordSet.getRowMeta().getFieldNames(), new String[]{"standardprice"}).finish();
            if (this.calByCostElement) {
                List<Object[]> dataList1 = this.getDataList(rangeCostRecordSet, "standardprice");
                rangeCostRecordSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList1.iterator(), rangeCostRecordSet.getRowMeta());
            }
            String finalField = this.getFinalFields(false) + ",standardbaseqty * standardprice as standardamount";
            rangeCostRecordSet = rangeCostRecordSet.select(finalField);
        }
        rangeCostRecordSet = rangeCostRecordSet.groupBy(this.getGroupFields().split(",")).sum("baseqty").sum("actualqty").sum("standardamount").sum("actualamount").finish();
        DataSet[] splitDataSet = rangeCostRecordSet.splitByFilter(new String[]{new QFilter("calrange", "in", this.emptyRangeIds).toString(), new QFilter("calrange", "not in", this.emptyRangeIds).toString()}, false);
        DataSet emptyRangeDataSet = splitDataSet[0];
        DataSet notEmptyRangeDataSet = splitDataSet[1];
        JoinDataSet joinDataSet = emptyRangeDataSet.leftJoin(this.calrangeDataSet.copy());
        for (String onField : this.calrangeGroupNames) {
            joinDataSet = joinDataSet.on(onField, onField);
        }
        emptyRangeDataSet = joinDataSet.select(emptyRangeDataSet.getRowMeta().getFieldNames(), new String[]{"actualprice"}).finish();
        joinDataSet = notEmptyRangeDataSet.leftJoin(this.calrangeDataSet.copy());
        for (String onField : this.calNotEmptyRangeGroupNames) {
            joinDataSet = joinDataSet.on(onField, onField);
        }
        notEmptyRangeDataSet = joinDataSet.select(notEmptyRangeDataSet.getRowMeta().getFieldNames(), new String[]{"actualprice"}).finish();
        rangeCostRecordSet = emptyRangeDataSet.union(notEmptyRangeDataSet);
        rangeCostRecordSet = rangeCostRecordSet.select(this.getCommonGroupBy(true) + ",calrange,baseqty,actualqty,actualqty * actualprice as actualamount,standardamount");
        rangeCostRecordSet = rangeCostRecordSet.groupBy(groupStrs).sum("baseqty").sum("actualqty").sum("standardamount").sum("actualamount").finish();
        rangeCostRecordSet = rangeCostRecordSet.select(this.getCommonGroupBy(true) + ",calrange,baseqty,actualamount,standardamount");
        rangeCostAdjustSet = rangeCostAdjustSet.filter(filterStr).groupBy(groupStrs).sum("standardamount").sum("actualamount").finish();
        String costAdjustField = this.getCommonGroupBy(true) + ",calrange,0 as baseqty,actualamount,standardamount";
        rangeCostAdjustSet = rangeCostAdjustSet.select(costAdjustField);
        rangeCostDiffBillSet = rangeCostDiffBillSet.filter(filterStr).groupBy(groupStrs).sum("standardamount").sum("actualamount").finish();
        rangeCostDiffBillSet = rangeCostDiffBillSet.select(costAdjustField);
        String[] totalGroupStrs = ("calrange," + this.getCommonGroupBy(false)).split(",");
        DataSet intervalRangeDataSet = rangeCostRecordSet.union(rangeCostAdjustSet).union(rangeCostDiffBillSet).groupBy(totalGroupStrs).sum("baseqty").sum("actualamount").sum("standardamount").finish();
        List<Object[]> dataList = this.getDataList(intervalRangeDataSet, "actualamount");
        intervalRangeDataSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList.iterator(), intervalRangeDataSet.getRowMeta());
        return intervalRangeDataSet;
    }

    private String getNoStatisticalFilterStr() {
        String nostatistical = this.filterInfo.getString("nostatistical");
        StringBuilder filterStr = new StringBuilder("1=1");
        if (nostatistical != null && !nostatistical.isEmpty()) {
            String[] nostatisticalArray = nostatistical.split(",");
            for (int i = 0; i < nostatisticalArray.length; ++i) {
                String tmp = nostatisticalArray[i];
                String[] tmps = tmp.split(":");
                if (tmps.length <= 0) continue;
                String billTypeId = tmps[0];
                filterStr.append(" and ( billtype.id <> ").append(billTypeId);
                if (tmps.length > 1) {
                    long biztypeId = Long.parseLong(tmps[1]);
                    filterStr.append(" or biztype.id <> ").append(biztypeId);
                    if (tmps.length > 2) {
                        long invschemeId = Long.parseLong(tmps[2]);
                        filterStr.append(" or invscheme.id <> ").append(invschemeId);
                    }
                }
                filterStr.append(')');
            }
        }
        return filterStr.toString();
    }

    private DataSet buildSumDataSet(DataSet prevPeriodEndSet, DataSet costRecordDataSet, DataSet costAdjustDataSet, DataSet costDiffBillDataSet) {
        String groupStr = this.getCommonGroupBy(false);
        if (this.filterFields != null) {
            groupStr = groupStr + "," + this.filterFields;
        }
        costAdjustDataSet = costAdjustDataSet.select(costRecordDataSet.getRowMeta().getFieldNames());
        costDiffBillDataSet = costDiffBillDataSet.select(costRecordDataSet.getRowMeta().getFieldNames());
        DataSet sumDataSet = prevPeriodEndSet.union(costRecordDataSet).union(costAdjustDataSet).union(costDiffBillDataSet).groupBy(this.getGroupFields().split(",")).sum("baseqty").sum("actualqty").sum("actualamount").sum("standardamount").finish();
        this.calrangeDataSet = sumDataSet.copy();
        DealCalRangeFunction billCalRangeFun = new DealCalRangeFunction(this.emptyRangeIds, this.divStr, "", this.calrangeDataSet.getRowMeta());
        this.calrangeDataSet = this.calrangeDataSet.map((MapFunction)billCalRangeFun);
        this.calrangeDataSet = this.calrangeDataSet.groupBy(this.calrangeGroupNames).sum("actualamount").sum("actualqty").finish();
        this.calrangeDataSet = this.calrangeDataSet.select((String[])ArrayUtils.concatAll((Object[])this.calrangeDataSet.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"case when actualqty != 0 then actualamount / actualqty else 0 end as actualprice"}}));
        DataSet[] splitDataSet = sumDataSet.splitByFilter(new String[]{new QFilter("calrange", "in", this.emptyRangeIds).toString(), new QFilter("calrange", "not in", this.emptyRangeIds).toString()}, false);
        DataSet emptyRangeDataSet = splitDataSet[0];
        DataSet notEmptyRangeDataSet = splitDataSet[1];
        JoinDataSet joinDataSet = emptyRangeDataSet.leftJoin(this.calrangeDataSet.copy());
        for (String onField : this.calrangeGroupNames) {
            joinDataSet = joinDataSet.on(onField, onField);
        }
        emptyRangeDataSet = joinDataSet.select(emptyRangeDataSet.getRowMeta().getFieldNames(), new String[]{"actualprice"}).finish();
        joinDataSet = notEmptyRangeDataSet.leftJoin(this.calrangeDataSet.copy());
        for (String onField : this.calNotEmptyRangeGroupNames) {
            joinDataSet = joinDataSet.on(onField, onField);
        }
        notEmptyRangeDataSet = joinDataSet.select(notEmptyRangeDataSet.getRowMeta().getFieldNames(), new String[]{"actualprice"}).finish();
        sumDataSet = emptyRangeDataSet.union(notEmptyRangeDataSet);
        sumDataSet = sumDataSet.select(this.getGroupFields() + ",baseqty,actualqty * actualprice as calrangeamount,actualqty * actualprice as actualamount,standardamount");
        sumDataSet = sumDataSet.groupBy(this.getGroupFields().split(",")).sum("baseqty").sum("calrangeamount").sum("actualamount").sum("standardamount").finish();
        sumDataSet = sumDataSet.groupBy(("calrange," + groupStr).split(",")).sum("baseqty").sum("calrangeamount").sum("actualamount").sum("standardamount").finish();
        List<Object[]> dataList = this.getDataList(sumDataSet, "calrangeamount");
        sumDataSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList.iterator(), sumDataSet.getRowMeta());
        sumDataSet = sumDataSet.groupBy(("calrange," + groupStr).split(",")).sum("baseqty").sum("calrangeamount", "actualamount").sum("standardamount").finish();
        sumDataSet = sumDataSet.filter("baseqty <> 0");
        return sumDataSet;
    }

    private List<Object[]> getDataList(DataSet dataSet, String fieldName) {
        int fieldLength = dataSet.getRowMeta().getFields().length;
        DataSet dataSetCopy = dataSet.copy();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        for (Row row : dataSetCopy) {
            BigDecimal standardamount;
            Object[] RowData = new Object[fieldLength];
            for (int i = 0; i < fieldLength; ++i) {
                RowData[i] = row.get(i);
            }
            if (!StringUtils.isEmpty((String)fieldName)) {
                BigDecimal actualamount = row.getBigDecimal(fieldName);
                if (actualamount != null) {
                    actualamount = actualamount.setScale(this.amountPrecision, 4);
                }
                RowData[this.getListFieldIndex((String)fieldName, (DataSet)dataSet)] = actualamount;
            }
            if ((standardamount = row.getBigDecimal("standardamount")) != null) {
                standardamount = standardamount.setScale(this.amountPrecision, 4);
            }
            RowData[this.getListFieldIndex((String)"standardamount", (DataSet)dataSet)] = standardamount;
            dataList.add(RowData);
        }
        return dataList;
    }

    private int getListFieldIndex(String field, DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private DataSet getStandardPriceDataSet(Set<Long> materialIdSet, Map<String, List<Map<String, Object>>> paramsMap) {
        DataSet costInfoSet = new StandardCostHelper().getStandardCost(paramsMap, false);
        return costInfoSet;
    }

    private DataSet getCostAdjustDataSet() {
        QFilter q = this.getCostAdjustFilter();
        q.and("bookdate", "<=", (Object)this.endDate);
        q.and("bookdate", ">=", (Object)this.startDate);
        q.and("entryentity.material", "in", this.materialIds);
        q.and("isupdatecost", "=", (Object)"1");
        q.and("difftype", "=", (Object)Character.valueOf('B'));
        DataSet costAdjustSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustFields(this.isContainDiffer, true), (QFilter[])new QFilter[]{q}, null);
        return costAdjustSet.select(this.getFinalFields(true));
    }

    private DataSet getCostdiffBillDataSet() {
        QFilter q = this.getCostAdjustFilter();
        q.and("bookdate", "<=", (Object)this.endDate);
        q.and("bookdate", ">=", (Object)this.startDate);
        q.and("entryentity.material", "in", this.materialIds);
        q.and("isupdatecost", "=", (Object)"1");
        DataSet costAdjustSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCostdiffBillFields(this.isContainDiffer, true), (QFilter[])new QFilter[]{q}, null);
        return costAdjustSet.select(this.getFinalFields(true));
    }

    private QFilter getCostAdjustFilter() {
        QFilter q = this.buildCommonFilter(COSTADJUST);
        q.and("billstatus", "=", (Object)BillStatus.C);
        q.and("entryentity.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        return q;
    }

    private DataSet getCostRecordDataSet() {
        QFilter q = this.getCostRecordFilter();
        q.and("bookdate", "<=", (Object)new Timestamp(this.endDate.getTime()));
        q.and("bookdate", ">=", (Object)this.startDate);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        String fields = this.getCostRecordFields(true);
        DataSet costRecordSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)fields, (QFilter[])q.toArray(), null);
        String filterStr = this.getNoStatisticalFilterStr();
        costRecordSet = costRecordSet.filter(filterStr);
        String finalField = this.getFinalFields(false);
        if (this.isContainDiffer) {
            finalField = finalField + ",standardamount";
        } else {
            DataSet recordSetCopy = costRecordSet.copy();
            recordSetCopy.groupBy(new String[]{"material"});
            HashSet<Long> recordMaterialIds = new HashSet<Long>();
            HashMap<String, List<Map<String, Object>>> paramsMap = new HashMap<String, List<Map<String, Object>>>(16);
            for (Row row : recordSetCopy) {
                ArrayList params;
                recordMaterialIds.add(row.getLong("material"));
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                Long calorgId = row.getLong("calorgid");
                Long costAccountId = row.getLong("costaccountid");
                Long storageorgId = row.getLong("storageorg");
                String paramKey = calorgId + "_" + costAccountId;
                param.put("uniqueID", row.getLong("entryid"));
                param.put("invorg", storageorgId);
                param.put("date", this.endDate);
                param.put("material", row.getLong("material"));
                param.put("priority", "0");
                if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
                    for (String calDimension : this.calDimensionSet) {
                        Object value = row.get(calDimension);
                        if (value != null) {
                            if (value instanceof DynamicObject) {
                                param.put(calDimension, ((DynamicObject)value).getPkValue());
                                continue;
                            }
                            param.put(calDimension, value);
                            continue;
                        }
                        param.put(calDimension, 0L);
                    }
                }
                if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
                    params = new ArrayList(16);
                    params.add(param);
                    paramsMap.put(paramKey, params);
                    continue;
                }
                params.add(param);
            }
            DataSet costInfoSet = this.getStandardPriceDataSet(recordMaterialIds, paramsMap);
            costRecordSet = costRecordSet.join(costInfoSet, JoinType.LEFT).on("entryid", "entryid").select(costRecordSet.getRowMeta().getFieldNames(), new String[]{"standardprice"}).finish();
            if (this.calByCostElement) {
                List<Object[]> dataList1 = this.getDataList(costRecordSet, "standardprice");
                costRecordSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList1.iterator(), costRecordSet.getRowMeta());
            }
            finalField = finalField + ",standardbaseqty * standardprice as standardamount";
        }
        List<Object[]> dataList = this.getDataList(costRecordSet, null);
        costRecordSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList.iterator(), costRecordSet.getRowMeta());
        costRecordSet = costRecordSet.select(finalField);
        costRecordSet = costRecordSet.groupBy((this.getGroupFields() + ",entryid").split(",")).max("baseqty").max("actualqty").sum("actualamount").sum("standardamount").finish();
        return costRecordSet;
    }

    private String getCommonGroupBy(boolean isHashStor) {
        StringBuilder select = new StringBuilder();
        select.append("costaccountid,calorgid");
        select.append(",material,materialnumber,baseunit");
        if (this.hasGroup(this.groupType, "owner")) {
            select.append(",owner,ownertype");
        }
        if (this.hasGroup(this.groupType, "storageorg") || isHashStor) {
            select.append(",storageorg");
        }
        if (this.hasGroup(this.groupType, "group")) {
            if (!this.hasGroup(this.groupType, "storageorg") && !isHashStor) {
                select.append(",storageorg");
            }
            select.append(",group");
        }
        if (this.hasGroup(this.groupType, "warehouse")) {
            if (!(this.hasGroup(this.groupType, "storageorg") || this.hasGroup(this.groupType, "group") || isHashStor)) {
                select.append(",storageorg");
            }
            if (!this.hasGroup(this.groupType, "group")) {
                select.append(",group");
            }
            select.append(",warehouse");
        }
        if (this.hasGroup(this.groupType, "location")) {
            if (!(this.hasGroup(this.groupType, "storageorg") || this.hasGroup(this.groupType, "group") || this.hasGroup(this.groupType, "warehouse") || isHashStor)) {
                select.append(",storageorg");
            }
            if (!this.hasGroup(this.groupType, "group") && !this.hasGroup(this.groupType, "warehouse")) {
                select.append(",group");
            }
            if (!this.hasGroup(this.groupType, "warehouse")) {
                select.append(",warehouse");
            }
            select.append(",location");
        }
        if (this.hasGroup(this.groupType, "lot")) {
            select.append(",lot");
        }
        if (this.hasGroup(this.groupType, "tracknumber")) {
            select.append(",tracknumber");
        }
        if (this.hasGroup(this.groupType, "assist")) {
            select.append(",assist");
        }
        if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
            String tempStr = select.toString();
            for (String calDimension : this.calDimensionSet) {
                if (tempStr.contains(calDimension) || !this.hasGroup(this.groupType, calDimension)) continue;
                select.append(",");
                select.append(calDimension);
            }
        }
        return select.toString();
    }

    private String getSumRowFields() {
        StringBuilder select = new StringBuilder();
        String sumString = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockAgeRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
        select.append("0l as costaccountid,0l as calorgid");
        select.append(",0l as material,'");
        select.append(sumString);
        select.append("' as materialnumber,0l as baseunit");
        if (this.hasGroup(this.groupType, "owner")) {
            select.append(",0l as owner,' ' as ownertype");
        }
        if (this.hasGroup(this.groupType, "storageorg")) {
            select.append(",0l as storageorg");
        }
        if (this.hasGroup(this.groupType, "group")) {
            if (!this.hasGroup(this.groupType, "storageorg")) {
                select.append(",0l as storageorg");
            }
            select.append(",0l as group");
        }
        if (this.hasGroup(this.groupType, "warehouse")) {
            if (!this.hasGroup(this.groupType, "storageorg") && !this.hasGroup(this.groupType, "group")) {
                select.append(",0l as storageorg");
            }
            if (!this.hasGroup(this.groupType, "group")) {
                select.append(",0l as group");
            }
            select.append(",0l as warehouse");
        }
        if (this.hasGroup(this.groupType, "location")) {
            if (!(this.hasGroup(this.groupType, "storageorg") || this.hasGroup(this.groupType, "group") || this.hasGroup(this.groupType, "warehouse"))) {
                select.append(",0l as storageorg");
            }
            if (!this.hasGroup(this.groupType, "group") && !this.hasGroup(this.groupType, "warehouse")) {
                select.append(",0l as group");
            }
            if (!this.hasGroup(this.groupType, "warehouse")) {
                select.append(",0l as warehouse");
            }
            select.append(",0l as location");
        }
        if (this.hasGroup(this.groupType, "lot")) {
            select.append(",' ' as lot");
        }
        if (this.hasGroup(this.groupType, "tracknumber")) {
            select.append(",0l as tracknumber");
        }
        if (this.hasGroup(this.groupType, "assist")) {
            select.append(",0l as assist");
        }
        select.append(",0l as calrange");
        select.append(",baseqty");
        select.append(",amount");
        select.append(",currencyid");
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)balanceEntity);
        if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
            String tempStr = select.toString();
            for (String calDimension : this.calDimensionSet) {
                IDataEntityProperty dataProperty;
                if (tempStr.contains(calDimension) || !this.hasGroup(this.groupType, calDimension) || (dataProperty = costRecordEntityType.findProperty(calDimension)) == null) continue;
                if (dataProperty instanceof BasedataProp) {
                    select.append("0 as ");
                    select.append(calDimension);
                    continue;
                }
                if (!(dataProperty instanceof TextProp)) continue;
                select.append("' ' as ");
                select.append(calDimension);
            }
        }
        return select.toString();
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private String getCostAdjustFields(Boolean isContainDiffer, boolean isNeedCalrange) {
        StringBuilder select = new StringBuilder();
        if (isNeedCalrange) {
            select.append("entryentity.calrange as calrange,");
            select.append("0 as actualqty,0 as baseqty,0 as standardbaseqty,");
        }
        select.append("costaccount as costaccountid,calorg as calorgid,");
        select.append("entryentity.baseunit as baseunit,");
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,");
        select.append("billno as billno,billtype.name as billtype,null as calbilltype,");
        select.append("entryentity.owner as owner,entryentity.ownertype as ownertype,entryentity.storageorgunit as storageorg,");
        select.append("entryentity.warehouse as warehouse,entryentity.warehouse.group as group,entryentity.location as location,entryentity.lot as lot,entryentity.tracknumber as tracknumber,");
        select.append("entryentity.assist as assist,entryentity.project as project,");
        select.append("entryentity.material as material,entryentity.material.number as materialnumber,");
        if (isContainDiffer.booleanValue()) {
            select.append("case when biztype = 'A' and difftype <> 'B' and createtype <> 'C1' and entryentity.accounttype = 'D' then entryentity.adjustamt ");
            select.append(" when biztype = 'B' and difftype <> 'B' and createtype <> 'C1' and entryentity.accounttype = 'D' then 0 - entryentity.adjustamt else 0 end as standardamount,");
        } else {
            select.append(" 0  as standardamount, ");
        }
        select.append("case when biztype = 'A' and difftype <> 'M' and createtype <> 'C1' and entryentity.accounttype <> 'D' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and difftype <> 'M' and createtype <>  'C1' and entryentity.accounttype <> 'D'  then 0 - entryentity.adjustamt else 0 end as actualamount,id as entryid,entryentity.configuredcode as configuredcode");
        this.getCostCalDimensionStr(select, true, "entryentity");
        return select.toString();
    }

    private String getCostdiffBillFields(Boolean isContainDiffer, boolean isNeedCalrange) {
        StringBuilder select = new StringBuilder();
        if (isNeedCalrange) {
            select.append("entryentity.calrange as calrange,");
            select.append("0 as actualqty,0 as baseqty,0 as standardbaseqty,");
        }
        select.append("costaccount as costaccountid,calorg as calorgid,");
        select.append("entryentity.baseunit as baseunit,");
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,");
        select.append("billno as billno,billtype.name as billtype,null as calbilltype,");
        select.append("entryentity.owner as owner,entryentity.ownertype as ownertype,entryentity.storageorgunit as storageorg,");
        select.append("entryentity.warehouse as warehouse,entryentity.warehouse.group as group,entryentity.location as location,entryentity.lot as lot,entryentity.tracknumber as tracknumber,");
        select.append("entryentity.assist as assist,entryentity.project as project,");
        select.append("entryentity.material as material,entryentity.material.number as materialnumber,");
        if (isContainDiffer.booleanValue()) {
            select.append("case when biztype = 'A' and createtype <> 'C1' and entryentity.accounttype = 'D' then entryentity.adjustamt ");
            select.append(" when biztype = 'B' and createtype <> 'C1' and entryentity.accounttype = 'D' then 0 - entryentity.adjustamt else 0 end as standardamount,");
        } else {
            select.append(" 0  as standardamount, ");
        }
        select.append(" 0 as actualamount,id as entryid,entryentity.configuredcode as configuredcode");
        this.getCostCalDimensionStr(select, true, "entryentity");
        return select.toString();
    }

    private String getInitBillFields(boolean isNeedCalrange) {
        StringBuilder select = new StringBuilder();
        if (isNeedCalrange) {
            select.append("entryentity.calrange as calrange,");
            select.append("case when entryentity.accounttype <> 'D' then entryentity.baseqty else 0 end as actualqty,");
        }
        select.append("costaccount as costaccountid,calorg as calorgid,");
        select.append("entryentity.baseunit as baseunit,");
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,entryentity.stockindate as bookdate,auditdate as audittime,");
        select.append("billno as billno,billtype.name as billtype,null as calbilltype,");
        select.append("entryentity.owner as owner,entryentity.ownertype as ownertype,entryentity.storageorgunit as storageorg,");
        select.append("entryentity.warehouse as warehouse,entryentity.warehouse.group as group,entryentity.location as location,entryentity.lot as lot,entryentity.tracknumber as tracknumber,");
        select.append("entryentity.assist as assist,entryentity.project as project,");
        select.append("entryentity.material as material,entryentity.material.number as materialnumber,");
        select.append("entryentity.baseqty as baseqty,");
        if (this.isContainDiffer) {
            select.append("case when entryentity.accounttype = 'D' then entryentity.amount + entryentity.costdiff else 0 end as standardamount,");
            select.append("case when entryentity.accounttype <> 'D' then entryentity.amount + entryentity.costdiff else 0 end as actualamount,");
        } else {
            select.append("case when entryentity.accounttype = 'D' then entryentity.amount else 0 end as standardamount,");
            select.append("case when entryentity.accounttype <> 'D' then entryentity.amount else 0 end as actualamount,");
        }
        select.append("case when entryentity.accounttype = 'D' then entryentity.baseqty else 0 end as standardbaseqty,entryentity.configuredcode as configuredcode,entryentity.id as entryid");
        this.getCostCalDimensionStr(select, true, "entryentity");
        return select.toString();
    }

    private String getCostRecordFields(boolean isNeedCalrange) {
        StringBuilder select = new StringBuilder();
        if (isNeedCalrange) {
            select.append("entry.calrange as calrange,");
            select.append("case when calbilltype = 'IN' and entry.accounttype <> 'D' then entry.baseqty ");
            select.append("when calbilltype = 'OUT' and entry.accounttype <> 'D' then 0 - entry.baseqty ");
            select.append(" else 0 end as actualqty,");
        }
        select.append("billtype.id,biztype.id,invscheme.id,entry.bizbillentryid as bizbillentryid,");
        select.append("costaccount as costaccountid,calorg as calorgid,");
        select.append("entry.baseunit as baseunit,");
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,");
        select.append("billno as billno,calbilltype as calbilltype,billtype.name as billtype,");
        select.append("entry.owner as owner,entry.ownertype as ownertype,storageorgunit as storageorg,");
        select.append("entry.warehouse as warehouse,entry.warehouse.group as group,entry.location as location,entry.lot as lot,entry.tracknumber as tracknumber,");
        select.append("entry.assist as assist,entry.project as project,");
        select.append("entry.material as material,entry.material.number as materialnumber,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 - entry.baseqty end as baseqty,");
        select.append("case when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost ");
        select.append("when calbilltype = 'OUT' and entry.accounttype = 'D'  then 0 - entry.standardcost ");
        select.append(" else 0 end as standardamount,");
        select.append("case when calbilltype = 'IN' and entry.accounttype = 'D' then entry.baseqty ");
        select.append("when calbilltype = 'OUT' and entry.accounttype = 'D'  then 0 - entry.baseqty ");
        select.append(" else 0 end as standardbaseqty,");
        select.append("case when calbilltype = 'IN' and entry.accounttype <> 'D' then entry.actualcost ");
        select.append("when calbilltype = 'OUT' and entry.accounttype <> 'D' then 0 - entry.actualcost ");
        select.append(" else 0 end as actualamount,id,entry.configuredcode as configuredcode,entry.id as entryid");
        this.getCostCalDimensionStr(select, true, "entry");
        return select.toString();
    }

    private void getMaterialIds(DataSet prevPeriodEndSet, DataSet costRecordDataSet) {
        DataSet materialSumSet = prevPeriodEndSet.union(costRecordDataSet);
        DataSet materialSet = materialSumSet.filter("baseqty <> 0").select("material");
        for (Row row : materialSet) {
            Long materialId = row.getLong("material");
            this.materialIds.add(materialId);
        }
    }

    private QFilter getCostRecordFilter() {
        QFilter q = this.buildFilterOnlyMaterial(COSTRECORD);
        q.and("issplitcreate", "=", (Object)Boolean.FALSE);
        q.and("isinitbill", "=", (Object)Boolean.FALSE);
        q.and("biztype", "not in", this.notUpdBalBizType);
        q.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        return q;
    }

    private QFilter buildFilterOnlyMaterial(String formType) {
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                if (BALANCE.equals(formType)) {
                    q.and("material.id", "in", materialSet);
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.id", "in", materialSet);
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.id", "in", materialSet);
                }
            } else if (this.filter_materialFrom.size() == 1) {
                if (BALANCE.equals(formType)) {
                    q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                }
            }
        }
        if (this.filter_materialTo != null) {
            if (BALANCE.equals(formType)) {
                q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            }
        }
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            String entry = "";
            if (COSTRECORD.equals(formType)) {
                entry = "entry.";
            } else if (COSTADJUST.equals(formType)) {
                entry = "entryentity.";
            }
            q.and(entry + "ownertype", "=", (Object)this.filter_ownertype);
        }
        if (this.filter_lot != null) {
            if (BALANCE.equals(formType)) {
                q.and("lot", "in", (Object)this.filter_lot);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.lot", "in", (Object)this.filter_lot);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.lot", "in", (Object)this.filter_lot);
            }
        }
        if (this.filter_tracknumber != null) {
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("tracknumber", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.tracknumber", "in", set);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.tracknumber", "in", set);
            }
        }
        return q;
    }

    private QFilter buildCommonFilter(String formType) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (Object materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                if (BALANCE.equals(formType)) {
                    q.and("material.id", "in", materialSet);
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.id", "in", materialSet);
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.id", "in", materialSet);
                }
            } else if (this.filter_materialFrom.size() == 1) {
                if (BALANCE.equals(formType)) {
                    q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                } else if (COSTRECORD.equals(formType)) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                } else if (COSTADJUST.equals(formType)) {
                    q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                }
            }
        }
        if (this.filter_materialTo != null) {
            if (BALANCE.equals(formType)) {
                q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            }
        }
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            String entry = "";
            if (COSTRECORD.equals(formType)) {
                entry = "entry.";
            } else if (COSTADJUST.equals(formType)) {
                entry = "entryentity.";
            }
            q.and(entry + "ownertype", "=", (Object)this.filter_ownertype);
            if (this.filter_owner != null) {
                HashSet<Object> set2 = new HashSet<Object>();
                for (DynamicObject info : this.filter_owner) {
                    set2.add(info.getPkValue());
                }
                q.and(entry + "owner", "in", set2);
            }
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            if (COSTADJUST.equals(formType)) {
                q.and("entryentity.storageorgunit", "in", set);
            } else {
                q.and("storageorgunit", "in", set);
            }
        }
        if (this.filter_lot != null) {
            if (BALANCE.equals(formType)) {
                q.and("lot", "in", (Object)this.filter_lot);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.lot", "in", (Object)this.filter_lot);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.lot", "in", (Object)this.filter_lot);
            }
        }
        if (!this.warehsGroupSet.isEmpty()) {
            if (BALANCE.equals(formType)) {
                q.and("warehouse.group", "in", this.warehsGroupSet);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.warehouse.group", "in", this.warehsGroupSet);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
            }
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("warehouse", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.warehouse", "in", set);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.warehouse", "in", set);
            }
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("location", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.location", "in", set);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.location", "in", set);
            }
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            if (BALANCE.equals(formType)) {
                q.and("tracknumber", "in", set);
            } else if (COSTRECORD.equals(formType)) {
                q.and("entry.tracknumber", "in", set);
            } else if (COSTADJUST.equals(formType)) {
                q.and("entryentity.tracknumber", "in", set);
            }
        }
        return q;
    }

    private DataSet getPrevPeriodEndDataSet() {
        QFilter q = this.buildFilterOnlyMaterial(BALANCE);
        q.and("period", "<", (Object)this.startPeriod);
        q.and("endperiod", ">=", (Object)this.startPeriod);
        q.and("invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        DataSet calBalanceSet = null;
        String fields = this.getCalBalanceFields(this.isContainDiffer);
        if (this.isNewBalance) {
            String moreFields = ",id,calorg,calrange,accounttype,warehouse.group,material.number,baseunit,year,month,baseqty_bal as periodendqty,standardcost_bal as periodendstandardcost,costdiff_bal as periodendcostdiff,actualcost_bal as periodendactualcost";
            String select = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
            String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",calorg,calrange,accounttype,warehouse.group,material.number,baseunit,year,month").split(",");
            calBalanceSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)select, (QFilter[])new QFilter[]{q}, null);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            calBalanceSet = balCompress ? calBalanceSet.groupBy(groupSelect).sum("periodendqty").max("id").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodendactualcost").finish() : calBalanceSet.groupBy(groupSelect).max("periodendqty").max("id").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodendactualcost").finish();
            calBalanceSet = calBalanceSet.select(fields);
        } else {
            calBalanceSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)fields, (QFilter[])new QFilter[]{q}, null);
        }
        DataSet balanceSetCopy = calBalanceSet.copy();
        balanceSetCopy.groupBy(new String[]{"material"});
        HashSet<Long> balanceMaterialIds = new HashSet<Long>();
        HashMap<String, List<Map<String, Object>>> paramsMap = new HashMap<String, List<Map<String, Object>>>(16);
        for (Row row : balanceSetCopy) {
            ArrayList params;
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            balanceMaterialIds.add(row.getLong("material"));
            Long calorgId = row.getLong("calorgid");
            Long costAccountId = row.getLong("costaccountid");
            Long storageorgId = row.getLong("storageorg");
            String paramKey = calorgId + "_" + costAccountId;
            param.put("uniqueID", row.getLong("entryid"));
            param.put("invorg", storageorgId);
            param.put("date", this.endDate);
            param.put("material", row.getLong("material"));
            param.put("priority", "0");
            if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
                for (String calDimension : this.calDimensionSet) {
                    Object value = row.get(calDimension);
                    if (value != null) {
                        if (value instanceof DynamicObject) {
                            param.put(calDimension, ((DynamicObject)value).getPkValue());
                            continue;
                        }
                        param.put(calDimension, value);
                        continue;
                    }
                    param.put(calDimension, 0L);
                }
            }
            if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
                params = new ArrayList(16);
                params.add(param);
                paramsMap.put(paramKey, params);
                continue;
            }
            params.add(param);
        }
        String finalField = this.getFinalFields(false);
        if (this.isContainDiffer) {
            finalField = finalField + ",standardamount";
        } else {
            DataSet costInfoSet = this.getStandardPriceDataSet(balanceMaterialIds, paramsMap);
            calBalanceSet = calBalanceSet.join(costInfoSet, JoinType.LEFT).on("entryid", "entryid").select(calBalanceSet.getRowMeta().getFieldNames(), new String[]{"standardprice"}).finish();
            if (this.calByCostElement) {
                List<Object[]> dataList1 = this.getDataList(calBalanceSet, "standardprice");
                calBalanceSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList1.iterator(), calBalanceSet.getRowMeta());
            }
            finalField = finalField + ",standardbaseqty * standardprice as standardamount";
        }
        List<Object[]> dataList = this.getDataList(calBalanceSet, null);
        calBalanceSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList.iterator(), calBalanceSet.getRowMeta());
        calBalanceSet = calBalanceSet.select(finalField);
        calBalanceSet = calBalanceSet.groupBy((this.getGroupFields() + ",0 as entryid").split(",")).max("baseqty").max("actualqty").sum("actualamount").sum("standardamount").finish();
        return calBalanceSet;
    }

    private String getCalBalanceFields(Boolean isContainDiffer) {
        StringBuilder select = new StringBuilder();
        select.append("id as entryid,calrange,costaccount as costaccountid,calorg as calorgid,");
        select.append("baseunit,");
        select.append("year,month as period,null as bizdate,null as bookdate,null as audittime,");
        select.append("null as billno,null as calbilltype,");
        select.append("owner,ownertype,storageorgunit as storageorg,");
        select.append("warehouse,warehouse.group as group,location,lot,tracknumber,configuredcode,");
        select.append("assist,project,");
        select.append("material,material.number as materialnumber,");
        select.append("periodendqty as baseqty,");
        if (isContainDiffer.booleanValue()) {
            select.append("case when accounttype = 'D' then periodendstandardcost + periodendcostdiff else 0 end as standardamount,");
        } else {
            select.append("case when accounttype = 'D' then periodendstandardcost else 0 end as standardamount,");
        }
        select.append("case when accounttype = 'D' then periodendqty end as standardbaseqty,");
        select.append("case when accounttype <> 'D' then periodendactualcost else 0 end as actualamount,");
        select.append("case when accounttype <> 'D' then periodendqty else 0 end as actualqty");
        this.getCostCalDimensionStr(select, false, null);
        return select.toString();
    }

    private String getFinalFields(boolean hasStdAmtField) {
        StringBuilder select = new StringBuilder();
        select.append("calrange,costaccountid,calorgid,entryid,");
        select.append("baseunit,");
        select.append("year,period,bizdate,bookdate,audittime,");
        select.append("billno,calbilltype,");
        select.append("owner,ownertype,storageorg,");
        select.append("warehouse,group,location,lot,tracknumber,configuredcode,");
        select.append("assist,project,");
        select.append("material,materialnumber,");
        select.append("baseqty,");
        select.append("standardbaseqty,");
        select.append("actualamount,");
        select.append("actualqty");
        if (hasStdAmtField) {
            select.append(",standardamount");
        }
        this.getCostCalDimensionStr(select, false, null);
        return select.toString();
    }

    private void getCostCalDimensionStr(StringBuilder select, boolean isEntry, String entryName) {
        if (this.calDimensionSet != null && this.calDimensionSet.size() > 0) {
            String tempStr = select.toString();
            for (String calDimension : this.calDimensionSet) {
                if (tempStr.contains(calDimension)) continue;
                if (isEntry) {
                    select.append(",");
                    select.append(entryName);
                    select.append(".");
                    select.append(calDimension);
                    select.append(" as ");
                    select.append(calDimension);
                    continue;
                }
                select.append(",");
                select.append(calDimension);
            }
        }
    }

    private String getGroupFields() {
        StringBuilder select = new StringBuilder();
        select.append("calrange,costaccountid,calorgid,");
        select.append("baseunit,");
        select.append("owner,ownertype,storageorg,");
        select.append("warehouse,group,location,tracknumber,");
        select.append("material,materialnumber,configuredcode,assist,project,lot,year,period");
        this.getCostCalDimensionStr(select, false, null);
        return select.toString();
    }

    private DataSet handleClassifiedMaterialDataSet(DataSet allDataSet) {
        Object pkValue = null;
        DynamicObject materialgroupstandard = this.filterInfo.getDynamicObject("materialgroupstandard");
        pkValue = materialgroupstandard == null ? Long.valueOf(730148448254487552L) : materialgroupstandard.getPkValue();
        QFilter q = new QFilter("standard", "=", pkValue);
        q.and("material.id", "in", this.materialIds);
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"standard,group as materialgroup,group.number as groupnumber,material,material.number as materialnumber", (QFilter[])q.toArray(), (String)"group desc");
        String[] leftField = allDataSet.getRowMeta().getFieldNames();
        DataSet resultDataSet = allDataSet.leftJoin(classifiedMaterialDataSet).on("material", "material").select(leftField, new String[]{"materialgroup"}).finish();
        if (this.materialClassSum) {
            resultDataSet = resultDataSet.orderBy(new String[]{"materialgroup desc"});
        }
        if (this.onlyShowSumRow) {
            String groupStr = "costaccountid,calorgid,materialgroup,currencyid";
            GroupbyDataSet groupbyDataSet = resultDataSet.groupBy(groupStr.split(","));
            groupbyDataSet = groupbyDataSet.sum("baseqty").sum("amount");
            String[] intervalDays = this.filterInfo.getString("intervaldays").split(",");
            for (int i = 0; i < intervalDays.length; ++i) {
                String prefixField = "range" + i;
                String qtyField = prefixField + "qty";
                String amountField = prefixField + "amount";
                groupbyDataSet = groupbyDataSet.sum(qtyField).sum(amountField);
            }
            resultDataSet = groupbyDataSet.finish();
        }
        return resultDataSet;
    }

    private DataSet addSumRow(DataSet dataSet) {
        StringBuilder select = new StringBuilder();
        select.append(this.getSumRowFields());
        select.append(',');
        String groupStr = "costaccountid,calorgid,currencyid";
        GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(groupStr.split(","));
        groupbyDataSet = groupbyDataSet.sum("baseqty").sum("amount");
        String[] intervalDays = this.filterInfo.getString("intervaldays").split(",");
        for (int i = 0; i < intervalDays.length; ++i) {
            String prefixField = "range" + i;
            String qtyField = prefixField + "qty";
            String amountField = prefixField + "amount";
            select.append(qtyField);
            select.append(',');
            select.append(amountField);
            select.append(',');
            groupbyDataSet = groupbyDataSet.sum(qtyField).sum(amountField);
        }
        if (this.hasGroup(this.groupType, "owner")) {
            select.append("0l as ownernumber,");
        }
        select.append("0l as materialgroup");
        DataSet sumRowDataSet = groupbyDataSet.finish().select(select.toString());
        dataSet = dataSet.addField("0", "orderinex").union(sumRowDataSet.addField("1", "orderinex"));
        dataSet = this.materialClassSum ? dataSet.orderBy(new String[]{"orderinex", "materialgroup desc", "materialnumber", "calrange"}) : dataSet.orderBy(new String[]{"orderinex", "materialnumber", "calrange"});
        return dataSet;
    }

    private DataSet addMatGroupSumRow(DataSet dataSet) {
        StringBuilder select = new StringBuilder();
        String sumString = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockAgeRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
        select.append("0l as costaccountid,0l as calorgid,0l as materialgroup,currencyid,baseqty,amount,");
        String groupStr = "costaccountid,calorgid,currencyid";
        GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(groupStr.split(","));
        groupbyDataSet = groupbyDataSet.sum("baseqty").sum("amount");
        String[] intervalDays = this.filterInfo.getString("intervaldays").split(",");
        for (int i = 0; i < intervalDays.length; ++i) {
            String prefixField = "range" + i;
            String qtyField = prefixField + "qty";
            String amountField = prefixField + "amount";
            select.append(qtyField);
            select.append(',');
            select.append(amountField);
            select.append(',');
            groupbyDataSet = groupbyDataSet.sum(qtyField).sum(amountField);
        }
        select.append('\'');
        select.append(sumString);
        select.append("' as materialnumber");
        DataSet sumRowDataSet = groupbyDataSet.finish().select(select.toString());
        dataSet = dataSet.addField("' '", "materialnumber").addField("0", "orderinex");
        dataSet = dataSet.union(sumRowDataSet.addField("1", "orderinex"));
        dataSet = this.materialClassSum ? dataSet.orderBy(new String[]{"orderinex", "materialgroup desc"}) : dataSet.orderBy(new String[]{"orderinex"});
        return dataSet;
    }

    private DataSet filterGroupFields(DataSet sumDataSet) {
        HashSet<Object> set;
        StringBuilder filterStr = new StringBuilder("1=1");
        QFilter q = new QFilter("1", "=", (Object)1);
        if (this.filter_owner != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getPkValue());
            }
            q.and("owner", "in", set);
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorg", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        sumDataSet = sumDataSet.filter(q.toString());
        sumDataSet = sumDataSet.groupBy(("calrange," + this.getCommonGroupBy(false)).split(",")).sum("baseqty").sum("actualamount").sum("standardamount").finish();
        return sumDataSet.select(this.getCommonGroupBy(false) + ",calrange,baseqty,actualamount,standardamount");
    }

    private String getFilterfields() {
        StringBuilder fields = new StringBuilder();
        if (this.filter_owner != null && !this.hasGroup(this.groupType, "owner")) {
            fields.append("owner");
            fields.append(',');
        }
        if (!(this.filter_storageOrg == null || this.hasGroup(this.groupType, "storageorg") || this.hasGroup(this.groupType, "group") || this.hasGroup(this.groupType, "warehouse") || this.hasGroup(this.groupType, "location"))) {
            fields.append("storageorg");
            fields.append(',');
        }
        if (!(this.warehsGroupSet.isEmpty() || this.hasGroup(this.groupType, "group") || this.hasGroup(this.groupType, "warehouse") || this.hasGroup(this.groupType, "location"))) {
            fields.append("group");
            fields.append(',');
        }
        if (this.filter_warehouse != null && !this.hasGroup(this.groupType, "warehouse") && !this.hasGroup(this.groupType, "location")) {
            fields.append("warehouse");
            fields.append(',');
        }
        if (this.filter_location != null && !this.hasGroup(this.groupType, "location")) {
            fields.append("location");
            fields.append(',');
        }
        if (fields.length() > 0) {
            return CommonUtils.trimComma((String)fields.toString());
        }
        return null;
    }

    private Set<Long> getEmptyEntryRangeIds() {
        QFilter filter = new QFilter("costaccount", "=", (Object)this.filter_costAccount.getLong("id"));
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        if (emptyEntryRangeIds.isEmpty()) {
            emptyEntryRangeIds.add(-1L);
        }
        return emptyEntryRangeIds;
    }
}

